/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.application;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.PrefixSuffixFileFilter;
import ch.kronospace.logpsychoanalyst.VirtualHost;
import ch.kronospace.logpsychoanalyst.application.Application;
import ch.kronospace.logpsychoanalyst.logformat.ApacheCommon;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsBuilder;
import java.io.File;
import java.text.SimpleDateFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Tomcat
extends Application {
    private int access_log_speed_grade = 3;
    public File install_dir = null;
    public String version;
    private TomcatServerConfigFileParser parser = new TomcatServerConfigFileParser();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Tomcat(File install_dir, String version) {
        this.install_dir = install_dir;
        this.version = version;
    }

    public Class getService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.application.WebService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getServiceLocation() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ch.kronospace.logpsychoanalyst.application.WebServiceLocalhost");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void extractTomcat5VirtualHosts() {
        String server_config_file = "conf/server.xml";
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(this.install_dir, server_config_file), this.getParser());
        }
        catch (SAXParseException e) {
            System.out.println("Error: parse error in $CATALINA_HOME/" + server_config_file + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String toString() {
        return "Tomcat " + this.version;
    }

    public DefaultHandler getParser() {
        return this.parser;
    }

    protected class TomcatServerConfigFileParser
    extends DefaultHandler {
        private VirtualHost vhost = null;
        private boolean in_alias = false;
        static /* synthetic */ Class class$0;

        protected TomcatServerConfigFileParser() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals("Host")) {
                String host_name = attrs.getValue("name");
                this.vhost = new VirtualHost(host_name);
                Tomcat.this.getVirtualHosts().add(this.vhost);
                this.vhost.addAlias(new Alias(host_name));
                this.vhost.setStatisticsBuilder(new HTTPStatisticsBuilder());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.report.HTTPStatistics");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.vhost.setStatisticsClass(clazz);
            } else if (this.vhost != null && eName.equals("Alias")) {
                this.in_alias = true;
            } else if (this.vhost != null && eName.equals("Valve") && attrs.getValue("className").equals("org.apache.catalina.valves.AccessLogValve")) {
                String dir = attrs.getValue("directory");
                File directory = new File(dir);
                if (!directory.isAbsolute()) {
                    directory = new File(Tomcat.this.install_dir, dir);
                }
                if (!directory.exists()) {
                    System.err.println("Warning: the specified AccessLog directory doesn't existing (" + directory.getAbsolutePath() + ")");
                }
                String prefix = attrs.getValue("prefix");
                String suffix = attrs.getValue("suffix");
                String suffix_without_extension = "'" + suffix.substring(0, suffix.lastIndexOf(46) + 1) + "'";
                if (suffix_without_extension.length() <= 2) {
                    suffix_without_extension = "";
                }
                LogFormat log_format = null;
                String pattern = attrs.getValue("pattern");
                if (pattern.equals("combined")) {
                    try {
                        log_format = (LogFormat)Class.forName("loganalyst.logformat.ApacheCombined" + Tomcat.this.access_log_speed_grade).newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (pattern.equals("common")) {
                    log_format = new ApacheCommon();
                } else {
                    log_format = null;
                    System.out.println(String.valueOf(this.getClass().getName()) + ", Error: the specified log format is not recognized (" + pattern + ") for host '" + this.vhost.toString() + "'. Can be a not-yet-implemented feature.");
                }
                SimpleDateFormat file_pattern = new SimpleDateFormat("'" + prefix + "'yyyy-MM-dd" + suffix_without_extension);
                boolean recursive = false;
                PrefixSuffixFileFilter file_filter = new PrefixSuffixFileFilter(prefix, suffix, "Tomcat Access Log for " + this.vhost.getSourceName(), recursive);
                this.vhost.setAccessLogger(directory, recursive, file_filter, file_pattern, log_format);
            } else if (this.vhost != null && eName.equals("Logger") && attrs.getValue("className").equals("org.apache.catalina.logger.FileLogger")) {
                String dir = attrs.getValue("directory");
                File directory = new File(dir);
                if (!directory.isAbsolute()) {
                    directory = new File(Tomcat.this.install_dir, dir);
                }
                String prefix = attrs.getValue("prefix");
                String suffix = attrs.getValue("suffix");
                SimpleDateFormat file_pattern = new SimpleDateFormat("'" + prefix + "'yyyy-MM-dd'" + suffix + "'");
                boolean recursive = false;
                PrefixSuffixFileFilter file_filter = new PrefixSuffixFileFilter(prefix, suffix, "Tomcat Logs for " + this.vhost.getSourceName(), recursive);
                this.vhost.setLogger(directory, file_filter, file_pattern, null);
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this.vhost != null && eName.equals("Host")) {
                this.vhost = null;
            } else if (this.vhost != null && eName.equals("Alias")) {
                this.in_alias = false;
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            String s = new String(buf, offset, len);
            if (this.in_alias && this.vhost != null) {
                this.vhost.addAlias(new Alias(s));
            }
        }
    }
}

