/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.application;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RootKey;
import ch.kronospace.logpsychoanalyst.application.ApplicationDetector;
import ch.kronospace.logpsychoanalyst.application.Service;
import ch.kronospace.logpsychoanalyst.application.Tomcat;
import ch.kronospace.tools.DOSCommands;
import java.io.File;
import java.util.Iterator;

public class TomcatDetector
extends ApplicationDetector {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Service.registerApplicationDetector(new TomcatDetector());
    }

    public Class getService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.application.WebService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getServiceLocation() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ch.kronospace.logpsychoanalyst.application.WebServiceLocalhost");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void detect() {
        String os_name = System.getProperty("os.name");
        if (os_name.startsWith("Windows")) {
            File catalina_home = null;
            String home = DOSCommands.getenv("CATALINA_HOME");
            if (home != null && !(catalina_home = new File(home)).exists()) {
                catalina_home = null;
                System.err.println("Warning: CATALINA_HOME environment variable existing but the pointed directory does not exist. I try to look in the registry.");
            }
            if (catalina_home == null) {
                RegistryKey r;
                if (!RegistryKey.isInitialized()) {
                    RegistryKey.initialize();
                }
                if ((r = new RegistryKey(RootKey.HKEY_LOCAL_MACHINE, "Software\\Apache Software Foundation\\Tomcat")).exists() && r.hasSubkeys()) {
                    Iterator subkeys = r.subkeys();
                    while (subkeys.hasNext()) {
                        RegistryKey v = (RegistryKey)subkeys.next();
                        if (v.getName().equals("5.0")) {
                            String path = v.getValue("InstallPath").getStringValue();
                            String version = v.getValue("Version").getStringValue();
                            catalina_home = new File(path);
                            if (!catalina_home.exists()) {
                                catalina_home = null;
                                System.err.println("Warning: Tomcat " + version + " InstallPath registry key found but directory does not exist. I cannot continue.");
                                continue;
                            }
                            Tomcat application = new Tomcat(catalina_home, version);
                            application.extractTomcat5VirtualHosts();
                            this.add(application);
                            continue;
                        }
                        System.out.println(v.toString());
                    }
                }
            }
        } else {
            System.err.println("Warning: Tomcat cannot detected on your operating system (" + os_name + ")");
        }
    }

    public String toString() {
        return "Tomcat detector";
    }
}

