/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.conf.CalendarRenderer;
import ch.kronospace.tools.DateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import org.jdesktop.swingx.calendar.DateSpan;

public class CalendarEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -6528000464172867947L;
    Calendar current_date = null;
    long[] flagged_dates = null;
    static /* synthetic */ Class class$0;

    public CalendarEditor(JButton b) {
        super(new JCheckBox());
        this.editorComponent = b;
        this.setClickCountToStart(1);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CalendarEditor.this.fireEditingStopped();
            }
        });
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return this.current_date;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.flagged_dates = new long[table.getModel().getRowCount()];
        int i = 0;
        while (i < this.flagged_dates.length) {
            long time = ((Calendar)table.getModel().getValueAt(i, column)).getTimeInMillis();
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(time);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            this.flagged_dates[i] = c.getTimeInMillis();
            ++i;
        }
        ((JButton)this.editorComponent).setText(CalendarRenderer.df.format(((Calendar)value).getTime()));
        this.current_date = (Calendar)value;
        return this.editorComponent;
    }

    public static void setUpCalendarEditor(JTable table) {
        final JButton button = new JButton("");
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        CalendarEditor calendar_editor = new CalendarEditor(button);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        table.setDefaultEditor(clazz, calendar_editor);
        final DateChooser date_chooser = new DateChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CalendarEditor.this.current_date = date_chooser.getCalendar();
            }
        };
        final JDialog dialog = DateChooser.createDialog(button, "Select a date", true, date_chooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                long time = CalendarEditor.this.current_date.getTimeInMillis();
                date_chooser.setSelectedDateSpan(new DateSpan(time, time));
                date_chooser.setFlaggedDates(CalendarEditor.this.flagged_dates);
                dialog.setLocationRelativeTo(button);
                dialog.setVisible(true);
            }
        });
    }
}

