/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.ConfigParser;
import ch.kronospace.logpsychoanalyst.Echo;
import ch.kronospace.logpsychoanalyst.conf.HostsConfigurator;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.geography.MaxMindGeoIPFree;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class ConfigurationFactory {
    public static void create() {
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.logformat");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.advisor");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.visit");
        Echo.loadPackageClassFiles(new File("lib"), "ch.kronospace.logpsychoanalyst.plugins.report");
        HostsConfigurator hosts = new HostsConfigurator();
        boolean ok = true;
        if (ok &= hosts.ask()) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(new File(ConfigParser.app_data_dir, "global_config.xml")));
                out.println("<Config>");
                hosts.write(out);
                out.println("</Config>");
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final void main(String[] args) {
        String ua_string = "LogPsychoAnalyst/0.1 (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; +http://www.logpsychoanalyst.com/bot.html)";
        System.setProperty("http.agent", ua_string);
        System.out.println("Geolocation database loading and updating...");
        MaxMindGeoIPFree geoip = new MaxMindGeoIPFree(new File("data/maxmind_geoip_free"));
        if (geoip.getLastDatabaseDate() + 2419200000L < System.currentTimeMillis()) {
            geoip.downloadUpdate();
        }
        IPGeographyUtil.registerProvider(geoip);
        Echo.updateProgram("ConfigureHosts");
        ConfigurationFactory.create();
    }
}

