/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.Host;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DataSourceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -9124735847374179151L;
    Vector datasources = new Vector();
    Host host = null;

    public void removeRow(int row) {
        this.datasources.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public DataSource getDataSource(int index) {
        return (DataSource)this.datasources.elementAt(index);
    }

    public void addDataSource(DataSource h) {
        this.datasources.add(h);
        this.fireTableDataChanged();
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
        }
        return "[bad column index]";
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.host == null) {
            return 0;
        }
        return this.datasources.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.host == null) {
            return "null host";
        }
        DataSource ds = (DataSource)this.datasources.elementAt(row);
        if (ds == null) {
            return "null";
        }
        switch (col) {
            case 0: {
                return ds.getSourceName();
            }
            case 1: {
                return ds.getType();
            }
        }
        return "[bad column index]";
    }

    public void setHost(Host h) {
        this.host = h;
        this.datasources.clear();
        Enumeration e = this.host.getDataSource().elements();
        while (e.hasMoreElements()) {
            this.datasources.add(e.nextElement());
        }
    }
}

