/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.FTPDataSource;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.ISP;
import ch.kronospace.logpsychoanalyst.RobotTrap;
import ch.kronospace.logpsychoanalyst.Tools;
import ch.kronospace.logpsychoanalyst.conf.DataSourceConfigurationDialog;
import ch.kronospace.logpsychoanalyst.database.ISPDatabase;
import ch.kronospace.logpsychoanalyst.database.ISPDatabaseParser;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.logformat.LogFormatManager;
import ch.kronospace.tools.GUITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FTPDataSourceConfigurator
extends DataSourceConfigurationDialog {
    private String domain_name = null;
    private Host host = null;
    private FTPDataSource internal_ds = null;
    private FTPDataSource existing_ds = null;
    private boolean form_validated = false;
    private boolean auto_download_log_files = true;
    private JTextField tf_domain_name = new JTextField(20);
    private JTextField tf_isp = new JTextField(30);
    private JTextField tf_ip = new JTextField();
    private JTextField tf_ftp_server = new JTextField();
    private JTextField tf_log_file_directory = new JTextField();
    private JTextField tf_log_file_regexp = new JTextField();
    private JComboBox cb_log_file_format = new JComboBox();
    private JTextField tf_username = new JTextField(10);
    private JPasswordField tf_password = new JPasswordField(10);
    private JCheckBox cb_auto_download_files = new JCheckBox("Download log files at every launch", this.auto_download_log_files);
    private final JList jl_aliases = new JList(new DefaultListModel());
    private final JList jl_dpes = new JList(new DefaultListModel());
    private final JList jl_rtes = new JList(new DefaultListModel());
    private final JButton bt_del_dp = new JButton("Remove default page");
    private JButton bt_add_dp = new JButton("Add default page");
    private final JButton bt_del_alias = new JButton("Remove alias");
    private final JButton bt_del_rt = new JButton("Remove robot trap");
    private JButton bt_add_rt = new JButton("Add robot trap");
    private JDialog f = null;
    private JFrame frame;

    public FTPDataSourceConfigurator(JFrame frame, String domain_name, Host host) {
        this.setDomainName(domain_name);
        this.setHost(host);
        this.f = this.createConfigDialog(domain_name, frame);
        this.frame = frame;
    }

    public void setDomainName(String domain_name) {
        this.domain_name = domain_name;
        this.tf_domain_name.setText(domain_name);
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public void setEnabledFormFields(boolean enable_data_fields) {
        this.tf_ftp_server.setEditable(enable_data_fields);
        this.tf_isp.setEditable(enable_data_fields);
        this.tf_ip.setEditable(enable_data_fields);
        this.tf_log_file_directory.setEditable(enable_data_fields);
        this.tf_log_file_regexp.setEditable(enable_data_fields);
        this.cb_log_file_format.setEnabled(enable_data_fields);
        this.bt_add_dp.setEnabled(enable_data_fields);
        this.jl_dpes.setEnabled(enable_data_fields);
    }

    public void clearFormFields() {
        this.tf_ftp_server.setText("");
        this.tf_isp.setText("");
        this.tf_ip.setText("");
        this.tf_log_file_directory.setText("");
        this.tf_log_file_regexp.setText("");
        this.tf_username.setText("");
        this.tf_password.setText("");
        this.cb_log_file_format.setSelectedIndex(-1);
        DefaultListModel model = (DefaultListModel)this.jl_dpes.getModel();
        model.clear();
    }

    public JDialog createConfigDialog(String domain_name, JFrame frame) {
        JButton bt_autodetect_from_domain_name = new JButton("Autocomplete form");
        JPanel p_domain_name = new JPanel(new FlowLayout());
        p_domain_name.setBorder(BorderFactory.createTitledBorder("Domain name information"));
        p_domain_name.add(new JLabel("Domain name"));
        p_domain_name.add(this.tf_domain_name);
        p_domain_name.add(bt_autodetect_from_domain_name);
        p_domain_name.add(new JLabel(GUITools.internet_icon));
        p_domain_name.add(GUITools.createPrivacyButton("A DNS query must be performed in order to get the web server IP address which is needed to determine the hosting compagny.<br><br>If the DNS query fail, the IP address will be asked.<br><br>Only one DNS query is made, using your machine default DNS server. No other query or information are made/transmitted to anyone."));
        ActionListener al_autodetect = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        bt_autodetect_from_domain_name.addActionListener(al_autodetect);
        this.tf_domain_name.addActionListener(al_autodetect);
        this.cb_log_file_format.removeAllItems();
        Enumeration e = LogFormatManager.availableLogFormats().elements();
        while (e.hasMoreElements()) {
            LogFormat lf = (LogFormat)e.nextElement();
            this.cb_log_file_format.addItem(lf.getClass().getName());
        }
        this.cb_log_file_format.setEditable(false);
        this.cb_log_file_format.setEnabled(false);
        JPanel p_lb = new JPanel(new GridLayout(0, 1, 5, 5));
        p_lb.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_lb.add(new JLabel("IP address"));
        p_lb.add(new JLabel("Hosted by"));
        p_lb.add(new JLabel("Log file directory"));
        p_lb.add(new JLabel("Log file name"));
        p_lb.add(new JLabel("Log file format"));
        JPanel p_tf = new JPanel(new GridLayout(0, 1, 5, 5));
        p_tf.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_tf.add(this.tf_ip);
        p_tf.add(this.tf_isp);
        p_tf.add(this.tf_log_file_directory);
        p_tf.add(this.tf_log_file_regexp);
        p_tf.add(this.cb_log_file_format);
        JPanel p_lb_tf = new JPanel(new BorderLayout());
        p_lb_tf.setBorder(BorderFactory.createTitledBorder("FTP server"));
        p_lb_tf.add((Component)p_lb, "West");
        p_lb_tf.add((Component)p_tf, "Center");
        p_lb = new JPanel(new GridLayout(0, 1, 5, 5));
        p_lb.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_lb.add(new JLabel("FTP server"));
        p_lb.add(new JLabel("Username"));
        JPanel p_password = new JPanel(new FlowLayout(0, 0, 0));
        p_password.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        p_password.add(new JLabel("Password"));
        p_password.add(GUITools.createPrivacyButton("The password will be stored in your configuration file and will only be used to retrieve the log files.<br><br>If not provided here, it will be asked when required (as the log file download is done on a daily basis, it is recommended to provide it here).<br><br>The username/password are not transmitted to anyone (of course, excepted to the specified FTP server to get the log)."));
        p_lb.add(p_password);
        p_tf = new JPanel(new GridLayout(0, 1, 5, 5));
        p_tf.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_tf.add(this.tf_ftp_server);
        p_tf.add(this.tf_username);
        p_tf.add(this.tf_password);
        JPanel p_login_info = new JPanel(new BorderLayout());
        p_login_info.setBorder(BorderFactory.createTitledBorder("FTP login"));
        p_login_info.add((Component)p_lb, "West");
        p_login_info.add((Component)p_tf, "Center");
        JPanel p_auto_download = new JPanel(new FlowLayout(0));
        p_auto_download.add(this.cb_auto_download_files);
        p_auto_download.add(new JLabel(GUITools.internet_icon));
        p_auto_download.add(GUITools.createPrivacyButton("A internet connexion to this FTP server is made to retrieve the log files (and only to this end).<br><br>No internet connexion are made to other servers and only the log directory will be inspected on the FTP server."));
        p_login_info.add((Component)p_auto_download, "South");
        this.cb_auto_download_files.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FTPDataSourceConfigurator.this.auto_download_log_files = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        this.jl_aliases.setVisibleRowCount(3);
        JButton bt_add_alias = new JButton("Add alias");
        JPanel p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(bt_add_alias);
        p_bt.add(this.bt_del_alias);
        JLabel lb_aliases = new JLabel("Aliases");
        lb_aliases.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_aliases = new JPanel(new BorderLayout());
        p_aliases.add((Component)lb_aliases, "West");
        p_aliases.add((Component)new JScrollPane(this.jl_aliases), "Center");
        p_aliases.add((Component)p_bt, "East");
        final JFrame frame2 = frame;
        bt_add_alias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String alias = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new alias (e.g. www.foo.com)");
                if (alias != null) {
                    ((DefaultListModel)FTPDataSourceConfigurator.this.jl_aliases.getModel()).addElement(new Alias(alias));
                    FTPDataSourceConfigurator.this.bt_del_alias.setEnabled(true);
                }
            }
        });
        this.bt_del_alias.setEnabled(false);
        this.bt_del_alias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FTPDataSourceConfigurator.this.jl_aliases.getModel();
                int selected_index = FTPDataSourceConfigurator.this.jl_aliases.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FTPDataSourceConfigurator.this.bt_del_alias.setEnabled(false);
                    }
                }
            }
        });
        this.jl_dpes.setVisibleRowCount(3);
        p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(this.bt_add_dp);
        p_bt.add(this.bt_del_dp);
        JLabel lb_dpes = new JLabel("Default pages");
        lb_dpes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_dpes = new JPanel(new BorderLayout());
        p_dpes.add((Component)lb_dpes, "West");
        p_dpes.add((Component)new JScrollPane(this.jl_dpes), "Center");
        p_dpes.add((Component)p_bt, "East");
        this.bt_add_dp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dp = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new default page (e.g. index.html)");
                if (dp != null) {
                    ((DefaultListModel)FTPDataSourceConfigurator.this.jl_dpes.getModel()).addElement(new DefaultPage(dp));
                    FTPDataSourceConfigurator.this.bt_del_dp.setEnabled(true);
                }
            }
        });
        this.bt_del_dp.setEnabled(false);
        this.bt_del_dp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FTPDataSourceConfigurator.this.jl_dpes.getModel();
                int selected_index = FTPDataSourceConfigurator.this.jl_dpes.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FTPDataSourceConfigurator.this.bt_del_dp.setEnabled(false);
                    }
                }
            }
        });
        this.jl_rtes.setVisibleRowCount(3);
        p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(this.bt_add_rt);
        p_bt.add(this.bt_del_rt);
        JLabel lb_rtes = new JLabel("Robot traps");
        lb_rtes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_rtes = new JPanel(new BorderLayout());
        p_rtes.add((Component)lb_rtes, "West");
        p_rtes.add((Component)new JScrollPane(this.jl_rtes), "Center");
        p_rtes.add((Component)p_bt, "East");
        this.bt_add_rt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String rt = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new robot trap URL (e.g. /robot_trap.html)");
                if (rt != null) {
                    ((DefaultListModel)FTPDataSourceConfigurator.this.jl_rtes.getModel()).addElement(new RobotTrap(rt));
                    FTPDataSourceConfigurator.this.bt_del_rt.setEnabled(true);
                }
            }
        });
        this.bt_del_rt.setEnabled(false);
        this.bt_del_rt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FTPDataSourceConfigurator.this.jl_rtes.getModel();
                int selected_index = FTPDataSourceConfigurator.this.jl_rtes.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FTPDataSourceConfigurator.this.bt_del_rt.setEnabled(false);
                    }
                }
            }
        });
        JPanel p_web_info = new JPanel();
        p_web_info.setBorder(BorderFactory.createTitledBorder("Web site"));
        p_web_info.setLayout(new BoxLayout(p_web_info, 1));
        p_web_info.add(p_aliases);
        p_web_info.add(p_dpes);
        p_web_info.add(p_rtes);
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        JPanel p_welcome = new JPanel();
        p_welcome.setLayout(new BoxLayout(p_welcome, 1));
        p_welcome.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p_welcome.add(p_domain_name);
        p_welcome.add(p_lb_tf);
        p_welcome.add(p_login_info);
        p_welcome.add(p_web_info);
        p_welcome.add(p_buttons);
        final JDialog dialog = new JDialog(frame, "FTP data source configuration", true);
        dialog.getContentPane().add(p_welcome);
        if (domain_name != null) {
            this.tf_domain_name.setText(domain_name);
        } else {
            this.setEnabledFormFields(true);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FTPDataSourceConfigurator.this.form_validated = FTPDataSourceConfigurator.this.validateForm();
                if (FTPDataSourceConfigurator.this.form_validated) {
                    dialog.setVisible(false);
                }
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FTPDataSourceConfigurator.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        return dialog;
    }

    public void setDataSource(DataSource datasource) {
        if (datasource == null) {
            datasource = new FTPDataSource(this.host);
        }
        this.existing_ds = (FTPDataSource)datasource;
        this.autofill_form(this.existing_ds);
    }

    public void updateDataSource(DataSource model_to_update) {
        model_to_update.setData(this.internal_ds);
    }

    public DataSource getDataSource() {
        FTPDataSource ds = new FTPDataSource(this.host);
        this.validateForm(true);
        ds.setData(this.internal_ds);
        return ds;
    }

    public boolean validateForm() {
        return this.validateForm(false);
    }

    public boolean validateForm(boolean silent) {
        Enumeration e;
        this.internal_ds = new FTPDataSource(this.host);
        this.internal_ds.setServerIP(this.tf_ip.getText());
        this.internal_ds.setUsername(this.tf_username.getText());
        this.internal_ds.setPassword(new String(this.tf_password.getPassword()));
        this.internal_ds.setAutoDownload(this.auto_download_log_files);
        ISPDatabase isp_database = ISPDatabaseParser.getDefaultDatabase();
        ISP isp = isp_database.getISP(this.internal_ds.getServerIP());
        if (isp == null) {
            isp = new ISP();
            isp.setName(this.tf_isp.getText());
            isp.setLogDirectory(this.tf_log_file_directory.getText());
            isp.setLogFilenameRegExp(this.tf_log_file_regexp.getText());
            isp.setLogServerURL(this.tf_ftp_server.getText());
            if (this.cb_log_file_format.getSelectedIndex() > 0) {
                isp.setLogFormat((LogFormat)LogFormatManager.availableLogFormats().elementAt(this.cb_log_file_format.getSelectedIndex()));
            }
            DefaultListModel lm = (DefaultListModel)this.jl_dpes.getModel();
            e = lm.elements();
            while (e.hasMoreElements()) {
                isp.addDefaultPage((DefaultPage)e.nextElement());
            }
            this.internal_ds.addISP(isp);
        }
        this.internal_ds.setServerName(this.tf_ftp_server.getText());
        DefaultListModel model = (DefaultListModel)this.jl_aliases.getModel();
        e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addAlias((Alias)e.nextElement());
        }
        model = (DefaultListModel)this.jl_dpes.getModel();
        e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addDefaultPage((DefaultPage)e.nextElement());
        }
        model = (DefaultListModel)this.jl_rtes.getModel();
        e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addRobotTrap((RobotTrap)e.nextElement());
        }
        if (this.tf_isp.isEnabled() && !silent) {
            String message;
            int send_info;
            DefaultListModel lm = (DefaultListModel)this.jl_dpes.getModel();
            String default_page_list = "";
            Enumeration e2 = lm.elements();
            while (e2.hasMoreElements()) {
                default_page_list = String.valueOf(default_page_list) + ((DefaultPage)e2.nextElement()).getName() + ", ";
            }
            if (default_page_list.length() > 0) {
                default_page_list = default_page_list.substring(0, default_page_list.length() - 2);
            }
            if ((send_info = JOptionPane.showConfirmDialog(this.frame, message = "<html><p>You have manually entered some information that were not <br>available in Log(psycho)Analyst.</p><p>You can give these information to the Log(psycho)Analyst project <br>so that they will be available to other users hosted by the same ISP.</p><p><br>Do you agree to send the following information?</p><ul><li>ISP name (<font color=red>" + this.tf_isp.getText() + "</font>)" + "<li>log file directory (<font color=red>" + this.tf_log_file_directory.getText() + "</font>)" + "<li>log file name (<font color=red>" + this.tf_log_file_regexp.getText() + "</font>)" + "<li>log file format (<font color=red>" + this.cb_log_file_format.getSelectedItem() + "</font>)" + "<li>default pages (<font color=red>" + default_page_list + ")" + "<li>IP* (<font color=red>" + this.tf_ip.getText() + "</font>)" + "<li>FTP server* (<font color=red>" + this.tf_ftp_server.getText() + "</font>)" + "</ul>" + "<p>* These information will not be shared with other users but are <br>needed by Log(psycho)Analyst team to improve the ISP database.</p>", "Help us to improve the ISP database", 0, 3)) == 0) {
                Tools.sendByFormmail(message, "New ISP submission");
            }
        }
        return true;
    }

    public void autofill_form(FTPDataSource datasource) {
        Object obj;
        Enumeration e;
        DefaultListModel model;
        this.clearFormFields();
        if (datasource == null) {
            throw new RuntimeException("no datasource provided.");
        }
        String ip = datasource.getServerIP();
        String domain_name = datasource.getHost().getDomainName();
        if (domain_name != null) {
            this.tf_domain_name.setText(domain_name);
            String ip2 = null;
            try {
                ip2 = InetAddress.getByName(domain_name).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (ip2 == null) {
                JOptionPane.showMessageDialog(this.frame, "<html><p width=250>could not connect to the net to get the IP address of '" + domain_name + "'.<br><br>Reason: no internet connection or bad address.", "DNS query error", 0);
            } else {
                ip = ip2;
            }
        }
        this.tf_ip.setText(ip);
        this.tf_username.setText(datasource.getUsername());
        this.tf_password.setText(datasource.getPassword());
        this.cb_auto_download_files.setSelected(datasource.isAutoDownloadUsed());
        ISP isp = null;
        boolean is_isp_local = false;
        if (datasource.getIspAsIsp() != null) {
            isp = datasource.getIspAsIsp();
            is_isp_local = true;
        } else {
            isp = ISPDatabaseParser.getDefaultDatabase().getISP(ip);
        }
        this.setEnabledFormFields(is_isp_local);
        if (isp != null) {
            this.tf_isp.setText(isp.name);
            this.tf_ip.setText(ip);
            if (isp.log_url != null) {
                this.tf_ftp_server.setText(isp.getLogServerURL().replaceAll("\\{domain_name\\}", domain_name));
            }
            this.tf_log_file_directory.setText(isp.getLogDirectory());
            this.tf_log_file_regexp.setText(isp.getLogFilenameRegExp());
            if (isp.getLogFormatAsLogFormat() != null) {
                this.cb_log_file_format.setSelectedItem(isp.getLogFormatAsLogFormat().getClass().getName());
            }
            model = (DefaultListModel)this.jl_dpes.getModel();
            model.clear();
            e = isp.default_pages();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (!model.contains(obj)) {
                    model.addElement(obj);
                }
                this.bt_del_dp.setEnabled(true);
            }
        }
        model = (DefaultListModel)this.jl_aliases.getModel();
        model.clear();
        e = datasource.aliases();
        while (e.hasMoreElements()) {
            obj = e.nextElement();
            if (!model.contains(obj)) {
                model.addElement(obj);
            }
            this.bt_del_alias.setEnabled(true);
        }
        if (isp != null) {
            e = isp.aliases();
            while (e.hasMoreElements()) {
                obj = new Alias(((Alias)e.nextElement()).getName().replaceAll("\\{domain_name\\}", domain_name));
                if (!model.contains(obj)) {
                    model.addElement(obj);
                }
                this.bt_del_alias.setEnabled(true);
            }
        }
        model = (DefaultListModel)this.jl_rtes.getModel();
        model.clear();
        e = datasource.getRobotTrap().elements();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
            this.bt_del_rt.setEnabled(true);
        }
    }

    public boolean ask() {
        if (this.host != null) {
            this.tf_domain_name.setText(this.host.getDomainName());
        }
        this.f.setVisible(true);
        return this.form_validated;
    }
}

