/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.FileDataSource;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.RobotTrap;
import ch.kronospace.logpsychoanalyst.conf.DataSourceConfigurationDialog;
import ch.kronospace.logpsychoanalyst.database.GeographicDatabaseParser;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.logformat.LogFormatManager;
import ch.kronospace.tools.DOSCommands;
import ch.kronospace.tools.GUITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FileDataSourceConfigurator
extends DataSourceConfigurationDialog {
    private String domain_name = null;
    private Host host = null;
    private FileDataSource internal_ds = null;
    private FileDataSource existing_ds = null;
    private boolean form_validated = false;
    private Locale[] countries = null;
    private JTextField tf_dir = new JTextField(30);
    private JTextField tf_file_pattern = new JTextField(30);
    private JCheckBox cb_recursive = new JCheckBox("Recursive directory processing", true);
    private JComboBox cb_tz;
    private JComboBox cb_country;
    private JComboBox cb_format = new JComboBox();
    private TimeZone local_timezone = GeographicDatabaseParser.getDefaultDatabase().getTimeZone(Locale.getDefault().getCountry());
    private JDialog f;
    private JFrame frame;
    private final JList jl_aliases;
    private final JList jl_dpes;
    private final JList jl_rtes;
    private final JButton bt_del_dp;
    private JButton bt_add_dp;
    private final JButton bt_del_alias;
    private final JButton bt_del_rt;
    private JButton bt_add_rt;

    public FileDataSourceConfigurator(JFrame frame) {
        Object[] tzs = TimeZone.getAvailableIDs();
        Arrays.sort(tzs);
        this.cb_tz = new JComboBox<Object>(tzs);
        if (this.local_timezone != null) {
            this.cb_tz.setSelectedItem(this.local_timezone.getID());
        }
        String[] country_codes = Locale.getISOCountries();
        String[] country_names = new String[country_codes.length];
        this.countries = new Locale[country_codes.length];
        Locale l = Locale.getDefault();
        int i = 0;
        while (i < country_codes.length) {
            this.countries[i] = new Locale(l.getLanguage(), country_codes[i]);
            ++i;
        }
        Arrays.sort(this.countries, new Comparator(){

            public int compare(Object o1, Object o2) {
                Locale l1 = (Locale)o1;
                Locale l2 = (Locale)o2;
                return l1.getDisplayCountry().compareTo(l2.getDisplayCountry());
            }

            public boolean equals(Object o) {
                return true;
            }
        });
        i = 0;
        while (i < country_codes.length) {
            country_names[i] = this.countries[i].getDisplayCountry();
            ++i;
        }
        this.cb_country = new JComboBox<String>(country_names);
        this.cb_country.setSelectedItem(Locale.getDefault().getDisplayCountry());
        Enumeration e = LogFormatManager.availableLogFormats().elements();
        while (e.hasMoreElements()) {
            LogFormat lf = (LogFormat)e.nextElement();
            this.cb_format.addItem(lf.getClass().getName());
        }
        this.f = null;
        this.jl_aliases = new JList(new DefaultListModel());
        this.jl_dpes = new JList(new DefaultListModel());
        this.jl_rtes = new JList(new DefaultListModel());
        this.bt_del_dp = new JButton("Remove default page");
        this.bt_add_dp = new JButton("Add default page");
        this.bt_del_alias = new JButton("Remove alias");
        this.bt_del_rt = new JButton("Remove robot trap");
        this.bt_add_rt = new JButton("Add robot trap");
        this.f = this.createConfigDialog(this.domain_name, frame);
        this.frame = frame;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public void clearFormFields() {
        this.tf_dir.setText("");
        this.cb_recursive.setSelected(true);
        this.tf_file_pattern.setText("");
    }

    public JDialog createConfigDialog(String domain_name, JFrame frame) {
        Cursor old_cursor = frame.getCursor();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        JButton bt_explore_dir = new JButton(new ImageIcon("images/file_open.png"));
        bt_explore_dir.setToolTipText("Open the file or directory using the default tool.");
        bt_explore_dir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DOSCommands.start(FileDataSourceConfigurator.this.tf_dir.getText(), "ouvre l'explorer");
            }
        });
        JButton bt_dir_browse = new JButton("Browse...");
        bt_dir_browse.setToolTipText("Browse the local filesystem to select another log file or directory.");
        final JFrame frame2 = frame;
        bt_dir_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(2);
                int result = fc.showOpenDialog(frame2);
                if (result == 0) {
                    String filename = fc.getCurrentDirectory().getAbsolutePath();
                    if (fc.getSelectedFile() != null) {
                        File cur_file = fc.getSelectedFile();
                        if (!cur_file.exists()) {
                            cur_file = cur_file.getParentFile();
                        }
                        filename = cur_file.getAbsolutePath();
                    }
                    FileDataSourceConfigurator.this.tf_dir.setText(filename);
                }
            }
        });
        JPanel p_dir = new JPanel(new FlowLayout(0));
        p_dir.add(new JLabel("Log files directory"));
        p_dir.add(this.tf_dir);
        p_dir.add(bt_dir_browse);
        p_dir.add(bt_explore_dir);
        JPanel p_file_pattern = new JPanel(new FlowLayout(0));
        p_file_pattern.add(new JLabel("Filename pattern (by default: all files)"));
        p_file_pattern.add(this.tf_file_pattern);
        JLabel lb_hint_dir = new JLabel("Hint: you can put all your log files in this directory (or change it to point your your log file or directory).");
        lb_hint_dir.setAlignmentX(0.5f);
        this.cb_recursive.setAlignmentX(0.5f);
        JPanel p_file_ds = new JPanel(new FlowLayout(0));
        p_file_ds.setBorder(BorderFactory.createTitledBorder("File data source"));
        p_file_ds.setLayout(new BoxLayout(p_file_ds, 1));
        p_file_ds.add(p_dir);
        p_file_ds.add(lb_hint_dir);
        p_file_ds.add(this.cb_recursive);
        p_file_ds.add(p_file_pattern);
        JPanel p_tz = new JPanel(new FlowLayout(0));
        p_tz.add(new JLabel("Server timezone"));
        p_tz.add(this.cb_tz);
        JPanel p_country = new JPanel(new FlowLayout(0));
        p_country.add(new JLabel("Server country"));
        p_country.add(this.cb_country);
        JPanel p_file_format = new JPanel(new FlowLayout(0));
        p_file_format.add(new JLabel("Log file format"));
        p_file_format.add(this.cb_format);
        JPanel p_format = new JPanel();
        p_format.setBorder(BorderFactory.createTitledBorder("Log file format"));
        p_format.setLayout(new BoxLayout(p_format, 1));
        p_format.add(p_tz);
        p_format.add(p_country);
        p_format.add(p_file_format);
        this.jl_aliases.setVisibleRowCount(3);
        JButton bt_add_alias = new JButton("Add alias");
        JPanel p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(bt_add_alias);
        p_bt.add(this.bt_del_alias);
        JLabel lb_aliases = new JLabel("Aliases");
        lb_aliases.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_aliases = new JPanel(new BorderLayout());
        p_aliases.add((Component)lb_aliases, "West");
        p_aliases.add((Component)new JScrollPane(this.jl_aliases), "Center");
        p_aliases.add((Component)p_bt, "East");
        bt_add_alias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String alias = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new alias (e.g. www.foo.com)");
                if (alias != null) {
                    ((DefaultListModel)FileDataSourceConfigurator.this.jl_aliases.getModel()).addElement(new Alias(alias));
                    FileDataSourceConfigurator.this.bt_del_alias.setEnabled(true);
                }
            }
        });
        this.bt_del_alias.setEnabled(false);
        this.bt_del_alias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FileDataSourceConfigurator.this.jl_aliases.getModel();
                int selected_index = FileDataSourceConfigurator.this.jl_aliases.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FileDataSourceConfigurator.this.bt_del_alias.setEnabled(false);
                    }
                }
            }
        });
        this.jl_dpes.setVisibleRowCount(3);
        p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(this.bt_add_dp);
        p_bt.add(this.bt_del_dp);
        JLabel lb_dpes = new JLabel("Default pages");
        lb_dpes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_dpes = new JPanel(new BorderLayout());
        p_dpes.add((Component)lb_dpes, "West");
        p_dpes.add((Component)new JScrollPane(this.jl_dpes), "Center");
        p_dpes.add((Component)p_bt, "East");
        this.bt_add_dp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dp = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new default page (e.g. index.html)");
                if (dp != null) {
                    ((DefaultListModel)FileDataSourceConfigurator.this.jl_dpes.getModel()).addElement(new DefaultPage(dp));
                    FileDataSourceConfigurator.this.bt_del_dp.setEnabled(true);
                }
            }
        });
        this.bt_del_dp.setEnabled(false);
        this.bt_del_dp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FileDataSourceConfigurator.this.jl_dpes.getModel();
                int selected_index = FileDataSourceConfigurator.this.jl_dpes.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FileDataSourceConfigurator.this.bt_del_dp.setEnabled(false);
                    }
                }
            }
        });
        this.jl_rtes.setVisibleRowCount(3);
        p_bt = new JPanel();
        p_bt.setLayout(new BoxLayout(p_bt, 1));
        p_bt.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p_bt.add(this.bt_add_rt);
        p_bt.add(this.bt_del_rt);
        JLabel lb_rtes = new JLabel("Robot traps");
        lb_rtes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        JPanel p_rtes = new JPanel(new BorderLayout());
        p_rtes.add((Component)lb_rtes, "West");
        p_rtes.add((Component)new JScrollPane(this.jl_rtes), "Center");
        p_rtes.add((Component)p_bt, "East");
        this.bt_add_rt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String rt = JOptionPane.showInputDialog(frame2, (Object)"Please enter a new robot trap URL (e.g. /robot_trap.html)");
                if (rt != null) {
                    ((DefaultListModel)FileDataSourceConfigurator.this.jl_rtes.getModel()).addElement(new RobotTrap(rt));
                    FileDataSourceConfigurator.this.bt_del_rt.setEnabled(true);
                }
            }
        });
        this.bt_del_rt.setEnabled(false);
        this.bt_del_rt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)FileDataSourceConfigurator.this.jl_rtes.getModel();
                int selected_index = FileDataSourceConfigurator.this.jl_rtes.getSelectedIndex();
                if (selected_index >= 0) {
                    model.remove(selected_index);
                    if (model.size() == 0) {
                        FileDataSourceConfigurator.this.bt_del_rt.setEnabled(false);
                    }
                }
            }
        });
        JPanel p_web_info = new JPanel();
        p_web_info.setBorder(BorderFactory.createTitledBorder("Web site"));
        p_web_info.setLayout(new BoxLayout(p_web_info, 1));
        p_web_info.add(p_aliases);
        p_web_info.add(p_dpes);
        p_web_info.add(p_rtes);
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        JPanel p_welcome = new JPanel();
        p_welcome.setLayout(new BoxLayout(p_welcome, 1));
        p_welcome.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p_welcome.add(p_file_ds);
        p_welcome.add(p_format);
        p_welcome.add(p_web_info);
        p_welcome.add(p_buttons);
        final JDialog dialog = new JDialog(frame, "File data source configuration", true);
        dialog.getContentPane().add(p_welcome);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDataSourceConfigurator.this.form_validated = true;
                dialog.setVisible(false);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDataSourceConfigurator.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        frame.setCursor(old_cursor);
        return dialog;
    }

    public void autofill_form(FileDataSource datasource) {
        if (datasource == null) {
            throw new RuntimeException("null datasource provided");
        }
        this.tf_dir.setText(datasource.getDirectory().getAbsolutePath());
        this.cb_recursive.setSelected(datasource.isRecursive());
        this.tf_file_pattern.setText(datasource.getFilePattern());
        if (datasource.getTimeZone() != null) {
            this.cb_tz.setSelectedItem(datasource.getTimeZone().getID());
        } else if (this.local_timezone != null) {
            this.cb_tz.setSelectedItem(this.local_timezone.getID());
        }
        if (datasource.getCountry() != null) {
            this.cb_country.setSelectedItem(new Locale(Locale.getDefault().getLanguage(), datasource.getCountry()).getDisplayCountry());
        }
        if (datasource.getLogFormatAsLogFormat() != null) {
            this.cb_format.setSelectedItem(datasource.getLogFormatAsLogFormat().getClass().getName());
        }
        DefaultListModel model = (DefaultListModel)this.jl_aliases.getModel();
        model.clear();
        Enumeration e = datasource.aliases();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
            this.bt_del_alias.setEnabled(true);
        }
        model = (DefaultListModel)this.jl_dpes.getModel();
        model.clear();
        e = datasource.getDefaultPage().elements();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
            this.bt_del_dp.setEnabled(true);
        }
        model = (DefaultListModel)this.jl_rtes.getModel();
        model.clear();
        e = datasource.getRobotTrap().elements();
        while (e.hasMoreElements()) {
            model.addElement(e.nextElement());
            this.bt_del_rt.setEnabled(true);
        }
    }

    public void setDataSource(DataSource datasource) {
        if (datasource == null) {
            this.existing_ds = new FileDataSource(this.host);
            this.existing_ds.getDirectory().mkdirs();
        } else {
            this.existing_ds = (FileDataSource)datasource;
        }
        this.autofill_form(this.existing_ds);
    }

    public DataSource getDataSource() {
        FileDataSource ds = new FileDataSource(this.host);
        this.validateForm(true);
        ds.setData(this.internal_ds);
        return ds;
    }

    public void updateDataSource(DataSource model_to_update) {
        model_to_update.setData(this.internal_ds);
    }

    public boolean validateForm(boolean silent) {
        this.internal_ds = new FileDataSource(this.host);
        this.internal_ds.setDirectory(this.tf_dir.getText());
        this.internal_ds.setRecursive(this.cb_recursive.isSelected());
        this.internal_ds.setFilePattern(this.tf_file_pattern.getText());
        if (this.cb_tz.getSelectedItem() != null) {
            this.internal_ds.setTimeZone(TimeZone.getTimeZone(this.cb_tz.getSelectedItem().toString()));
        }
        if (this.cb_country.getSelectedIndex() >= 0) {
            this.internal_ds.setCountry(this.countries[this.cb_country.getSelectedIndex()].getCountry());
        }
        if (this.cb_format.getSelectedIndex() > 0) {
            this.internal_ds.setLogFormat((LogFormat)LogFormatManager.availableLogFormats().elementAt(this.cb_format.getSelectedIndex()));
        }
        DefaultListModel model = (DefaultListModel)this.jl_aliases.getModel();
        this.internal_ds.getAlias().clear();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addAlias((Alias)e.nextElement());
        }
        model = (DefaultListModel)this.jl_dpes.getModel();
        this.internal_ds.getDefaultPage().clear();
        e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addDefaultPage((DefaultPage)e.nextElement());
        }
        model = (DefaultListModel)this.jl_rtes.getModel();
        this.internal_ds.getRobotTrap().clear();
        e = model.elements();
        while (e.hasMoreElements()) {
            this.internal_ds.addRobotTrap((RobotTrap)e.nextElement());
        }
        return true;
    }

    public boolean ask() {
        this.f.setVisible(true);
        this.form_validated = this.validateForm(true);
        return this.form_validated;
    }
}

