/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.AuthenticatedUserHiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.HiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IPRangeHiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.ListItem;
import ch.kronospace.logpsychoanalyst.SecretURLHiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.conf.Configurator;
import ch.kronospace.tools.GUITools;
import ch.kronospace.tools.RadioButtonPanel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HiddenVisitFilterEditor
implements Configurator {
    Random r = new Random();
    private boolean form_validated = false;
    private Host host;
    JTextField tf_ip_start = new JTextField(16);
    JTextField tf_ip_stop = new JTextField(16);
    JTextField tf_secret_url = new JTextField(16);
    JTextField tf_username = new JTextField(16);
    JTextField tf_name = new JTextField(16);
    RadioButtonPanel p_secret_url = null;
    RadioButtonPanel p_ip_range = null;
    RadioButtonPanel p_username = null;
    public static Vector processing_type_options = new Vector();
    JComboBox jl_processing_type = new JComboBox(processing_type_options);
    JDialog dialog;
    JFrame frame;
    static HiddenVisitFilterEditor singleton;

    static {
        processing_type_options.add(new ListItem("robot", "Consider as a robot"));
        processing_type_options.add(new ListItem("hide", "Just hide"));
        singleton = null;
    }

    private HiddenVisitFilterEditor(JFrame frame) {
        this.jl_processing_type.setSelectedIndex(0);
        this.dialog = null;
        this.frame = null;
        this.frame = frame;
    }

    public static HiddenVisitFilterEditor getInstance(JFrame frame) {
        if (singleton == null) {
            singleton = new HiddenVisitFilterEditor(frame);
        }
        return singleton;
    }

    public void setDomainName(String domain_name) {
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public JDialog createDialog() {
        final JDialog dialog = new JDialog(this.frame, "Hidden visit filter", true);
        JPanel p_full = new JPanel();
        p_full.setLayout(new BoxLayout(p_full, 1));
        p_full.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        p_full.add(this.getFilterTypePanel());
        p_full.add(p_buttons);
        dialog.getContentPane().add(p_full);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HiddenVisitFilterEditor.this.form_validated = true;
                dialog.setVisible(false);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HiddenVisitFilterEditor.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        return dialog;
    }

    private JPanel getFilterTypePanel() {
        JLabel lb_url = new JLabel("http://www.foo.com");
        JPanel p_secret_url_temp = new JPanel(new FlowLayout(0));
        p_secret_url_temp.add(lb_url);
        p_secret_url_temp.add(this.tf_secret_url);
        this.p_secret_url = new RadioButtonPanel("Secret URL", new JComponent[]{this.tf_secret_url, lb_url}, p_secret_url_temp);
        JLabel lb_name = new JLabel("Filter name:");
        JLabel lb_ip_start = new JLabel("From IP (e.g. 129.194.1.2):");
        JLabel lb_ip_stop = new JLabel("to IP (e.g. 129.194.255.255):");
        JPanel p_ip_range_temp = new JPanel();
        p_ip_range_temp.setLayout(new BoxLayout(p_ip_range_temp, 1));
        JPanel row = new JPanel(new FlowLayout(0));
        row.add(lb_ip_start);
        row.add(this.tf_ip_start);
        p_ip_range_temp.add(row);
        row = new JPanel(new FlowLayout(0));
        row.add(lb_ip_stop);
        row.add(this.tf_ip_stop);
        p_ip_range_temp.add(row);
        row = new JPanel(new FlowLayout(0));
        row.add(lb_name);
        row.add(this.tf_name);
        p_ip_range_temp.add(row);
        this.p_ip_range = new RadioButtonPanel("IP range", new JComponent[]{this.tf_ip_start, this.tf_ip_stop, lb_ip_stop, lb_ip_start, lb_name, this.tf_name}, p_ip_range_temp);
        JLabel lb_username = new JLabel("Username:");
        JPanel p_username_temp = new JPanel(new FlowLayout(0));
        p_username_temp.add(lb_username);
        p_username_temp.add(this.tf_username);
        this.p_username = new RadioButtonPanel("Authenticated user", new JComponent[]{this.tf_username, lb_username}, p_username_temp);
        JLabel lb_processing_type = new JLabel("Processing type");
        JPanel p_processing_type_temp = new JPanel(new FlowLayout(0));
        p_processing_type_temp.add(lb_processing_type);
        p_processing_type_temp.add(this.jl_processing_type);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.p_secret_url.getRadioButton());
        btg.add(this.p_ip_range.getRadioButton());
        btg.add(this.p_username.getRadioButton());
        this.p_secret_url.getRadioButton().setSelected(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createTitledBorder("Type of hidden visit filter"));
        p.add(this.p_secret_url);
        p.add(this.p_ip_range);
        p.add(this.p_username);
        p.add(p_processing_type_temp);
        return p;
    }

    private char getPasswordChar() {
        char c;
        while (!Character.isLetterOrDigit(c = (char)this.r.nextInt(128))) {
        }
        return c;
    }

    public boolean ask() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        if (this.tf_secret_url.getText().length() == 0) {
            String secret_url = "";
            int i = 0;
            while (i < 8) {
                secret_url = String.valueOf(secret_url) + this.getPasswordChar();
                ++i;
            }
            this.tf_secret_url.setText("/lpa/" + secret_url);
        }
        if (this.tf_ip_start.getText().length() == 0) {
            try {
                this.tf_ip_start.setText(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tf_ip_stop.getText().length() == 0) {
            try {
                this.tf_ip_stop.setText(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tf_name.getText().length() == 0) {
            this.tf_name.setText("Current host");
        }
        this.dialog.setVisible(true);
        return this.form_validated;
    }

    public static int getProcessingTypeIndex(String name) {
        return processing_type_options.indexOf(new ListItem(name, ""));
    }

    public void setHiddenVisitFilter(HiddenVisitFilter filter) {
        if (this.p_secret_url == null) {
            this.dialog = this.createDialog();
        }
        if (filter instanceof SecretURLHiddenVisitFilter) {
            SecretURLHiddenVisitFilter f = (SecretURLHiddenVisitFilter)filter;
            this.p_secret_url.getRadioButton().setSelected(true);
            this.tf_secret_url.setText(f.getURL());
            this.jl_processing_type.setSelectedIndex(HiddenVisitFilterEditor.getProcessingTypeIndex(f.getProcessingType()));
        } else if (filter instanceof IPRangeHiddenVisitFilter) {
            IPRangeHiddenVisitFilter f = (IPRangeHiddenVisitFilter)filter;
            this.p_ip_range.getRadioButton().setSelected(true);
            this.tf_ip_start.setText(f.getIPStart());
            this.tf_ip_stop.setText(f.getIPStop());
            this.tf_name.setText(f.getName());
            this.jl_processing_type.setSelectedIndex(HiddenVisitFilterEditor.getProcessingTypeIndex(f.getProcessingType()));
        } else if (filter instanceof AuthenticatedUserHiddenVisitFilter) {
            AuthenticatedUserHiddenVisitFilter f = (AuthenticatedUserHiddenVisitFilter)filter;
            this.p_username.getRadioButton().setSelected(true);
            this.tf_username.setText(f.getUsername());
            this.jl_processing_type.setSelectedIndex(HiddenVisitFilterEditor.getProcessingTypeIndex(f.getProcessingType()));
        } else {
            throw new RuntimeException(String.valueOf(this.getClass().getName().toString()) + ".setHiddenVisitFilter(HiddenVisitFilter) is not implemented for objects of class " + filter.getClass().getName().toString());
        }
    }

    public HiddenVisitFilter getHiddenVisitFilter() {
        if (this.p_secret_url.getRadioButton().isSelected()) {
            SecretURLHiddenVisitFilter hvf = new SecretURLHiddenVisitFilter();
            hvf.setURL(this.tf_secret_url.getText());
            hvf.setProcessingType(((ListItem)this.jl_processing_type.getSelectedItem()).getName());
            this.tf_secret_url.setText("");
            return hvf;
        }
        if (this.p_ip_range.getRadioButton().isSelected()) {
            IPRangeHiddenVisitFilter hvf = new IPRangeHiddenVisitFilter();
            hvf.setIPStart(this.tf_ip_start.getText());
            hvf.setIPStop(this.tf_ip_stop.getText());
            hvf.setName(this.tf_name.getText());
            hvf.setProcessingType(((ListItem)this.jl_processing_type.getSelectedItem()).getName());
            return hvf;
        }
        if (this.p_username.getRadioButton().isSelected()) {
            AuthenticatedUserHiddenVisitFilter hvf = new AuthenticatedUserHiddenVisitFilter();
            hvf.setUsername(this.tf_username.getText());
            hvf.setProcessingType(((ListItem)this.jl_processing_type.getSelectedItem()).getName());
            return hvf;
        }
        return null;
    }
}

