/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.HiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.conf.HiddenVisitFilterEditor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class HiddenVisitFilterTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5327564898848893118L;
    Vector events = new Vector();
    Host host = null;

    public void removeRow(int row) {
        this.events.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void replaceFilter(int index, HiddenVisitFilter filter) {
        this.events.remove(index);
        this.events.insertElementAt(filter, index);
        this.fireTableDataChanged();
    }

    public HiddenVisitFilter getFilter(int index) {
        return (HiddenVisitFilter)this.events.elementAt(index);
    }

    public void addRow(HiddenVisitFilter h) {
        this.events.add(h);
        this.fireTableDataChanged();
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Filter name";
            }
            case 1: {
                return "Filter type";
            }
            case 2: {
                return "Processing type";
            }
        }
        return "[bad column index]";
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        if (this.host == null) {
            return 0;
        }
        return this.events.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.host == null) {
            return "null host";
        }
        HiddenVisitFilter filter = (HiddenVisitFilter)this.events.elementAt(row);
        if (filter == null) {
            return "null";
        }
        switch (col) {
            case 0: {
                return filter.getName();
            }
            case 1: {
                return filter.getType();
            }
            case 2: {
                return HiddenVisitFilterEditor.processing_type_options.get(HiddenVisitFilterEditor.getProcessingTypeIndex(filter.getProcessingType()));
            }
        }
        return "[bad column index]";
    }

    public void setHost(Host h) {
        this.host = h;
        this.events.clear();
        Enumeration e = this.host.getHiddenVisitFilter().elements();
        while (e.hasMoreElements()) {
            this.events.add(e.nextElement());
        }
    }
}

