/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.HistoryGraphEvent;
import ch.kronospace.logpsychoanalyst.Host;
import java.awt.Color;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class HistoryGraphEventTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3303917811274375895L;
    Vector events = new Vector();
    Host host = null;

    public void removeRow(int row) {
        this.events.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public HistoryGraphEvent getHistoryGraphEvent(int index) {
        return (HistoryGraphEvent)this.events.elementAt(index);
    }

    public void addHistoryGraphEvent(HistoryGraphEvent h) {
        this.events.add(h);
        Collections.sort(this.events);
        this.fireTableDataChanged();
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Date";
            }
            case 2: {
                return "Color";
            }
        }
        return "[bad column index]";
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.events.size();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Object getValueAt(int row, int col) {
        HistoryGraphEvent ds = (HistoryGraphEvent)this.events.elementAt(row);
        if (ds == null) {
            return "null";
        }
        switch (col) {
            case 0: {
                return ds.getName();
            }
            case 1: {
                return ds.getCalendar();
            }
            case 2: {
                return ds.getColorAsColor();
            }
        }
        return "[bad column index]";
    }

    public void setValueAt(Object value, int row, int col) {
        HistoryGraphEvent ds = (HistoryGraphEvent)this.events.elementAt(row);
        switch (col) {
            case 0: {
                ds.setName((String)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                ds.setDateAsCalendar((Calendar)value);
                Collections.sort(this.events);
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                ds.setColorAsColor((Color)value);
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    public void setHost(Host h) {
        this.host = h;
        this.events.clear();
        Enumeration e = this.host.getHistoryGraphEvent().elements();
        while (e.hasMoreElements()) {
            this.events.add(e.nextElement());
        }
        Collections.sort(this.events);
        this.fireTableDataChanged();
    }
}

