/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.HiddenVisitFilter;
import ch.kronospace.logpsychoanalyst.HistoryGraphEvent;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.PluginProperties;
import ch.kronospace.logpsychoanalyst.ProductReferer;
import ch.kronospace.logpsychoanalyst.URLAliasParam;
import ch.kronospace.logpsychoanalyst.URLAliasParamValue;
import ch.kronospace.logpsychoanalyst.conf.CalendarEditor;
import ch.kronospace.logpsychoanalyst.conf.CalendarRenderer;
import ch.kronospace.logpsychoanalyst.conf.ColorEditor;
import ch.kronospace.logpsychoanalyst.conf.ColorRenderer;
import ch.kronospace.logpsychoanalyst.conf.Configurator;
import ch.kronospace.logpsychoanalyst.conf.DataSourceConfigurationDialog;
import ch.kronospace.logpsychoanalyst.conf.DataSourceTableModel;
import ch.kronospace.logpsychoanalyst.conf.HiddenVisitFilterEditor;
import ch.kronospace.logpsychoanalyst.conf.HiddenVisitFilterTableModel;
import ch.kronospace.logpsychoanalyst.conf.HistoryGraphEventTableModel;
import ch.kronospace.logpsychoanalyst.conf.HttpReportConfigurator;
import ch.kronospace.logpsychoanalyst.conf.NewDataSourceDialog;
import ch.kronospace.logpsychoanalyst.conf.ProductRefererEditor;
import ch.kronospace.logpsychoanalyst.conf.ProductRefererTableModel;
import ch.kronospace.logpsychoanalyst.conf.URLAliasParamTreeModel;
import ch.kronospace.logpsychoanalyst.plugins.Plugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.tools.DOSCommands;
import ch.kronospace.tools.GUITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HostConfigurator
implements Configurator {
    private Host current_host = null;
    private boolean form_validated = false;
    JTextField tf_domain_name = new JTextField(30);
    final DataSourceTableModel dataModel;
    final JTable jt_ds;
    JButton bt_ds_add;
    JButton bt_ds_edit;
    JButton bt_ds_del;
    final HistoryGraphEventTableModel dataModel_hge;
    final JTable jt_hge;
    JButton bt_hge_add;
    JButton bt_hge_edit;
    JButton bt_hge_del;
    final ProductRefererTableModel pr_dataModel;
    final JTable jt_pr;
    JButton bt_pr_add;
    JButton bt_pr_edit;
    JButton bt_pr_del;
    final HiddenVisitFilterTableModel hv_dataModel;
    final JTable jt_hv;
    JButton bt_hv_add;
    JButton bt_hv_edit;
    JButton bt_hv_del;
    JDialog f;
    JFrame frame;
    HttpReportConfigurator report_config;
    URLAliasParamTreeModel tm_url_aliases;
    JTree jt_urlalias_parameters;
    final JButton bt_configure;
    DefaultMutableTreeNode tm_plugins_root;
    DefaultTreeModel tm_plugins;
    JTree jt_plugins;

    public HostConfigurator(JFrame frame, Host current_host) {
        this.tf_domain_name.setEnabled(false);
        this.dataModel = new DataSourceTableModel();
        this.jt_ds = new JTable(this.dataModel);
        this.bt_ds_add = new JButton("Add source");
        this.bt_ds_edit = new JButton("Edit source");
        this.bt_ds_del = new JButton("Remove source");
        this.bt_ds_add.setToolTipText("Add a datasource.");
        this.bt_ds_edit.setToolTipText("Modify the selected datasource.");
        this.bt_ds_del.setToolTipText("Delete the selected datasources. No confirmation will be asked. The associated log files will not be deleted.");
        this.jt_ds.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.dataModel_hge = new HistoryGraphEventTableModel();
        this.jt_hge = new JTable(this.dataModel_hge);
        this.bt_hge_add = new JButton("Add event");
        this.bt_hge_edit = new JButton("Edit event");
        this.bt_hge_del = new JButton("Remove event");
        this.bt_hge_add.setToolTipText("Add an event.");
        this.bt_hge_edit.setToolTipText("Edit the events directly within the list.");
        this.bt_hge_del.setToolTipText("Delete the selected event(s). No confirmation will be asked.");
        this.bt_hge_edit.setEnabled(false);
        this.enable_events_buttons();
        ColorRenderer.setUpColorRenderer(this.jt_hge);
        ColorEditor.setUpColorEditor(this.jt_hge);
        CalendarRenderer.setUpCalendarRenderer(this.jt_hge);
        CalendarEditor.setUpCalendarEditor(this.jt_hge);
        this.pr_dataModel = new ProductRefererTableModel();
        this.jt_pr = new JTable(this.pr_dataModel);
        this.bt_pr_add = new JButton("Add product referer");
        this.bt_pr_edit = new JButton("Edit product referer");
        this.bt_pr_del = new JButton("Remove product referer");
        this.bt_pr_add.setToolTipText("Add a new product referer.");
        this.bt_pr_edit.setToolTipText("Edit the selected product referer.");
        this.bt_pr_del.setToolTipText("Delete the selected product referer(s). No confirmation will be asked.");
        this.enable_pr_buttons();
        this.hv_dataModel = new HiddenVisitFilterTableModel();
        this.jt_hv = new JTable(this.hv_dataModel);
        this.bt_hv_add = new JButton("Add filter");
        this.bt_hv_edit = new JButton("Edit filter");
        this.bt_hv_del = new JButton("Remove filter");
        this.enable_hvf_buttons();
        this.bt_hv_add.setToolTipText("Add an hidden visit filter.");
        this.bt_hv_edit.setToolTipText("Modify the selected hidden visit filter.");
        this.bt_hv_del.setToolTipText("Delete the selected hidden visit filter. No confirmation will be asked.");
        this.f = null;
        this.frame = null;
        this.report_config = null;
        this.tm_url_aliases = new URLAliasParamTreeModel();
        this.jt_urlalias_parameters = new JTree(this.tm_url_aliases);
        this.jt_urlalias_parameters.setVisibleRowCount(4);
        this.bt_configure = new JButton("Configure...");
        this.tm_plugins_root = new DefaultMutableTreeNode();
        this.tm_plugins = new DefaultTreeModel(this.tm_plugins_root);
        this.jt_plugins = new JTree(this.tm_plugins);
        this.jt_plugins.setVisibleRowCount(4);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Visit plugins");
        Enumeration e = PluginManager.getVisitPlugins().elements();
        while (e.hasMoreElements()) {
            node.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.tm_plugins_root.add(node);
        node = new DefaultMutableTreeNode("Advisor plugins");
        e = PluginManager.getAdvisorPlugins().elements();
        while (e.hasMoreElements()) {
            node.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.tm_plugins_root.add(node);
        node = new DefaultMutableTreeNode("Report plugins");
        e = PluginManager.getReportPlugins().elements();
        while (e.hasMoreElements()) {
            node.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.tm_plugins_root.add(node);
        node = new DefaultMutableTreeNode("Other plugins");
        e = PluginManager.getPlugins().elements();
        while (e.hasMoreElements()) {
            node.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.tm_plugins_root.add(node);
        this.jt_plugins.expandRow(0);
        this.jt_plugins.setRootVisible(false);
        final Host current_host2 = this.current_host;
        this.jt_plugins.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent arg0) {
                TreePath selected_path = HostConfigurator.this.jt_plugins.getSelectionPath();
                if (selected_path != null && selected_path.getPathCount() > 2) {
                    Object plugin = ((DefaultMutableTreeNode)selected_path.getPath()[2]).getUserObject();
                    if (plugin instanceof Plugin) {
                        HostConfigurator.this.bt_configure.setEnabled(((Plugin)plugin).getConfigPanel(current_host2) != null);
                    }
                } else {
                    HostConfigurator.this.bt_configure.setEnabled(false);
                }
            }
        });
        this.bt_configure.setEnabled(false);
        this.frame = frame;
        this.setHost(current_host);
        this.report_config = new HttpReportConfigurator(frame);
        this.f = this.createConfigDialog(frame);
    }

    public void setHost(Host h) {
        this.current_host = h;
        this.dataModel.setHost(this.current_host);
        this.dataModel_hge.setHost(this.current_host);
        this.hv_dataModel.setHost(this.current_host);
        this.enable_datasource_buttons();
        this.enable_hvf_buttons();
    }

    private void enable_datasource_buttons() {
        boolean state = this.dataModel.getRowCount() > 0;
        this.bt_ds_edit.setEnabled(state);
        this.bt_ds_del.setEnabled(state);
    }

    private void enable_events_buttons() {
        boolean state = this.dataModel_hge.getRowCount() > 0;
        this.bt_hge_del.setEnabled(state);
    }

    private void enable_hvf_buttons() {
        boolean state = this.hv_dataModel.getRowCount() > 0;
        this.bt_hv_edit.setEnabled(state);
        this.bt_hv_del.setEnabled(state);
    }

    private void enable_pr_buttons() {
        boolean state = this.pr_dataModel.getRowCount() > 0;
        this.bt_pr_edit.setEnabled(state);
        this.bt_pr_del.setEnabled(state);
    }

    public JPanel createHistoryGraphEventPanel(JFrame frame) {
        JScrollPane sp_jt_hge = new JScrollPane(this.jt_hge);
        sp_jt_hge.setPreferredSize(new Dimension(300, this.dataModel_hge.getRowCount() * this.jt_hge.getRowHeight()));
        this.jt_hge.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.jt_hge.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.jt_hge.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.bt_hge_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoryGraphEvent hge = new HistoryGraphEvent();
                hge.setDateAsCalendar(Calendar.getInstance());
                hge.setName("Enter your event name here...");
                HostConfigurator.this.dataModel_hge.addHistoryGraphEvent(hge);
                HostConfigurator.this.enable_events_buttons();
            }
        });
        this.bt_hge_del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = HostConfigurator.this.jt_hge.getSelectedRows();
                if (rows.length > 0) {
                    boolean choice = false;
                    if (choice) {
                        return;
                    }
                    int i = 0;
                    while (i < rows.length) {
                        HostConfigurator.this.dataModel_hge.removeRow(rows[i] - i);
                        ++i;
                    }
                    HostConfigurator.this.enable_events_buttons();
                }
            }
        });
        JPanel p_buttons = new JPanel();
        p_buttons.setLayout(new BoxLayout(p_buttons, 1));
        p_buttons.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_buttons.add(this.bt_hge_add);
        p_buttons.add(this.bt_hge_edit);
        p_buttons.add(this.bt_hge_del);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("History graph events"));
        p.add((Component)sp_jt_hge, "Center");
        p.add((Component)p_buttons, "East");
        return p;
    }

    public JPanel createHiddenVisitsPanel(JFrame frame) {
        JScrollPane sp_jt_hv = new JScrollPane(this.jt_hv);
        sp_jt_hv.setPreferredSize(new Dimension(200, this.hv_dataModel.getRowCount() * this.jt_hv.getRowHeight()));
        JPanel p_buttons_hv = new JPanel();
        p_buttons_hv.setLayout(new BoxLayout(p_buttons_hv, 1));
        p_buttons_hv.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_buttons_hv.add(this.bt_hv_add);
        p_buttons_hv.add(this.bt_hv_edit);
        p_buttons_hv.add(this.bt_hv_del);
        final JFrame frame2 = frame;
        this.bt_hv_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HiddenVisitFilterEditor f = HiddenVisitFilterEditor.getInstance(frame2);
                boolean b = f.ask();
                if (b) {
                    HiddenVisitFilter hvf = f.getHiddenVisitFilter();
                    HostConfigurator.this.hv_dataModel.addRow(hvf);
                    HostConfigurator.this.enable_hvf_buttons();
                }
            }
        });
        this.bt_hv_del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selected_indexes = HostConfigurator.this.jt_hv.getSelectedRows();
                int i = selected_indexes.length - 1;
                while (i >= 0) {
                    HostConfigurator.this.hv_dataModel.removeRow(selected_indexes[i]);
                    --i;
                }
                HostConfigurator.this.enable_hvf_buttons();
            }
        });
        this.bt_hv_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.edit_selected_hv();
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HostConfigurator.this.edit_selected_hv();
                }
            }
        };
        this.jt_hv.addMouseListener(mouseListener);
        JPanel p_hv = new JPanel(new BorderLayout());
        p_hv.setBorder(BorderFactory.createTitledBorder("Hidden visit filters"));
        p_hv.add((Component)sp_jt_hv, "Center");
        p_hv.add((Component)p_buttons_hv, "East");
        return p_hv;
    }

    public void edit_selected_hv() {
        int selected_index = this.jt_hv.getSelectedRow();
        if (selected_index >= 0) {
            HiddenVisitFilterEditor f = HiddenVisitFilterEditor.getInstance(this.frame);
            f.setHiddenVisitFilter(this.hv_dataModel.getFilter(selected_index));
            boolean b = f.ask();
            if (b) {
                HiddenVisitFilter hvf = f.getHiddenVisitFilter();
                this.hv_dataModel.replaceFilter(selected_index, hvf);
            }
        }
    }

    public JPanel createProductRefererPanel(JFrame frame) {
        JScrollPane sp_jt_pr = new JScrollPane(this.jt_pr);
        sp_jt_pr.setPreferredSize(new Dimension(300, this.pr_dataModel.getRowCount() * this.jt_pr.getRowHeight()));
        this.jt_pr.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.jt_pr.getColumnModel().getColumn(1).setPreferredWidth(50);
        final JFrame frame2 = frame;
        this.bt_pr_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProductRefererEditor editor = ProductRefererEditor.getInstance(frame2);
                editor.clear();
                boolean created = editor.ask();
                if (created) {
                    HostConfigurator.this.pr_dataModel.addProductReferer(editor.getProductReferer());
                    HostConfigurator.this.enable_pr_buttons();
                }
            }
        });
        this.bt_pr_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.edit_selected_pr();
            }
        });
        this.bt_pr_del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = HostConfigurator.this.jt_pr.getSelectedRows();
                if (rows.length > 0) {
                    boolean choice = false;
                    if (choice) {
                        return;
                    }
                    int i = 0;
                    while (i < rows.length) {
                        HostConfigurator.this.pr_dataModel.removeRow(rows[i] - i);
                        ++i;
                    }
                    HostConfigurator.this.enable_pr_buttons();
                }
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HostConfigurator.this.edit_selected_pr();
                }
            }
        };
        this.jt_ds.addMouseListener(mouseListener);
        JPanel p_buttons = new JPanel();
        p_buttons.setLayout(new BoxLayout(p_buttons, 1));
        p_buttons.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_buttons.add(this.bt_pr_add);
        p_buttons.add(this.bt_pr_edit);
        p_buttons.add(this.bt_pr_del);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Product referers"));
        p.add((Component)sp_jt_pr, "Center");
        p.add((Component)p_buttons, "East");
        return p;
    }

    public void edit_selected_pr() {
        int row = this.jt_pr.getSelectedRow();
        if (row < 0) {
            return;
        }
        ProductReferer pr = this.pr_dataModel.getProductReferer(row);
        ProductRefererEditor editor = ProductRefererEditor.getInstance(this.frame);
        editor.setProductReferer(pr);
        boolean changed = editor.ask();
        if (changed) {
            this.pr_dataModel.setProductReferer(editor.getProductReferer(), row);
        }
    }

    public JPanel createDatasourcesPanel(JFrame frame) {
        JScrollPane sp_jt_ds = new JScrollPane(this.jt_ds);
        sp_jt_ds.setPreferredSize(new Dimension(200, this.dataModel.getRowCount() * this.jt_ds.getRowHeight()));
        this.jt_ds.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.jt_ds.getColumnModel().getColumn(1).setPreferredWidth(20);
        final JFrame frame2 = frame;
        this.bt_ds_add.addActionListener(new ActionListener(){
            NewDataSourceDialog ds_type_dialog = null;

            public void actionPerformed(ActionEvent e) {
                DataSourceConfigurationDialog ds_dialog;
                if (this.ds_type_dialog == null) {
                    this.ds_type_dialog = new NewDataSourceDialog(frame2, HostConfigurator.this.current_host);
                }
                if ((ds_dialog = this.ds_type_dialog.askDataSourceDialog()) == null) {
                    return;
                }
                ds_dialog.setDataSource(null);
                boolean ok = ds_dialog.ask();
                if (ok) {
                    DataSource ds = ds_dialog.getDataSource();
                    HostConfigurator.this.dataModel.addDataSource(ds);
                    HostConfigurator.this.enable_datasource_buttons();
                }
            }
        });
        this.bt_ds_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.edit_selected_datasource(frame2);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HostConfigurator.this.edit_selected_datasource(frame2);
                }
            }
        };
        this.jt_ds.addMouseListener(mouseListener);
        this.bt_ds_del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = HostConfigurator.this.jt_ds.getSelectedRows();
                if (rows.length > 0) {
                    boolean choice = false;
                    if (choice) {
                        return;
                    }
                    int i = 0;
                    while (i < rows.length) {
                        HostConfigurator.this.dataModel.removeRow(rows[i] - i);
                        ++i;
                    }
                    HostConfigurator.this.enable_datasource_buttons();
                }
            }
        });
        JPanel p_buttons_ds = new JPanel();
        p_buttons_ds.setLayout(new BoxLayout(p_buttons_ds, 1));
        p_buttons_ds.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_buttons_ds.add(this.bt_ds_add);
        p_buttons_ds.add(this.bt_ds_edit);
        p_buttons_ds.add(this.bt_ds_del);
        JPanel p_ds = new JPanel(new BorderLayout());
        p_ds.setBorder(BorderFactory.createTitledBorder("Data sources"));
        p_ds.add((Component)sp_jt_ds, "Center");
        p_ds.add((Component)p_buttons_ds, "East");
        p_ds.add((Component)new JLabel("Note: the datasources are processed in the specified order, so please define the older datasource first."), "South");
        return p_ds;
    }

    public JPanel createURLAliasPanel(JFrame frame) {
        JPanel p_buttons_param = new JPanel();
        p_buttons_param.setLayout(new BoxLayout(p_buttons_param, 1));
        p_buttons_param.setBorder(BorderFactory.createTitledBorder("Parameters"));
        JButton bt_param_add = new JButton("Add");
        JButton bt_param_del = new JButton("Del");
        p_buttons_param.add(bt_param_add);
        p_buttons_param.add(bt_param_del);
        final JFrame frame2 = frame;
        bt_param_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(frame2, (Object)"Please enter the parameter name:");
                if (name != null) {
                    URLAliasParam p = new URLAliasParam();
                    p.setParam(name);
                    String id = JOptionPane.showInputDialog(frame2, "Please enter the parameter unique id:", String.valueOf(name) + "_id");
                    if (id != null) {
                        p.setId(id);
                        HostConfigurator.this.current_host.addURLAliasParam(p);
                        HostConfigurator.this.tm_url_aliases.fireDataChanged();
                    }
                }
            }
        });
        JPanel p_buttons_values = new JPanel();
        p_buttons_values.setLayout(new BoxLayout(p_buttons_values, 1));
        p_buttons_values.setBorder(BorderFactory.createTitledBorder("Values"));
        JButton bt_value_add = new JButton("Add");
        JButton bt_value_del = new JButton("Del");
        p_buttons_values.add(bt_value_add);
        p_buttons_values.add(bt_value_del);
        bt_value_add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreePath selected_path = HostConfigurator.this.jt_urlalias_parameters.getSelectionPath();
                if (selected_path != null && selected_path.getPathCount() > 1) {
                    URLAliasParam parent = (URLAliasParam)selected_path.getPath()[1];
                    String value = JOptionPane.showInputDialog(frame2, (Object)"Please enter the parameter value:");
                    if (value != null) {
                        URLAliasParamValue v = new URLAliasParamValue();
                        v.setValue(value);
                        String alias = JOptionPane.showInputDialog(frame2, (Object)"Please enter the parameter value alias:");
                        if (alias != null) {
                            v.setAlias(alias);
                            parent.addURLAliasParamValue(v);
                            HostConfigurator.this.tm_url_aliases.fireDataChanged();
                        }
                    }
                }
            }
        });
        JPanel p_buttons = new JPanel();
        p_buttons.add(p_buttons_param);
        p_buttons.add(p_buttons_values);
        JScrollPane sp_urlalias_params = new JScrollPane(this.jt_urlalias_parameters);
        JPanel p_parameters = new JPanel(new BorderLayout());
        p_parameters.setBorder(BorderFactory.createTitledBorder("Parameters (under development)"));
        p_parameters.add((Component)sp_urlalias_params, "Center");
        p_parameters.add((Component)p_buttons, "East");
        return p_parameters;
    }

    public JPanel createPluginsPanel(JFrame frame) {
        JPanel p_buttons_param = new JPanel();
        p_buttons_param.add(this.bt_configure);
        final Host current_host2 = this.current_host;
        final JFrame frame2 = frame;
        this.bt_configure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginConfigurator p;
                Object plugin;
                TreePath selected_path = HostConfigurator.this.jt_plugins.getSelectionPath();
                if (selected_path != null && selected_path.getPathCount() > 2 && (plugin = ((DefaultMutableTreeNode)selected_path.getPath()[2]).getUserObject()) instanceof Plugin && (p = ((Plugin)plugin).getConfigPanel(current_host2)) != null) {
                    JDialog dialog = new JDialog(frame2, String.valueOf(plugin.getClass().getSimpleName()) + " plugin configuration", true);
                    PluginProperties pp = current_host2.getPluginProperties(plugin.getClass().getName());
                    if (pp == null) {
                        System.out.println("creating a new property file for " + plugin.getClass().getName());
                        pp = new PluginProperties();
                        pp.setClassName(plugin.getClass().getName());
                        current_host2.addPluginProperties(pp);
                    } else {
                        p.setProperties(pp.getProperty());
                    }
                    JPanel p_buttons = new JPanel();
                    JButton bt_ok = new JButton("Ok");
                    JButton bt_cancel = new JButton("Cancel");
                    PluginProperties current_pp2 = pp;
                    bt_ok.addActionListener(new ActionListener(this, p, current_pp2, dialog){
                        final /* synthetic */ 18 this$1;
                        private final /* synthetic */ PluginConfigurator val$p;
                        private final /* synthetic */ PluginProperties val$current_pp2;
                        private final /* synthetic */ JDialog val$dialog;
                        {
                            this.this$1 = var1_1;
                            this.val$p = pluginConfigurator;
                            this.val$current_pp2 = pluginProperties;
                            this.val$dialog = jDialog;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            System.out.println(this.val$p.getProperties());
                            this.val$current_pp2.setProperties(this.val$p.getProperties());
                            this.val$dialog.setVisible(false);
                        }
                    });
                    bt_cancel.addActionListener(new ActionListener(this, dialog){
                        final /* synthetic */ 18 this$1;
                        private final /* synthetic */ JDialog val$dialog;
                        {
                            this.this$1 = var1_1;
                            this.val$dialog = jDialog;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            this.val$dialog.setVisible(false);
                        }
                    });
                    p_buttons.add(bt_ok);
                    p_buttons.add(bt_cancel);
                    dialog.getContentPane().setLayout(new BorderLayout());
                    dialog.getContentPane().add((Component)p.getPanel(null), "Center");
                    dialog.getContentPane().add((Component)p_buttons, "South");
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                }
            }
        });
        JScrollPane sp_plugins = new JScrollPane(this.jt_plugins);
        JPanel p_plugins = new JPanel(new BorderLayout());
        p_plugins.setBorder(BorderFactory.createTitledBorder("Plugins"));
        p_plugins.add((Component)sp_plugins, "Center");
        p_plugins.add((Component)p_buttons_param, "East");
        return p_plugins;
    }

    public JDialog createConfigDialog(JFrame frame) {
        JButton bt_open_dir = new JButton(new ImageIcon("images/file_open.png"));
        bt_open_dir.setToolTipText("Open the host configuration directory");
        bt_open_dir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DOSCommands.start(HostConfigurator.this.current_host.getConfigDirectory().getAbsolutePath(), "open dir");
            }
        });
        JPanel p_domain_name = new JPanel(new FlowLayout(0));
        p_domain_name.setBorder(BorderFactory.createTitledBorder("Domain name"));
        p_domain_name.add(this.tf_domain_name);
        p_domain_name.add(bt_open_dir);
        JPanel p_reports = new JPanel(new BorderLayout());
        p_reports.setBorder(BorderFactory.createTitledBorder("Reports configuration"));
        JButton bt_report_config = new JButton("Configure reports...");
        bt_report_config.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.report_config.setModel(HostConfigurator.this.current_host.getProcessingOptionsAsProcessingOptions());
                boolean ok = HostConfigurator.this.report_config.ask();
                if (ok) {
                    HostConfigurator.this.current_host.addProcessingOptions(HostConfigurator.this.report_config.getModel());
                }
            }
        });
        p_reports.add((Component)bt_report_config, "Center");
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        JPanel p_full = new JPanel(new BorderLayout());
        p_full.setLayout(new BoxLayout(p_full, 1));
        p_full.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_full.add(p_domain_name);
        p_full.add(this.createDatasourcesPanel(frame));
        p_full.add(this.createHistoryGraphEventPanel(frame));
        p_full.add(this.createProductRefererPanel(frame));
        p_full.add(this.createHiddenVisitsPanel(frame));
        p_full.add(this.createURLAliasPanel(frame));
        p_full.add(this.createPluginsPanel(frame));
        p_full.add(p_reports);
        p_full.add(p_buttons);
        final JDialog dialog = new JDialog(frame, "Host configuration", true);
        dialog.getContentPane().add(p_full);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.form_validated = true;
                dialog.setVisible(false);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        return dialog;
    }

    public void edit_selected_datasource(JFrame frame2) {
        int[] rows = this.jt_ds.getSelectedRows();
        if (rows.length > 0) {
            DataSource selected_ds = this.dataModel.getDataSource(rows[0]);
            NewDataSourceDialog ds_type_dialog = new NewDataSourceDialog(frame2, this.current_host);
            DataSourceConfigurationDialog ds_dialog = ds_type_dialog.askDataSourceDialog(selected_ds);
            ds_dialog.setDataSource(selected_ds);
            boolean ok = ds_dialog.ask();
            if (ok) {
                ds_dialog.updateDataSource(selected_ds);
                this.dataModel.fireTableDataChanged();
            }
        }
    }

    public boolean ask() {
        this.tf_domain_name.setText(this.current_host.getDomainName());
        this.dataModel.setHost(this.current_host);
        this.dataModel_hge.setHost(this.current_host);
        this.pr_dataModel.setHost(this.current_host);
        this.tm_url_aliases.setHost(this.current_host);
        this.f.setVisible(true);
        if (this.form_validated) {
            this.f.setCursor(Cursor.getPredefinedCursor(3));
            this.current_host.getDataSource().clear();
            int i = 0;
            while (i < this.dataModel.getRowCount()) {
                this.current_host.addDataSource(this.dataModel.getDataSource(i));
                ++i;
            }
            this.current_host.getHistoryGraphEvent().clear();
            i = 0;
            while (i < this.dataModel_hge.getRowCount()) {
                this.current_host.addHistoryGraphEvent(this.dataModel_hge.getHistoryGraphEvent(i));
                ++i;
            }
            this.current_host.getProductReferer().clear();
            i = 0;
            while (i < this.pr_dataModel.getRowCount()) {
                this.current_host.addProductReferer(this.pr_dataModel.getProductReferer(i));
                ++i;
            }
            this.current_host.getHiddenVisitFilter().clear();
            i = 0;
            while (i < this.hv_dataModel.getRowCount()) {
                this.current_host.addHiddenVisitFilter(this.hv_dataModel.getFilter(i));
                ++i;
            }
            this.f.setCursor(Cursor.getPredefinedCursor(0));
        }
        return this.form_validated;
    }
}

