/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.ConfigParser;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.conf.Configurator;
import ch.kronospace.logpsychoanalyst.conf.HostConfigurator;
import ch.kronospace.logpsychoanalyst.conf.HostTableModel;
import ch.kronospace.taskscheduler.ScheduledTask;
import ch.kronospace.taskscheduler.TaskScheduler;
import ch.kronospace.tools.DiskTools;
import ch.kronospace.tools.GUITools;
import ch.kronospace.tools.JDOMTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class HostsConfigurator
implements Configurator {
    final JFrame dialog = new JFrame("Log(psycho)Analyst configuration");
    final HostTableModel dataModel;
    final JTable jt_hosts;
    private Host current_host;
    private boolean form_validated;
    JCheckBox cb_download_ip2country;
    JCheckBox cb_download_databases;
    JCheckBox cb_download_program;
    JSpinner sp_download_ip2country;
    JSpinner sp_download_databases;
    JSpinner sp_download_program;
    JCheckBox cb_launch_startup;
    JCheckBox cb_launch_scheduled;
    JSpinner sp_launch_scheduled;
    JSpinner sp_launch_scheduled_hour;
    JSpinner sp_launch_scheduled_minute;

    public HostsConfigurator() {
        this.dialog.setIconImage(new ImageIcon("images/lpa_icon.png").getImage());
        this.dataModel = new HostTableModel();
        this.jt_hosts = new JTable(this.dataModel);
        this.current_host = null;
        this.form_validated = false;
        this.cb_download_ip2country = new JCheckBox("Download IP-to-country database every", true);
        this.cb_download_databases = new JCheckBox("Download loganalyst databases every", true);
        this.cb_download_program = new JCheckBox("Download loganalyst program every", true);
        this.sp_download_ip2country = new JSpinner(new SpinnerNumberModel(28, 0, 365, 1));
        this.sp_download_databases = new JSpinner(new SpinnerNumberModel(28, 0, 365, 1));
        this.sp_download_program = new JSpinner(new SpinnerNumberModel(0, 0, 365, 1));
        this.cb_launch_startup = new JCheckBox("Process log files at the machine startup", true);
        this.cb_launch_scheduled = new JCheckBox("Process log files every", true);
        this.sp_launch_scheduled = new JSpinner(new SpinnerNumberModel(1, 0, 365, 1));
        this.sp_launch_scheduled_hour = new JSpinner(new SpinnerNumberModel(new Random().nextInt(24), 0, 23, 1));
        this.sp_launch_scheduled_minute = new JSpinner(new SpinnerNumberModel(new Random().nextInt(60), 0, 59, 1));
        this.cb_download_ip2country.setEnabled(false);
        this.cb_download_databases.setSelected(false);
        this.sp_download_ip2country.setEnabled(false);
        this.cb_download_program.setEnabled(false);
        this.cb_download_program.setSelected(true);
        this.sp_download_program.setEnabled(false);
        this.cb_download_databases.setEnabled(false);
        this.sp_download_databases.setEnabled(false);
        this.sp_launch_scheduled.setEnabled(false);
        TaskScheduler sched = TaskScheduler.getDefault();
        if (sched == null) {
            this.cb_launch_scheduled.setSelected(false);
            this.cb_launch_scheduled.setEnabled(false);
        }
        this.cb_launch_startup.setEnabled(false);
        this.cb_launch_startup.setSelected(false);
    }

    public void setDomainName(String domain_name) {
    }

    public void setJDOMElement(Element el) {
    }

    public void setEnabledFormFields(boolean enable_data_fields) {
    }

    public void clearFormFields() {
    }

    public JFrame createConfigDialog() {
        int hgap;
        new ConfigParser();
        JScrollPane sp_jt_hosts = new JScrollPane(this.jt_hosts);
        sp_jt_hosts.setPreferredSize(new Dimension(200, this.dataModel.getRowCount() * this.jt_hosts.getRowHeight()));
        JButton bt_new_host = new JButton("New host");
        JButton bt_edit_host = new JButton("Edit host");
        JButton bt_del_host = new JButton("Remove host");
        bt_new_host.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String domain_name = JOptionPane.showInputDialog(HostsConfigurator.this.dialog, "Please enter the domain name.", "auberge-meyrin.ch");
                if (domain_name != null) {
                    File config_directory = new File(ConfigParser.hosts_dir, domain_name);
                    HostsConfigurator.this.current_host = new Host(domain_name, config_directory);
                    try {
                        SAXBuilder builder = new SAXBuilder(false);
                        Document doc = builder.build(new File("data/default_host_config.xml"));
                        Element root = doc.getRootElement();
                        root.setAttribute("name", domain_name);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    HostConfigurator host_conf = new HostConfigurator(HostsConfigurator.this.dialog, HostsConfigurator.this.current_host);
                    host_conf.setHost(HostsConfigurator.this.current_host);
                    boolean ok = host_conf.ask();
                    if (ok) {
                        DiskTools.copy(HostsConfigurator.this.current_host.getConfigFile(), new File(HostsConfigurator.this.current_host.getConfigFile().getParentFile(), "config." + new Date().getTime() + ".xml"), false);
                        System.out.println("write to file: " + HostsConfigurator.this.current_host.getConfigFile());
                        JDOMTools.writeToXMLFile(HostsConfigurator.this.current_host, HostsConfigurator.this.current_host.getConfigFile());
                        HostsConfigurator.this.dataModel.addRow(HostsConfigurator.this.current_host);
                    }
                }
            }
        });
        bt_edit_host.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostsConfigurator.this.edit_selected_host();
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    HostsConfigurator.this.edit_selected_host();
                }
            }
        };
        this.jt_hosts.addMouseListener(mouseListener);
        bt_del_host.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] rows = HostsConfigurator.this.jt_hosts.getSelectedRows();
                if (rows.length > 0) {
                    int choice = JOptionPane.showConfirmDialog(HostsConfigurator.this.dialog, "The selected Hosts configuration files will be deleted (the log files and reports will not be removed).\n\nDo you want to suppress these configuration files ?", "Confirm removing", 1, 2);
                    if (choice != 0) {
                        return;
                    }
                    int i = 0;
                    while (i < rows.length) {
                        HostsConfigurator.this.dataModel.removeRow(rows[i]);
                        ++i;
                    }
                }
            }
        });
        JPanel p_buttons_hosts = new JPanel();
        p_buttons_hosts.setLayout(new BoxLayout(p_buttons_hosts, 1));
        p_buttons_hosts.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p_buttons_hosts.add(bt_new_host);
        p_buttons_hosts.add(bt_edit_host);
        p_buttons_hosts.add(bt_del_host);
        JPanel p_hosts = new JPanel(new BorderLayout());
        p_hosts.setBorder(BorderFactory.createTitledBorder("Reports to make"));
        p_hosts.add((Component)sp_jt_hosts, "Center");
        p_hosts.add((Component)p_buttons_hosts, "East");
        int vgap = hgap = 1;
        JPanel p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        JPanel p_log_traitement = new JPanel();
        p_log_traitement.setLayout(new BoxLayout(p_log_traitement, 1));
        p_log_traitement.setBorder(BorderFactory.createTitledBorder("Auto-update"));
        p_temp.add(this.cb_download_ip2country);
        p_temp.add(this.sp_download_ip2country);
        p_temp.add(new JLabel("days."));
        p_temp.add(new JLabel(GUITools.internet_icon));
        p_temp.add(GUITools.createPrivacyButton("Download a file from third party web site (about 1 MB).<br><br>No information is sent, except the URL of the file to download. No other connection is done."));
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_download_databases);
        p_temp.add(this.sp_download_databases);
        p_temp.add(new JLabel("days."));
        p_temp.add(new JLabel(GUITools.internet_icon));
        p_temp.add(GUITools.createPrivacyButton("Download a file from loganalyst FTP site (about 1 MB).<br><br>No information is sent, except the URL of the file to download. No other connection is done."));
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_download_program);
        p_temp.add(this.sp_download_program);
        p_temp.add(new JLabel("days."));
        p_temp.add(new JLabel(GUITools.internet_icon));
        p_temp.add(GUITools.createPrivacyButton("Download a file from loganalyst FTP site (about 1 MB).<br><br>No information is sent, except the URL of the file to download. No other connection is done."));
        p_log_traitement.add(p_temp);
        JPanel p_values = new JPanel();
        p_values.setLayout(new BoxLayout(p_values, 1));
        p_values.setBorder(BorderFactory.createTitledBorder("Log processing planification"));
        JPanel p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.cb_launch_startup);
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.cb_launch_scheduled);
        p_topx.add(this.sp_launch_scheduled);
        p_topx.add(new JLabel("day(s) at "));
        p_topx.add(this.sp_launch_scheduled_hour);
        p_topx.add(new JLabel(":"));
        p_topx.add(this.sp_launch_scheduled_minute);
        p_values.add(p_topx);
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        JPanel p_full = new JPanel(new BorderLayout());
        p_full.setLayout(new BoxLayout(p_full, 1));
        p_full.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel lb_welcome = new JLabel("<html><p width=350>Welcome to Log(psycho)Analyst, the log file analyzer.<br>Look at  <a href=http://www.logpsychoanalyst.com/?src=ConfigureHosts>www.logpsychoanalyst.com</a>  for more information.<br><br>Please add the hosts to be processed below.<br><br>");
        lb_welcome.setAlignmentX(0.5f);
        p_full.add((Component)lb_welcome, "North");
        p_full.add(p_hosts);
        p_full.add(p_log_traitement);
        p_full.add(p_values);
        p_full.add(p_buttons);
        this.dialog.getContentPane().add(p_full);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setDefaultCloseOperation(3);
        bt_ok.setToolTipText("Writes the global configuration file, register the scheduled task, then quit.");
        bt_cancel.setToolTipText("Quit without saving the global configuration file and without registering the scheduled task.");
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostsConfigurator.this.form_validated = true;
                HostsConfigurator.this.dialog.setVisible(false);
                ScheduledTask task = new ScheduledTask("Loganalyst (process log files)");
                task.setPlanification(3);
                task.setCommand(new File("_run.bat").getAbsolutePath());
                task.setInteractive(true);
                task.setStartTime(((SpinnerNumberModel)HostsConfigurator.this.sp_launch_scheduled_hour.getModel()).getNumber().intValue(), ((SpinnerNumberModel)HostsConfigurator.this.sp_launch_scheduled_minute.getModel()).getNumber().intValue());
                TaskScheduler scheduler = TaskScheduler.getDefault();
                scheduler.delete(task);
                scheduler.create(task);
                System.exit(0);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostsConfigurator.this.form_validated = false;
                HostsConfigurator.this.dialog.setVisible(false);
                System.exit(0);
            }
        });
        bt_help.setEnabled(false);
        return this.dialog;
    }

    public void edit_selected_host() {
        int selected_index = this.jt_hosts.getSelectedRow();
        if (selected_index < 0) {
            return;
        }
        this.current_host = (Host)ConfigParser.configs.elementAt(selected_index);
        HostConfigurator host_conf = new HostConfigurator(this.dialog, this.current_host);
        host_conf.setHost(this.current_host);
        boolean ok = host_conf.ask();
        if (ok) {
            DiskTools.copy(this.current_host.getConfigFile(), new File(this.current_host.getConfigFile().getParentFile(), "config." + new Date().getTime() + ".xml"), false);
            System.out.println("write to file:" + this.current_host.getConfigFile());
            JDOMTools.writeToXMLFile(this.current_host, this.current_host.getConfigFile());
        }
    }

    public boolean ask() {
        JFrame f = this.createConfigDialog();
        f.setVisible(true);
        return true;
    }

    public void write(PrintWriter out) {
        try {
            out.println();
            out.println("  <Constant auto_update_country_database=\"" + new Boolean(this.cb_download_ip2country.isSelected()) + "\"/>");
            out.println("  <Constant auto_update_country_database_days=\"" + this.sp_download_ip2country.getValue() + "\"/>");
            out.println();
            out.println("  <Constant auto_update_prog_database=\"" + new Boolean(this.cb_download_program.isSelected()) + "\"/>");
            out.println("  <Constant auto_update_prog_database_days=\"" + this.sp_download_program.getValue() + "\"/>");
            out.println();
            out.println("  <Constant auto_update_data_database=\"" + new Boolean(this.cb_download_databases.isSelected()) + "\"/>");
            out.println("  <Constant auto_update_data_database_days=\"" + this.sp_download_databases.getValue() + "\"/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

