/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.ProcessingOptions;
import ch.kronospace.logpsychoanalyst.conf.Configurator;
import ch.kronospace.tools.GUITools;
import ch.kronospace.tools.RadioButtonPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class HttpReportConfigurator
implements Configurator {
    private boolean form_validated = false;
    private Host host;
    JCheckBox cb_recognize_useragent = new JCheckBox("Recognize User-Agents", true);
    JCheckBox cb_recognize_os = new JCheckBox("Recognize Operating-System", true);
    JCheckBox cb_recognize_country = new JCheckBox("Recognize Country", true);
    JCheckBox cb_recognize_referer = new JCheckBox("Recognize Referer", true);
    JCheckBox cb_recognize_mime_type = new JCheckBox("Recognize Mime-Type", true);
    JCheckBox cb_detect_worms = new JCheckBox("Detect worms", true);
    JCheckBox cb_detect_robot_traps = new JCheckBox("Detect robot traps", true);
    JCheckBox cb_track_country_by_date = new JCheckBox("IP-to-country tracking by date", true);
    JCheckBox cb_do_reverse_dns = new JCheckBox("Do reverse DNS", false);
    JCheckBox cb_do_sorbs = new JCheckBox("Do SORBS detection", false);
    JCheckBox cb_do_ahbl = new JCheckBox("Do AHBL detection", false);
    JSpinner sp_visit_timeout_minutes = new JSpinner(new SpinnerNumberModel(30, 0, 525600, 1));
    JTextField tf_max_visit_duration = new JTextField("30", 5);
    JSpinner sp_top_ua;
    JSpinner sp_top_hosts;
    JSpinner sp_top_countries;
    JSpinner sp_top_os;
    JSpinner sp_top_pages;
    JSpinner sp_top_referes;
    JSpinner sp_top_bad_links;
    JSpinner sp_top_bad_referer_links;
    JCheckBox cb_generate_visit_map;
    JCheckBox cb_generate_detailed_ua;
    JCheckBox cb_generate_detailed_unknown_ua;
    JFrame frame;

    public HttpReportConfigurator(JFrame frame) {
        this.cb_recognize_useragent.setEnabled(false);
        this.cb_recognize_os.setEnabled(false);
        this.cb_recognize_referer.setEnabled(false);
        this.sp_top_ua = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_hosts = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_countries = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_os = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_pages = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_referes = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_bad_links = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_bad_referer_links = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
        this.sp_top_ua.setEnabled(false);
        this.sp_top_hosts.setEnabled(false);
        this.sp_top_countries.setEnabled(false);
        this.sp_top_os.setEnabled(false);
        this.sp_top_pages.setEnabled(false);
        this.sp_top_referes.setEnabled(false);
        this.sp_top_bad_links.setEnabled(false);
        this.sp_top_bad_referer_links.setEnabled(false);
        this.cb_generate_visit_map = new JCheckBox("Generate visit map", true);
        this.cb_generate_detailed_ua = new JCheckBox("Generate detailed user-agent graphs");
        this.cb_generate_detailed_unknown_ua = new JCheckBox("Generate detailed unknown user-agent graphs", true);
        this.frame = null;
        this.frame = frame;
    }

    public void setDomainName(String domain_name) {
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public JDialog createDialog() {
        int hgap;
        final JDialog dialog = new JDialog(this.frame, "Report configuration", true);
        JPanel p_full = new JPanel();
        p_full.setLayout(new BoxLayout(p_full, 1));
        p_full.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int vgap = hgap = 1;
        JPanel p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        JPanel p_log_traitement = new JPanel();
        p_log_traitement.setLayout(new BoxLayout(p_log_traitement, 1));
        p_log_traitement.setBorder(BorderFactory.createTitledBorder("Log file processing"));
        p_temp.add(this.cb_recognize_useragent);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_recognize_os);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_recognize_country);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_track_country_by_date);
        p_temp.add(new JLabel(GUITools.timing_icon));
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_recognize_referer);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_recognize_mime_type);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_detect_worms);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_detect_robot_traps);
        p_log_traitement.add(p_temp);
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_do_reverse_dns);
        p_temp.add(new JLabel(GUITools.internet_icon));
        p_temp.add(new JLabel(GUITools.timing_icon));
        p_temp.add(GUITools.createPrivacyButton("Reverse DNS queries are made to your machine default DNS server in order to get the host name from the IP address.<br><br>No other DNS server is used and no other kind of requests are made. No information is sent to the internet (of course, except the DNS queries to you default DNS server)."));
        p_temp = new JPanel(new FlowLayout(0, hgap, vgap));
        p_temp.add(this.cb_do_sorbs);
        p_temp.add(this.cb_do_ahbl);
        p_temp.add(new JLabel(GUITools.internet_icon));
        p_temp.add(new JLabel(GUITools.timing_icon));
        p_temp.add(GUITools.createPrivacyButton("SORBS and AHBL detection uses DNS queries made using your machine default DNS server in order to categorize a visitor.<br><br>No other DNS server is used and no other information than your IP address is transmitted. No information is sent to the internet (of course, except the DNS queries to you default DNS server)."));
        p_log_traitement.add(p_temp);
        JPanel p_visit = new JPanel();
        p_visit.setLayout(new BoxLayout(p_visit, 1));
        p_visit.setBorder(BorderFactory.createTitledBorder("Visit parameters"));
        p_temp = new JPanel(new FlowLayout(0, 3, 3));
        p_temp.add(new JLabel("Visit timeout [min]"));
        p_temp.add(this.sp_visit_timeout_minutes);
        p_visit.add(p_temp);
        JPanel p_values = new JPanel();
        p_values.setLayout(new BoxLayout(p_values, 1));
        p_values.setBorder(BorderFactory.createTitledBorder("Top displayed information"));
        JPanel p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_ua);
        p_topx.add(new JLabel("user-agents"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_os);
        p_topx.add(new JLabel("operating-systems"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_countries);
        p_topx.add(new JLabel("countries"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_referes);
        p_topx.add(new JLabel("referers"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_hosts);
        p_topx.add(new JLabel("hosts"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_pages);
        p_topx.add(new JLabel("pages"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_bad_links);
        p_topx.add(new JLabel("bad links"));
        p_values.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.sp_top_bad_referer_links);
        p_topx.add(new JLabel("bad referer links"));
        p_values.add(p_topx);
        JPanel p_graphics = new JPanel();
        p_graphics.setLayout(new BoxLayout(p_graphics, 1));
        p_graphics.setBorder(BorderFactory.createTitledBorder("Graphic reports"));
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.cb_generate_visit_map);
        p_graphics.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.cb_generate_detailed_ua);
        p_topx.add(new JLabel(GUITools.timing_icon));
        p_graphics.add(p_topx);
        p_topx = new JPanel(new FlowLayout(0, hgap, vgap));
        p_topx.add(this.cb_generate_detailed_unknown_ua);
        p_topx.add(new JLabel(GUITools.timing_icon));
        p_graphics.add(p_topx);
        JPanel p_horiz = new JPanel();
        p_horiz.setLayout(new BoxLayout(p_horiz, 0));
        p_horiz.add(p_log_traitement);
        p_horiz.add(p_values);
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        p_full.add(this.getReportPeriodPanel());
        p_full.add(p_horiz);
        p_full.add(p_visit);
        p_full.add(p_graphics);
        p_full.add(p_buttons);
        dialog.getContentPane().add(p_full);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HttpReportConfigurator.this.form_validated = true;
                dialog.setVisible(false);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HttpReportConfigurator.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        return dialog;
    }

    private JPanel getReportPeriodPanel() {
        JRadioButton rb_all_data = new JRadioButton("All available data");
        JPanel p_all_data = new JPanel(new BorderLayout());
        p_all_data.add((Component)rb_all_data, "North");
        JPanel p_sub_last_n_month = new JPanel();
        p_sub_last_n_month.setLayout(new BoxLayout(p_sub_last_n_month, 1));
        JRadioButton rb_up_to_last_data = new JRadioButton("Up to the last available data");
        p_sub_last_n_month.add(rb_up_to_last_data);
        ButtonGroup btg2 = new ButtonGroup();
        btg2.add(rb_up_to_last_data);
        rb_up_to_last_data.setSelected(true);
        RadioButtonPanel p_last_n_month = new RadioButtonPanel("Last 12 month", new JComponent[]{rb_up_to_last_data}, p_sub_last_n_month);
        JLabel lb_from = new JLabel("From (yyyymmdd):");
        JLabel lb_to = new JLabel("To (yyyymmdd):");
        JPanel p_from = new JPanel(new FlowLayout(0));
        JPanel p_to = new JPanel(new FlowLayout(0));
        JTextField tf_from = new JTextField(10);
        JTextField tf_to = new JTextField(10);
        p_from.add(lb_from);
        p_from.add(tf_from);
        p_to.add(lb_to);
        p_to.add(tf_to);
        JPanel p_sub_specific_period = new JPanel();
        p_sub_specific_period.setLayout(new BoxLayout(p_sub_specific_period, 1));
        p_sub_specific_period.add(p_from);
        p_sub_specific_period.add(p_to);
        RadioButtonPanel p_specific_period = new RadioButtonPanel("Specific period", new JComponent[]{lb_from, lb_to, tf_from, tf_to}, p_sub_specific_period);
        ButtonGroup btg = new ButtonGroup();
        btg.add(rb_all_data);
        btg.add(p_last_n_month.getRadioButton());
        btg.add(p_specific_period.getRadioButton());
        rb_all_data.setSelected(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createTitledBorder("Report period (under development)"));
        p.add(p_all_data);
        p.add(p_last_n_month);
        p.add(p_specific_period);
        return p;
    }

    public boolean ask() {
        JDialog d = this.createDialog();
        d.setVisible(true);
        return this.form_validated;
    }

    public ProcessingOptions getModel() {
        ProcessingOptions p = new ProcessingOptions();
        p.setIPtoCountry(Boolean.toString(this.cb_recognize_country.isSelected()));
        p.setRecognizeMimeType(Boolean.toString(this.cb_recognize_mime_type.isSelected()));
        p.setDetectWorms(Boolean.toString(this.cb_detect_worms.isSelected()));
        p.setDetectRobotTrap(Boolean.toString(this.cb_detect_robot_traps.isSelected()));
        p.setTemporalIPtoCountry(Boolean.toString(this.cb_track_country_by_date.isSelected()));
        p.setReverseDNS(Boolean.toString(this.cb_do_reverse_dns.isSelected()));
        p.setSorbs(Boolean.toString(this.cb_do_sorbs.isSelected()));
        p.setAhbl(Boolean.toString(this.cb_do_ahbl.isSelected()));
        p.setVisitTimeout(this.sp_visit_timeout_minutes.getValue().toString());
        p.setMaxVisitDuration(this.tf_max_visit_duration.getText());
        p.setGenerateVisitMap(Boolean.toString(this.cb_generate_visit_map.isSelected()));
        p.setGenerateDetailedUseragentReports(Boolean.toString(this.cb_generate_detailed_ua.isSelected()));
        p.setGenerateDetailedUnknownUseragentsReports(Boolean.toString(this.cb_generate_detailed_unknown_ua.isSelected()));
        return p;
    }

    public void setModel(ProcessingOptions p) {
        this.cb_recognize_country.setSelected(p.getIPtoCountryAsBoolean());
        this.cb_recognize_mime_type.setSelected(p.getRecognizeMimeTypeAsBoolean());
        this.cb_detect_worms.setSelected(p.getDetectWormsAsBoolean());
        this.cb_detect_robot_traps.setSelected(p.getDetectRobotTrapAsBoolean());
        this.cb_track_country_by_date.setSelected(p.getTemporalIPtoCountryAsBoolean());
        this.cb_do_reverse_dns.setSelected(p.getReverseDNSAsBoolean());
        this.cb_do_sorbs.setSelected(p.getSorbsAsBoolean());
        this.cb_do_ahbl.setSelected(p.getAhblAsBoolean());
        this.sp_visit_timeout_minutes.setValue(new Integer(p.getVisitTimeoutAsInt()));
        this.tf_max_visit_duration.setText(p.getMaxVisitDuration());
        this.cb_generate_visit_map.setSelected(p.getGenerateVisitMapAsBoolean());
        this.cb_generate_detailed_ua.setSelected(p.getGenerateDetailedUseragentReportsAsBoolean());
        this.cb_generate_detailed_unknown_ua.setSelected(p.getGenerateDetailedUnknownUseragentsReportsAsBoolean());
    }

    public void write(PrintWriter out) {
        try {
            out.println();
            out.println("<!-- Log file processing -->");
            out.println("  <Constant recognize_useragent=\"" + new Boolean(this.cb_recognize_useragent.isSelected()) + "\"/>");
            out.println("  <Constant recognize_os=\"" + new Boolean(this.cb_recognize_os.isSelected()) + "\"/>");
            out.println("  <Constant recognize_referer=\"" + new Boolean(this.cb_recognize_referer.isSelected()) + "\"/>");
            out.println();
            out.println("<!-- Top displayed information -->");
            out.println("  <Constant top_ua=\"" + this.sp_top_ua.getValue() + "\"/>");
            out.println("  <Constant top_hosts=\"" + this.sp_top_hosts.getValue() + "\"/>");
            out.println("  <Constant top_countries=\"" + this.sp_top_countries.getValue() + "\"/>");
            out.println("  <Constant top_os=\"" + this.sp_top_os.getValue() + "\"/>");
            out.println("  <Constant top_pages=\"" + this.sp_top_pages.getValue() + "\"/>");
            out.println("  <Constant top_referes=\"" + this.sp_top_referes.getValue() + "\"/>");
            out.println("  <Constant top_bad_links=\"" + this.sp_top_bad_links.getValue() + "\"/>");
            out.println("  <Constant top_bad_referer_links=\"" + this.sp_top_bad_referer_links.getValue() + "\"/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

