/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.conf.DataSourceConfigurationDialog;
import ch.kronospace.logpsychoanalyst.conf.FTPDataSourceConfigurator;
import ch.kronospace.logpsychoanalyst.conf.FileDataSourceConfigurator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewDataSourceDialog
extends JDialog {
    private static final long serialVersionUID = 4540329976257782321L;
    DataSourceConfigurationDialog selected_ds_dialog = null;
    JFrame frame;
    Host host;
    static FileDataSourceConfigurator ds_file_dialog = null;
    static FTPDataSourceConfigurator ds_ftp_dialog = null;

    public NewDataSourceDialog(JFrame frame, Host host) {
        super(frame, "New data source", true);
        this.frame = frame;
        this.host = host;
        JButton bt_ds_file = new JButton("File");
        JButton bt_ds_ftp = new JButton("FTP");
        JButton bt_ds_local_server = new JButton("Local server");
        bt_ds_file.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewDataSourceDialog.this.createFileDatasource();
                NewDataSourceDialog.this.setVisible(false);
            }
        });
        bt_ds_ftp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewDataSourceDialog.this.createFTPDatasource();
                NewDataSourceDialog.this.setVisible(false);
            }
        });
        bt_ds_local_server.setEnabled(false);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(new JLabel("Please select the type of datasource to create:"));
        p.add(bt_ds_file);
        p.add(bt_ds_ftp);
        p.add(bt_ds_local_server);
        this.getContentPane().add(p);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void createFTPDatasource() {
        if (ds_ftp_dialog == null) {
            ds_ftp_dialog = new FTPDataSourceConfigurator(this.frame, this.host.getDomainName(), this.host);
        }
        ds_ftp_dialog.setHost(this.host);
        ds_ftp_dialog.clearFormFields();
        this.selected_ds_dialog = ds_ftp_dialog;
    }

    public void createFileDatasource() {
        if (ds_file_dialog == null) {
            ds_file_dialog = new FileDataSourceConfigurator(this.frame);
        }
        ds_file_dialog.setHost(this.host);
        this.selected_ds_dialog = ds_file_dialog;
    }

    public DataSourceConfigurationDialog askDataSourceDialog(DataSource ds) {
        if (ds.getType().equals("File")) {
            this.createFileDatasource();
        } else if (ds.getType().equals("FTP")) {
            this.createFTPDatasource();
        }
        return this.selected_ds_dialog;
    }

    public DataSourceConfigurationDialog askDataSourceDialog() {
        this.setVisible(true);
        return this.selected_ds_dialog;
    }
}

