/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.conf;

import ch.kronospace.logpsychoanalyst.ProductReferer;
import ch.kronospace.logpsychoanalyst.ProductRefererGroup;
import ch.kronospace.logpsychoanalyst.ProductRefererKeywords;
import ch.kronospace.logpsychoanalyst.RefererOrRefererGroup;
import ch.kronospace.logpsychoanalyst.conf.Configurator;
import ch.kronospace.logpsychoanalyst.database.RefererDatabaseParser;
import ch.kronospace.tools.GUITools;
import ch.kronospace.tools.RadioButtonPanel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ProductRefererEditor
implements Configurator {
    private boolean form_validated = false;
    RadioButtonPanel p_group = null;
    RadioButtonPanel p_kw_ref = null;
    private DefaultListModel lm_keywords = new DefaultListModel();
    private JList jl_keywords = new JList(this.lm_keywords);
    private JTree jt_groups = new JTree(RefererDatabaseParser.getDefaultDatabase().getRootRefererGroup());
    JDialog dialog;
    JFrame frame;
    static ProductRefererEditor singleton = null;

    private ProductRefererEditor(JFrame frame) {
        this.jt_groups.setVisibleRowCount(5);
        this.jl_keywords.setVisibleRowCount(4);
        this.dialog = null;
        this.frame = null;
        this.frame = frame;
    }

    public static ProductRefererEditor getInstance(JFrame frame) {
        if (singleton == null) {
            singleton = new ProductRefererEditor(frame);
        }
        return singleton;
    }

    public JDialog createDialog() {
        final JDialog dialog = new JDialog(this.frame, "Product Referer", true);
        JPanel p_full = new JPanel();
        p_full.setLayout(new BoxLayout(p_full, 1));
        p_full.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton bt_help = new JButton("Help");
        JButton bt_ok = new JButton("Ok", GUITools.yes_icon);
        JButton bt_cancel = new JButton("Cancel", GUITools.no_icon);
        JPanel p_buttons = new JPanel(new FlowLayout(2));
        p_buttons.add(bt_help);
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        p_full.add(this.getProductRefererPanel());
        p_full.add(p_buttons);
        dialog.getContentPane().add(p_full);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProductRefererEditor.this.form_validated = ProductRefererEditor.this.validateForm();
                dialog.setVisible(false);
            }
        });
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProductRefererEditor.this.form_validated = false;
                dialog.setVisible(false);
            }
        });
        bt_help.setEnabled(false);
        return dialog;
    }

    public boolean validateForm() {
        if (this.p_group.getRadioButton().isSelected()) {
            return this.jt_groups.getSelectionCount() > 0;
        }
        return this.lm_keywords.size() > 0;
    }

    private JPanel getProductRefererPanel() {
        JPanel p_group_temp = new JPanel(new FlowLayout(0));
        JScrollPane sp_tree = new JScrollPane(this.jt_groups);
        p_group_temp.add(sp_tree);
        this.p_group = new RadioButtonPanel("Group referer", new JComponent[]{sp_tree, this.jt_groups}, p_group_temp);
        JScrollPane sp_keywords = new JScrollPane(this.jl_keywords);
        JButton bt_add_keyword = new JButton("Add keyword");
        JButton bt_del_keyword = new JButton("Remove keyword");
        JButton bt_edit_keyword = new JButton("Edit keyword");
        JPanel p_buttons = new JPanel();
        p_buttons.setLayout(new BoxLayout(p_buttons, 1));
        p_buttons.add(bt_add_keyword);
        p_buttons.add(bt_del_keyword);
        p_buttons.add(bt_edit_keyword);
        bt_add_keyword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String kw = JOptionPane.showInputDialog(ProductRefererEditor.this.frame, (Object)"Please enter a new keyword");
                if (kw != null) {
                    ProductRefererEditor.this.lm_keywords.addElement(kw);
                }
            }
        });
        bt_edit_keyword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String kw;
                int index_to_edit = ProductRefererEditor.this.jl_keywords.getSelectedIndex();
                if (index_to_edit >= 0 && (kw = JOptionPane.showInputDialog(ProductRefererEditor.this.frame, "Please enter a new keyword", (String)ProductRefererEditor.this.jl_keywords.getSelectedValue())) != null) {
                    ProductRefererEditor.this.lm_keywords.setElementAt(kw, index_to_edit);
                }
            }
        });
        bt_del_keyword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index_to_remove = ProductRefererEditor.this.jl_keywords.getSelectedIndex();
                if (index_to_remove >= 0) {
                    ProductRefererEditor.this.lm_keywords.remove(index_to_remove);
                }
            }
        });
        JPanel p_kw_ref_temp = new JPanel(new FlowLayout(0));
        p_kw_ref_temp.add(sp_keywords);
        p_kw_ref_temp.add(p_buttons);
        this.p_kw_ref = new RadioButtonPanel("Keywords referers", new JComponent[]{bt_del_keyword, bt_edit_keyword, bt_add_keyword, this.jl_keywords}, p_kw_ref_temp);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.p_group.getRadioButton());
        btg.add(this.p_kw_ref.getRadioButton());
        this.p_group.getRadioButton().setSelected(true);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createTitledBorder("Type of Product Referer"));
        p.add(this.p_group);
        p.add(this.p_kw_ref);
        return p;
    }

    public void clear() {
        this.jt_groups.clearSelection();
        this.lm_keywords.clear();
    }

    public boolean ask() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.dialog.setVisible(true);
        return this.form_validated;
    }

    public void setProductReferer(ProductReferer product_referer) {
        if (this.p_group == null) {
            this.dialog = this.createDialog();
        }
        if (product_referer instanceof ProductRefererGroup) {
            ProductRefererGroup f = (ProductRefererGroup)product_referer;
            this.p_group.getRadioButton().setSelected(true);
            RefererOrRefererGroup r = RefererDatabaseParser.getDefaultDatabase().getRefererGroupByID(f.getGroupID());
            TreePath path = new TreePath(r.getPath());
            this.jt_groups.setSelectionPath(path);
        } else if (product_referer instanceof ProductRefererKeywords) {
            ProductRefererKeywords f = (ProductRefererKeywords)product_referer;
            this.p_kw_ref.getRadioButton().setSelected(true);
            this.lm_keywords.clear();
            String[] keywords = f.getSearchEngineKeywordsArray();
            int i = 0;
            while (i < keywords.length) {
                this.lm_keywords.addElement(keywords[i]);
                ++i;
            }
        } else {
            throw new RuntimeException(String.valueOf(this.getClass().getName().toString()) + ".setProductReferer(ProductReferer) is not implemented for objects of class " + product_referer.getClass().getName().toString());
        }
    }

    public ProductReferer getProductReferer() {
        if (this.p_group.getRadioButton().isSelected()) {
            ProductRefererGroup prg = new ProductRefererGroup();
            String group_id = ((RefererOrRefererGroup)this.jt_groups.getSelectionPath().getLastPathComponent()).getID();
            prg.setGroupID(group_id);
            System.out.println("You selecteded: " + group_id);
            return prg;
        }
        if (this.p_kw_ref.getRadioButton().isSelected()) {
            ProductRefererKeywords prk = new ProductRefererKeywords();
            Object[] keywords = new String[this.lm_keywords.getSize()];
            this.lm_keywords.copyInto(keywords);
            prk.setSearchEngineKeywordsArray((String[])keywords);
            return prk;
        }
        return null;
    }
}

