/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.database.GeographicDatabase;
import java.io.File;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GeographicDatabaseParser
extends DefaultHandler {
    private static GeographicDatabaseParser default_parser = null;
    private GeographicDatabase default_database = new GeographicDatabase();

    private GeographicDatabaseParser() {
        this.parse();
    }

    public static GeographicDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new GeographicDatabaseParser();
        }
        return GeographicDatabaseParser.default_parser.default_database;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/geographic_database.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        System.out.println("Geographic database: " + this.default_database.getTimeZones().size() + " timezones/countries");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("TimeZone")) {
            String country_code = attrs.getValue("country");
            String timezone_id = attrs.getValue("timezone");
            this.default_database.addTimeZone(country_code, TimeZone.getTimeZone(timezone_id));
        }
    }
}

