/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.Alias;
import ch.kronospace.logpsychoanalyst.DefaultPage;
import ch.kronospace.logpsychoanalyst.ISP;
import ch.kronospace.logpsychoanalyst.database.ISPDatabase;
import ch.kronospace.logpsychoanalyst.logformat.ApacheCombined3;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.io.File;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ISPDatabaseParser
extends DefaultHandler {
    private static ISPDatabaseParser default_parser = null;
    private ISPDatabase singleton = new ISPDatabase();

    private ISPDatabaseParser() {
        this.parse();
    }

    public static ISPDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new ISPDatabaseParser();
        }
        return ISPDatabaseParser.default_parser.singleton;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/isp_database.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        System.out.println("ISP database: " + this.singleton.size() + " ISPs");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("ISP")) {
            String aliases;
            String dps;
            ISP isp = new ISP();
            isp.name = attrs.getValue("name");
            isp.first_ip = attrs.getValue("firstIP");
            isp.last_ip = attrs.getValue("lastIP");
            isp.country = attrs.getValue("country");
            String tz = attrs.getValue("timezone");
            if (tz != null) {
                isp.timezone = TimeZone.getTimeZone(tz);
            }
            isp.isp_url = attrs.getValue("url");
            isp.log_url = attrs.getValue("log_url");
            isp.log_directory = attrs.getValue("log_directory");
            isp.log_file_regexp = attrs.getValue("log_file_regexp");
            String log_format_class = attrs.getValue("log_format");
            isp.log_format = new ApacheCombined3();
            if (log_format_class != null) {
                try {
                    isp.log_format = (LogFormat)Class.forName(log_format_class).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((dps = attrs.getValue("defaultPages")) != null) {
                StringTokenizer st = new StringTokenizer(dps, " ;,");
                while (st.hasMoreTokens()) {
                    isp.addDefaultPage(new DefaultPage(st.nextToken()));
                }
            }
            if ((aliases = attrs.getValue("aliases")) != null) {
                StringTokenizer st = new StringTokenizer(aliases, " ;,");
                while (st.hasMoreTokens()) {
                    isp.addAlias(new Alias(st.nextToken()));
                }
            }
            this.singleton.add(isp);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }
}

