/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.MimeType;
import ch.kronospace.logpsychoanalyst.database.MimeTypeDatabase;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MimeTypeDatabaseParser
extends DefaultHandler {
    private static MimeTypeDatabaseParser default_parser = null;
    private MimeTypeDatabase default_database = new MimeTypeDatabase();
    public String filename_extension = null;
    public String mime_type = null;
    public boolean in_mime_type = false;
    public boolean in_mime_mapping = false;
    public boolean in_filename_extension = false;

    private MimeTypeDatabaseParser() {
        this.parse();
    }

    public static MimeTypeDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new MimeTypeDatabaseParser();
        }
        return MimeTypeDatabaseParser.default_parser.default_database;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/mime_type_database.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        System.out.println("MimeType database: " + this.default_database.getMimeTypes().size() + " mime-types");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("MimeType")) {
            String mimetype = attrs.getValue("mimetype");
            String extension = attrs.getValue("extension");
            String icon = attrs.getValue("icon");
            if (icon.equals("")) {
                icon = "unknown";
            }
            String description = attrs.getValue("description");
            this.default_database.add(new MimeType(mimetype, extension, icon, description));
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }
}

