/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.OS;
import ch.kronospace.logpsychoanalyst.OSFamily;
import ch.kronospace.logpsychoanalyst.database.OSDatabase;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OSDatabaseParser
extends DefaultHandler {
    private static OSDatabaseParser default_parser = null;
    private OSDatabase singleton = new OSDatabase();
    public OSFamily family = null;
    public OS os = null;
    int nbr_os = 0;
    int nbr_os_definitions = 0;
    int nbr_unknown_icon = 0;
    int nbr_missing_url = 0;
    public int version_max_length = 50;
    public static boolean debug = false;

    private OSDatabaseParser() {
        this.parse();
    }

    public static OSDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new OSDatabaseParser();
        }
        return OSDatabaseParser.default_parser.singleton;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/os_list.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        System.out.println("OSRecognition database: " + this.nbr_os + " OS");
        System.out.println("OSRecognition database: " + this.nbr_missing_url + " missing URLs; " + this.nbr_unknown_icon + " without icon");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("Family")) {
            String familyid = attrs.getValue("id");
            String name = attrs.getValue("name");
            String icon = attrs.getValue("icon");
            this.family = new OSFamily(familyid, name, icon);
            this.singleton.add(this.family);
        } else if (eName.equals("OS")) {
            String id = attrs.getValue("id");
            String regexp = attrs.getValue("regexp");
            String name = attrs.getValue("name");
            String icon = attrs.getValue("icon");
            String url = attrs.getValue("url");
            this.os = new OS(this.family, id, regexp, name, icon, url);
            this.family.add(this.os);
            ++this.nbr_os_definitions;
            if (this.singleton.getOS(id) == null) {
                this.singleton.add(this.os);
                ++this.nbr_os;
            } else {
                System.out.println("ERROR: more than one OS have the id '" + id + "'");
            }
            if (icon.equals("unknown")) {
                ++this.nbr_unknown_icon;
            }
            if (url == null || url.equals("")) {
                ++this.nbr_missing_url;
            }
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (debug) {
            String s = new String(buf, offset, len);
            System.out.println(s);
        }
    }
}

