/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.Referer;
import ch.kronospace.logpsychoanalyst.RefererGroup;
import ch.kronospace.logpsychoanalyst.database.RefererDatabase;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RefererDatabaseParser
extends DefaultHandler {
    private static RefererDatabaseParser default_parser = null;
    private RefererDatabase singleton = new RefererDatabase();
    RefererGroup root_group = null;
    private RefererGroup current_group = null;
    private int nbr_ua = 0;
    private int nbr_ua_definitions = 0;
    private int nbr_unknown_icon = 0;
    private int nbr_missing_url = 0;
    private int nbr_useragents_visible_traffic = 0;
    private int nbr_useragents_invisible_traffic = 0;
    public static boolean debug = false;

    private RefererDatabaseParser() {
        this.parse();
    }

    public static RefererDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new RefererDatabaseParser();
        }
        return RefererDatabaseParser.default_parser.singleton;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/referer_database.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (debug) {
            System.out.println("Referer database: " + this.nbr_ua + " agents (human: " + this.nbr_useragents_visible_traffic + "; non-human: " + this.nbr_useragents_invisible_traffic + ") using " + this.nbr_ua_definitions + " definitions");
            System.out.println("Referer database: " + this.nbr_missing_url + " missing URLs; " + this.nbr_unknown_icon + " without icon");
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        String id = attrs.getValue("id");
        String localized_name = attrs.getValue("name");
        if (localized_name == null) {
            try {
                localized_name = ResourceBundle.getBundle("lang.Referer").getString(id);
            }
            catch (MissingResourceException e) {
                localized_name = id;
            }
        }
        if (eName.equals("RefererGroup")) {
            RefererGroup new_group = new RefererGroup(id, localized_name);
            if (this.current_group == null) {
                this.root_group = new_group;
                this.singleton.setRootRefererGroup(this.root_group);
            } else {
                this.current_group.add(new_group);
            }
            this.current_group = new_group;
        } else if (eName.equals("SearchEngine")) {
            String name_regex = attrs.getValue("name_regex");
            String query_regex = attrs.getValue("query_regex");
            if (name_regex == null) {
                throw new SAXException("no 'name_regex' provided for " + localized_name);
            }
            Referer ua = new Referer(id, localized_name, name_regex, query_regex, null);
            this.current_group.add(ua);
            this.singleton.add(ua);
        } else if (eName.equals("Referer")) {
            String name_regex = attrs.getValue("name_regex");
            String query_regex = attrs.getValue("query_regex");
            if (name_regex == null) {
                throw new SAXException("no 'name_regex' provided for " + localized_name);
            }
            Referer ua = new Referer(id, localized_name, name_regex, query_regex, null);
            String isURLParam_str = attrs.getValue("isURLParam");
            if (isURLParam_str != null) {
                ua.setIsURLParam(isURLParam_str);
            }
            this.current_group.add(ua);
            this.singleton.add(ua);
        } else if (eName.equals("Forum")) {
            String name_regex = attrs.getValue("name_regex");
            String query_regex = attrs.getValue("query_regex");
            if (name_regex == null) {
                throw new SAXException("no 'name_regex' provided for " + localized_name);
            }
            Referer ua = new Referer(id, localized_name, name_regex, query_regex, null);
            this.current_group.add(ua);
            this.singleton.add(ua);
        } else if (eName.equals("Webmail")) {
            String name_regex = attrs.getValue("name_regex");
            String query_regex = attrs.getValue("query_regex");
            if (name_regex == null) {
                throw new SAXException("no 'name_regex' provided for " + localized_name);
            }
            Referer ua = new Referer(id, localized_name, name_regex, query_regex, null);
            this.current_group.add(ua);
            this.singleton.add(ua);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("RefererGroup")) {
            this.current_group = (RefererGroup)this.current_group.getParent();
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
    }
}

