/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.UserAgent;
import ch.kronospace.logpsychoanalyst.UserAgentFamily;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabase;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class UserAgentDatabaseParser {
    private static UserAgentDatabaseParser default_parser = null;
    private UserAgentDatabase singleton = new UserAgentDatabase();
    private UserAgentFamily family = null;
    private UserAgent ua = null;
    private int nbr_ua = 0;
    private int nbr_ua_definitions = 0;
    private int nbr_unknown_icon = 0;
    private int nbr_missing_url = 0;
    private int nbr_useragents_visible_traffic = 0;
    private int nbr_useragents_invisible_traffic = 0;

    private UserAgentDatabaseParser() {
        this.parse();
    }

    public static UserAgentDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new UserAgentDatabaseParser();
        }
        return UserAgentDatabaseParser.default_parser.singleton;
    }

    private void parse() {
        SAXBuilder builder = new SAXBuilder(true);
        try {
            Document doc = builder.build("data/useragents.xml");
            Element root = doc.getRootElement();
            Iterator iter = root.getChildren().iterator();
            while (iter.hasNext()) {
                Element el = (Element)iter.next();
                if (!el.getName().equals("Constant") || !el.getAttributeValue("name").equals("version_max_length")) continue;
                try {
                    this.singleton.version_max_length = el.getAttribute("value").getIntValue();
                }
                catch (Exception e) {
                    this.singleton.version_max_length = 50;
                }
            }
            String order = root.getChild("UserAgentFamilyPriorityList").getAttributeValue("order");
            this.singleton.setFamilySearchOrder(order.split(",\\s*"));
            Iterator iter2 = root.getChild("UserAgentList").getChildren().iterator();
            while (iter2.hasNext()) {
                Element el = (Element)iter2.next();
                String id = el.getAttributeValue("id");
                String regexp = el.getAttributeValue("regexp");
                String name = el.getAttributeValue("name");
                String icon = el.getAttributeValue("icon");
                String visitortype = el.getAttributeValue("visitortype");
                this.family = new UserAgentFamily(id, regexp, name, icon, visitortype);
                this.singleton.add(this.family);
                Iterator iter22 = el.getChildren().iterator();
                while (iter22.hasNext()) {
                    Element el_ua = (Element)iter22.next();
                    id = el_ua.getAttributeValue("id");
                    String versionid = el_ua.getAttributeValue("versionid");
                    regexp = el_ua.getAttributeValue("regexp");
                    name = el_ua.getAttributeValue("name");
                    icon = el_ua.getAttributeValue("icon");
                    String url = el_ua.getAttributeValue("url");
                    if (id.matches(".*[\\ /].*")) {
                        System.out.println("Error (useragents.xml): the userAgend ID (" + id + ") must not contains non filename characters (eg. space, \\).");
                    }
                    this.ua = new UserAgent(this.family, id, versionid, regexp, name, icon, url);
                    this.family.add(this.ua);
                    ++this.nbr_ua_definitions;
                    if (this.singleton.getUserAgent(id) == null) {
                        this.singleton.add(this.ua);
                        ++this.nbr_ua;
                        if (this.family.getVisitorType().equals("human")) {
                            ++this.nbr_useragents_visible_traffic;
                        } else {
                            ++this.nbr_useragents_invisible_traffic;
                        }
                    }
                    if (icon.equals("unknown")) {
                        ++this.nbr_unknown_icon;
                    }
                    if (url != null && !url.equals("")) continue;
                    ++this.nbr_missing_url;
                }
            }
            System.out.println("UserAgentRecognition database: " + this.nbr_ua + " agents (human: " + this.nbr_useragents_visible_traffic + "; non-human: " + this.nbr_useragents_invisible_traffic + ") using " + this.nbr_ua_definitions + " definitions");
            System.out.println("UserAgentRecognition database: " + this.nbr_missing_url + " missing URLs; " + this.nbr_unknown_icon + " without icon");
        }
        catch (JDOMException e) {
            System.out.println("Error loading XML: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

