/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.UserAgentString;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabase;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class UserAgentDatabaseTestParser
extends DefaultHandler {
    private static UserAgentDatabaseTestParser singleton = null;
    private Hashtable ht_browsers = new Hashtable();
    private Vector user_agents = new Vector();
    private int nbr_browsers = 0;
    private int nbr_useragent_string = 0;

    private UserAgentDatabaseTestParser() {
    }

    public static void validate(UserAgentDatabase database) {
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/useragent_database_test.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        System.out.println("UserAgentRecognition validation: " + this.nbr_useragent_string + " HTTP UserAgent strings (" + this.nbr_browsers + " different user-agents)");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("UserAgentString")) {
            String browserid = attrs.getValue("browserid");
            String versionid = attrs.getValue("versionid");
            String familyid = attrs.getValue("familyid");
            String ua = attrs.getValue("ua");
            this.user_agents.add(new UserAgentString(ua, familyid, browserid, versionid));
            ++this.nbr_useragent_string;
            if (this.ht_browsers.get(browserid) == null) {
                this.ht_browsers.put(browserid, "");
                ++this.nbr_browsers;
            }
        }
    }
}

