/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.database;

import ch.kronospace.logpsychoanalyst.Worm;
import ch.kronospace.logpsychoanalyst.database.WormDatabase;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WormDatabaseParser
extends DefaultHandler {
    private static WormDatabaseParser default_parser = null;
    private WormDatabase singleton = new WormDatabase();

    private WormDatabaseParser() {
        this.parse();
    }

    public static WormDatabase getDefaultDatabase() {
        if (default_parser == null) {
            default_parser = new WormDatabaseParser();
        }
        return WormDatabaseParser.default_parser.singleton;
    }

    public void parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File("data/worm_database.xml"), (DefaultHandler)this);
        }
        catch (SAXParseException e) {
            System.out.println("exception at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " :");
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        System.out.println("WormRecognition database: " + this.singleton.getWorms().size() + " worms");
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("Worm")) {
            String id = attrs.getValue("id");
            String name = attrs.getValue("name");
            String regexp = attrs.getValue("regexp");
            String target = attrs.getValue("target");
            String url = attrs.getValue("url");
            this.singleton.add(new Worm(id, name, regexp, target, url));
        } else if (eName.equals("PossibleWorm")) {
            String contains = attrs.getValue("contains");
            this.singleton.getPossibleWorms().add(contains);
        }
    }
}

