/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.geography;

import ch.kronospace.logpsychoanalyst.database.GeographicDatabase;
import ch.kronospace.logpsychoanalyst.database.GeographicDatabaseParser;
import ch.kronospace.logpsychoanalyst.geography.GeoIPProvider;
import ch.kronospace.logpsychoanalyst.geography.Location;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class IPGeographyUtil {
    private static Vector providers = new Vector();
    private static String localhost_country_code = Locale.getDefault().getCountry().toLowerCase();
    private static String local_network_country_code;
    private static long last_ip_address;
    private static String last_country_code;
    private static GeographicDatabase timezone_database;

    static {
        if (localhost_country_code.length() == 0) {
            localhost_country_code = "--";
        }
        local_network_country_code = localhost_country_code;
        last_ip_address = -1L;
        last_country_code = null;
        timezone_database = GeographicDatabaseParser.getDefaultDatabase();
    }

    public static void registerProvider(GeoIPProvider provider) {
        providers.add(0, provider);
    }

    public static void setLocalNetworkCountryCode(String country_code) {
        local_network_country_code = country_code;
    }

    public static void setLocalhostCountryCode(String country_code) {
        localhost_country_code = country_code;
    }

    public static Location getLocation(long ip_address) {
        Location loc = new Location();
        loc.locale = new Locale("en", IPGeographyUtil.getCountryCode(ip_address));
        return loc;
    }

    public static TimeZone getTimeZone(long ip_address) {
        TimeZone timezone = null;
        Enumeration e = providers.elements();
        while (e.hasMoreElements()) {
            GeoIPProvider provider = (GeoIPProvider)e.nextElement();
            timezone = provider.getTimeZoneId(ip_address);
        }
        if (timezone != null) {
            return timezone;
        }
        String country_code = null;
        if (last_ip_address == ip_address) {
            country_code = last_country_code;
        } else {
            country_code = IPGeographyUtil.getCountryCode(ip_address);
            last_ip_address = ip_address;
            last_country_code = country_code;
        }
        return timezone_database.getTimeZone(country_code);
    }

    public static String getCountryCode(long ip_address) {
        last_ip_address = ip_address;
        if ((ip_address & 0xFFFFFFFFFF000000L) == 0x7F000000L) {
            last_country_code = localhost_country_code;
            return localhost_country_code;
        }
        if ((ip_address & 0xFFFFFFFFFFFF0000L) == 3232235520L || (ip_address & 0xFFFFFFFFFF000000L) == 0xA000000L || (ip_address & 0xFFFFFFFFFFF00000L) == 2886729728L) {
            last_country_code = local_network_country_code;
            return local_network_country_code;
        }
        String country_code = null;
        Enumeration e = providers.elements();
        while (country_code == null && e.hasMoreElements()) {
            GeoIPProvider provider = (GeoIPProvider)e.nextElement();
            country_code = provider.getCountryCode(ip_address);
        }
        last_country_code = country_code;
        if (country_code == null) {
            System.out.println("ERROR: country_code=null" + providers.toString());
        }
        return country_code;
    }

    public static String getCountryCode(long ip_address, long date) {
        last_ip_address = ip_address;
        if ((ip_address & 0xFFFFFFFFFF000000L) == 0x7F000000L) {
            last_country_code = localhost_country_code;
            return localhost_country_code;
        }
        if ((ip_address & 0xFFFFFFFFFFFF0000L) == 3232235520L || (ip_address & 0xFFFFFFFFFF000000L) == 0xA000000L || (ip_address & 0xFFFFFFFFFFF00000L) == 2886729728L) {
            last_country_code = local_network_country_code;
            return local_network_country_code;
        }
        String country_code = null;
        Enumeration e = providers.elements();
        while (country_code == null && e.hasMoreElements()) {
            GeoIPProvider provider = (GeoIPProvider)e.nextElement();
            country_code = provider.getCountryCode(ip_address, date);
        }
        last_country_code = country_code;
        return country_code;
    }

    public static void setDatabase(long date) {
        Enumeration e = providers.elements();
        while (e.hasMoreElements()) {
            GeoIPProvider provider = (GeoIPProvider)e.nextElement();
            provider.setDatabase(date);
        }
    }

    public static void downloadUpdate() {
        Enumeration e = providers.elements();
        while (e.hasMoreElements()) {
            GeoIPProvider provider = (GeoIPProvider)e.nextElement();
            provider.downloadUpdate();
        }
    }

    public static String getCountryCode(String ip) {
        return IPGeographyUtil.getCountryCode(IPGeographyUtil.getIPAsLong(ip));
    }

    public static String getIP(long ip_address) {
        String result = "";
        int i = 0;
        while (i < 4) {
            int digit = (int)(ip_address & 0xFFL);
            result = digit + "." + result;
            ip_address >>= 8;
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }

    public static long getIPAsLong(String ip_address) {
        long long_ip = 0L;
        int aa = 0;
        int i = 0;
        while (i < ip_address.length()) {
            char c = ip_address.charAt(i);
            if (c == '.') {
                long_ip = (long_ip << 8) + (long)aa;
                aa = 0;
            } else {
                aa = aa * 10 + c - 48;
            }
            ++i;
        }
        long_ip = (long_ip << 8) + (long)aa;
        return long_ip;
    }
}

