/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.geography;

import ch.kronospace.logpsychoanalyst.geography.GeoIPProvider;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class MaxMindGeoIPFree
implements GeoIPProvider {
    private RandomAccessFile file = null;
    private File dir = null;
    SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd hh:mm");
    public static final int COUNTRY_EDITION = 1;
    public static final int REGION_EDITION_REV0 = 7;
    public static final int REGION_EDITION_REV1 = 3;
    public static final int CITY_EDITION_REV0 = 6;
    public static final int CITY_EDITION_REV1 = 2;
    public static final int ORG_EDITION = 5;
    public static final int ISP_EDITION = 4;
    public static final int PROXY_EDITION = 8;
    public static final int ASNUM_EDITION = 9;
    public static final int NETSPEED_EDITION = 10;
    byte databaseType = 1;
    int[] databaseSegments;
    int recordLength;
    String licenseKey;
    int dnsService = 0;
    byte[] dbbuffer;
    int[] int_dbbuffer;
    public static final int US_OFFSET = 1;
    public static final int CANADA_OFFSET = 677;
    public static final int WORLD_OFFSET = 1353;
    public static final int FIPS_RANGE = 360;
    public static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STATE_BEGIN_REV0 = 16700000;
    private static final int STATE_BEGIN_REV1 = 16000000;
    private static final int STRUCTURE_INFO_MAX_SIZE = 20;
    public static final int DATABASE_INFO_MAX_SIZE = 100;
    public static final int GEOIP_STANDARD = 0;
    public static final int GEOIP_MEMORY_CACHE = 1;
    public static final int GEOIP_UNKNOWN_SPEED = 0;
    public static final int GEOIP_DIALUP_SPEED = 1;
    public static final int GEOIP_CABLEDSL_SPEED = 2;
    public static final int GEOIP_CORPORATE_SPEED = 3;
    int dboptions = 1;
    private static final int SEGMENT_RECORD_LENGTH = 3;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int ORG_RECORD_LENGTH = 4;
    public static final int MAX_RECORD_LENGTH = 4;
    public static final int MAX_ORG_RECORD_LENGTH = 300;
    public static final int FULL_RECORD_LENGTH = 50;
    private static final String[] countryCode = new String[]{"--", "ap", "eu", "ad", "ae", "af", "ag", "ai", "al", "am", "an", "ao", "aq", "ar", "as", "at", "au", "aw", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "eh", "er", "es", "et", "fi", "fj", "fk", "fm", "fo", "fr", "fx", "ga", "gb", "gd", "ge", "gf", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "in", "io", "iq", "ir", "is", "it", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "sv", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tm", "tn", "to", "tp", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "um", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "yu", "za", "zm", "zr", "zw", "A1", "A2", "O1"};
    Pattern pat_old_database = null;
    File[] database_files = new File[0];
    long[] database_files_date = new long[0];
    int current_database_index;

    public MaxMindGeoIPFree(File database_dir) {
        if (!database_dir.isDirectory()) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        this.dir = database_dir;
        this.init_databases();
    }

    public MaxMindGeoIPFree(String databaseFile) {
        this.loadFile(new File(databaseFile));
    }

    private void init_databases() {
        File[] files = this.dir.listFiles();
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return (int)(f1.lastModified() / 1000L - f2.lastModified() / 1000L);
            }

            public boolean equals(Object c) {
                return true;
            }
        });
        this.database_files = files;
        this.database_files_date = new long[this.database_files.length];
        int i = 0;
        while (i < files.length) {
            this.database_files_date[i] = this.database_files[i].lastModified();
            ++i;
        }
        this.current_database_index = this.database_files.length - 1;
        if (this.database_files.length > 0) {
            this.loadFile(this.database_files[this.current_database_index]);
        }
    }

    public void loadFile(File databaseFile) {
        try {
            this.file = new RandomAccessFile(databaseFile, "r");
            this.init();
            this.file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws IOException {
        byte[] delim = new byte[3];
        byte[] buf = new byte[3];
        if (this.file == null) {
            return;
        }
        this.file.seek(this.file.length() - 3L);
        int i = 0;
        while (i < 20) {
            this.file.read(delim);
            if (delim[0] == -1 && delim[1] == -1 && delim[2] == -1) {
                this.databaseType = this.file.readByte();
                if (this.databaseType >= 106) {
                    this.databaseType = (byte)(this.databaseType - 105);
                }
                if (this.databaseType == 7) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16700000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType == 3) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16000000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType != 6 && this.databaseType != 2 && this.databaseType != 5 && this.databaseType != 4 && this.databaseType != 9) break;
                this.databaseSegments = new int[1];
                this.databaseSegments[0] = 0;
                this.recordLength = this.databaseType == 6 || this.databaseType == 2 ? 3 : 4;
                this.file.read(buf);
                int j = 0;
                while (j < 3) {
                    this.databaseSegments[0] = this.databaseSegments[0] + (MaxMindGeoIPFree.unsignedByteToInt(buf[j]) << j * 8);
                    ++j;
                }
                break;
            }
            this.file.seek(this.file.getFilePointer() - 4L);
            ++i;
        }
        if (this.databaseType == 1 | this.databaseType == 8 | this.databaseType == 10) {
            this.databaseSegments = new int[1];
            this.databaseSegments[0] = 0xFFFF00;
            this.recordLength = 3;
        }
        if ((this.dboptions & 1) == 1) {
            int l = (int)this.file.length();
            this.dbbuffer = new byte[l];
            this.file.seek(0L);
            this.file.read(this.dbbuffer, 0, l);
            int nbr_pointers = l / this.recordLength;
            this.int_dbbuffer = new int[nbr_pointers];
            int i2 = 0;
            while (i2 < nbr_pointers) {
                int pointer = 0;
                int j = 0;
                while (j < this.recordLength) {
                    int b = this.dbbuffer[i2 * this.recordLength + j];
                    if (b < 0) {
                        b += 256;
                    }
                    pointer += b << j * 8;
                    ++j;
                }
                this.int_dbbuffer[i2] = pointer;
                ++i2;
            }
        }
    }

    public void close() {
        try {
            this.file.close();
            this.file = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDatabase(long date) {
        int min_index = Arrays.binarySearch(this.database_files_date, date);
        if (min_index < 0) {
            min_index = Math.min(-(min_index + 1), this.database_files_date.length - 1);
        }
        if (min_index != this.current_database_index) {
            System.out.println("Loading a new maxmind geoip free database: " + this.df.format(new Date(this.database_files_date[min_index])));
            this.current_database_index = min_index;
            this.loadFile(this.database_files[this.current_database_index]);
        }
    }

    public String getCountryCode(long ip_address, long date) {
        this.setDatabase(date);
        return this.getCountryCode(ip_address);
    }

    public String getCountryCode(long ip_address) {
        if (this.int_dbbuffer == null) {
            return countryCode[0];
        }
        int offset = 0;
        String country_code = null;
        int depth = 31;
        while (depth >= 0) {
            int a = this.int_dbbuffer[2 * offset];
            int b = this.int_dbbuffer[2 * offset + 1];
            if ((ip_address & (long)(1 << depth)) > 0L) {
                if (b >= 0xFFFF00) {
                    country_code = countryCode[b - 0xFFFF00];
                    break;
                }
                offset = b;
            } else {
                if (a >= 0xFFFF00) {
                    country_code = countryCode[a - 0xFFFF00];
                    break;
                }
                offset = a;
            }
            --depth;
        }
        return country_code;
    }

    public TimeZone getTimeZoneId(long ip_address) {
        return null;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public void downloadUpdate() {
        File[] list = this.dir.listFiles();
        Pattern pat = Pattern.compile("GeoIP_(\\d+)\\.dat.*");
        int last_seq_number = list.length;
        int i = 0;
        while (i < list.length) {
            String filename = list[i].getName();
            Matcher m = pat.matcher(filename);
            if (m.find()) {
                String str_num = m.group(1);
                try {
                    last_seq_number = Math.max(last_seq_number, Integer.parseInt(str_num));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        File file = null;
        while ((file = new File(this.dir, "GeoIP_" + ++last_seq_number + ".dat")).exists()) {
        }
        URL url = null;
        try {
            int nbr_bytes_read;
            url = new URL("http://www.maxmind.com/download/geoip/database/GeoIP.dat.gz");
            URLConnection con = url.openConnection();
            int buffer_len = 16384;
            long last_mod = con.getLastModified();
            if (last_mod / 60000L == this.getLastDatabaseDate() / 60000L) {
                return;
            }
            int len = con.getContentLength();
            if (len < 0) {
                len = 0;
            }
            InputStream in = con.getInputStream();
            ByteArrayOutputStream compressed_content = new ByteArrayOutputStream(len);
            byte[] buffer = new byte[buffer_len];
            System.out.println("Downloading " + url.toString() + " ...");
            int total_bytes_read = nbr_bytes_read = in.read(buffer);
            while (nbr_bytes_read > 0) {
                if (len > 0) {
                    System.out.print(String.valueOf(total_bytes_read * 100 / len) + "%\r");
                }
                compressed_content.write(buffer, 0, nbr_bytes_read);
                nbr_bytes_read = in.read(buffer);
                total_bytes_read += nbr_bytes_read;
            }
            GZIPInputStream in_comp = new GZIPInputStream((InputStream)new ByteArrayInputStream(compressed_content.toByteArray()), buffer_len);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            nbr_bytes_read = in_comp.read(buffer);
            while (nbr_bytes_read > 0) {
                out.write(buffer, 0, nbr_bytes_read);
                nbr_bytes_read = in_comp.read(buffer);
            }
            out.close();
            in_comp.close();
            if (last_mod != 0L) {
                file.setLastModified(last_mod);
            }
            in.close();
        }
        catch (UnknownHostException e) {
            System.out.println("WARNING, UnknownHostException: could not connect to '" + url.toString() + "'. Probably no internet connexion.");
            return;
        }
        catch (IOException e) {
            System.out.println("WARNING, IOException: could not connect to '" + url.toString() + "'. Probably no internet connexion.");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init_databases();
    }

    public long getLastDatabaseDate() {
        File[] list = this.dir.listFiles();
        long last_date = Long.MIN_VALUE;
        int i = 0;
        while (i < list.length) {
            long current_date = list[i].lastModified();
            if (current_date > last_date) {
                last_date = current_date;
            }
            ++i;
        }
        return last_date;
    }
}

