/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.logformat;

import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApacheCommon
extends LogFormat {
    static final Pattern pattern = Pattern.compile("([^ ]+) [^ ]+ ([^\\[]+) \\[([^ ]+) [^ ]+\\] \\\"([^ ]+) ([^ ]+) [^\\\"]*\\\" ([\\d|-]+) ([\\d|-]+)");
    static final Matcher m = pattern.matcher("");

    public void parse(String log_entry) {
        this.corrupted = false;
        m.reset(log_entry);
        boolean ok = m.matches();
        if (!ok) {
            System.out.println(this.getClass() + "/parse(String): parse error in " + log_entry);
        }
        this.host = m.group(1);
        this.host_ip = IPGeographyUtil.getIPAsLong(this.host);
        this.logname = m.group(2);
        try {
            this.date.setTime(df.parse(m.group(3)));
            this.hour = this.date.get(11);
            this.minute = this.date.get(12);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.method = m.group(4);
        this.url = m.group(5);
        try {
            this.code = Integer.parseInt(m.group(6));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.size = Long.parseLong(m.group(7));
        }
        catch (Exception e) {
            this.size = 0L;
        }
        this.referer = null;
        this.useragent = null;
    }

    public boolean hasReferer() {
        return false;
    }

    public boolean hasUserAgent() {
        return false;
    }
}

