/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.logformat;

import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.logformat.LogFormatManager;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ApacheCommon2
extends LogFormat {
    char[] chars = new char[4096];
    int previous_day_of_week = -1;
    int previous_day = -1;
    int previous_month = -1;
    int previous_year = -1;
    boolean first_time_report_resolved_hostname_error = true;
    boolean unresolve_resolved_hosts = true;

    static {
        LogFormatManager.register(new ApacheCommon2());
    }

    public ApacheCommon2() {
        this.referer = "";
        this.useragent = "";
    }

    public void parse(String log_entry) {
        try {
            this.corrupted = false;
            if (log_entry.length() > this.chars.length) {
                this.corrupted = true;
                return;
            }
            log_entry.getChars(0, log_entry.length(), this.chars, 0);
            int last_index = 0;
            int index = 0;
            while (this.chars[index] != ' ') {
                ++index;
            }
            this.host = new String(this.chars, 0, index);
            last_index = index++;
            this.host_ip = 0L;
            long host_ip_resolved = -1L;
            int aa = 0;
            int i = 0;
            while (i < this.host.length()) {
                char c = this.chars[i];
                if (c == '.') {
                    this.host_ip = (this.host_ip << 8) + (long)aa;
                    aa = 0;
                } else {
                    aa = aa * 10 + c - 48;
                    if (c > '9') {
                        if (this.unresolve_resolved_hosts) {
                            try {
                                byte[] ip_parts = InetAddress.getByName(this.host).getAddress();
                                host_ip_resolved = 0L;
                                int j = 0;
                                while (j < ip_parts.length) {
                                    host_ip_resolved = (host_ip_resolved << 8) + (long)ip_parts[j];
                                    ++j;
                                }
                                break;
                            }
                            catch (UnknownHostException e) {
                                this.corrupted = true;
                                this.unresolve_resolved_hosts = false;
                            }
                        } else {
                            this.corrupted = true;
                        }
                        if (this.corrupted && this.first_time_report_resolved_hostname_error) {
                            System.out.println("corrupted (resolved host not supported): " + this.getClass().getName() + " does not support records with resolved host names. Please use an more flexible LogFormat parser.");
                            System.out.println(log_entry);
                            this.first_time_report_resolved_hostname_error = false;
                            return;
                        }
                    }
                }
                ++i;
            }
            this.host_ip = host_ip_resolved >= 0L ? host_ip_resolved : (this.host_ip << 8) + (long)aa;
            while (this.chars[index] != ' ') {
                ++index;
            }
            last_index = index++;
            while (this.chars[index] != '[') {
                ++index;
            }
            this.logname = new String(this.chars, last_index + 1, index - last_index - 1);
            --index;
            last_index = index++;
            while (this.chars[index] != ' ') {
                ++index;
            }
            this.previous_day = this.day;
            this.previous_month = this.month;
            this.previous_year = this.year;
            this.day = (this.chars[last_index + 2] - 48) * 10 + this.chars[last_index + 3] - 48;
            char c1 = this.chars[last_index + 5];
            char c2 = this.chars[last_index + 6];
            char c3 = this.chars[last_index + 7];
            this.month = c3 == 'y' ? 4 : (c2 == 'p' ? 3 : (c3 == 'l' ? 6 : (c1 == 'M' ? 2 : (c2 == 'a' ? 0 : (c1 == 'J' ? 5 : (c1 == 'S' ? 8 : (c1 == 'D' ? 11 : (c1 == 'F' ? 1 : (c1 == 'A' ? 7 : (c1 == 'O' ? 9 : 10))))))))));
            this.year = (this.chars[last_index + 9] - 48) * 1000 + (this.chars[last_index + 10] - 48) * 100 + (this.chars[last_index + 11] - 48) * 10 + (this.chars[last_index + 12] - 48);
            this.hour = (this.chars[last_index + 14] - 48) * 10 + (this.chars[last_index + 15] - 48);
            this.minute = (this.chars[last_index + 17] - 48) * 10 + (this.chars[last_index + 18] - 48);
            int sec = (this.chars[last_index + 20] - 48) * 10 + (this.chars[last_index + 21] - 48);
            this.date.set(this.year, this.month, this.day, this.hour, this.minute, sec);
            this.getDayOfWeek();
            last_index = index++;
            while (this.chars[index] != ' ') {
                ++index;
            }
            last_index = index++;
            ++index;
            while (this.chars[index] != ' ' && this.chars[index] != '\"') {
                ++index;
            }
            if (this.chars[index] == '\"') {
                this.corrupted = true;
                if (this.debug) {
                    System.out.println("corrupted record (no method/URL/httpVersion): " + log_entry);
                }
                return;
            }
            this.method = new String(this.chars, last_index + 2, index - last_index - 2);
            last_index = index++;
            while (this.chars[index] != '\"' || this.chars[index - 1] == '\\' || this.chars[index + 1] != ' ') {
                ++index;
            }
            int index2 = --index;
            while (this.chars[index] != ' ' && this.chars[index] != '\"') {
                --index;
            }
            if (last_index == index) {
                index = index2;
            }
            this.url = new String(this.chars, last_index + 1, index - last_index - 1);
            last_index = index++;
            while (this.chars[index] != ' ') {
                ++index;
            }
            last_index = index++;
            while (this.chars[index] != ' ') {
                ++index;
            }
            try {
                this.code = Integer.parseInt(new String(this.chars, last_index + 1, index - last_index - 1));
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println(log_entry);
                    e.printStackTrace();
                }
                this.corrupted = true;
            }
            last_index = index++;
            try {
                this.size = Long.parseLong(new String(this.chars, last_index + 1, log_entry.length() - last_index - 1));
            }
            catch (Exception e) {
                this.size = 0L;
            }
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println(log_entry);
                e.printStackTrace();
            }
            this.corrupted = true;
        }
    }

    public int getDayOfWeek() {
        if (this.day_of_week == -1 || this.day != this.previous_day || this.month != this.previous_month || this.year != this.previous_year) {
            this.day_of_week = super.getDayOfWeek();
        }
        return this.day_of_week;
    }

    public boolean hasReferer() {
        return false;
    }

    public boolean hasUserAgent() {
        return false;
    }

    public boolean isRefererOnSameVirtualHostThanURL() {
        return false;
    }

    public String getRefererHost() {
        return null;
    }

    public String getRefererPage() {
        return null;
    }

    public String toString() {
        return "ApacheCommon (speed grade 2)";
    }
}

