/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.logformat;

import ch.kronospace.logpsychoanalyst.DataSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class LogFormat {
    public static SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.ENGLISH);
    protected String host = null;
    protected long host_ip = 0L;
    protected InetAddress host_inet_address = null;
    protected String logname = null;
    protected Calendar date = Calendar.getInstance();
    protected String method = null;
    protected String url = null;
    protected int code = 0;
    protected long size = 0L;
    protected String referer = null;
    protected String useragent = null;
    protected boolean corrupted = false;
    protected boolean debug = false;
    protected String ref_host_name = null;
    protected boolean is_referer_on_same_vhost = false;
    protected String ref_page = null;
    protected DataSource vhost = null;
    protected int hour = -1;
    protected int minute = -1;
    protected int day = -1;
    protected int month = -1;
    protected int year = -1;
    protected int day_of_week = -1;
    String last_entry = null;
    protected BufferedReader in = null;

    public void setDataSource(DataSource vhost) {
        this.vhost = vhost;
    }

    public DataSource getDataSource() {
        return this.vhost;
    }

    public void setBufferedReader(BufferedReader in) {
        this.in = in;
    }

    public String getNextEntry() throws IOException {
        this.last_entry = this.in.readLine();
        return this.last_entry;
    }

    public String getLastEntry() {
        return this.last_entry;
    }

    public void parse(String log_entry) {
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public String getHostAsString() {
        return this.host;
    }

    public long getHost() {
        return this.host_ip;
    }

    public InetAddress getHostAsInetAddress() {
        return this.host_inet_address;
    }

    public String getLogName() {
        return this.logname;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getDayOfWeek() {
        return this.getDate().get(7);
    }

    public int getMonth() {
        return this.getDate().get(2);
    }

    public int getDayOfYear() {
        return this.getDate().get(6);
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURL() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public long getSize() {
        return this.size;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUserAgent() {
        return this.useragent;
    }

    public void setUserAgent(String ua) {
        this.useragent = ua;
    }

    public boolean isRefererOnSameVirtualHostThanURL() {
        return this.is_referer_on_same_vhost;
    }

    public String getRefererHost() {
        return this.ref_host_name;
    }

    public String getRefererPage() {
        return this.ref_page;
    }

    public boolean hasReferer() {
        return true;
    }

    public boolean hasUserAgent() {
        return true;
    }

    public String toString() {
        return "Host: *" + this.getHost() + "*\n" + "Date: *" + df.format(this.getDate().getTime()) + "*\n" + "URL:  *" + this.getURL() + "*\n" + "Method: *" + this.getMethod() + "*\n" + "Code: " + this.getCode() + "\n" + "Size: " + this.getSize() + "\n" + "Referer: " + this.getReferer() + "\n" + "UserAgent: " + this.getUserAgent() + "\n";
    }
}

