/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AWStatsMiscTracker
implements GeneralPlugin {
    private static String awstats_misc_tracker_filename = "awstats_misc_tracker.js";

    static {
        PluginManager.registerPlugin(new AWStatsMiscTracker());
    }

    public Object getValue(String key) {
        return null;
    }

    private void addPageWithTracker(String page_url) {
    }

    public void processRecord(LogFormat lf, Visit visit, HTTPStatistics stats) {
        String page = lf.getURL();
        int index_script = page.indexOf(awstats_misc_tracker_filename);
        if (index_script != -1 && page.length() > index_script + awstats_misc_tracker_filename.length()) {
            String plugin;
            String screen_size;
            String ref_page = lf.getReferer();
            int index_last_slash = ref_page.lastIndexOf(47);
            if (index_last_slash > "http://".length()) {
                String ref_page_file = ref_page.substring(index_last_slash + 1);
                if (ref_page_file.length() == 0) {
                    this.addPageWithTracker("/");
                } else if (lf.getDataSource().isDefaultPage(ref_page_file)) {
                    String directory = String.valueOf(ref_page.substring(ref_page.indexOf(47, "http://".length()), index_last_slash)) + "/";
                    this.addPageWithTracker(directory);
                }
            } else if (index_last_slash >= 0) {
                this.addPageWithTracker("/");
            }
            Hashtable<String, String> ht_values = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(page.substring(index_script + awstats_misc_tracker_filename.length() + 1), "=&");
            while (st.hasMoreTokens()) {
                ht_values.put(st.nextToken(), st.nextToken());
            }
            if (ht_values.size() > 0) {
                visit.addInstalledPlugin("<img src=images/mimetypes/script.png> Javascript", true);
            }
            if ((screen_size = (String)ht_values.get("screen")) != null) {
                int screen_width = -1;
                int screen_height = -1;
                try {
                    int index_x = screen_size.indexOf(120);
                    screen_width = Integer.parseInt(screen_size.substring(0, index_x));
                    screen_height = Integer.parseInt(screen_size.substring(index_x + 1));
                    visit.setScreenSize(screen_width, screen_height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((plugin = (String)ht_values.get("pdf")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/adobe.png> AcrobatReader", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("java")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/java.png> Java", plugin.equals("true"));
            }
            if ((plugin = (String)ht_values.get("shk")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/shockwave.png> Shockwave", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("fla")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/flash.png> Flash", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("rp")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/realplayer.png> RealPlayer", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("wma")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/wmp.png> WMAPlayer", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("mov")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/quicktime.png> Quicktime", plugin.equals("y"));
            }
            visit.setVisitID((String)ht_values.get("sid"));
            visit.setVisitorID((String)ht_values.get("uid"));
        }
    }

    public boolean isAHit(LogFormat lf) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognize AWStats's misc tracker)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

