/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GoogleAdwordsTracker
implements GeneralPlugin {
    private static String script_name;

    static {
        PluginManager.registerPlugin(new GoogleAdwordsTracker());
        script_name = "http://pagead2.googlesyndication.com/pagead/ads?";
    }

    public Object getValue(String key) {
        return null;
    }

    public void processRecord(LogFormat lf, Visit visit, HTTPStatistics stats) {
        String ref = lf.getReferer();
        if (ref.startsWith(script_name)) {
            Hashtable<String, String> ht_values = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(ref.substring(script_name.length() + 1), "&");
            while (st.hasMoreTokens()) {
                String key_value = st.nextToken();
                int index_equal = key_value.indexOf(61);
                if (index_equal > 0) {
                    String value = key_value.substring(index_equal + 1);
                    String key = key_value.substring(0, index_equal);
                    ht_values.put(key, value);
                    continue;
                }
                if (ref.substring(script_name.length() + 1).endsWith(key_value)) continue;
                System.out.println("GOOGLEADWORDS error (no equal):" + key_value + " ## " + ref);
            }
            visit.addInstalledPlugin("<img src=images/mimetypes/script.png> Javascript", true);
            String width_str = (String)ht_values.get("u_w");
            String height_str = (String)ht_values.get("u_h");
            int screen_width = -1;
            int screen_height = -1;
            try {
                if (width_str != null) {
                    screen_width = Integer.parseInt(width_str);
                }
                if (height_str != null) {
                    screen_height = Integer.parseInt(height_str);
                }
                visit.setScreenSize(screen_width, screen_height);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String plugin = (String)ht_values.get("u_java");
            if (plugin != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/java.png> Java", plugin.equals("true"));
            }
        }
    }

    public boolean isAHit(LogFormat lf) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognize Google AdWords referers)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

