/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.KeyphraseRanking;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GoogleReferer
implements GeneralPlugin {
    private static String google_referer_start;
    public KeyphraseRanking keyphrase_ranking = new KeyphraseRanking("auberge meyrin");

    static {
        PluginManager.registerPlugin(new GoogleReferer());
        google_referer_start = "http://www.google.";
    }

    public Object getValue(String key) {
        return null;
    }

    public void processRecord(LogFormat lf, Visit visit, HTTPStatistics stats) {
        String ref = lf.getReferer();
        if (ref.startsWith(google_referer_start)) {
            int index_questionmark = ref.indexOf(63, google_referer_start.length());
            if (index_questionmark < 0) {
                return;
            }
            Hashtable<String, String> ht_values = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(ref.substring(index_questionmark + 1), "&");
            while (st.hasMoreTokens()) {
                String key_value = st.nextToken();
                int index_equal = key_value.indexOf(61);
                String value = key_value.substring(index_equal + 1);
                String key = key_value.substring(0, index_equal);
                ht_values.put(key, value);
            }
            String language_string = (String)ht_values.get("lr");
            if (language_string == null) {
                language_string = (String)ht_values.get("hl");
            }
            if (language_string != null) {
                if (language_string.startsWith("lang_")) {
                    language_string = language_string.substring("lang_".length());
                }
                if (language_string.length() > 2) {
                    language_string = language_string.substring(0, 2);
                }
                if (language_string.length() > 0) {
                    visit.addLanguage(language_string, 1.0f);
                }
            }
            String keywords = (String)ht_values.get("q");
            String start = (String)ht_values.get("start");
            if (start == null) {
                start = "0";
            }
            if (start != null && keywords != null && keywords.indexOf("restaurant") >= 0) {
                this.keyphrase_ranking.addVisit(lf.getDate().getTimeInMillis(), Integer.parseInt(start));
            }
        }
    }

    public boolean isAHit(LogFormat lf) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognize language in Google referers)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

