/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogPsychoAnalystTracker
implements GeneralPlugin {
    private static String logpsychanalyst_info_script_filename;
    private static Pattern language_pattern;
    private Vector pages_with_tracker = new Vector();

    static {
        PluginManager.registerPlugin(new LogPsychoAnalystTracker());
        logpsychanalyst_info_script_filename = "logpsychoanalyst_tracker.js";
        language_pattern = Pattern.compile("(.*?);q=([\\d\\.]+),?");
    }

    public Object getValue(String key) {
        if (key.equals("pages_with_tracker")) {
            return this.pages_with_tracker;
        }
        return null;
    }

    private void addPageWithTracker(String page_url) {
        if (!this.pages_with_tracker.contains(page_url)) {
            this.pages_with_tracker.add(page_url);
        }
    }

    public void processRecord(LogFormat lf, Visit visit, HTTPStatistics stats) {
        String page = lf.getURL();
        int index_script = page.indexOf(logpsychanalyst_info_script_filename);
        if (index_script != -1 && page.length() > index_script + logpsychanalyst_info_script_filename.length()) {
            String plugin;
            String language_string;
            String ref_page = lf.getReferer();
            int index_last_slash = ref_page.lastIndexOf(47);
            if (index_last_slash > "http://".length()) {
                String ref_page_file = ref_page.substring(index_last_slash + 1);
                if (ref_page_file.length() == 0) {
                    this.addPageWithTracker("/");
                } else if (lf.getDataSource().isDefaultPage(ref_page_file)) {
                    String directory = String.valueOf(ref_page.substring(ref_page.indexOf(47, "http://".length()), index_last_slash)) + "/";
                    this.addPageWithTracker(directory);
                } else {
                    String directory_and_file = ref_page.substring(ref_page.indexOf(47, "http://".length()));
                    this.addPageWithTracker(directory_and_file);
                }
            } else if (index_last_slash >= 0) {
                this.addPageWithTracker("/");
            }
            Hashtable<String, String> ht_values = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(page.substring(index_script + logpsychanalyst_info_script_filename.length() + 1), "&");
            while (st.hasMoreTokens()) {
                String key_value = st.nextToken();
                int index_equal = key_value.indexOf(61);
                String value = key_value.substring(index_equal + 1);
                String key = key_value.substring(0, index_equal);
                ht_values.put(key, value);
            }
            visit.setVisitorID((String)ht_values.get("uid"));
            String javascript = (String)ht_values.get("javascript");
            if (javascript != null) {
                visit.addInstalledPlugin("<img src=images/mimetypes/script.png> Javascript", !javascript.equals("no"));
            }
            if ((language_string = (String)ht_values.get("lang")) != null) {
                Matcher m = language_pattern.matcher(language_string);
                while (m.find()) {
                    try {
                        String[] languages = m.group(1).split("'");
                        float language_preference = Float.parseFloat(m.group(2));
                        int i = 0;
                        while (i < languages.length) {
                            visit.addLanguage(languages[i], language_preference);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                language_string = (String)ht_values.get("bl");
                if (language_string != null) {
                    if (language_string.equals("-")) {
                        System.out.println("Warning (LogPsychoAnalystTracker.java): unable to detect the language for browser \"" + lf.getUserAgent() + "\"  URL=" + lf.getURL());
                        language_string = null;
                    } else {
                        if (language_string.length() > 2) {
                            language_string = language_string.substring(0, 2);
                        }
                        visit.addLanguage(language_string, 1.0f);
                    }
                }
            }
            String screen_size = (String)ht_values.get("screen");
            int screen_width = -1;
            int screen_height = -1;
            try {
                if (screen_size != null) {
                    visit.addInstalledPlugin("<img src=images/mimetypes/script.png> Javascript", true);
                    int index_x = screen_size.indexOf(120);
                    screen_width = Integer.parseInt(screen_size.substring(0, index_x));
                    screen_height = Integer.parseInt(screen_size.substring(index_x + 1));
                    visit.setScreenSize(screen_width, screen_height);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ((plugin = (String)ht_values.get("jws")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/java.png> Java Web Start", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("svg")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/svg.png> SVG", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("pdf")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/adobe.png> AcrobatReader", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("java")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/java.png> Java", plugin.equals("true"));
            }
            if ((plugin = (String)ht_values.get("shk")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/shockwave.png> Shockwave", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("fla")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/flash.png> Flash", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("rp")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/realplayer.png> RealPlayer", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("wma")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/wmp.png> WMAPlayer", plugin.equals("y"));
            }
            if ((plugin = (String)ht_values.get("mov")) != null) {
                visit.addInstalledPlugin("<img src=images/useragent_icon/quicktime.png> Quicktime", plugin.equals("y"));
            }
            visit.setVisitID((String)ht_values.get("sid"));
            visit.setVisitorID((String)ht_values.get("uid"));
        } else if (page.endsWith("lpa/robotstxt_disallow_tracker.png")) {
            System.out.println("ALERT: hacking bot hit; " + lf.getLastEntry());
        } else if (page.endsWith("/logpsychoanalyst_print_tracker.png")) {
            String printed_page = lf.getReferer();
            if (printed_page.equals("-")) {
                printed_page = visit.getLastVisitedPage();
            }
            if (printed_page != null) {
                RecognizedURL recognized_url;
                if (printed_page.startsWith("http://")) {
                    int index_slash = printed_page.indexOf(47, "http://".length() + 1);
                    printed_page = index_slash < 0 ? "/" : printed_page.substring(index_slash);
                }
                if ((recognized_url = stats.statistic_bag.url_group_manager.getRecognizedURL2(printed_page)) != null) {
                    recognized_url.incPrints();
                }
            }
        }
    }

    public boolean isAHit(LogFormat lf) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognizes LPA javascript tracker)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

