/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.RestorangStatus;
import ch.kronospace.logpsychoanalyst.RestorangUpdater;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RestorangTracker
implements GeneralPlugin {
    private static String logpsychanalyst_info_script_filename;
    public Hashtable ht_stats = new Hashtable();
    public boolean used = false;
    private RestorangUpdater updater = new RestorangUpdater();

    static {
        PluginManager.registerPlugin(new RestorangTracker());
        logpsychanalyst_info_script_filename = "resto-rang.js";
    }

    public Object getValue(String key) {
        return null;
    }

    public void processRecord(LogFormat lf, Visit visit, HTTPStatistics stats) {
        String page = lf.getURL();
        int index_script = page.indexOf(logpsychanalyst_info_script_filename);
        if (index_script != -1 && page.length() > index_script + logpsychanalyst_info_script_filename.length()) {
            String value;
            this.used = true;
            Hashtable<String, String> ht_values = new Hashtable<String, String>();
            StringTokenizer st = new StringTokenizer(page.substring(index_script + logpsychanalyst_info_script_filename.length() + 1), "&");
            while (st.hasMoreTokens()) {
                String key_value = st.nextToken();
                int index_equal = key_value.indexOf(61);
                value = key_value.substring(index_equal + 1);
                String key = key_value.substring(0, index_equal);
                ht_values.put(key, value);
            }
            System.out.println(String.valueOf(LogFormat.df.format(lf.getDate().getTime())) + " " + ht_values);
            String key = (String)ht_values.get("rn");
            if (key != null) {
                DailyActivityStorage daily_stats = (DailyActivityStorage)this.ht_stats.get(key);
                if (daily_stats == null) {
                    daily_stats = new DailyActivityStorage();
                    daily_stats.setEmptyActivity(new RestorangStatus());
                    this.ht_stats.put(key, daily_stats);
                }
                if ((value = (String)ht_values.get("nv")) != null) {
                    this.updater.nbr_views = value.equals("-") ? 0 : Integer.parseInt(value);
                }
                if ((value = (String)ht_values.get("na")) != null) {
                    this.updater.nbr_app = Integer.parseInt(value);
                }
                if ((value = (String)ht_values.get("nc")) != null) {
                    this.updater.nbr_comments = Integer.parseInt(value);
                }
                if ((value = (String)ht_values.get("ag")) != null) {
                    this.updater.app_globale = Double.parseDouble(value);
                }
                if ((value = (String)ht_values.get("ak")) != null) {
                    this.updater.app_cuisine = Double.parseDouble(value);
                }
                if ((value = (String)ht_values.get("ac")) != null) {
                    this.updater.app_contexte = Double.parseDouble(value);
                }
                daily_stats.update(lf.getDate().getTimeInMillis(), this.updater);
            }
        }
    }

    public boolean isAHit(LogFormat lf) {
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognizes Resto-rang.ch status URL)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

