/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.advisor;

import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import ch.kronospace.logpsychoanalyst.StatisticBag;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.advisor.AdvisorPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsBuilder;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsHTMLReportBuilder;
import ch.kronospace.logpsychoanalyst.report.ReportBuilder;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AddTrackerAdvisor
implements AdvisorPlugin {
    private HTTPStatisticsBuilder stat_builder = null;
    private HTTPStatisticsHTMLReportBuilder report_builder = null;

    static {
        PluginManager.registerAdvisorPlugin(new AddTrackerAdvisor());
    }

    public void setStatisticsBuilder(StatisticsBuilder stat_builder) {
        if (stat_builder instanceof HTTPStatisticsBuilder) {
            this.stat_builder = (HTTPStatisticsBuilder)stat_builder;
        }
    }

    public void setReportBuilder(ReportBuilder report_builder) {
        if (report_builder instanceof HTTPStatisticsHTMLReportBuilder) {
            this.report_builder = (HTTPStatisticsHTMLReportBuilder)report_builder;
        }
    }

    public String getHTMLAdvice() {
        if (this.stat_builder == null) {
            return "";
        }
        ArrayList<String> pages_with_tracker = new ArrayList<String>();
        Enumeration e = this.stat_builder.plugins.elements();
        while (e.hasMoreElements()) {
            GeneralPlugin p = (GeneralPlugin)e.nextElement();
            Vector v = (Vector)p.getValue("pages_with_tracker");
            if (v == null) continue;
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                String page = (String)e2.nextElement();
                if (pages_with_tracker.contains(page)) continue;
                pages_with_tracker.add(page);
            }
        }
        Vector<String> not_html_page_extension = new Vector<String>();
        not_html_page_extension.add(".pdf");
        Hashtable<String, IntegerCounter> ht_hist_url_undetailed_visits = new Hashtable<String, IntegerCounter>();
        StatisticBag stats2 = (StatisticBag)this.stat_builder.stats.statistic_bags.get("human");
        if (stats2 == null) {
            return "";
        }
        int j = 0;
        while (j < stats2.closed_visits.size()) {
            Visit v = (Visit)stats2.closed_visits.get(j);
            if (v.getInstalledPlugins().size() == 0 && !v.containsAnyPages(pages_with_tracker)) {
                ArrayList pages = v.getVisitedPages();
                int i = 0;
                while (i < pages.size()) {
                    VisitedURL vurl = (VisitedURL)pages.get(i);
                    if (vurl.getURL() != null) {
                        String extension;
                        int last_dot;
                        String full_url = vurl.getURL().url;
                        String key = full_url;
                        int index_questionmark = key.indexOf(63);
                        if (index_questionmark >= 0) {
                            key = key.substring(0, index_questionmark);
                        }
                        if ((last_dot = key.lastIndexOf(46)) < 0 || !not_html_page_extension.contains(extension = key.substring(last_dot))) {
                            IntegerCounter count = (IntegerCounter)ht_hist_url_undetailed_visits.get(key);
                            if (count == null) {
                                count = new IntegerCounter();
                                count.object = key;
                                ht_hist_url_undetailed_visits.put(key, count);
                            }
                            count.inc();
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        double pages_per_visit = this.report_builder.getAveragePagesPerVisit();
        int nbr_pages_total = ht_hist_url_undetailed_visits.size() + pages_with_tracker.size();
        ArrayList undetailed_urls = new ArrayList(ht_hist_url_undetailed_visits.values());
        Collections.sort(undetailed_urls);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<a name=advice_unknown_plugin><table class=\"reporttable\">");
        buffer.append("<tr><td class=\"tabletitle\">&nbsp;<img src=images/advice.png> Reduce unknown plugins and screen resolution</td><td align=right><a href=help/advice_unknown_plugin.html><img border=0 src=images/help.png></a> </td></tr>");
        buffer.append("<tr><td colspan=3>");
        buffer.append("<p>You could lower your 'unknown' rate of screen size and plugins by adding the following HTML code:");
        buffer.append("<p><code>");
        buffer.append("  &lt;script language=javascript content=\"text/javascript\" src=\"/js/logpsychoanalyst_tracker.js\"&gt;&lt;/script&gt;<br>");
        buffer.append("  &lt;noscript&gt;<br>");
        buffer.append("    &lt;a href=/iamabot.html&gt;&lt;img src=\"/js/logpsychoanalyst_tracker.js?javascript=no\" height=1 width=1 border=0&gt;&lt;/a&gt;<br>");
        buffer.append("  &lt;/noscript&gt;<br>");
        buffer.append("</code>");
        buffer.append("<p>to the bottom of one (or more) of the following pages:\n");
        buffer.append("<p><table id=\"t_advice_unknown_browser_info\" class=\"sortable\" width=\"100%\">\n");
        buffer.append("<tr><th width=80%>Pages without tracker</th><th nowrap>Undetailed visits</th><th nowrap>Can be reduced up to</th></tr>");
        Iterator e2 = undetailed_urls.iterator();
        while (e2.hasNext()) {
            IntegerCounter count = (IntegerCounter)e2.next();
            String key = (String)count.object;
            RecognizedURL recognized_url = stats2.url_group_manager.getRecognizedURL2(key);
            long total_hits = Math.max(recognized_url.nbr_visits, Math.max(recognized_url.nbr_pages, recognized_url.nbr_hits));
            if (total_hits == 0L) continue;
            buffer.append("<tr><td>" + key + "</td><td>" + count.i + "</td><td>" + (long)(count.i * 100) / total_hits + "%</td></tr>\n");
        }
        buffer.append("</table>");
        buffer.append("<p>You currently have an average of " + pages_per_visit + " pages per visit. As you have " + nbr_pages_total + " pages on your site, it is recommended that " + Math.floor((double)nbr_pages_total / pages_per_visit * 10.0) / 10.0 + " pages include a tracker.<p>The pages with tracker are currently:");
        buffer.append("<p><table id=\"t_advice_unknown_browser_info2\" class=\"sortable\" width=\"100%\">\n");
        buffer.append("<tr><th width=80%>Page with tracker included</th></tr>");
        int i = 0;
        while (i < pages_with_tracker.size()) {
            buffer.append("<tr><td>" + pages_with_tracker.get(i).toString() + "</td></tr>");
            ++i;
        }
        buffer.append("</table>");
        return new String(buffer);
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

