/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.report;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.report.PhpBbUserRow;
import ch.kronospace.logpsychoanalyst.plugins.report.ReportPlugin;
import ch.kronospace.logpsychoanalyst.plugins.visit.FSpamlistEmail;
import ch.kronospace.logpsychoanalyst.plugins.visit.FSpamlistUtils;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbLpaDetector;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbPost;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbPosterDetectorElement;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbStatisticElement;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUser;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUtils;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsHTMLReportBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PhpBbLpaReport
implements ReportPlugin {
    HTTPStatisticsHTMLReportBuilder report_builder = null;

    static {
        PluginManager.registerReportPlugin(new PhpBbLpaReport());
    }

    public String getReport(HTTPStatisticsHTMLReportBuilder report_builder, String visitor_type) {
        if (visitor_type.equals("non-human")) {
            return "";
        }
        this.report_builder = report_builder;
        PhpBbLpaDetector cn_tracker = null;
        Enumeration e = PluginManager.getVisitPlugins().elements();
        while (e.hasMoreElements()) {
            Object plugin = e.nextElement();
            if (!(plugin instanceof PhpBbLpaDetector)) continue;
            cn_tracker = (PhpBbLpaDetector)plugin;
            break;
        }
        if (!cn_tracker.used) {
            return "";
        }
        String result = "";
        DailyActivityStorage das = cn_tracker.getDailyActivityStorage();
        String figure_title = "Deleted users and posts";
        String figure_xlabel = "Time";
        String figure_ylabel = "";
        String filename_deleted_users_img = "pbpbb_deleted_users.png";
        boolean normalized = false;
        int figure_width = 450;
        int figure_height = 150;
        StatisticElementArrayGetter[] getters = new StatisticElementArrayGetter[]{PhpBbStatisticElement.getter_deleted_posts, PhpBbStatisticElement.getter_deleted_users};
        List col = cn_tracker.getIntegerCounters();
        Collections.sort(col, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!o1.getClass().equals(o2.getClass())) {
                    return 0;
                }
                IntegerCounter c1 = (IntegerCounter)o1;
                PhpBbPosterDetectorElement e1 = (PhpBbPosterDetectorElement)c1.object;
                IntegerCounter c2 = (IntegerCounter)o2;
                PhpBbPosterDetectorElement e2 = (PhpBbPosterDetectorElement)c2.object;
                return (int)(e2.getLastVisitDate() / 1000L - e1.getLastVisitDate() / 1000L);
            }
        });
        String table_main = "<table class=sortable id=phpbb_ip_address_deleted_post_list>";
        table_main = String.valueOf(table_main) + "<tr>";
        table_main = String.valueOf(table_main) + "<th>Host</th>";
        table_main = String.valueOf(table_main) + "<th>UserAgent</th>";
        table_main = String.valueOf(table_main) + "<th>Last visit date</th>";
        table_main = String.valueOf(table_main) + "<th>Number of posts</th>";
        table_main = String.valueOf(table_main) + "</tr>";
        String filename_full_report_ip = "phpbb_ip_deleted_posts.html";
        String filename_ip_deleted_posts = "phpbb_ip_deleted_posts_list.html";
        int max_nbr_ip_address_summary = 10;
        String short_ip_table = "<p>Hosts for last " + max_nbr_ip_address_summary + " deleted posts &nbsp; &nbsp; &nbsp; <a href=" + filename_full_report_ip + "><img src=images/details.png border=0> Details</a><br>" + table_main;
        String table = "<p>Hosts for last deleted posts<br>" + table_main;
        String ip_list = "";
        int num_ip = 0;
        int nbr_posts_total = 0;
        int nbr_posts_total_summary = 0;
        String ip_list_separator = ", ";
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            IntegerCounter count2 = (IntegerCounter)iter.next();
            PhpBbPosterDetectorElement el = (PhpBbPosterDetectorElement)count2.object;
            String row = "";
            if (PhpBbUtils.ipWhiteList.get(el.getHost().getHostName()) == null) {
                row = "<tr><td><a href=\"http://www.whois.sc/" + el.getHost().getHostName() + "\">" + el.getHost().getHostName() + "</a></td>" + "<td>" + el.getUserAgent() + "</td>" + "<td>" + LogFormat.df.format(new Date(el.getLastVisitDate())) + "</td>" + "<td>" + count2.i + "</td></tr>\n";
                nbr_posts_total += count2.i;
                table = String.valueOf(table) + row;
                ip_list = String.valueOf(ip_list) + el.getHost().getHostName() + ip_list_separator;
                PhpBbUtils.reportSpamIpAddress(el.getHost().getHostName(), count2.i, new Date(el.getLastVisitDate()));
            }
            if (num_ip < max_nbr_ip_address_summary) {
                short_ip_table = String.valueOf(short_ip_table) + row;
                nbr_posts_total_summary += count2.i;
            }
            ++num_ip;
        }
        if (ip_list.length() > 0) {
            ip_list = ip_list.substring(0, ip_list.length() - ip_list_separator.length());
        }
        table = String.valueOf(table) + "</table><br>Total: " + col.size() + " hosts, " + nbr_posts_total + " deleted posts</p>";
        short_ip_table = String.valueOf(short_ip_table) + "</table><br>Other: " + Math.max(col.size() - max_nbr_ip_address_summary, 0) + " hosts, " + (nbr_posts_total - nbr_posts_total_summary) + " deleted posts<br>Total: " + col.size() + " hosts, " + nbr_posts_total + " deleted posts</p>";
        try {
            PrintWriter out_report2 = new PrintWriter(new FileWriter(String.valueOf(report_builder.report_directory) + filename_full_report_ip));
            out_report2.println(report_builder.getReportHeader());
            out_report2.println("<script type=\"text/javascript\" src=\"folding.js\"></script>");
            out_report2.println("<table class=\"reporttable\" width=100%>");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Hosts</td><td align=right><a href=help/plugin_phpbb_lpa.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println(table);
            out_report2.println("<p>You could add the following list to the PhpBB ban list: <a href=\"javascript:phpbbBanIp('" + ip_list + "');\" title=\"Ban IP addresses\">Ban IP list</a><br><span style='font-size:8pt'>" + ip_list + "</span>.<br>");
            out_report2.println("You can also add the following XML tag to your config.xml file: <br><span style='font-size:8pt'>&lt;HostUserAgentList ip=\"" + ip_list + "\"  name=\"phpBB hosts with deleted users\" familyID=\"spammers\"/&gt;</span>");
            out_report2.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            PrintWriter out_report3 = new PrintWriter(new FileWriter(String.valueOf(report_builder.report_directory) + filename_ip_deleted_posts));
            out_report3.println("<textarea cols=200 rows=50>&lt;HostUserAgentList ip=\"" + ip_list + "\"  name=\"phpBB hosts with deleted users\" familyID=\"spammers\"/&gt;</textarea>");
            out_report3.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String users_to_delete_table_header = "<p><script src=phpbblibjs.js></script><script>setPhpbbBaseUrl(\"" + PhpBbUtils.phpbb_url + "\"); setPhpbbSid(\"" + (PhpBbUtils.sid != null ? PhpBbUtils.sid : "") + "\");</script>" + "<br>PhpBb valid admin sid <input id=el_admin_sid_id value='" + (PhpBbUtils.sid != null ? PhpBbUtils.sid : "") + "' onchange=\"setPhpbbSid(this.value);\" size=40> <a href=\"" + PhpBbUtils.getLoginUrl() + "\" target=_blank>Login to PhpBB</a> <small>Note: after logged in, copy the SID from the request parameters to the input field on the left. Afterwards, you will be able to manage the users/posts.</small><br><br>";
        String users_to_delete_table_main = "<table class=\"sortable\" id=\"phpbb_deleted_user_table\">";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<tr>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Name</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Email</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Occupation</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Interests</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Posts</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Last post date</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "<th>Spammer probability</th>";
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "</tr>";
        Vector<PhpBbUserRow> users_rows = new Vector<PhpBbUserRow>();
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd.MM.yyyy hh:mm");
        HashMap<String, String> already_used_user_ids = new HashMap<String, String>();
        int nbr_existing_posts = 0;
        FSpamlistUtils.init(new Vector(), report_builder.host.getConfigDirectory());
        int i = 0;
        while (i < cn_tracker.visit_patterns.length) {
            if (cn_tracker.visit_patterns[i].getNbrUsers() > 0) {
                int spammer_probability = cn_tracker.visit_patterns[i].getNbrDeletedUsers() * 100 / cn_tracker.visit_patterns[i].getNbrUsers();
                Iterator iter2 = cn_tracker.visit_patterns[i].getExistingUsers().iterator();
                while (iter2.hasNext()) {
                    String user_id = (String)iter2.next();
                    PhpBbUser user = PhpBbUtils.getUser(user_id, null);
                    if (user == null) {
                        user = new PhpBbUser();
                    }
                    if (!user.isExisting() || already_used_user_ids.get(user_id) != null) continue;
                    already_used_user_ids.put(user_id, user_id);
                    List post_list = PhpBbUtils.getUserPosts(user.getName());
                    long last_post_date = post_list.size() > 0 ? ((PhpBbPost)post_list.get(0)).getPostDate() : 0L;
                    FSpamlistEmail fsl_email = FSpamlistUtils.getEmail(user.getEmail());
                    String fsl_rate = "";
                    if (fsl_email.getRate() > 0) {
                        fsl_rate = ", <a href=http://www.fspamlist.com/view.php?s=" + fsl_email.getId() + ">FSL:<img border=0 src=images/fsl_" + fsl_email.getRate() + ".png></a>";
                    }
                    String html_row = "<tr>";
                    html_row = String.valueOf(html_row) + "<td><a href=\"" + PhpBbUtils.phpbb_url + "profile.php?mode=viewprofile&u=" + user_id + "\">" + user.getName() + "</a> <a href=\"" + PhpBbUtils.getDeleteUserUrl(user_id) + "\" title=\"Delete the user\"><img src=\"images/delete.png\" border=0></a></td>";
                    html_row = String.valueOf(html_row) + "<td>" + user.getEmail() + " <a href=\"http://www.google.com/search?q=" + user.getEmail().replaceAll("^.+@([^@]+)$", "$1") + "\" title=\"Google the domain\" target=\"_blank\">GG</a> <a href=\"javascript:phpbbBanEmail('" + user.getEmail() + "')\" title=\"Ban the user email\">BE</a> <a href=\"javascript:phpbbBanEmail('" + user.getEmail().replaceAll("^.+@([^@]+)$", "*@$1") + "');\" title=\"Ban the user domain\">BD</a></td>";
                    html_row = String.valueOf(html_row) + "<td>" + user.getOccupation() + "</td>";
                    html_row = String.valueOf(html_row) + "<td>" + user.getInterests() + "</td>";
                    html_row = String.valueOf(html_row) + "<td>" + user.getNbrPosts() + (user.getNbrPosts() > 0 ? " <a href=\"javascript:phpbbUserPosts('" + user.getName() + "');\" title=\"Display the user posts\"><img src=\"images/details.png\" border=0></a>" : "") + (user.getNbrPosts() > 0 ? " <a href=\"javascript:phpbbDeletePostList(" + post_list.toString() + ")\" title=\"Delete all posts\"><img src=\"images/delete.png\" border=0></a>" : "") + "</td>";
                    html_row = String.valueOf(html_row) + "<td>" + (post_list.size() > 0 ? sdf2.format(new Date(last_post_date)) : "-") + "</td>";
                    html_row = String.valueOf(html_row) + "<td>" + spammer_probability + "% (" + cn_tracker.visit_patterns[i].getClass().getSimpleName().replace("PhpBbVisitPattern", "").replaceAll("([a-z])([A-Z])", "$1 -> $2") + ")" + fsl_rate + "</td>";
                    html_row = String.valueOf(html_row) + "</tr>";
                    PhpBbUserRow row = new PhpBbUserRow();
                    row.setHtmlRowInnerHtml(html_row);
                    row.setLastPostDate(last_post_date);
                    row.setSpamProbability(spammer_probability);
                    row.setNbrPosts(user.getNbrPosts());
                    users_rows.add(row);
                    nbr_existing_posts += user.getNbrPosts();
                }
            }
            ++i;
        }
        FSpamlistUtils.writePhpBbExistingUsersCache();
        Collections.sort(users_rows, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!o1.getClass().equals(o2.getClass())) {
                    return 0;
                }
                PhpBbUserRow u1 = (PhpBbUserRow)o1;
                PhpBbUserRow u2 = (PhpBbUserRow)o2;
                int last_post_cmp = (int)(u2.getLastPostDate() / 1000L - u1.getLastPostDate() / 1000L);
                return last_post_cmp != 0 ? last_post_cmp : u2.getSpamProbability() - u1.getSpamProbability();
            }
        });
        String filename_full_registered_users = "phpbb_registered_users.html";
        String users_to_delete_table_main_short = users_to_delete_table_main;
        int num_user = 0;
        int max_nbr_registered_users_summary = 10;
        int nbr_existing_posts_summary = 0;
        Enumeration e2 = users_rows.elements();
        while (e2.hasMoreElements()) {
            PhpBbUserRow u = (PhpBbUserRow)e2.nextElement();
            users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + u.getHtmlRowInnerHtml() + "\n";
            if (num_user < max_nbr_registered_users_summary) {
                users_to_delete_table_main_short = String.valueOf(users_to_delete_table_main_short) + u.getHtmlRowInnerHtml() + "\n";
                nbr_existing_posts_summary += u.getNbrPosts();
            }
            ++num_user;
        }
        users_to_delete_table_main = String.valueOf(users_to_delete_table_main) + "</table>";
        users_to_delete_table_main_short = String.valueOf(users_to_delete_table_main_short) + "</table>";
        String users_to_delete_table = String.valueOf(users_to_delete_table_header) + users_to_delete_table_main + "<br>Total: " + users_rows.size() + " users, " + nbr_existing_posts + " posts</p>";
        String users_to_delete_table_short = String.valueOf(users_to_delete_table_header) + "Activated users (last " + max_nbr_registered_users_summary + " posting users): &nbsp; &nbsp; &nbsp;     <a href=\"" + filename_full_registered_users + "\"><img src=images/details.png border=0> Details</a><br>" + users_to_delete_table_main_short + "<br>Other: " + Math.max(users_rows.size() - max_nbr_registered_users_summary, 0) + " users, " + (nbr_existing_posts - nbr_existing_posts_summary) + " posts<br>Total: " + users_rows.size() + " users, " + nbr_existing_posts + " posts</p><p>Note: some information may be outdated because if the cache use.</p>";
        try {
            PrintWriter out_report4 = new PrintWriter(new FileWriter(String.valueOf(report_builder.report_directory) + filename_full_registered_users));
            out_report4.println(report_builder.getReportHeader());
            out_report4.println("<script type=\"text/javascript\" src=\"folding.js\"></script>");
            out_report4.println("<table class=\"reporttable\" width=100%>");
            out_report4.println("<tr><td class=\"tabletitle\">&nbsp;Activated users</td><td align=right><a href=help/plugin_phpbb_lpa.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report4.println("<tr><td colspan=3>");
            out_report4.println(users_to_delete_table);
            out_report4.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        report_builder.writeGraphic(report_builder.timestamps_days, das, String.valueOf(report_builder.report_directory) + filename_deleted_users_img, normalized, getters, figure_title, figure_xlabel, figure_ylabel, figure_width, figure_height, 7);
        PhpBbUtils.writePhpBbExistingUsersCache();
        PhpBbUtils.writePhpBbExistingPostsCache();
        PhpBbUtils.writePhpBbUtilsParams();
        result = String.valueOf(result) + "<p><table class=\"reporttable\"><tr><td class=\"tabletitle\">&nbsp;PhpBB Forum statistics</td><td align=right><a href=help/plugin_phpbb_lpa.html><img border=0 src=images/help.png></a></td></tr><tr><td colspan=2><img src=\"" + filename_deleted_users_img + "\">" + users_to_delete_table_short + "<br>" + short_ip_table + "<p>You could add the following list to the PhpBB ban list: <a href=\"javascript:phpbbBanIp('" + ip_list + "');\" title=\"Ban IP addresses\">Ban IP list</a><br><br>" + "You can also include the following XML file to your config.xml file: <a href=\"" + filename_ip_deleted_posts + "\">" + filename_ip_deleted_posts + "</a></p>" + "</td></tr></table></p>";
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (build PhpBb-LPA reports)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

