/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.report;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.RestorangStatus;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.RestorangTracker;
import ch.kronospace.logpsychoanalyst.plugins.report.ReportPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsHTMLReportBuilder;
import java.util.Enumeration;

public class RestorangReport
implements ReportPlugin {
    public static final StatisticElementArrayGetter getter_nbr_views;
    public static final StatisticElementArrayGetter getter_nbr_app;
    public static final StatisticElementArrayGetter getter_nbr_comments;
    public static final StatisticElementArrayGetter getter_app_globale;
    public static final StatisticElementArrayGetter getter_app_cuisine;
    public static final StatisticElementArrayGetter getter_app_contexte;
    HTTPStatisticsHTMLReportBuilder report_builder = null;

    static {
        PluginManager.registerReportPlugin(new RestorangReport());
        getter_nbr_views = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Nombre de vues/jour";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                double nbr_views_this_month_yesterday = Double.MIN_VALUE;
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    double nbr_views_this_month = el.nbr_views;
                    if (nbr_views_this_month == 0.0) {
                        int next_non_zero_index = i + 1;
                        boolean found_non_zero = false;
                        double next_non_zero_views = 0.0;
                        next_non_zero_index = i + 1;
                        while (next_non_zero_index < elements.length) {
                            next_non_zero_views = ((RestorangStatus)elements[next_non_zero_index]).nbr_views;
                            if (next_non_zero_views != 0.0) {
                                found_non_zero = true;
                                break;
                            }
                            ++next_non_zero_index;
                        }
                        if (found_non_zero) {
                            double mean_value = next_non_zero_views / (double)(next_non_zero_index - i + 1);
                            System.out.println("spreading value: " + mean_value);
                            nbr_views_this_month = (long)mean_value;
                            int j = i;
                            while (j <= next_non_zero_index) {
                                ((RestorangStatus)elements[j]).nbr_views = (long)(mean_value * (double)(j - i + 1));
                                ++j;
                            }
                        }
                    }
                    double nbr_views_this_day = nbr_views_this_month_yesterday < 0.0 || nbr_views_this_month < 0.0 ? 0.0 : (nbr_views_this_month < nbr_views_this_month_yesterday ? nbr_views_this_month : nbr_views_this_month - nbr_views_this_month_yesterday);
                    values[i] = nbr_views_this_day;
                    System.out.println(String.valueOf(nbr_views_this_month) + " " + nbr_views_this_month_yesterday + " " + nbr_views_this_day);
                    nbr_views_this_month_yesterday = nbr_views_this_month;
                    ++i;
                }
                return values;
            }
        };
        getter_nbr_app = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Nombre de votes";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                long nbr_app_yesterday = -1L;
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    if (el.nbr_app < 0L && nbr_app_yesterday > 0L) {
                        el.nbr_app = nbr_app_yesterday;
                    }
                    values[i] = el.nbr_app;
                    nbr_app_yesterday = el.nbr_app;
                    ++i;
                }
                return values;
            }
        };
        getter_nbr_comments = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Nombre de commentaires";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    values[i] = el.nbr_comments;
                    ++i;
                }
                return values;
            }
        };
        getter_app_globale = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Note globale";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    values[i] = el.app_globale;
                    ++i;
                }
                return values;
            }
        };
        getter_app_cuisine = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Note cuisine";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    values[i] = el.app_cuisine;
                    ++i;
                }
                return values;
            }
        };
        getter_app_contexte = new StatisticElementArrayGetter(){

            public String getValueName() {
                return "Note contexte";
            }

            public double[] getValues(DailyActivityStorage das, long first_date, long last_date) {
                StatisticElement[] elements = das.getRange(first_date, last_date);
                double[] values = new double[elements.length];
                int i = 0;
                while (i < elements.length) {
                    RestorangStatus el = (RestorangStatus)elements[i];
                    values[i] = el.app_contexte;
                    ++i;
                }
                return values;
            }
        };
    }

    public String getReport(HTTPStatisticsHTMLReportBuilder report_builder, String visitor_type) {
        if (visitor_type.equals("non-human")) {
            return "";
        }
        this.report_builder = report_builder;
        RestorangTracker cn_tracker = null;
        Enumeration e = report_builder.stat_builder.plugins.elements();
        while (e.hasMoreElements()) {
            Object plugin = e.nextElement();
            if (!(plugin instanceof RestorangTracker)) continue;
            cn_tracker = (RestorangTracker)plugin;
            break;
        }
        if (!cn_tracker.used) {
            return "";
        }
        String result = "";
        Enumeration keys = cn_tracker.ht_stats.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            DailyActivityStorage das = (DailyActivityStorage)cn_tracker.ht_stats.get(key);
            String figure_title = "Nombre de vues/commentaires/votes";
            String figure_xlabel = "Time";
            String figure_ylabel = "";
            String filename = "resto-rang." + key + ".nbr.png";
            boolean normalized = false;
            int figure_width = 450;
            int figure_height = 150;
            StatisticElementArrayGetter[] getters = new StatisticElementArrayGetter[]{getter_nbr_views, getter_nbr_app, getter_nbr_comments};
            report_builder.writeGraphic(report_builder.timestamps_days, das, String.valueOf(report_builder.report_directory) + filename, normalized, getters, figure_title, figure_xlabel, figure_ylabel, figure_width, figure_height, 14);
            String figure_title2 = "Votes";
            String figure_xlabel2 = figure_xlabel;
            String figure_ylabel2 = figure_ylabel;
            String filename2 = "resto-rang." + key + ".app.png";
            boolean normalized2 = false;
            int figure_width2 = figure_width;
            int figure_height2 = figure_height;
            StatisticElementArrayGetter[] getters2 = new StatisticElementArrayGetter[]{getter_app_globale, getter_app_cuisine, getter_app_contexte};
            report_builder.writeGraphic(report_builder.timestamps_days, das, String.valueOf(report_builder.report_directory) + filename2, normalized2, getters2, figure_title2, figure_xlabel2, figure_ylabel2, figure_width2, figure_height2, 3);
            result = String.valueOf(result) + "<p><table class=\"reporttable\"><tr><td class=\"tabletitle\">&nbsp;Resto-rang.ch (" + key + ")</td><td align=right><a href=help/restorang.html><img border=0 src=images/help.png></a></td></tr>" + "<tr><td colspan=2 nowrap>" + "<img src=\"" + filename + "\">" + "<img src=\"" + filename2 + "\">" + "</td></tr></table>";
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (build Resto-rang.ch report)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

