/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.PluginProperties;
import ch.kronospace.logpsychoanalyst.Property;
import ch.kronospace.logpsychoanalyst.plugins.visit.FSpamlistEmail;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FSpamlistUtils {
    private static Hashtable ht_fspamlist_emails = null;
    private static File FILENAME_FSPAMLIST_EMAIL_SER = null;
    private static long EXISTING_EMAIL_TIMEOUT = 604800000L;
    private static long DELAI_BETWEEN_REQUESTS = 300L;
    static long last_call_date = 0L;
    public static boolean debug = true;

    public static void init(PluginProperties pp, File config_directory) {
        FSpamlistUtils.init(pp.getProperty(), config_directory);
    }

    public static void init(Vector pp, File config_directory) {
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration e2 = pp.elements();
        while (e2.hasMoreElements()) {
            Property p = (Property)e2.nextElement();
            m.put(p.getName(), p.getValue());
        }
        try {
            EXISTING_EMAIL_TIMEOUT = Long.parseLong((String)m.get("emailTimeout"));
        }
        catch (Exception e) {
            System.out.println("WARNING: could not parse 'emailTimeout'. Defaulted to " + EXISTING_EMAIL_TIMEOUT);
        }
        if (config_directory == null) {
            config_directory = new File("./");
        }
        FILENAME_FSPAMLIST_EMAIL_SER = new File(config_directory, "fspamlist_email.ser");
        ht_fspamlist_emails = null;
    }

    public static void waitIfRequired() {
        long wait_time = last_call_date + DELAI_BETWEEN_REQUESTS - System.currentTimeMillis();
        if (wait_time > 0L) {
            try {
                Thread.sleep(wait_time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        last_call_date = System.currentTimeMillis();
    }

    public static FSpamlistEmail getEmailFromCache(String emailAddress) {
        if (ht_fspamlist_emails == null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FILENAME_FSPAMLIST_EMAIL_SER));
                ht_fspamlist_emails = (Hashtable)ois.readObject();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (ht_fspamlist_emails == null) {
                ht_fspamlist_emails = new Hashtable();
            }
        }
        return (FSpamlistEmail)ht_fspamlist_emails.get(emailAddress);
    }

    public static void writePhpBbExistingUsersCache() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(FILENAME_FSPAMLIST_EMAIL_SER));
            oos.writeObject(ht_fspamlist_emails);
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FSpamlistEmail getEmail(String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        FSpamlistEmail email = FSpamlistUtils.getEmailFromCache(emailAddress);
        if (email == null || System.currentTimeMillis() > email.getLastUpdate() + EXISTING_EMAIL_TIMEOUT) {
            try {
                String data_in = "";
                data_in = String.valueOf(data_in) + URLEncoder.encode("user", "UTF-8") + "=" + URLEncoder.encode(emailAddress, "UTF-8") + "&";
                data_in = String.valueOf(data_in) + URLEncoder.encode("type", "UTF-8") + "=" + URLEncoder.encode("Email", "UTF-8") + "&";
                FSpamlistUtils.waitIfRequired();
                URL url = new URL("http://www.fspamlist.com/search.php");
                if (debug) {
                    System.out.println("fspamlistUtils.getEmail: " + url.toString());
                }
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data_in);
                wr.flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String data = "";
                String ligne = in.readLine();
                while (ligne != null) {
                    data = String.valueOf(data) + ligne + "\n";
                    ligne = in.readLine();
                }
                Pattern pat_view = Pattern.compile("<a href=\"view.php\\?s=(\\d+)");
                String email_id = "";
                Matcher matcher_email_id = pat_view.matcher(data);
                if (matcher_email_id.find()) {
                    email_id = matcher_email_id.group(1);
                }
                Pattern pat_level = Pattern.compile("Threat Level: <u><font color=\".+?\">([a-zA-Z]+)");
                int rate = 0;
                Matcher matcher_level = pat_level.matcher(data);
                if (matcher_level.find()) {
                    String level = matcher_level.group(1);
                    if (level.equals("LOW")) {
                        rate = 1;
                    } else if (level.equals("MED")) {
                        rate = 2;
                    } else if (level.equals("HI")) {
                        rate = 3;
                    } else {
                        System.out.println("FspamlistUtils.getEmail: unknown level: " + level);
                    }
                }
                boolean store_email = false;
                if (email == null) {
                    email = new FSpamlistEmail();
                    store_email = true;
                }
                email.setEmail(emailAddress);
                email.setLastUpdate(System.currentTimeMillis());
                email.setId(email_id);
                email.setRate(rate);
                if (store_email) {
                    ht_fspamlist_emails.put(emailAddress, email);
                }
                return email;
            }
            catch (UnknownHostException e) {
                System.out.println("WARNING: could not get email info for emailAddress=" + emailAddress + ". Cause: " + e.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        return email;
    }
}

