/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitIncrementer;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbPosterDetectorElement;
import ch.kronospace.logpsychoanalyst.plugins.visit.VisitPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class PhpBbEmailCollectorDetector
implements VisitPlugin,
DailyActivityStorageOwner {
    int nbr_email_collector_found = 0;
    public boolean used = true;
    private boolean debug = false;
    Pattern[] patterns = new Pattern[]{Pattern.compile("profile\\.php.*mode=register"), Pattern.compile("profile\\.php.*mode=confirm"), Pattern.compile("profile\\.php.*sid="), Pattern.compile("memberlist\\.php")};
    Hashtable ht_hosts = new Hashtable();
    private Vector detectedVisits = new Vector();
    private DailyActivityStorage daily_histogram = new DailyActivityStorage();
    VisitIncrementer visit_incrementer = new VisitIncrementer();
    private List c = new ArrayList();

    static {
        PluginManager.registerVisitPlugin(new PhpBbEmailCollectorDetector());
    }

    public Object getValue(String key) {
        return null;
    }

    public void processVisit(Visit v, HTTPStatistics stats) {
        if (v.getLastVisitedPage() != null) {
            int pat_start_index = 0;
            Iterator iter = v.getVisitedPages().iterator();
            while (iter.hasNext()) {
                String url;
                VisitedURL vurl = (VisitedURL)iter.next();
                String string = url = vurl.getURL() != null ? vurl.getURL().url : "";
                if (pat_start_index >= this.patterns.length || !this.patterns[pat_start_index].matcher(url).find()) continue;
                ++pat_start_index;
            }
            if (pat_start_index == this.patterns.length) {
                IntegerCounter count;
                ++this.nbr_email_collector_found;
                if (this.debug) {
                    System.out.println("----------------PhpBbEmailCollectorDetector (" + this.nbr_email_collector_found + ")-----------------");
                }
                if ((count = (IntegerCounter)this.ht_hosts.get(v.host.getHostName())) == null) {
                    count = new IntegerCounter();
                    PhpBbPosterDetectorElement el = new PhpBbPosterDetectorElement();
                    el.setHost(v.host);
                    el.setLastVisitDate(v.getLastVisitedPageDate());
                    el.setUserAgent(v.getUserAgent());
                    count.object = el;
                    this.ht_hosts.put(v.host.getHostName(), count);
                }
                count.inc();
                if (this.debug) {
                    System.out.println(this.ht_hosts);
                }
                this.c = new ArrayList(this.ht_hosts.values());
                Collections.sort(this.c);
                if (this.debug) {
                    System.out.println("  USERAGENT:" + v.getUserAgent());
                }
                if (this.debug) {
                    System.out.println("  HOST:" + v.host.getHostName());
                }
                Iterator iter2 = v.getVisitedPages().iterator();
                while (iter2.hasNext()) {
                    VisitedURL vurl = (VisitedURL)iter2.next();
                    if (!this.debug) continue;
                    System.out.println("  " + vurl.toString());
                }
                this.detectedVisits.add(v);
                this.daily_histogram.update(v.getFirstHitDate(), this.visit_incrementer);
            }
        }
    }

    public List getIntegerCounters() {
        return this.c;
    }

    public Vector getDetectedVisits() {
        return this.detectedVisits;
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_histogram;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognizes PhpBB email collector patterns, LPA)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        return null;
    }
}

