/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.Property;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.visit.IpSpamReportingLpa;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class PhpBbLpaDectorConfigurator
implements PluginConfigurator {
    JTextField tf_forumUrl = new JTextField();
    JTextField tf_adminUsername = new JTextField();
    JPasswordField tf_adminPassword = new JPasswordField();
    JTextField tf_spamReportId = new JTextField();
    JPasswordField tf_spamReportPassword = new JPasswordField();
    JButton bt_create_new_spam_target = new JButton("Create a new spam target...");
    JTextField tf_ipWhiteList = new JTextField();
    SpinnerNumberModel spm_userTimeout = new SpinnerNumberModel(2, 0, 180, 1);
    SpinnerNumberModel spm_postTimeout = new SpinnerNumberModel(2, 0, 180, 1);
    JSpinner sp_userTimeout = new JSpinner(this.spm_userTimeout);
    JSpinner sp_postTimeout = new JSpinner(this.spm_postTimeout);

    public JPanel getPanel(final JFrame parent_frame) {
        JButton bt_verify = new JButton("Verify data");
        bt_verify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PhpBbUtils.init(PhpBbLpaDectorConfigurator.this.getProperties(), null);
                if (PhpBbUtils.sid == null) {
                    JOptionPane.showMessageDialog(null, "Could not connect to PhpBB using data:\n  forumUrl=" + PhpBbLpaDectorConfigurator.this.tf_forumUrl.getText() + "\n  adminUsername=" + PhpBbLpaDectorConfigurator.this.tf_adminUsername.getText() + "\n  adminPassword=" + String.valueOf(PhpBbLpaDectorConfigurator.this.tf_adminPassword.getPassword()));
                } else {
                    JOptionPane.showMessageDialog(null, "PhpBB login ok");
                }
            }
        });
        JPanel p1 = new JPanel(new GridLayout(4, 2));
        p1.setBorder(new TitledBorder("PhpBB"));
        p1.add(new JLabel("Forum URL"));
        p1.add(this.tf_forumUrl);
        p1.add(new JLabel("PhpBB forum admin username"));
        p1.add(this.tf_adminUsername);
        p1.add(new JLabel("PhpBB forum admin password"));
        p1.add(this.tf_adminPassword);
        p1.add(new JLabel(" "));
        p1.add(bt_verify);
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.setBorder(new TitledBorder("Spam reporting"));
        p2.add(new JLabel(" "));
        p2.add(this.bt_create_new_spam_target);
        p2.add(new JLabel("Spam report id"));
        p2.add(this.tf_spamReportId);
        p2.add(new JLabel("Spam report password"));
        p2.add(this.tf_spamReportPassword);
        this.bt_create_new_spam_target.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String turl = JOptionPane.showInputDialog("Please enter the target URL (e.g. http://www.my-domain-name.com/forum )");
                if (turl == null) {
                    return;
                }
                String tpwd1 = null;
                String tpwd2 = null;
                do {
                    tpwd1 = JOptionPane.showInputDialog("Please enter the target password (e.g. mypassword ); will be asked two times");
                    tpwd2 = JOptionPane.showInputDialog("Please enter the target password again (to avoid typo errors)");
                } while (tpwd1 == null || !tpwd1.equals(tpwd2));
                if (tpwd1 == null) {
                    return;
                }
                String temail = JOptionPane.showInputDialog("Please enter the target administrator email (e.g. me@my-domain-name.com )");
                if (temail == null) {
                    return;
                }
                String tid = IpSpamReportingLpa.createTarget(turl, tpwd1, temail);
                if (tid != null) {
                    if (tid.length() > 20) {
                        JOptionPane.showMessageDialog(parent_frame, "Error while creating a new spam IP target. Message is:\n\n" + tid, "New spam IP target creation failed", 0);
                    } else {
                        PhpBbLpaDectorConfigurator.this.tf_spamReportId.setText(tid);
                        PhpBbLpaDectorConfigurator.this.tf_spamReportPassword.setText(tpwd1);
                    }
                }
            }
        });
        JPanel p3 = new JPanel(new GridLayout(3, 2));
        p3.setBorder(new TitledBorder("Misc"));
        p3.add(new JLabel("IP white list (separated by ',')"));
        p3.add(this.tf_ipWhiteList);
        p3.add(new JLabel("User profile timeout [days]"));
        p3.add(this.sp_userTimeout);
        p3.add(new JLabel("Post data timeout [days]"));
        p3.add(this.sp_postTimeout);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(p1);
        p.add(p2);
        p.add(p3);
        return p;
    }

    public Vector getProperties() {
        Vector<Property> v = new Vector<Property>();
        v.add(new Property("forumUrl", this.tf_forumUrl.getText()));
        v.add(new Property("adminUsername", this.tf_adminUsername.getText()));
        v.add(new Property("adminPassword", String.valueOf(this.tf_adminPassword.getPassword())));
        v.add(new Property("spamReportId", this.tf_spamReportId.getText()));
        v.add(new Property("spamReportPassword", String.valueOf(this.tf_spamReportPassword.getPassword())));
        v.add(new Property("ipWhiteList", this.tf_ipWhiteList.getText()));
        v.add(new Property("userTimeout", String.valueOf(this.spm_userTimeout.getNumber().longValue() * 24L * 60L * 60L * 1000L)));
        v.add(new Property("postTimeout", String.valueOf(this.spm_postTimeout.getNumber().longValue() * 24L * 60L * 60L * 1000L)));
        return v;
    }

    public void setProperties(Vector properties) {
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration e = properties.elements();
        while (e.hasMoreElements()) {
            Property p = (Property)e.nextElement();
            m.put(p.getName(), p.getValue());
        }
        this.tf_forumUrl.setText((String)m.get("forumUrl"));
        this.tf_adminUsername.setText((String)m.get("adminUsername"));
        this.tf_adminPassword.setText((String)m.get("adminPassword"));
        this.tf_spamReportId.setText((String)m.get("spamReportId"));
        this.tf_spamReportPassword.setText((String)m.get("spamReportPassword"));
        this.tf_ipWhiteList.setText((String)m.get("ipWhiteList"));
        try {
            this.spm_userTimeout.setValue(new Integer((int)(Long.parseLong((String)m.get("userTimeout")) / 24L / 60L / 60L / 1000L)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.spm_postTimeout.setValue(new Integer((int)(Long.parseLong((String)m.get("postTimeout")) / 24L / 60L / 60L / 1000L)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

