/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementUpdater;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import ch.kronospace.logpsychoanalyst.plugins.PluginConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbLpaDectorConfigurator;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbPosterDetectorElement;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbStatisticElement;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUser;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUtils;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPattern;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPatternActivate;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPatternActivateNewtopic;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPatternRegisterActivate;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPatternRegisterActivateNewtopic;
import ch.kronospace.logpsychoanalyst.plugins.visit.VisitPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhpBbLpaDetector
implements VisitPlugin,
DailyActivityStorageOwner {
    int nbr_email_collector_found = 0;
    public boolean used = true;
    public PhpBbVisitPattern[] visit_patterns = new PhpBbVisitPattern[]{new PhpBbVisitPatternRegisterActivateNewtopic(), new PhpBbVisitPatternRegisterActivate(), new PhpBbVisitPatternActivateNewtopic(), new PhpBbVisitPatternActivate()};
    Hashtable ht_hosts = new Hashtable();
    private Vector detectedVisits = new Vector();
    private DailyActivityStorage daily_histogram = new DailyActivityStorage();
    PhpBbIncrementer visit_incrementer;
    private List c;
    private boolean debug;
    private Pattern pat_viewtopic;
    private Hashtable ht_deleted_post_found;

    static {
        PluginManager.registerVisitPlugin(new PhpBbLpaDetector());
    }

    public PhpBbLpaDetector() {
        this.daily_histogram.setEmptyActivity(new PhpBbStatisticElement());
        this.visit_incrementer = new PhpBbIncrementer();
        this.c = new ArrayList();
        this.debug = false;
        this.pat_viewtopic = Pattern.compile("/viewtopic\\.php\\?p=(\\d+)");
        this.ht_deleted_post_found = new Hashtable();
    }

    public Object getValue(String key) {
        return null;
    }

    public void processVisit(Visit v, HTTPStatistics stats) {
        if (PhpBbUtils.phpbb_url == null) {
            PhpBbUtils.init(HTTPStatistics.host.getPluginProperties(this.getClass().getName()), HTTPStatistics.host.getConfigDirectory());
        }
        if (v.getLastVisitedPage() != null) {
            VisitedURL vurl;
            Iterator iter;
            int nbr_deleted_posts = 0;
            Iterator iter2 = v.getVisitedPages().iterator();
            while (iter2.hasNext()) {
                boolean exists;
                String post_id;
                Boolean post_already_found;
                VisitedURL vurl2 = (VisitedURL)iter2.next();
                String url = vurl2.getURL() != null ? vurl2.getURL().url : "";
                Matcher m = this.pat_viewtopic.matcher(url);
                if (!m.find() || (post_already_found = (Boolean)this.ht_deleted_post_found.get(post_id = m.group(1))) != null || (exists = PhpBbUtils.doesPhpBbPostExists(post_id))) continue;
                ++nbr_deleted_posts;
                this.ht_deleted_post_found.put(post_id, Boolean.TRUE);
            }
            PhpBbVisitPattern visit_pat = null;
            boolean matched = false;
            int num_visit_pat = 0;
            while (num_visit_pat < this.visit_patterns.length) {
                visit_pat = this.visit_patterns[num_visit_pat];
                visit_pat.reset();
                boolean continue_visit = true;
                iter = v.getVisitedPages().iterator();
                while (iter.hasNext() && continue_visit) {
                    vurl = (VisitedURL)iter.next();
                    String url = vurl.getURL() != null ? vurl.getURL().url : "";
                    continue_visit = visit_pat.processUrl(url);
                }
                boolean bl = matched = !continue_visit && visit_pat.getUserId() != null;
                if (matched) break;
                ++num_visit_pat;
            }
            this.visit_incrementer.nbr_deleted_users = 0;
            PhpBbUser user = PhpBbUtils.getUser(visit_pat.getUserId(), null);
            if (matched && (user == null || !user.isExisting())) {
                IntegerCounter count;
                ++this.nbr_email_collector_found;
                if (this.debug) {
                    System.out.println("----------------PhpBbPosterDetector (" + this.nbr_email_collector_found + ") " + visit_pat.getClass().getSimpleName() + " -----------------");
                }
                if ((count = (IntegerCounter)this.ht_hosts.get(v.host.getHostName())) == null) {
                    count = new IntegerCounter();
                    PhpBbPosterDetectorElement el = new PhpBbPosterDetectorElement();
                    el.setHost(v.host);
                    el.setLastVisitDate(v.getLastVisitedPageDate());
                    el.setUserAgent(v.getUserAgent());
                    count.object = el;
                    this.ht_hosts.put(v.host.getHostName(), count);
                }
                count.inc(nbr_deleted_posts + 1);
                if (this.debug) {
                    System.out.println("  USERAGENT:" + v.getUserAgent() + "      host=" + v.host.getIPAsString() + "   date=" + v.getLastVisitedPageDate());
                }
                this.c = new ArrayList(this.ht_hosts.values());
                Collections.sort(this.c);
                if (this.debug) {
                    iter = v.getVisitedPages().iterator();
                    while (iter.hasNext()) {
                        vurl = (VisitedURL)iter.next();
                        System.out.println("  " + vurl.toString());
                    }
                }
                this.detectedVisits.add(v);
                this.visit_incrementer.nbr_deleted_users = 1;
            }
            this.visit_incrementer.nbr_deleted_posts = nbr_deleted_posts;
            this.daily_histogram.update(v.getFirstHitDate(), this.visit_incrementer);
        }
    }

    public List getIntegerCounters() {
        return this.c;
    }

    public Vector getDetectedVisits() {
        return this.detectedVisits;
    }

    public DailyActivityStorage getDailyActivityStorage() {
        return this.daily_histogram;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (recognizes PhpBB patterns, LPA)";
    }

    public PluginConfigurator getConfigPanel(Host h) {
        PhpBbLpaDectorConfigurator conf = new PhpBbLpaDectorConfigurator();
        return conf;
    }

    public class PhpBbIncrementer
    implements StatisticElementUpdater {
        public int nbr_deleted_users = 1;
        public int nbr_deleted_posts = 0;

        public void update(StatisticElement element) {
            PhpBbStatisticElement el = (PhpBbStatisticElement)element;
            el.nbr_deleted_posts += this.nbr_deleted_posts;
            el.nbr_deleted_users += this.nbr_deleted_users;
        }
    }
}

