/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.PluginProperties;
import ch.kronospace.logpsychoanalyst.Property;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbPost;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhpBbUtils {
    private static Hashtable ht_phpbb_existing_users = null;
    private static Hashtable ht_phpbb_existing_users_by_username = null;
    private static Hashtable ht_phpbb_post_exists = null;
    private static File FILENAME_PHPBB_UTILS_PARAMS_SER = null;
    private static File FILENAME_PHPBB_EXISTING_USERS_SER = null;
    private static File FILENAME_PHPBB_EXISTING_POSTS_SER = null;
    private static long EXISTING_USER_TIMEOUT = 5184000000L;
    private static long EXISTING_POST_TIMEOUT = 5184000000L;
    private static long DELAI_BETWEEN_REQUESTS = 300L;
    public static String sid = null;
    public static String phpbb_url = null;
    static URLConnection conn = null;
    static long last_call_date = 0L;
    static String spamReportId = "";
    static String spamReportPassword = "";
    static long last_call_reportSpamIpAddress_date = 0L;
    public static Hashtable ipWhiteList = new Hashtable();
    public static boolean debug = true;

    public static void init(PluginProperties pp, File config_directory) {
        PhpBbUtils.init(pp.getProperty(), config_directory);
    }

    public static void init(Vector pp, File config_directory) {
        HashMap<String, String> m = new HashMap<String, String>();
        Enumeration e2 = pp.elements();
        while (e2.hasMoreElements()) {
            Property p = (Property)e2.nextElement();
            m.put(p.getName(), p.getValue());
        }
        phpbb_url = (String)m.get("forumUrl");
        if (sid != null) {
            PhpBbUtils.logout();
        }
        sid = PhpBbUtils.login((String)m.get("adminUsername"), (String)m.get("adminPassword"));
        spamReportId = (String)m.get("spamReportId");
        spamReportPassword = (String)m.get("spamReportPassword");
        try {
            EXISTING_USER_TIMEOUT = Long.parseLong((String)m.get("userTimeout"));
        }
        catch (Exception e) {
            System.out.println("WARNING: could not parse 'userTimeout'. Defaulted to " + EXISTING_USER_TIMEOUT);
        }
        try {
            EXISTING_POST_TIMEOUT = Long.parseLong((String)m.get("postTimeout"));
        }
        catch (Exception e) {
            System.out.println("WARNING: could not parse 'postTimeout'. Defaulted to " + EXISTING_POST_TIMEOUT);
        }
        ipWhiteList = new Hashtable();
        String[] ip_white_list_elems = ((String)m.get("ipWhiteList")).split(", ?");
        int i = 0;
        while (i < ip_white_list_elems.length) {
            ipWhiteList.put(ip_white_list_elems[i], Boolean.TRUE);
            ++i;
        }
        if (config_directory != null) {
            FILENAME_PHPBB_EXISTING_USERS_SER = new File(config_directory, "phpbb_existing_users.ser");
            FILENAME_PHPBB_EXISTING_POSTS_SER = new File(config_directory, "phpbb_existing_posts.ser");
            FILENAME_PHPBB_UTILS_PARAMS_SER = new File(config_directory, "phpbb_utils_params.ser");
        }
        ht_phpbb_existing_users = null;
        ht_phpbb_existing_users_by_username = null;
        ht_phpbb_post_exists = null;
        PhpBbUtils.readPhpBbUtilsParams();
    }

    public static void waitIfRequired() {
        long wait_time = last_call_date + DELAI_BETWEEN_REQUESTS - System.currentTimeMillis();
        if (wait_time > 0L) {
            try {
                Thread.sleep(wait_time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        last_call_date = System.currentTimeMillis();
    }

    public static void buildUserByUsernameCacheFromUserCache() {
        ht_phpbb_existing_users_by_username = new Hashtable();
        Iterator iter = ht_phpbb_existing_users.values().iterator();
        while (iter.hasNext()) {
            PhpBbUser user = (PhpBbUser)iter.next();
            ht_phpbb_existing_users_by_username.put(user.getName(), user);
        }
    }

    public static PhpBbUser getUserFromCache(String user_id) {
        if (ht_phpbb_existing_users == null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FILENAME_PHPBB_EXISTING_USERS_SER));
                ht_phpbb_existing_users = (Hashtable)ois.readObject();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (ht_phpbb_existing_users == null) {
                ht_phpbb_existing_users = new Hashtable();
            }
            PhpBbUtils.buildUserByUsernameCacheFromUserCache();
        }
        return (PhpBbUser)ht_phpbb_existing_users.get(user_id);
    }

    public static PhpBbPost doesPhpBbPostExistsInCache(String user_id) {
        if (ht_phpbb_post_exists == null) {
            if (FILENAME_PHPBB_EXISTING_POSTS_SER != null) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FILENAME_PHPBB_EXISTING_POSTS_SER));
                    ht_phpbb_post_exists = (Hashtable)ois.readObject();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (ht_phpbb_post_exists == null) {
                ht_phpbb_post_exists = new Hashtable();
            }
        }
        return (PhpBbPost)ht_phpbb_post_exists.get(user_id);
    }

    public static void writePhpBbUtilsParams() {
        if (FILENAME_PHPBB_UTILS_PARAMS_SER == null) {
            return;
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(FILENAME_PHPBB_UTILS_PARAMS_SER));
            oos.writeLong(System.currentTimeMillis());
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readPhpBbUtilsParams() {
        if (FILENAME_PHPBB_UTILS_PARAMS_SER == null) {
            return;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FILENAME_PHPBB_UTILS_PARAMS_SER));
            last_call_reportSpamIpAddress_date = ois.readLong();
            ois.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writePhpBbExistingUsersCache() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(FILENAME_PHPBB_EXISTING_USERS_SER));
            oos.writeObject(ht_phpbb_existing_users);
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writePhpBbExistingPostsCache() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(FILENAME_PHPBB_EXISTING_POSTS_SER));
            oos.writeObject(ht_phpbb_post_exists);
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean doesPhpBbPostExists(String post_id) {
        PhpBbPost post = PhpBbUtils.doesPhpBbPostExistsInCache(post_id);
        if (post == null || post.isExisting() && System.currentTimeMillis() > post.getLastUpdate() + EXISTING_POST_TIMEOUT) {
            try {
                PhpBbUtils.waitIfRequired();
                String url = String.valueOf(phpbb_url) + "viewtopic.php?p=" + post_id;
                if (debug) {
                    System.out.println("phpBbUtils.doesPhpBbPostExists: " + url);
                }
                URLConnection url_con = new URL(url).openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
                String ligne = in.readLine();
                boolean found_no_user_message = false;
                while (ligne != null && !found_no_user_message) {
                    found_no_user_message = ligne.indexOf("The topic or post you requested does not exist") >= 0;
                    ligne = in.readLine();
                }
                if (post == null) {
                    post = new PhpBbPost();
                    ht_phpbb_post_exists.put(post_id, post);
                }
                post.setExisting(!found_no_user_message);
                post.setPostId(post_id);
                post.setLastUpdate(System.currentTimeMillis());
                return post.isExisting();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return post.isExisting();
    }

    public static void logout() {
        if (sid != null) {
            return;
        }
        String url = String.valueOf(phpbb_url) + "login.php?logout=true&sid=" + sid;
        if (debug) {
            System.out.println("PhpBbUtils.logout: " + url);
        }
        PhpBbUtils.waitIfRequired();
        try {
            URLConnection url_con = new URL(url).openConnection();
            url_con.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
            String data = "";
            String ligne = in.readLine();
            while (ligne != null) {
                data = String.valueOf(data) + ligne + "\n";
                ligne = in.readLine();
            }
            in.close();
            sid = null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String login(String username, String password) {
        try {
            String line;
            String data = "";
            data = String.valueOf(data) + URLEncoder.encode("username", "UTF-8") + "=" + URLEncoder.encode(username, "UTF-8") + "&";
            data = String.valueOf(data) + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(password, "UTF-8") + "&";
            data = String.valueOf(data) + URLEncoder.encode("login", "UTF-8") + "=" + URLEncoder.encode("Log in", "UTF-8") + "&";
            PhpBbUtils.waitIfRequired();
            URL url = new URL(String.valueOf(phpbb_url) + "login.php");
            if (debug) {
                System.out.println("PhpBbUtils.login: " + url.toString());
            }
            conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Pattern pat_sid = Pattern.compile("\\?sid=(.*?)\"");
            String sid = null;
            while ((line = rd.readLine()) != null) {
                if (line.indexOf("You have specified an incorrect or inactive username, or an invalid password.") >= 0) {
                    sid = null;
                    break;
                }
                Matcher m = pat_sid.matcher(line);
                if (!m.find() || sid != null) continue;
                sid = m.group(1);
            }
            return sid;
        }
        catch (UnknownHostException e) {
            System.out.println("WARNING: could not login on phpbb with username=" + username + ". Cause: " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static PhpBbUser getUser(String userId, String sid) {
        if (userId == null) {
            return null;
        }
        PhpBbUser user = PhpBbUtils.getUserFromCache(userId);
        if (user == null || user.isExisting() && System.currentTimeMillis() > user.getLastUpdate() + EXISTING_USER_TIMEOUT) {
            try {
                if (sid == null) {
                    sid = PhpBbUtils.sid;
                }
                String url = String.valueOf(phpbb_url) + "profile.php?mode=viewprofile&u=" + userId + (sid != null ? "&sid=" + sid : "");
                if (debug) {
                    System.out.println("phpBbUtils.getUser URL: " + url);
                }
                PhpBbUtils.waitIfRequired();
                URLConnection url_con = new URL(url).openConnection();
                String myCookie = "PHPSESSID=" + sid;
                url_con.setRequestProperty("Cookie", myCookie);
                url_con.connect();
                BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
                String data = "";
                String ligne = in.readLine();
                while (ligne != null) {
                    data = String.valueOf(data) + ligne + "\n";
                    ligne = in.readLine();
                }
                boolean does_user_exists = data.indexOf("Sorry, but that user does not exist.") < 0;
                Pattern pat_occupation = Pattern.compile("<span class=\"gen\">Occupation.*\\n.*<span class=\"gen\">(.*)</span>");
                String occupation = "?";
                Matcher matcher_occupation = pat_occupation.matcher(data);
                if (matcher_occupation.find()) {
                    occupation = matcher_occupation.group(1);
                }
                Pattern pat_interests = Pattern.compile("<span class=\"gen\">Interests.*\\n.*<span class=\"gen\">(.*)</span>");
                String interests = "?";
                Matcher matcher_interests = pat_interests.matcher(data);
                if (matcher_interests.find()) {
                    interests = matcher_interests.group(1);
                }
                Pattern pat_name = Pattern.compile("<th class=\"thHead\" colspan=\"\\d\" height=\"\\d+\" nowrap=\"nowrap\">Viewing profile :: (.*)</th>");
                String name = "?";
                Matcher matcher_name = pat_name.matcher(data);
                if (matcher_name.find()) {
                    name = matcher_name.group(1);
                }
                Pattern pat_nbr_posts = Pattern.compile("Total posts:&nbsp;</span></td>\\n\\s+<td valign=\"top\"><b><span class=\"gen\">(.+?)</span>", 8);
                int nbr_posts = -1;
                Matcher matcher_nbr_posts = pat_nbr_posts.matcher(data);
                if (matcher_nbr_posts.find()) {
                    try {
                        nbr_posts = Integer.parseInt(matcher_nbr_posts.group(1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Pattern pat_email = Pattern.compile("<a href=\"mailto:(.*)\">");
                String email = "?";
                Matcher matcher_email = pat_email.matcher(data);
                if (matcher_email.find()) {
                    email = matcher_email.group(1);
                }
                boolean store_user = false;
                if (user == null) {
                    user = new PhpBbUser();
                    store_user = true;
                }
                if (does_user_exists) {
                    user.setUserId(userId);
                    user.setName(name);
                    user.setEmail(email);
                    user.setInterests(interests);
                    user.setOccupation(occupation);
                    user.setNbrPosts(nbr_posts);
                }
                user.setExisting(does_user_exists);
                user.setLastUpdate(System.currentTimeMillis());
                if (store_user) {
                    ht_phpbb_existing_users.put(userId, user);
                    ht_phpbb_existing_users_by_username.put(user.getName(), user);
                }
                return user;
            }
            catch (UnknownHostException e) {
                System.out.println("WARNING: could not get phpbb profile for userId=" + userId + ". Cause: " + e.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        return user;
    }

    public static String getDeleteUserUrl(String user_id) {
        return "javascript:phpbbDeleteUser(" + user_id + ");";
    }

    public static String getBanEmailUrl(String email) {
        return "javascript:phpbbBanEmail('" + email + "');";
    }

    public static String getLoginUrl() {
        return String.valueOf(phpbb_url) + "login.php";
    }

    public static void reportSpamIpAddress(String ip_address, int nbr_visits, Date last_visit_date) {
        PhpBbUtils.reportSpamIpAddress(ip_address, nbr_visits, last_visit_date, spamReportId, spamReportPassword);
    }

    public static void reportSpamIpAddress(String ip_address, int nbr_visits, Date last_visit_date, String tid, String tpwd) {
        if (last_visit_date.getTime() <= last_call_reportSpamIpAddress_date) {
            return;
        }
        String url = "http://www.logpsychoanalyst.com/spam-fighting/report-spam-ip-address.php?ip_address=" + ip_address + "&last_visit_date=" + new SimpleDateFormat("yyyy-MM-dd").format(last_visit_date) + "&nbr_visits=" + nbr_visits + "&tid=" + tid + "&tpwd=" + tpwd;
        if (debug) {
            System.out.println("reportSpamIpAddress URL: " + url);
        }
        PhpBbUtils.waitIfRequired();
        try {
            URLConnection url_con = new URL(url).openConnection();
            url_con.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
            String data = "";
            String ligne = in.readLine();
            while (ligne != null) {
                data = String.valueOf(data) + ligne + "\n";
                ligne = in.readLine();
            }
            in.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List getUserPosts(String username) {
        List<PhpBbPost> list;
        block16: {
            list = new ArrayList();
            if (username == null) {
                System.out.println("WARNING: getUserPosts: username=null");
                return list;
            }
            PhpBbUser user = (PhpBbUser)ht_phpbb_existing_users_by_username.get(username);
            if (user == null || user.isExisting() && System.currentTimeMillis() > user.getPostListLastUpdate() + EXISTING_POST_TIMEOUT) {
                Pattern pat = Pattern.compile("<a href=\"viewtopic.php\\?p=(\\d+)&amp;highlight=.*?\"", 8);
                Pattern pat_last_post_date = Pattern.compile("Posted: (.*)&nbsp; &nbsp;Subject:");
                String url = String.valueOf(phpbb_url) + "search.php?mode=results&search_author=" + username.replaceAll(" ", "%20") + "&show_results=posts";
                if (debug) {
                    System.out.println("getUserPostIds URL: " + url);
                }
                PhpBbUtils.waitIfRequired();
                try {
                    URLConnection url_con = new URL(url).openConnection();
                    url_con.connect();
                    BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
                    String data = "";
                    String ligne = in.readLine();
                    while (ligne != null) {
                        data = String.valueOf(data) + ligne + "\n";
                        ligne = in.readLine();
                    }
                    in.close();
                    Matcher m2 = pat_last_post_date.matcher(data);
                    long last_post_date = 0L;
                    if (m2.find()) {
                        String date_str = m2.group(1);
                        try {
                            Date last_post_date_as_date = new SimpleDateFormat("EEE MMM dd, yyyy hh:mm a", new Locale("en")).parse(date_str);
                            last_post_date = last_post_date_as_date.getTime();
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    Matcher m = pat.matcher(data);
                    boolean first_post_in_list = true;
                    while (m.find()) {
                        String post_id = m.group(1);
                        PhpBbPost post = new PhpBbPost();
                        post.setPostId(post_id);
                        if (first_post_in_list) {
                            first_post_in_list = false;
                            post.setPostDate(last_post_date);
                        }
                        post.setLastUpdate(System.currentTimeMillis());
                        post.setExisting(true);
                        list.add(post);
                    }
                    if (user != null) {
                        user.setPostList(list);
                        user.setPostListLastUpdate(System.currentTimeMillis());
                        break block16;
                    }
                    System.out.println("WARNING in PhpBbUtils.getUserPosts: the user '" + username + "' was not found => determine it e.g. by its user_id if it could be found in the parsed page");
                }
                catch (UnknownHostException e) {
                    System.out.println("WARNING: could not get phpbb posts for username=" + username + ". Cause: " + e.toString());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (user != null) {
                list = user.isExisting() ? user.getPostList() : new ArrayList();
            }
        }
        return list;
    }

    public static List getUserTopics(String username) {
        Pattern pat = Pattern.compile("<a href=\"viewtopic.php\\?t=(\\d+)&amp;highlight=(?:&.+)\"", 8);
        Pattern pat_last_post_date = Pattern.compile("Posted: (.*)&nbsp; &nbsp;Subject:");
        String url = String.valueOf(phpbb_url) + "search.php?mode=results&search_author=" + username.replaceAll(" ", "%20") + "&show_results=posts";
        if (debug) {
            System.out.println("getUserTopicIds URL: " + url);
        }
        PhpBbUtils.waitIfRequired();
        ArrayList<PhpBbPost> list = new ArrayList<PhpBbPost>();
        try {
            URLConnection url_con = new URL(url).openConnection();
            url_con.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(url_con.getInputStream()));
            String data = "";
            String ligne = in.readLine();
            while (ligne != null) {
                data = String.valueOf(data) + ligne + "\n";
                ligne = in.readLine();
            }
            in.close();
            Matcher m2 = pat_last_post_date.matcher(data);
            long last_post_date = 0L;
            if (m2.find()) {
                String date_str = m2.group(1);
                try {
                    Date last_post_date_as_date = new SimpleDateFormat("EEE MMM dd, yyyy hh:mm a", new Locale("en")).parse(date_str);
                    last_post_date = last_post_date_as_date.getTime();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            Matcher m = pat.matcher(data);
            boolean first_post_in_list = true;
            while (m.find()) {
                String post_id = m.group(1);
                PhpBbPost post = new PhpBbPost();
                post.setPostId(post_id);
                if (first_post_in_list) {
                    first_post_in_list = false;
                    post.setPostDate(last_post_date);
                }
                post.setLastUpdate(System.currentTimeMillis());
                post.setExisting(true);
                list.add(post);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

