/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.plugins.visit;

import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUser;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbUtils;
import ch.kronospace.logpsychoanalyst.plugins.visit.PhpBbVisitPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhpBbVisitPatternActivate
extends PhpBbVisitPattern {
    int pat_start_index = 0;

    public PhpBbVisitPatternActivate() {
        super.setUrlPatterns(new Pattern[]{Pattern.compile("/profile\\.php\\?mode=activate&u=(\\d+)")});
    }

    public void reset() {
        this.pat_start_index = 0;
        this.setUserId(null);
        this.setNbrDeletedPosts(0);
    }

    public boolean processUrl(String url) {
        if (this.pat_start_index >= this.getUrlPatterns().length) {
            return false;
        }
        Matcher matcher = this.getUrlPatterns()[this.pat_start_index].matcher(url);
        if (matcher.find()) {
            ++this.pat_start_index;
            if (matcher.groupCount() > 0 && matcher.group(1) != null) {
                this.setUserId(matcher.group(1));
            }
        }
        if (this.pat_start_index >= this.getUrlPatterns().length) {
            this.incNbrUsers();
            if (this.getUserId() != null) {
                PhpBbUser user = PhpBbUtils.getUser(this.getUserId(), null);
                if (user != null && user.isExisting()) {
                    this.addExistingUser(this.getUserId());
                } else {
                    this.addDeletedUser(this.getUserId());
                    this.incNbrDeletedUsers();
                }
            }
            this.pat_start_index = 0;
            return false;
        }
        return true;
    }
}

