/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.report;

import ch.kronospace.logpsychoanalyst.DNSQueryAHBL;
import ch.kronospace.logpsychoanalyst.DNSQuerySORBS;
import ch.kronospace.logpsychoanalyst.DataSource;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.HostUserAgent;
import ch.kronospace.logpsychoanalyst.HostUserAgentList;
import ch.kronospace.logpsychoanalyst.InputStreamVector;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.LogEntryFile;
import ch.kronospace.logpsychoanalyst.LogEntryFileUtils;
import ch.kronospace.logpsychoanalyst.MimeType;
import ch.kronospace.logpsychoanalyst.MultipleProxy;
import ch.kronospace.logpsychoanalyst.OS;
import ch.kronospace.logpsychoanalyst.ProcessingOptions;
import ch.kronospace.logpsychoanalyst.Proxy;
import ch.kronospace.logpsychoanalyst.Recognized404Error;
import ch.kronospace.logpsychoanalyst.RecognizedAlias;
import ch.kronospace.logpsychoanalyst.RecognizedCountry;
import ch.kronospace.logpsychoanalyst.RecognizedHost;
import ch.kronospace.logpsychoanalyst.RecognizedMimeType;
import ch.kronospace.logpsychoanalyst.RecognizedOS;
import ch.kronospace.logpsychoanalyst.RecognizedScreenSize;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgent;
import ch.kronospace.logpsychoanalyst.RecognizedWorm;
import ch.kronospace.logpsychoanalyst.Referer;
import ch.kronospace.logpsychoanalyst.RefererGroup;
import ch.kronospace.logpsychoanalyst.RefererOrRefererGroup;
import ch.kronospace.logpsychoanalyst.ReverseDNSQuery;
import ch.kronospace.logpsychoanalyst.SearchEngineKeywords;
import ch.kronospace.logpsychoanalyst.SearchEngineStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticBag;
import ch.kronospace.logpsychoanalyst.StatisticElementFullUpdater;
import ch.kronospace.logpsychoanalyst.UnknownOS;
import ch.kronospace.logpsychoanalyst.UnknownUserAgent;
import ch.kronospace.logpsychoanalyst.UserAgent;
import ch.kronospace.logpsychoanalyst.UserAgentFamily;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitIncrementer;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import ch.kronospace.logpsychoanalyst.Worm;
import ch.kronospace.logpsychoanalyst.database.ISPDatabase;
import ch.kronospace.logpsychoanalyst.database.ISPDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.MimeTypeDatabase;
import ch.kronospace.logpsychoanalyst.database.MimeTypeDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.OSDatabase;
import ch.kronospace.logpsychoanalyst.database.OSDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.RefererBlackListParser;
import ch.kronospace.logpsychoanalyst.database.RefererDatabase;
import ch.kronospace.logpsychoanalyst.database.RefererDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabase;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.WormDatabase;
import ch.kronospace.logpsychoanalyst.database.WormDatabaseParser;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.GeneralPlugin;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.visit.VisitPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import ch.kronospace.tools.GZIPInputStream2;
import ch.kronospace.tools.HTMLTools;
import ch.kronospace.tools.ThreadPool;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;

public class HTTPStatisticsBuilder
extends StatisticsBuilder {
    public static int nbr_clone_date = 0;
    public static UserAgentDatabase useragent_database = null;
    public static OSDatabase os_database = null;
    public static WormDatabase worm_database = null;
    public static MimeTypeDatabase mime_type_database = null;
    public static RefererDatabase referer_database = null;
    public static ISPDatabase isp_database = null;
    boolean recognize_useragent_master = true;
    boolean recognize_os_master = true;
    boolean recognize_referer_master = true;
    boolean recognize_useragent = this.recognize_useragent_master;
    boolean recognize_os = this.recognize_os_master;
    boolean recognize_referer = this.recognize_referer_master;
    boolean recognize_country = true;
    boolean recognize_mime_type = true;
    boolean detect_worms = true;
    boolean detect_robot_traps = true;
    boolean track_country_by_date = true;
    boolean do_reverse_dns = false;
    boolean do_sorbs = false;
    boolean do_ahbl = false;
    int visit_timeout_minutes = 30;
    int max_visit_duration = 30;
    int nbr_bins_visit_duration_histo = 60;
    int backtime_threshold_minutes = 65;
    public Vector plugins = PluginManager.getPlugins();
    public Vector proxies = new Vector();
    public Vector multiple_proxies = new Vector();
    public Vector host_useragents = new Vector();
    public Vector host_useragents_list = new Vector();
    public HTTPStatistics stats = null;
    long last_log_entry_date_long = 0L;
    VisitIncrementer visit_incrementer = new VisitIncrementer();
    StatisticElementFullUpdater stat_el_full_updater = new StatisticElementFullUpdater();

    public HTTPStatisticsBuilder() {
        this.stats = new HTTPStatistics();
        this.statistics = this.stats;
    }

    public String toString() {
        return "StatisticsBuilder for HTTP log files";
    }

    public void processLogFiles(Host vhost) {
        RefererOrRefererGroup group;
        StatisticBag statistic_bag;
        long t0;
        this.stats.t0 = t0 = System.currentTimeMillis();
        long t02 = System.currentTimeMillis();
        HTTPStatistics.host = vhost;
        ProcessingOptions p = vhost.getProcessingOptionsAsProcessingOptions();
        this.recognize_country = p.getIPtoCountryAsBoolean();
        this.recognize_mime_type = p.getRecognizeMimeTypeAsBoolean();
        this.detect_worms = p.getDetectWormsAsBoolean();
        this.detect_robot_traps = p.getDetectRobotTrapAsBoolean();
        this.track_country_by_date = p.getTemporalIPtoCountryAsBoolean();
        this.do_reverse_dns = p.getReverseDNSAsBoolean();
        this.do_sorbs = p.getSorbsAsBoolean();
        this.do_ahbl = p.getAhblAsBoolean();
        this.visit_timeout_minutes = p.getVisitTimeoutAsInt();
        this.max_visit_duration = p.geMaxVisitDurationAsInt();
        this.nbr_bins_visit_duration_histo = p.geNbrBinsVisitDurationHistAsInt();
        int nbr_unknown_countrycode = 0;
        useragent_database = UserAgentDatabaseParser.getDefaultDatabase();
        os_database = OSDatabaseParser.getDefaultDatabase();
        worm_database = WormDatabaseParser.getDefaultDatabase();
        mime_type_database = MimeTypeDatabaseParser.getDefaultDatabase();
        isp_database = ISPDatabaseParser.getDefaultDatabase();
        referer_database = RefererDatabaseParser.getDefaultDatabase();
        System.out.println("nbr_referers=" + HTTPStatisticsBuilder.referer_database.referers.size());
        RefererBlackListParser.load();
        int i = 0;
        while (i < this.stats.server_activity_hours.length) {
            this.stats.server_activity_hours[i] = new HTTPStatisticElement();
            ++i;
        }
        ThreadPool dns_threadpool = this.do_reverse_dns ? new ThreadPool(100, this.do_reverse_dns, false) : null;
        ThreadPool dns_threadpool_sorbs = this.do_sorbs ? new ThreadPool(100, this.do_sorbs, false) : null;
        ThreadPool dns_threadpool_ahbl = this.do_ahbl ? new ThreadPool(100, this.do_ahbl, false) : null;
        Hashtable<String, Referer> ht_referers = new Hashtable<String, Referer>();
        System.out.println();
        long total_size = 0L;
        int progress = 0;
        int old_progress = -1;
        int nbr_corrupted_records = 0;
        Pattern pat_hex_chars = Pattern.compile("(.*)%(\\w\\w)(.*)");
        Pattern p_mime_ext = Pattern.compile("^(?:http://.+)?/.+\\.([^/]+)$");
        System.out.print("computing the total of bytes to process...");
        long all_datasources_size = 0L;
        Enumeration enum_ds = vhost.getDataSource().elements();
        while (enum_ds.hasMoreElements()) {
            DataSource datasource = (DataSource)enum_ds.nextElement();
            InputStreamVector log_files_input_stream = datasource.getLogInputStreams();
            all_datasources_size += log_files_input_stream.total_size;
        }
        System.out.println("  done");
        long all_datasources_size_bak = all_datasources_size;
        this.proxies = vhost.getProxy();
        this.host_useragents = vhost.getHostUserAgent();
        this.host_useragents_list = vhost.getHostUserAgentList();
        this.multiple_proxies = vhost.getMultipleProxy();
        LogFormat log_format = null;
        boolean first_hit = true;
        Enumeration enum_ds2 = vhost.getDataSource().elements();
        while (enum_ds2.hasMoreElements()) {
            DataSource datasource = (DataSource)enum_ds2.nextElement();
            InputStreamVector log_files_input_stream = datasource.getLogInputStreams();
            Collections.sort(log_files_input_stream, LogEntryFileUtils.FIRST_ENTRY_DATE_COMPARATOR);
            IPGeographyUtil.setLocalNetworkCountryCode(datasource.getCountry());
            log_format = datasource.getLogFormatAsLogFormat();
            log_format.setDataSource(datasource);
            this.recognize_useragent = this.recognize_useragent_master && log_format.hasUserAgent();
            this.recognize_os = this.recognize_os_master && log_format.hasUserAgent();
            this.recognize_referer = this.recognize_referer_master && log_format.hasReferer();
            Enumeration en = log_files_input_stream.elements();
            while (en.hasMoreElements()) {
                LogEntryFile lef = (LogEntryFile)en.nextElement();
                InputStream is = null;
                try {
                    is = lef.createInputStream();
                    BufferedReader in = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")), 0x100000);
                    log_format.setBufferedReader(in);
                    String ligne = log_format.getNextEntry();
                    while (ligne != null) {
                        long t1;
                        progress = (int)((total_size += (long)ligne.length()) * 100L / all_datasources_size);
                        if (old_progress != progress) {
                            int remaining_time = 1000;
                            if (progress != 0) {
                                t1 = System.currentTimeMillis();
                                int duration = (int)(t1 / 1000L - t0 / 1000L);
                                remaining_time = (100 - progress) * duration / progress;
                            }
                            lef.updateContentLength();
                            all_datasources_size = all_datasources_size + lef.getContentLength() - lef.getPreviousContentLength();
                            System.out.print(String.valueOf(progress) + "% (" + remaining_time + " [s] remaining)     \r");
                        }
                        old_progress = progress;
                        log_format.parse(ligne);
                        if (log_format.isCorrupted()) {
                            ++nbr_corrupted_records;
                        } else if (this.backtime_threshold_minutes >= 0 && log_format.getDate().getTimeInMillis() + (long)(this.backtime_threshold_minutes * 60 * 1000) < this.last_log_entry_date_long) {
                            ++nbr_corrupted_records;
                            System.out.println("corrupted (backtime): " + ligne);
                        } else {
                            if (log_format.getCode() == 404 && log_format.getURL().startsWith("/lpa/")) {
                                log_format.setCode(200);
                            }
                            boolean is_plugin_hit = false;
                            Enumeration e = this.plugins.elements();
                            while (e.hasMoreElements()) {
                                GeneralPlugin p2 = (GeneralPlugin)e.nextElement();
                                is_plugin_hit |= p2.isAHit(log_format);
                            }
                            boolean is_page = this.isPage(log_format.getURL()) && !is_plugin_hit;
                            boolean is_page_valid = is_page && (log_format.getCode() == 200 || log_format.getCode() == 304 || log_format.getCode() == 302);
                            boolean method_logged = log_format.getMethod().equals("GET") || log_format.getMethod().equals("POST") || log_format.getMethod().equals("HEAD");
                            this.last_log_entry_date_long = log_format.getDate().getTimeInMillis();
                            if (first_hit) {
                                HTTPStatistics.first_day = this.last_log_entry_date_long;
                                first_hit = false;
                            }
                            String url_without_params = log_format.getURL();
                            url_without_params.replace('\\', '/');
                            int index_questionmark = url_without_params.indexOf(63);
                            if (index_questionmark != -1) {
                                url_without_params = url_without_params.substring(0, index_questionmark);
                            }
                            Matcher mat = pat_hex_chars.matcher(url_without_params);
                            while (mat.find()) {
                                try {
                                    url_without_params = String.valueOf(mat.group(1)) + (char)Integer.parseInt(mat.group(2), 16) + mat.group(3);
                                }
                                catch (Exception e2) {
                                    break;
                                }
                                mat = pat_hex_chars.matcher(url_without_params);
                            }
                            url_without_params.replace('\\', '/');
                            boolean worm_detected = false;
                            if (this.detect_worms) {
                                RecognizedWorm recognized_worm = this.getRecognizedWorm(log_format);
                                boolean bl = worm_detected = recognized_worm != null;
                                if (worm_detected) {
                                    ++recognized_worm.nbr_hits;
                                }
                            }
                            boolean bad_link = false;
                            if (!worm_detected && log_format.getCode() == 404) {
                                Recognized404Error error_404;
                                if (log_format.isRefererOnSameVirtualHostThanURL()) {
                                    error_404 = (Recognized404Error)this.stats.ht_bad_links.get(log_format.getURL());
                                    if (error_404 == null) {
                                        error_404 = new Recognized404Error(log_format.getURL());
                                        this.stats.ht_bad_links.put(log_format.getURL(), error_404);
                                    }
                                    error_404.addReferer(log_format.getReferer(), this.last_log_entry_date_long);
                                    ++error_404.nbr_hits;
                                } else {
                                    error_404 = (Recognized404Error)this.stats.ht_bad_referer_links.get(log_format.getURL());
                                    if (error_404 == null) {
                                        error_404 = new Recognized404Error(log_format.getURL());
                                        this.stats.ht_bad_referer_links.put(log_format.getURL(), error_404);
                                    }
                                    error_404.addReferer(log_format.getReferer(), this.last_log_entry_date_long);
                                    ++error_404.nbr_hits;
                                }
                                bad_link = true;
                            }
                            if (!worm_detected && !bad_link && method_logged) {
                                String loganalyst_download_speed_tracker_filename;
                                int index_download_speed_tracker;
                                String url;
                                RecognizedHost recognized_host;
                                boolean is_multiple_proxy;
                                TimeZone tz;
                                boolean human_ua_robots_txt_hit = log_format.getURL().equals("/robots.txt");
                                boolean robot_trap_hit = this.detect_robot_traps && datasource.isRobotTrap(log_format.getURL());
                                RecognizedUserAgent recognized_useragent = null;
                                if (this.recognize_useragent) {
                                    recognized_useragent = this.getRecognizedUserAgent(log_format, is_page, human_ua_robots_txt_hit, robot_trap_hit);
                                    if (is_page) {
                                        ++recognized_useragent.nbr_pages;
                                    }
                                    ++recognized_useragent.nbr_hits;
                                    recognized_useragent.size += log_format.getSize();
                                    recognized_useragent.setDate(this.last_log_entry_date_long);
                                }
                                String visitor_type = "human";
                                if (recognized_useragent != null) {
                                    visitor_type = recognized_useragent.getUserAgent().getFamily().getVisitorType();
                                }
                                this.stats.statistic_bag = (StatisticBag)this.stats.statistic_bags.get(visitor_type);
                                if (this.stats.statistic_bag == null) {
                                    this.stats.statistic_bag = new StatisticBag(visitor_type, this.nbr_bins_visit_duration_histo);
                                    this.stats.statistic_bags.put(visitor_type, this.stats.statistic_bag);
                                }
                                if (this.recognize_mime_type && !worm_detected && log_format.getCode() != 404 && log_format.getCode() != 401) {
                                    RecognizedMimeType mime_type_stat;
                                    MimeType mime_type;
                                    int index_anchor = url_without_params.indexOf(35);
                                    String url_without_params_without_anchor = url_without_params;
                                    if (index_anchor != -1) {
                                        url_without_params_without_anchor = url_without_params_without_anchor.substring(0, index_anchor);
                                    }
                                    String filename_extension = null;
                                    Matcher m_mime_ext = p_mime_ext.matcher(url_without_params_without_anchor);
                                    if (m_mime_ext.find()) {
                                        filename_extension = m_mime_ext.group(1).toLowerCase();
                                    } else {
                                        if (!url_without_params_without_anchor.endsWith("/")) {
                                            // empty if block
                                        }
                                        filename_extension = "html";
                                    }
                                    if (filename_extension.length() > 8) {
                                        System.out.println("Strange mime-type (ext=" + filename_extension + "): " + ligne);
                                    }
                                    if ((mime_type = mime_type_database.getMimeType(filename_extension)) == null) {
                                        mime_type = new MimeType(filename_extension, filename_extension, "unknown", "Unknown mime-type");
                                        mime_type_database.add(mime_type);
                                    }
                                    if ((mime_type_stat = (RecognizedMimeType)this.stats.statistic_bag.histo_mime_type.get(mime_type)) == null) {
                                        mime_type_stat = new RecognizedMimeType(mime_type);
                                        this.stats.statistic_bag.histo_mime_type.put(mime_type, mime_type_stat);
                                    }
                                    if (is_page) {
                                        ++mime_type_stat.nbr_pages;
                                    }
                                    ++mime_type_stat.nbr_hits;
                                    mime_type_stat.size += log_format.getSize();
                                    this.stat_el_full_updater.nbr_visits = 1L;
                                    this.stat_el_full_updater.nbr_pages = 1L;
                                    this.stat_el_full_updater.nbr_hits = 1L;
                                    this.stat_el_full_updater.size = log_format.getSize();
                                    mime_type_stat.getDailyActivityStorage().update(this.last_log_entry_date_long, this.stat_el_full_updater);
                                }
                                log_format.getHostAsString().equals("195.136.80.70");
                                log_format.getUserAgent().indexOf("cgitsie6");
                                log_format.getUserAgent().indexOf("Gecko/1.3.1");
                                if (log_format.getUserAgent().equals("Mozilla/4.0 (compatible;)")) {
                                    log_format.getCode();
                                }
                                log_format.getReferer().indexOf("66.249.93.104");
                                log_format.getUserAgent().indexOf("MSIE 5.01");
                                if (log_format.getUserAgent().indexOf("MSIE") != -1 && !log_format.getURL().equals("/robots.txt")) {
                                    log_format.getURL().equals("/iamabot.html");
                                }
                                if (log_format.getReferer().equals("http://1")) {
                                    System.out.println(ligne);
                                }
                                RecognizedCountry recognized_country = null;
                                String country_code = "";
                                if (this.recognize_country) {
                                    country_code = this.track_country_by_date ? IPGeographyUtil.getCountryCode(log_format.getHost(), this.last_log_entry_date_long) : IPGeographyUtil.getCountryCode(log_format.getHost());
                                    recognized_country = (RecognizedCountry)this.stats.statistic_bag.histo_country.get(country_code);
                                    if (recognized_country == null) {
                                        recognized_country = new RecognizedCountry(country_code);
                                        this.stats.statistic_bag.histo_country.put(country_code, recognized_country);
                                    }
                                    if (country_code.equals("--")) {
                                        System.out.println("unknown countrycode:" + ligne);
                                        ++nbr_unknown_countrycode;
                                    }
                                    if (is_page) {
                                        ++recognized_country.nbr_pages;
                                    }
                                    ++recognized_country.nbr_hits;
                                    recognized_country.size += log_format.getSize();
                                    this.stat_el_full_updater.nbr_visits = 0L;
                                    this.stat_el_full_updater.nbr_pages = is_page ? 1 : 0;
                                    this.stat_el_full_updater.nbr_hits = 1L;
                                    this.stat_el_full_updater.size = log_format.getSize();
                                    recognized_country.getDailyActivityStorage().update(this.last_log_entry_date_long, this.stat_el_full_updater);
                                }
                                int hour = log_format.getHour();
                                int server_activity_hour_index = 0;
                                int nbins = this.stats.server_activity_hours.length;
                                server_activity_hour_index = ((int)Math.round(((double)hour + (double)log_format.getMinute() / 60.0) * (double)nbins / 24.0) + nbins) % nbins;
                                HTTPStatisticElement server_activity_hour = this.stats.server_activity_hours[server_activity_hour_index];
                                ++server_activity_hour.nbr_hits;
                                server_activity_hour.size += log_format.getSize();
                                if (is_page) {
                                    ++server_activity_hour.nbr_pages;
                                }
                                int client_hour = hour;
                                int client_activity_hour_index = hour * this.stats.statistic_bag.activity_hours.length / 24;
                                if (country_code.length() > 0 && (tz = IPGeographyUtil.getTimeZone(log_format.getHost())) != null) {
                                    int minutes = log_format.getMinute() + (tz.getRawOffset() - datasource.getTimeZone().getRawOffset()) / 60000;
                                    int nbins2 = this.stats.statistic_bag.activity_hours.length;
                                    client_activity_hour_index = ((int)Math.round(((double)client_hour + (double)minutes / 60.0) * (double)nbins2 / 24.0) + nbins2) % nbins2;
                                }
                                HTTPStatisticElement client_activity_hour = this.stats.statistic_bag.activity_hours[client_activity_hour_index];
                                ++client_activity_hour.nbr_hits;
                                client_activity_hour.size += log_format.getSize();
                                if (is_page) {
                                    ++client_activity_hour.nbr_pages;
                                }
                                this.stat_el_full_updater.nbr_visits = 0L;
                                this.stat_el_full_updater.nbr_pages = is_page ? 1 : 0;
                                this.stat_el_full_updater.nbr_hits = 1L;
                                this.stat_el_full_updater.size = log_format.getSize();
                                this.stats.statistic_bag.daily_activity.update(this.last_log_entry_date_long, this.stat_el_full_updater);
                                this.stats.server_daily_activity.update(this.last_log_entry_date_long, this.stat_el_full_updater);
                                MultipleProxy multiple_proxy = this.getMultipleProxy(log_format.getHost());
                                boolean bl = is_multiple_proxy = multiple_proxy != null;
                                if (is_multiple_proxy) {
                                    recognized_host = (RecognizedHost)this.stats.statistic_bag.histo_hosts.get(multiple_proxy);
                                    if (recognized_host == null) {
                                        recognized_host = new RecognizedHost(multiple_proxy);
                                        this.stats.statistic_bag.histo_hosts.put(multiple_proxy, recognized_host);
                                    }
                                } else {
                                    Long host_key = new Long(log_format.getHost());
                                    recognized_host = (RecognizedHost)this.stats.statistic_bag.histo_hosts.get(host_key);
                                    if (recognized_host == null) {
                                        recognized_host = new RecognizedHost(log_format.getHost());
                                        this.stats.statistic_bag.histo_hosts.put(host_key, recognized_host);
                                        if (this.do_reverse_dns) {
                                            dns_threadpool.execute(new ReverseDNSQuery(recognized_host));
                                            dns_threadpool.start();
                                        }
                                        if (this.do_sorbs) {
                                            dns_threadpool_sorbs.execute(new DNSQuerySORBS(recognized_host));
                                            dns_threadpool_sorbs.start();
                                        }
                                        if (this.do_ahbl) {
                                            dns_threadpool_ahbl.execute(new DNSQueryAHBL(recognized_host));
                                            dns_threadpool_ahbl.start();
                                        }
                                    }
                                }
                                if (is_page) {
                                    ++recognized_host.nbr_pages;
                                }
                                ++recognized_host.nbr_hits;
                                recognized_host.size += log_format.getSize();
                                String page = url = log_format.getURL();
                                RecognizedURL recognized_url = null;
                                String host_name = "";
                                if (is_page_valid) {
                                    int index_last_slash2;
                                    if (url.startsWith("http://")) {
                                        int index_slash = url.indexOf(47, "http://".length() + 1);
                                        if (index_slash < 0) {
                                            index_slash = url.length();
                                            page = "/";
                                        } else {
                                            page = url.substring(index_slash);
                                        }
                                        host_name = url.substring("http://".length(), index_slash);
                                    }
                                    if ((index_last_slash2 = page.lastIndexOf("/")) >= 0 && datasource.isDefaultPage(page.substring(index_last_slash2 + 1))) {
                                        page = page.substring(0, index_last_slash2 + 1);
                                    }
                                    recognized_url = this.stats.statistic_bag.url_group_manager.getRecognizedURL2(page);
                                    recognized_url.incPages();
                                    recognized_url.incHits();
                                    recognized_url.incSize(log_format.getSize());
                                    recognized_url.setDate(this.last_log_entry_date_long);
                                    if (log_format.isRefererOnSameVirtualHostThanURL()) {
                                        this.stats.statistic_bag.visit_map.addMapSegment(log_format.getRefererPage(), page);
                                    } else {
                                        this.stats.statistic_bag.visit_map.addEntryPoint(page);
                                    }
                                }
                                Object visit_key = this.isProxy(recognized_host) || is_multiple_proxy ? log_format.getUserAgent() : recognized_host;
                                Visit visit = (Visit)this.stats.statistic_bag.open_visits.get(visit_key);
                                boolean visit_creation_required = false;
                                if (visit == null) {
                                    visit_creation_required = true;
                                } else {
                                    long visit_timeout = visit.getLastVisitedPageDate();
                                    if (this.last_log_entry_date_long > (visit_timeout += (long)(this.stats.visit_timeout_minutes * 60 * 1000))) {
                                        Enumeration e2 = PluginManager.getVisitPlugins().elements();
                                        while (e2.hasMoreElements()) {
                                            VisitPlugin vp = (VisitPlugin)e2.nextElement();
                                            vp.processVisit(visit, this.stats);
                                        }
                                        this.stats.statistic_bag.closed_visits.add(visit);
                                        this.stats.statistic_bag.visit_map.addExitPoint(visit.getLastVisitedPage());
                                        if (this.stats.statistic_bag.closed_visits.size() > this.stats.max_nbr_closed_visits) {
                                            ((Visit)this.stats.statistic_bag.closed_visits.get(this.stats.statistic_bag.closed_visits.size() - this.stats.max_nbr_closed_visits - 1)).packVisitedURLs();
                                        }
                                        this.stats.statistic_bag.daily_visit_duration.addVisit(this.last_log_entry_date_long, visit.getVisitDuration());
                                        visit_creation_required = true;
                                    }
                                }
                                boolean new_visit = false;
                                if (visit_creation_required) {
                                    visit = new Visit(null, this.last_log_entry_date_long);
                                    if (recognized_useragent != null) {
                                        visit.setUserAgent(recognized_useragent);
                                        recognized_useragent.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                    }
                                    visit.setRecognizedHost(recognized_host);
                                    visit.is_internal_referer = log_format.isRefererOnSameVirtualHostThanURL();
                                    this.stats.statistic_bag.open_visits.put(visit_key, visit);
                                    new_visit = true;
                                }
                                ++visit.nbr_hits;
                                visit.size += log_format.getSize();
                                visit.addVisitedURL(new VisitedURL(recognized_url, this.last_log_entry_date_long, is_page), log_format.getSize());
                                if (is_page) {
                                    ++visit.nbr_pages;
                                    long visit_last_page_date = visit.getLastVisitedPageDate();
                                    if (recognized_url != null) {
                                        recognized_url.incTotalVisitTime(this.last_log_entry_date_long - visit_last_page_date);
                                    }
                                }
                                String referer_host = "";
                                if (host_name.length() > 0) {
                                    referer_host = host_name;
                                }
                                if (this.recognize_referer) {
                                    String referer_str = log_format.getReferer();
                                    int referer_host_slash = referer_str.indexOf(47, 7);
                                    if (referer_host_slash == -1) {
                                        referer_str = String.valueOf(referer_str) + '/';
                                        referer_host_slash = referer_str.length() - 1;
                                    }
                                    if (referer_str.length() > 7) {
                                        referer_host = referer_str.substring(7, referer_host_slash);
                                    }
                                    if (new_visit && visitor_type.equals("human") && !datasource.isAlias(referer_host)) {
                                        referer_str = referer_str.replaceAll("(?i)%2D", "\\-");
                                        referer_str = referer_str.replaceAll("(?i)%2E", "\\.");
                                        Referer recognized_referer = (Referer)ht_referers.get(referer_str = referer_str.replaceAll("(?i)%C3%A0", "\u00e0"));
                                        boolean found_referer = recognized_referer != null;
                                        Enumeration e3 = HTTPStatisticsBuilder.referer_database.referers.elements();
                                        while (!found_referer && e3.hasMoreElements()) {
                                            Referer ref = (Referer)e3.nextElement();
                                            boolean display_keywords = false;
                                            boolean is_referer = ref.isURLParam ? ref.isReferer(log_format.getURL()) : ref.isReferer(referer_str);
                                            if (!is_referer) continue;
                                            if (display_keywords) {
                                                System.out.print(ref.getName());
                                            }
                                            String[] kw = ref.isURLParam ? ref.getKeywords(log_format.getURL()) : ref.getKeywords(referer_str);
                                            int j = 0;
                                            while (j < kw.length) {
                                                kw[j] = kw[j].toLowerCase();
                                                if (display_keywords) {
                                                    System.out.print(" " + kw[j]);
                                                }
                                                ++j;
                                            }
                                            if (display_keywords) {
                                                System.out.println();
                                            }
                                            found_referer = true;
                                            recognized_referer = ref;
                                            if (kw.length <= 0) continue;
                                            recognized_referer.stat.addKeywords(kw);
                                        }
                                        if (!found_referer && !referer_database.isBlackListed(recognized_referer = new Referer("staticpage", referer_str, null, null, null))) {
                                            referer_database.getRootRefererGroup().add(recognized_referer);
                                            ht_referers.put(referer_str, recognized_referer);
                                        }
                                        ++recognized_referer.stat.nbr_visits;
                                        recognized_referer.stat.setDate(this.last_log_entry_date_long);
                                        recognized_referer.stat.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                    }
                                }
                                if ((index_download_speed_tracker = page.indexOf(loganalyst_download_speed_tracker_filename = "/js/report_download_speed.js")) != -1) {
                                    Hashtable<String, String> ht_values = new Hashtable<String, String>();
                                    StringTokenizer st = new StringTokenizer(page.substring(index_download_speed_tracker + loganalyst_download_speed_tracker_filename.length() + 1), "=&");
                                    while (st.hasMoreTokens()) {
                                        ht_values.put(st.nextToken(), st.nextToken());
                                    }
                                    String speed_str = (String)ht_values.get("mean");
                                    if (speed_str != null) {
                                        visit.download_speed = Float.parseFloat(speed_str);
                                    }
                                }
                                Enumeration e4 = this.plugins.elements();
                                while (e4.hasMoreElements()) {
                                    GeneralPlugin p3 = (GeneralPlugin)e4.nextElement();
                                    p3.processRecord(log_format, visit, this.stats);
                                }
                                if (is_page && page.endsWith(".pdf") && visit.isPluginInstalled("<img src=images/useragent_icon/adobe.png> AcrobatReader") < 0) {
                                    visit.addInstalledPlugin("<img src=images/useragent_icon/adobe.png> AcrobatReader", true);
                                }
                                RecognizedOS recognized_os = null;
                                if (this.recognize_os && this.recognize_useragent) {
                                    recognized_os = this.getRecognizedOS(recognized_useragent, log_format, is_page, visit);
                                    if (is_page) {
                                        ++recognized_os.nbr_pages;
                                    }
                                    ++recognized_os.nbr_hits;
                                    recognized_os.size += log_format.getSize();
                                    recognized_os.setDate(this.last_log_entry_date_long);
                                }
                                if (!visit.isAliasRecognized() && datasource.isAlias(referer_host)) {
                                    RecognizedAlias recognized_alias = (RecognizedAlias)this.stats.statistic_bag.alias_histo.get(referer_host);
                                    if (recognized_alias == null) {
                                        recognized_alias = new RecognizedAlias(referer_host);
                                        this.stats.statistic_bag.alias_histo.put(referer_host, recognized_alias);
                                    }
                                    recognized_alias.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                    ++recognized_alias.nbr_visits;
                                    visit.setAliasRecognized(true);
                                }
                                if (new_visit) {
                                    UnknownUserAgent unknown_ua;
                                    UnknownOS unknown_os;
                                    if (recognized_host != null) {
                                        ++recognized_host.nbr_visits;
                                    }
                                    if (recognized_os != null) {
                                        ++recognized_os.nbr_visits;
                                        recognized_os.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                    }
                                    if (recognized_country != null) {
                                        ++recognized_country.nbr_visits;
                                    }
                                    if (recognized_useragent != null) {
                                        ++recognized_useragent.nbr_visits;
                                    }
                                    if ((unknown_os = (UnknownOS)this.stats.statistic_bag.ht_unknown_os.get(log_format.getUserAgent())) != null) {
                                        ++unknown_os.nbr_visits;
                                    }
                                    if ((unknown_ua = (UnknownUserAgent)HTTPStatistics.unknown_useragents.get(log_format.getUserAgent())) != null) {
                                        ++unknown_ua.nbr_visits;
                                        unknown_ua.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                    }
                                    ++server_activity_hour.nbr_visits;
                                    ++client_activity_hour.nbr_visits;
                                    this.stats.statistic_bag.daily_activity.update(this.last_log_entry_date_long, this.visit_incrementer);
                                    this.stats.server_daily_activity.update(this.last_log_entry_date_long, this.visit_incrementer);
                                    recognized_country.getDailyActivityStorage().update(this.last_log_entry_date_long, this.visit_incrementer);
                                }
                            }
                        }
                        ++this.stats.nbr_log_entries;
                        ligne = log_format.getNextEntry();
                        if (this.stats.nbr_log_entries % 20000L != 0L || this.stats.statistic_bag == null) continue;
                        int free_memory = (int)Runtime.getRuntime().freeMemory() / 0x100000;
                        t1 = System.currentTimeMillis();
                        System.out.println("Available memory:" + free_memory + " MB (" + (t1 - t02) / 1000L + " s for 20'000 records) " + LogFormat.df.format(new Date(this.last_log_entry_date_long)));
                        t02 = t1;
                        int min_free_memory = 30;
                        if (free_memory <= min_free_memory) {
                            System.out.println("WARNING: low memory, the visits URLs will be cleared (hosts visits will be less detailed).");
                            Iterator e = this.stats.statistic_bag.closed_visits.iterator();
                            while (e.hasNext()) {
                                Visit v = (Visit)e.next();
                                v.computeDownloadSpeed();
                                v.clearVisitedURLs();
                            }
                            System.gc();
                            free_memory = (int)Runtime.getRuntime().freeMemory() / 0x100000;
                            if (free_memory < min_free_memory) {
                                System.out.println("WARNING: low memory (the processing will be slowed and could lead to a crash. Please submit a bug).");
                                this.stats.displayMemoryUsage();
                            }
                        }
                        this.close_open_visits(this.stats.statistic_bag, this.last_log_entry_date_long);
                    }
                    if (is instanceof GZIPInputStream2) {
                        GZIPInputStream2 is2 = (GZIPInputStream2)is;
                        all_datasources_size_bak = all_datasources_size = all_datasources_size_bak - 20L * is2.getCompressedFileSize() + is2.getCompressedFileSize() * (long)is2.getInflater().getTotalOut() / (long)is2.getInflater().getTotalIn();
                    }
                    in.close();
                    lef.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.last_log_entry_date_long != 0L) {
            HTTPStatistics.last_day = this.last_log_entry_date_long;
        }
        System.out.println("                                                 ");
        HTTPStatistics.referer_group_root = referer_database.getRootRefererGroup();
        Iterator stat_bags_iter = this.stats.statistic_bags.values().iterator();
        while (stat_bags_iter.hasNext()) {
            statistic_bag = (StatisticBag)stat_bags_iter.next();
            this.close_open_visits(statistic_bag, this.last_log_entry_date_long);
        }
        stat_bags_iter = this.stats.statistic_bags.values().iterator();
        while (stat_bags_iter.hasNext()) {
            statistic_bag = (StatisticBag)stat_bags_iter.next();
            Iterator e = statistic_bag.closed_visits.iterator();
            while (e.hasNext()) {
                RecognizedScreenSize el;
                Visit v = (Visit)e.next();
                Dimension key = v.getScreenSize();
                if (key.width == -1 && key.height == -1) {
                    ArrayList pages = v.getVisitedPages();
                    Iterator e2 = pages.iterator();
                    while (e2.hasNext()) {
                        VisitedURL url = (VisitedURL)e2.next();
                        if (url.getURL() == null || !url.getURL().url.endsWith(".html") && !url.getURL().url.endsWith("/")) continue;
                        HTTPStatisticElement elem = (HTTPStatisticElement)statistic_bag.ht_undetailed_visits.get(url.getURL());
                        if (elem == null) {
                            elem = new HTTPStatisticElement();
                            statistic_bag.ht_undetailed_visits.put(url.getURL(), elem);
                        }
                        ++elem.nbr_pages;
                    }
                }
                if ((el = (RecognizedScreenSize)statistic_bag.ht_screen_size.get(key)) == null) {
                    el = new RecognizedScreenSize(key);
                    statistic_bag.ht_screen_size.put(key, el);
                }
                ++el.nbr_visits;
                long d = v.getLastVisitedPageDate();
                this.stat_el_full_updater.nbr_visits = 1L;
                this.stat_el_full_updater.nbr_pages = 0L;
                this.stat_el_full_updater.nbr_hits = 0L;
                this.stat_el_full_updater.size = 0L;
                el.getDailyActivityStorage().update(d, this.stat_el_full_updater);
                if (d <= el.getDate()) continue;
                el.setDate(d);
            }
        }
        String id = "referers_products";
        String id_searchengine = "searchengine";
        RefererGroup root_referer = referer_database.getRootRefererGroup();
        RefererGroup root_referer_product = new RefererGroup(id, ResourceBundle.getBundle("lang.Referer").getString(id));
        referer_database.setRootProductRefererGroup(root_referer_product);
        Vector product_referer_groups = HTTPStatistics.host.getProductRefererGroups();
        ArrayList<RefererOrRefererGroup> groups_to_move = new ArrayList<RefererOrRefererGroup>();
        Enumeration<TreeNode> e = root_referer.children();
        while (e.hasMoreElements()) {
            RefererGroup group2;
            group = (RefererOrRefererGroup)e.nextElement();
            if (product_referer_groups.contains(group.getID())) {
                groups_to_move.add(group);
                continue;
            }
            if (group.isLeaf() || !(group2 = (RefererGroup)group).getID().equals(id_searchengine)) continue;
            RefererGroup new_group = new RefererGroup(group2.getID(), group2.getName());
            root_referer_product.add(new_group);
            this.refererKeywords(group2, new_group);
        }
        Iterator iter = groups_to_move.iterator();
        while (iter.hasNext()) {
            group = (RefererOrRefererGroup)iter.next();
            root_referer.remove(group);
            root_referer_product.add(group);
        }
        int NBR_DAYS_IN_WEEK = 7;
        long CONVERSION_FACTOR_MS_TO_DAY = 86400000L;
        int nbr_activity_days = (int)((HTTPStatistics.last_day - HTTPStatistics.first_day) / CONVERSION_FACTOR_MS_TO_DAY);
        this.stats.nbr_activity_days = new int[NBR_DAYS_IN_WEEK];
        int i2 = 0;
        while (i2 < NBR_DAYS_IN_WEEK) {
            this.stats.nbr_activity_days[i2] = nbr_activity_days / NBR_DAYS_IN_WEEK;
            ++i2;
        }
        if (dns_threadpool != null && this.do_reverse_dns) {
            System.out.println("Waiting Reverse DNS queries...");
            dns_threadpool.waitTermination();
        }
        if (dns_threadpool_sorbs != null && this.do_sorbs) {
            System.out.println("Waiting SORBS DNS queries...");
            dns_threadpool_sorbs.waitTermination();
        }
        if (dns_threadpool_ahbl != null && this.do_ahbl) {
            System.out.println("Waiting AHBL DNS queries...");
            dns_threadpool_ahbl.waitTermination();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("\nSpeed: " + this.stats.nbr_log_entries * 1000L / (t1 - t0) + " records/second (" + this.stats.nbr_log_entries + " records, " + (t1 - t0) / 1000L + " seconds)");
        System.out.println("  " + nbr_corrupted_records + " corrupted record.");
        System.out.println("  " + nbr_unknown_countrycode + " unknown country code.");
    }

    public MultipleProxy getMultipleProxy(long ip) {
        Enumeration e = this.multiple_proxies.elements();
        while (e.hasMoreElements()) {
            MultipleProxy mp = (MultipleProxy)e.nextElement();
            if (!mp.hasIP(ip)) continue;
            return mp;
        }
        return null;
    }

    public void refererKeywords(RefererGroup group, RefererGroup group_product) {
        if (group.getChildCount() == 0) {
            return;
        }
        Enumeration<TreeNode> e2 = group.children();
        while (e2.hasMoreElements()) {
            RefererOrRefererGroup g = (RefererOrRefererGroup)e2.nextElement();
            if (g.isLeaf()) {
                Referer ref = (Referer)g;
                SearchEngineStatisticElement stat = ref.stat;
                Vector v_product_referer_keyphrases = HTTPStatistics.host.getProductRefererSearchEngineKeywords();
                Enumeration e3 = v_product_referer_keyphrases.elements();
                while (e3.hasMoreElements()) {
                    String[] product_keyphrase = (String[])e3.nextElement();
                    List list = stat.getKeyphrasesWithKeywords(product_keyphrase);
                    if (list.size() <= 0) continue;
                    Referer ref2 = new Referer(ref.getID(), ref.getName(), null, null, null);
                    group_product.add(ref2);
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        SearchEngineKeywords keywords = (SearchEngineKeywords)iter.next();
                        IntegerCounter count = ref.stat.getCount(keywords);
                        ref2.stat.addKeywords(keywords, count);
                        ref2.stat.nbr_visits += (long)count.i;
                        ref2.stat.setDate(ref.stat.getDate());
                        ref.stat.removeKeywords(keywords);
                    }
                }
                continue;
            }
            RefererGroup g2 = (RefererGroup)g;
            RefererGroup new_group_product = new RefererGroup(g2.getID(), g2.getName());
            group_product.add(new_group_product);
            this.refererKeywords(g2, new_group_product);
        }
    }

    public boolean isPage(String url) {
        int index_dot;
        int index_questionmark = url.indexOf(63);
        String url2 = url;
        if (index_questionmark != -1) {
            url2 = url2.substring(0, index_questionmark);
        }
        if ((index_dot = url2.lastIndexOf(46)) != -1) {
            url2 = url2.substring(index_dot);
        }
        url2 = url2.toLowerCase();
        String[] not_page_extension = new String[]{".js", ".jpg", ".gif", ".png", ".css", ".ico", ".class", ".bmp", ".jk2", ".tif", ".ppt", ".doc", ".xls"};
        int i = 0;
        while (i < not_page_extension.length) {
            if (url2.equals(not_page_extension[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toXML(String str) {
        return HTMLTools.cleanFromCSSA(str).replaceAll("&", "&amp;");
    }

    private void close_open_visits(StatisticBag stat_bag, long last_log_entry_date) {
        long visit_timeout = last_log_entry_date;
        visit_timeout -= (long)(this.visit_timeout_minutes * 60) * 1000L;
        Enumeration e = stat_bag.open_visits.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Visit visit = (Visit)stat_bag.open_visits.get(key);
            if (visit.getLastVisitedPageDate() >= visit_timeout) continue;
            visit.computeDownloadSpeed();
            stat_bag.open_visits.remove(key);
            stat_bag.closed_visits.add(visit);
            Enumeration e2 = PluginManager.getVisitPlugins().elements();
            while (e2.hasMoreElements()) {
                VisitPlugin vp = (VisitPlugin)e2.nextElement();
                vp.processVisit(visit, this.stats);
            }
            stat_bag.visit_map.addExitPoint(visit.getLastVisitedPage());
            stat_bag.daily_visit_duration.addVisit(last_log_entry_date, visit.getVisitDuration());
            if (visit.nbr_pages == 0L && visit.is_internal_referer) {
                Vector visits = visit.host.getVisits();
                int nbr_internal_refered_visits = 0;
                Enumeration e22 = visits.elements();
                while (e22.hasMoreElements()) {
                    if (!((Visit)e22.nextElement()).is_internal_referer) continue;
                    ++nbr_internal_refered_visits;
                }
                if (nbr_internal_refered_visits > visits.size() / 2) {
                    visit.host.incNbrProxyVotes();
                }
            }
            if (stat_bag.closed_visits.size() <= this.stats.max_nbr_closed_visits) continue;
            ((Visit)stat_bag.closed_visits.get(stat_bag.closed_visits.size() - this.stats.max_nbr_closed_visits - 1)).packVisitedURLs();
        }
    }

    public HostUserAgent getHostUserAgent(String ip_address) {
        HostUserAgent host_ua;
        Enumeration e = this.host_useragents_list.elements();
        while (e.hasMoreElements()) {
            host_ua = (HostUserAgentList)e.nextElement();
            if (!((HostUserAgentList)host_ua).matchesHostByIp(ip_address)) continue;
            return host_ua;
        }
        e = this.host_useragents.elements();
        while (e.hasMoreElements()) {
            host_ua = (HostUserAgent)e.nextElement();
            if (!host_ua.matchesHostByIp(ip_address)) continue;
            return host_ua;
        }
        return null;
    }

    public RecognizedUserAgent getRecognizedUserAgent(LogFormat log_format, boolean isPage, boolean human_ua_robots_txt_hit, boolean robot_trap_hit) {
        RecognizedUserAgent recognized_useragent;
        HostUserAgent host_useragent;
        String useragent_string = log_format.getUserAgent();
        if (useragent_database == null) {
            useragent_database = UserAgentDatabaseParser.getDefaultDatabase();
        }
        if ((host_useragent = this.getHostUserAgent(log_format.getHostAsString())) != null) {
            recognized_useragent = (RecognizedUserAgent)HTTPStatistics.ht_user_agent.get(log_format.getHostAsString());
            if (recognized_useragent == null) {
                recognized_useragent = new RecognizedUserAgent(host_useragent, "");
                HTTPStatistics.ht_user_agent.put(log_format.getHostAsString(), recognized_useragent);
            }
        } else {
            recognized_useragent = (RecognizedUserAgent)HTTPStatistics.ht_user_agent.get(useragent_string);
            if (recognized_useragent == null) {
                boolean found = false;
                String[] family_search_order = useragent_database.getFamilySearchOrder();
                if (family_search_order == null) {
                    family_search_order = new String[]{};
                }
                int i = 0;
                while (i < family_search_order.length) {
                    String familyid = family_search_order[i];
                    UserAgentFamily family = useragent_database.getUserAgentFamily(familyid);
                    Matcher m = family.regexp.matcher(useragent_string);
                    if (m.find()) {
                        Enumeration browsers = family.getUserAgents().elements();
                        while (browsers.hasMoreElements()) {
                            Matcher m2;
                            UserAgent browser = (UserAgent)browsers.nextElement();
                            if (browser.regexp == null || !(m2 = browser.regexp.matcher(useragent_string)).find()) continue;
                            String version = HTMLTools.cleanFromCSSA(m2.replaceAll(browser.versionid));
                            version = version.substring(0, Math.min(HTTPStatisticsBuilder.useragent_database.version_max_length, version.length()));
                            found = true;
                            recognized_useragent = new RecognizedUserAgent(browser, version);
                            HTTPStatistics.ht_user_agent.put(useragent_string, recognized_useragent);
                            break;
                        }
                        if (found) break;
                    }
                    ++i;
                }
            }
        }
        recognized_useragent.setHitRobotsTxtOR(human_ua_robots_txt_hit);
        recognized_useragent.setHitRobotTrapOR(robot_trap_hit);
        if (recognized_useragent.getUserAgent().getFamily().getId().equals("unknown") && recognized_useragent.getUserAgent().getId().equals("unknown")) {
            UnknownUserAgent unknown_ua = (UnknownUserAgent)HTTPStatistics.unknown_useragents.get(useragent_string);
            if (unknown_ua == null) {
                unknown_ua = new UnknownUserAgent(useragent_string);
                HTTPStatistics.unknown_useragents.put(useragent_string, unknown_ua);
            }
            ++unknown_ua.nbr_hits;
            if (isPage) {
                ++unknown_ua.nbr_pages;
            }
            this.stat_el_full_updater.nbr_visits = 0L;
            this.stat_el_full_updater.nbr_pages = isPage ? 1 : 0;
            this.stat_el_full_updater.nbr_hits = 1L;
            this.stat_el_full_updater.size = log_format.getSize();
            unknown_ua.getDailyActivityStorage().update(this.last_log_entry_date_long, this.stat_el_full_updater);
            unknown_ua.size += log_format.getSize();
            unknown_ua.setTime(this.last_log_entry_date_long);
            unknown_ua.addHost(log_format.getHostAsString(), human_ua_robots_txt_hit, robot_trap_hit);
            unknown_ua.setPageViewDate(log_format.getURL(), this.last_log_entry_date_long);
        }
        return recognized_useragent;
    }

    public RecognizedOS getRecognizedOS(RecognizedUserAgent recognized_useragent, LogFormat log_format, boolean isPage, Visit visit) {
        String useragent_string = log_format.getUserAgent();
        if (os_database == null) {
            os_database = OSDatabaseParser.getDefaultDatabase();
        }
        if (recognized_useragent == null) {
            return null;
        }
        RecognizedOS recognized_os = recognized_useragent.getRecognizedOS();
        if (recognized_useragent != null && recognized_os == null) {
            Enumeration os_list = HTTPStatisticsBuilder.os_database.os_list_order.elements();
            while (os_list.hasMoreElements()) {
                Matcher m2;
                OS os = (OS)os_list.nextElement();
                if (os.regexp == null || !(m2 = os.regexp.matcher(useragent_string)).find()) continue;
                recognized_os = (RecognizedOS)this.stats.statistic_bag.histo_os.get(os);
                if (recognized_os == null) {
                    recognized_os = new RecognizedOS(os);
                    this.stats.statistic_bag.histo_os.put(os, recognized_os);
                }
                recognized_useragent.setRecognizedOS(recognized_os);
                break;
            }
        }
        if (!recognized_os.os.id.equals("unknown")) {
            visit.setOS(recognized_os);
        } else if (visit.getOS() != null) {
            recognized_os = visit.getOS();
        } else {
            UnknownOS unknown_os = (UnknownOS)this.stats.statistic_bag.ht_unknown_os.get(useragent_string);
            if (unknown_os == null) {
                unknown_os = new UnknownOS(useragent_string, this.last_log_entry_date_long);
                this.stats.statistic_bag.ht_unknown_os.put(useragent_string, unknown_os);
            } else {
                ++unknown_os.nbr_hits;
                if (isPage) {
                    ++unknown_os.nbr_pages;
                }
                unknown_os.size += log_format.getSize();
                unknown_os.setDate(this.last_log_entry_date_long);
            }
        }
        return recognized_os;
    }

    public RecognizedWorm getRecognizedWorm(LogFormat log_format) {
        String url = log_format.getURL();
        if (worm_database == null) {
            worm_database = WormDatabaseParser.getDefaultDatabase();
        }
        boolean possible_worm = false;
        Enumeration e = worm_database.getPossibleWorms().elements();
        while (e.hasMoreElements()) {
            if (url.indexOf((String)e.nextElement()) == -1) continue;
            possible_worm = true;
            break;
        }
        if (!possible_worm) {
            return null;
        }
        e = worm_database.getWorms().elements();
        while (e.hasMoreElements()) {
            Worm worm = (Worm)e.nextElement();
            Matcher m2 = worm.regexp.matcher(url);
            if (!m2.find()) continue;
            RecognizedWorm recognized_worm = (RecognizedWorm)this.stats.ht_worms.get(worm);
            if (recognized_worm == null) {
                recognized_worm = new RecognizedWorm(worm);
                this.stats.ht_worms.put(worm, recognized_worm);
            }
            recognized_worm.setDate(this.last_log_entry_date_long);
            return recognized_worm;
        }
        return null;
    }

    public boolean isProxy(RecognizedHost recognized_host) {
        Enumeration e = this.proxies.elements();
        while (e.hasMoreElements()) {
            Proxy p = (Proxy)e.nextElement();
            if (recognized_host.ip_address != p.getIPAsLong()) continue;
            return true;
        }
        return false;
    }
}

