/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.logpsychoanalyst.report;

import ch.kronospace.logpsychoanalyst.DNSQueryAHBL;
import ch.kronospace.logpsychoanalyst.DNSQuerySORBS;
import ch.kronospace.logpsychoanalyst.DailyActivityStorage;
import ch.kronospace.logpsychoanalyst.DailyActivityStorageOwner;
import ch.kronospace.logpsychoanalyst.HTTPStatisticElement;
import ch.kronospace.logpsychoanalyst.HistoryGraphEvent;
import ch.kronospace.logpsychoanalyst.Host;
import ch.kronospace.logpsychoanalyst.IntegerCounter;
import ch.kronospace.logpsychoanalyst.ProcessingOptions;
import ch.kronospace.logpsychoanalyst.Recognized404Error;
import ch.kronospace.logpsychoanalyst.RecognizedHost;
import ch.kronospace.logpsychoanalyst.RecognizedLanguage;
import ch.kronospace.logpsychoanalyst.RecognizedPlugin;
import ch.kronospace.logpsychoanalyst.RecognizedURL;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgent;
import ch.kronospace.logpsychoanalyst.RecognizedUserAgentFamily;
import ch.kronospace.logpsychoanalyst.RecognizedWorm;
import ch.kronospace.logpsychoanalyst.RefererGroup;
import ch.kronospace.logpsychoanalyst.RefererOrRefererGroup;
import ch.kronospace.logpsychoanalyst.ReverseDNSQuery;
import ch.kronospace.logpsychoanalyst.SearchEngineKeywords;
import ch.kronospace.logpsychoanalyst.SearchEngineStatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticBag;
import ch.kronospace.logpsychoanalyst.StatisticElement;
import ch.kronospace.logpsychoanalyst.StatisticElementArrayGetter;
import ch.kronospace.logpsychoanalyst.StatisticsTable;
import ch.kronospace.logpsychoanalyst.URLGroup;
import ch.kronospace.logpsychoanalyst.UnknownUserAgent;
import ch.kronospace.logpsychoanalyst.UserAgent;
import ch.kronospace.logpsychoanalyst.UserAgentFamily;
import ch.kronospace.logpsychoanalyst.Visit;
import ch.kronospace.logpsychoanalyst.VisitCharacteristics;
import ch.kronospace.logpsychoanalyst.VisitIncrementer;
import ch.kronospace.logpsychoanalyst.VisitedURL;
import ch.kronospace.logpsychoanalyst.database.OSDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.RefererDatabaseParser;
import ch.kronospace.logpsychoanalyst.database.UserAgentDatabaseParser;
import ch.kronospace.logpsychoanalyst.geography.IPGeographyUtil;
import ch.kronospace.logpsychoanalyst.logformat.LogFormat;
import ch.kronospace.logpsychoanalyst.plugins.PluginManager;
import ch.kronospace.logpsychoanalyst.plugins.advisor.AdvisorPlugin;
import ch.kronospace.logpsychoanalyst.plugins.report.ReportPlugin;
import ch.kronospace.logpsychoanalyst.report.HTTPStatistics;
import ch.kronospace.logpsychoanalyst.report.HTTPStatisticsBuilder;
import ch.kronospace.logpsychoanalyst.report.ReportBuilder;
import ch.kronospace.logpsychoanalyst.report.ReportBuilderFactory;
import ch.kronospace.logpsychoanalyst.report.Statistics;
import ch.kronospace.logpsychoanalyst.report.StatisticsBuilder;
import ch.kronospace.tools.DiskTools;
import ch.kronospace.tools.HTMLTools;
import ch.kronospace.tools.PiePlot3D2;
import ch.kronospace.tools.SortableCategoryDataset;
import ch.kronospace.tools.SortablePieDataset;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.tree.TreeNode;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.RectangleInsets;
import org.jrobin.graph.LinearInterpolator;
import org.jrobin.graph.Plottable;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public class HTTPStatisticsHTMLReportBuilder
implements ReportBuilder {
    Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.BLACK, Color.CYAN, Color.GRAY, Color.ORANGE.darker(), Color.MAGENTA, Color.GREEN.darker().darker(), Color.PINK};
    public int nbr_displayed_hosts = 10;
    public int nbr_displayed_countries = 10;
    public int nbr_displayed_bad_links = 10;
    public int nbr_displayed_bad_referer_links = 10;
    public int nbr_displayed_os = 10;
    public int nbr_displayed_pages = 10;
    public int nbr_displayed_referers = 13;
    public boolean report_unknown_language = false;
    public boolean generate_visit_map = false;
    boolean do_sorbs = false;
    boolean do_ahbl = false;
    public boolean generate_detailed_useragent_graphs = true;
    public boolean generate_detailed_unknow_ua_graphs = true;
    public GregorianCalendar[] timestamps_hours = new GregorianCalendar[HTTPStatistics.nbr_bins_server_activity_hours + 1];
    public GregorianCalendar[] timestamps_days_of_week = new GregorianCalendar[8];
    public GregorianCalendar[] timestamps_days = null;
    final String unknown_icon = "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">";
    final String details_icon = "<img src=\"images/details.png\" border=0>";
    final String URL_IMAGE_YES = "<img src=\"images/yes.png\" border=0>";
    final String URL_IMAGE_NO = "<img src=\"images/no.png\" border=0>";
    public HTTPStatisticsBuilder stat_builder = null;
    private double avg_pages_per_visit = -1.0;
    public Host host;
    public String report_directory = null;
    Vector plugins = PluginManager.getReportPlugins();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("ch.kronospace.logpsychoanalyst.report.HTTPStatisticsHTMLReportBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("ch.kronospace.logpsychoanalyst.report.HTTPStatistics");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ReportBuilderFactory.registerReportBuilder(clazz2, clazz);
    }

    public HTTPStatisticsHTMLReportBuilder() {
        int hours_in_day = 24;
        int minutes_in_hour = 60;
        int i = 0;
        while (i < this.timestamps_hours.length - 1) {
            double full_hour = (double)i * (double)hours_in_day / (double)(this.timestamps_hours.length - 1);
            int hour = (int)full_hour;
            int minute = (int)((full_hour - (double)hour) * (double)minutes_in_hour);
            this.timestamps_hours[i] = new GregorianCalendar(2004, 2, 1, hour, minute, 0);
            ++i;
        }
        this.timestamps_hours[this.timestamps_hours.length - 1] = new GregorianCalendar(2004, 2, 1, hours_in_day, 0, 0);
        i = 0;
        while (i < this.timestamps_days_of_week.length - 1) {
            this.timestamps_days_of_week[i] = new GregorianCalendar(2004, 9, 3 + i, 0, 0, 0);
            ++i;
        }
        this.timestamps_days_of_week[this.timestamps_days_of_week.length - 1] = new GregorianCalendar(2004, 9, 10, 0, 0, 0);
    }

    public double log2(double n) {
        return Math.log(n) / Math.log(2.0);
    }

    public void setStatisticsBuilder(StatisticsBuilder stat_builder) {
        this.stat_builder = (HTTPStatisticsBuilder)stat_builder;
    }

    public void buildReport(Statistics statistics) {
        long t0 = System.currentTimeMillis();
        HTTPStatistics stats = (HTTPStatistics)statistics;
        this.host = HTTPStatistics.host;
        ProcessingOptions po = this.host.getProcessingOptionsAsProcessingOptions();
        this.nbr_displayed_hosts = 10;
        this.nbr_displayed_countries = 10;
        this.nbr_displayed_bad_links = 10;
        this.nbr_displayed_bad_referer_links = 10;
        this.nbr_displayed_os = 10;
        this.nbr_displayed_pages = 10;
        this.nbr_displayed_referers = 13;
        this.report_unknown_language = false;
        this.generate_visit_map = po.getGenerateVisitMapAsBoolean();
        this.generate_detailed_useragent_graphs = po.getGenerateDetailedUseragentReportsAsBoolean();
        this.generate_detailed_unknow_ua_graphs = po.getGenerateDetailedUnknownUseragentsReportsAsBoolean();
        this.do_sorbs = po.getSorbsAsBoolean();
        this.do_ahbl = po.getAhblAsBoolean();
        GregorianCalendar first_report_day = new GregorianCalendar(2004, 11, 1);
        GregorianCalendar last_report_day = new GregorianCalendar(2005, 11, 31);
        first_report_day.setTimeInMillis(HTTPStatistics.first_day);
        last_report_day.setTimeInMillis(HTTPStatistics.last_day);
        int nbr_days_in_report = (int)(last_report_day.getTimeInMillis() / 86400000L) - (int)(first_report_day.getTimeInMillis() / 86400000L);
        this.timestamps_days = new GregorianCalendar[nbr_days_in_report];
        int i = 0;
        while (i < this.timestamps_days.length) {
            GregorianCalendar current_date = (GregorianCalendar)first_report_day.clone();
            current_date.add(6, i);
            this.timestamps_days[i] = current_date;
            ++i;
        }
        File file_report_directory = new File(HTTPStatistics.host.getConfigDirectory(), "/report/");
        if (!file_report_directory.exists()) {
            file_report_directory.mkdirs();
            DiskTools.uncompressFile(new File("data/report.zip"), HTTPStatistics.host.getConfigDirectory());
        }
        this.report_directory = String.valueOf(file_report_directory.getPath()) + "/";
        UserAgentDatabaseParser.getDefaultDatabase();
        OSDatabaseParser.getDefaultDatabase();
        try {
            Recognized404Error ua;
            String bad_url;
            PrintWriter out_report;
            PrintWriter out_report3 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + "index.html"));
            out_report3.println(this.getReportHeader());
            out_report3.println("<title>Report: " + HTTPStatistics.host.getDomainName() + "</title>");
            out_report3.println("<h1>Report for " + HTTPStatistics.host.getDomainName() + "</h1>");
            out_report3.println("<p>Period: " + LogFormat.df.format(new Date(HTTPStatistics.first_day)) + " &nbsp;-&nbsp; " + LogFormat.df.format(new Date(HTTPStatistics.last_day)));
            out_report3.println("<p>");
            Iterator stat_bags_iter = stats.statistic_bags.values().iterator();
            while (stat_bags_iter.hasNext()) {
                StatisticBag statistic_bag = (StatisticBag)stat_bags_iter.next();
                out_report3.println("<a href=index." + statistic_bag.visitor_type + ".html>" + statistic_bag.visitor_type + "</a> - ");
            }
            out_report3.println("<a href=index.server.html>Server stats</a>");
            out_report3.println("<h2>Executive Summary</h2>");
            out_report3.println("<p>Note: server statistics are given in the server time zone.");
            String ua_unknown_filename = "ua_unknown.html";
            String activity_hours_filename = "activity_hours.png";
            String activity_hours_download_filename = "activity_hours_download.png";
            String activity_days_filename = "activity_days.png";
            String activity_days_download_filename = "activity_days_download.png";
            String activity_year_filename = "activity_year.png";
            String activity_year_download_filename = "activity_year_download.png";
            String activity_year_per_visit_filename = "activity_year_per_visit.png";
            String visit_duration_per_day_filename = "visit_duration_per_day.png";
            PrintWriter out_report2 = null;
            Iterator stat_bags_iter2 = stats.statistic_bags.values().iterator();
            while (stat_bags_iter2.hasNext()) {
                StatisticBag statistic_bag = (StatisticBag)stat_bags_iter2.next();
                out_report = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + "index." + statistic_bag.visitor_type + ".html"));
                out_report.println(this.getReportHeader());
                out_report.println("<h1>Report for " + HTTPStatistics.host.getDomainName() + "</h1>");
                out_report.println("<h2>" + statistic_bag.visitor_type + "</h2>");
                out_report.println("<h3>When have the site been visited...</h3>");
                out_report.println("<p><table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Visit duration</td><td align=right><a href=help/visit_duration.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=2>");
                out_report.println("<img src=\"" + statistic_bag.visitor_type + ".visit_duration.png\">");
                out_report.println("<img src=\"" + statistic_bag.visitor_type + "." + visit_duration_per_day_filename + "\">");
                out_report.println("</td></tr></table>");
                this.writeGraphic(this.timestamps_days, statistic_bag.daily_visit_duration.getDailyActivityStorage(), String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + visit_duration_per_day_filename, false, new StatisticElementArrayGetter[]{statistic_bag.daily_visit_duration.getter}, "Mean visit duration [s]", "days", "", 366, 150, 14);
                out_report.println("<p><table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Daily activity</td><td align=right><a href=help/activity_day.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=2>");
                out_report.println("<img src=\"" + statistic_bag.visitor_type + "." + activity_hours_filename + "\">");
                out_report.println("<img src=\"" + statistic_bag.visitor_type + "." + activity_hours_download_filename + "\">");
                out_report.println("</td></tr></table>");
                this.writeImageStatisticElementArray(this.timestamps_hours, statistic_bag.activity_hours, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_hours_filename, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_hours_download_filename, false, stats.nbr_activity_days);
                out_report.println("<p><table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Weekly activity</td><td align=right><a href=help/activity_week.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=2>");
                String activity_day_tag = "<img src=" + statistic_bag.visitor_type + "." + activity_days_filename + ">";
                out_report.println(activity_day_tag);
                out_report.println("<img src=" + statistic_bag.visitor_type + "." + activity_days_download_filename + ">");
                HTTPStatisticElement mean_activity_week = new HTTPStatisticElement();
                int nbr_days = 0;
                StatisticElement[] daily_activity_for_mean = statistic_bag.daily_activity.getRange(this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
                int i2 = 0;
                while (i2 < daily_activity_for_mean.length) {
                    HTTPStatisticElement el = (HTTPStatisticElement)daily_activity_for_mean[i2];
                    if (el.nbr_hits > 0L) {
                        ++nbr_days;
                    }
                    mean_activity_week.nbr_hits += el.nbr_hits;
                    mean_activity_week.nbr_pages += el.nbr_pages;
                    mean_activity_week.nbr_visits += el.nbr_visits;
                    mean_activity_week.size += el.size;
                    ++i2;
                }
                String activity_day_average = "<p>Average: " + this.round((double)(mean_activity_week.nbr_visits * 7L) / (double)nbr_days, 1) + " visits/week, " + this.round((double)(mean_activity_week.nbr_pages * 7L) / (double)nbr_days, 1) + " pages/week, " + this.round((double)(mean_activity_week.nbr_hits * 7L) / (double)nbr_days, 1) + ", hits/week.";
                out_report.println(activity_day_average);
                out_report.println("</td></tr></table>");
                this.writeGraphic(this.timestamps_days_of_week, statistic_bag.daily_activity, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_days_filename, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_visits_weekdays, HTTPStatisticElement.getter_pages_weekdays, HTTPStatisticElement.getter_hits_weekdays}, "", "days", "", 366, 150, 1, this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
                this.writeGraphic(this.timestamps_days_of_week, statistic_bag.daily_activity, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_days_download_filename, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_sizes_weekdays}, "", "days", "", 366, 150, 1, this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
                out_report.println("<p><table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Yearly activity</td><td align=right><a href=help/activity_year.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=2>");
                String activity_year_tag = "<img src=" + statistic_bag.visitor_type + "." + activity_year_filename + ">";
                out_report.println(activity_year_tag);
                out_report.println("<img src=" + statistic_bag.visitor_type + "." + activity_year_download_filename + ">");
                String activity_year_average = "<p>Average: " + this.round((double)mean_activity_week.nbr_visits / (double)nbr_days, 1) + " visits/day, " + this.round((double)mean_activity_week.nbr_pages / (double)nbr_days, 1) + " pages/day, " + this.round((double)mean_activity_week.nbr_hits / (double)nbr_days, 1) + ", hits/day.";
                out_report.println(activity_year_average);
                out_report.println("</td></tr></table>");
                this.writeGraphic(this.timestamps_days, statistic_bag.daily_activity, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_year_filename, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_visits, HTTPStatisticElement.getter_pages, HTTPStatisticElement.getter_hits}, "", "days", "", 366, 150, 14);
                this.writeGraphic(this.timestamps_days, statistic_bag.daily_activity, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_year_download_filename, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_sizes}, "Download", "days", "bytes", 366, 150, 14);
                if (statistic_bag.visitor_type.equals("human")) {
                    out_report3.println("<p>Yearly activity (per day):");
                    out_report3.println("<p>" + activity_year_tag);
                    out_report3.println(activity_year_average);
                }
                out_report.println("<p><table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Hits and pages per visit</td><td align=right><a href=help/activity_year.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=2>");
                String page_per_visit_tag = "<img src=" + statistic_bag.visitor_type + "." + activity_year_per_visit_filename + ">";
                out_report.println(page_per_visit_tag);
                StatisticElement[] daily_activity_temp = statistic_bag.daily_activity.getRange(this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
                long total_nbr_hits_per_visit = 0L;
                long total_nbr_pages_per_visit = 0L;
                long total_nbr_visits = 0L;
                int i3 = 0;
                while (i3 < daily_activity_temp.length) {
                    HTTPStatisticElement el = (HTTPStatisticElement)daily_activity_temp[i3];
                    long nbr_visits = el.nbr_visits;
                    if (nbr_visits > 0L) {
                        long nbr_hits = el.nbr_hits;
                        long nbr_pages = el.nbr_pages;
                        total_nbr_hits_per_visit += nbr_hits;
                        total_nbr_pages_per_visit += nbr_pages;
                        total_nbr_visits += nbr_visits;
                    }
                    ++i3;
                }
                double avg_pages_per_visit = this.round((double)total_nbr_pages_per_visit / (double)total_nbr_visits, 1);
                this.setAveragePagesPerVisit(avg_pages_per_visit);
                String page_per_visit_average = "<p>Average: " + avg_pages_per_visit + " pages/visit, " + this.round((double)total_nbr_hits_per_visit / (double)total_nbr_visits, 1) + " hits/visit";
                out_report.println(page_per_visit_average);
                out_report.println("</td></tr></table>");
                this.writeGraphic(this.timestamps_days, statistic_bag.daily_activity, String.valueOf(this.report_directory) + statistic_bag.visitor_type + "." + activity_year_per_visit_filename, false, new StatisticElementArrayGetter[]{VisitCharacteristics.getter_pages_per_visit, VisitCharacteristics.getter_hits_per_visit}, "Hits and pages per visit", "days", "", 366, 150, 14);
                if (statistic_bag.visitor_type.equals("human")) {
                    out_report3.println("<p>Pages and hits per visit (per day):");
                    out_report3.println("<p>" + page_per_visit_tag);
                    out_report3.println(page_per_visit_average);
                }
                statistic_bag.mergeUserAgents(HTTPStatistics.ht_user_agent);
                statistic_bag.computePluginHistogram();
                statistic_bag.zero_duration_visit = new Visit(null, 0L);
                statistic_bag.nbr_unknown_download_speed = 0;
                VisitIncrementer visit_incrementer = new VisitIncrementer();
                Object e = statistic_bag.closed_visits.iterator();
                while (e.hasNext()) {
                    int index;
                    Visit v = (Visit)e.next();
                    long duration = v.getVisitDuration();
                    if (duration == 0L) {
                        statistic_bag.zero_duration_visit.merge(v);
                        ++statistic_bag.nbr_zero_duration_visits;
                    } else {
                        index = (int)((duration /= 1000L) * (long)stats.nbr_bins_visit_duration_histo / (long)(stats.max_visit_duration * 60));
                        int min = index * stats.max_visit_duration * 60 / stats.nbr_bins_visit_duration_histo;
                        int max = (index + 1) * stats.max_visit_duration * 60 / stats.nbr_bins_visit_duration_histo;
                        if (duration < (long)min || duration > (long)max) {
                            System.out.println("ERROR: d=" + duration + " = " + min + ".." + max + "   (index=" + index + ")");
                        }
                        int n = index = Math.min(statistic_bag.histo_visit_duration.length - 1, index);
                        statistic_bag.histo_visit_duration[n] = statistic_bag.histo_visit_duration[n] + 1;
                        statistic_bag.total_visit_length += duration;
                    }
                    if (v.download_speed < 0.0f) {
                        ++statistic_bag.nbr_unknown_download_speed;
                    } else {
                        int n = index = Math.min(statistic_bag.nbr_bins_download_speed_histo - 1, Math.max(0, (int)Math.floor((this.log2(v.download_speed) - this.log2(statistic_bag.min_download_speed)) * (double)(statistic_bag.nbr_bins_download_speed_histo - 1) / (this.log2(statistic_bag.max_download_speed) - this.log2(statistic_bag.min_download_speed)))));
                        statistic_bag.download_speed_histo[n] = statistic_bag.download_speed_histo[n] + 1;
                        statistic_bag.daily_download_speed.addVisit(v.getFirstHitDate(), v.download_speed);
                    }
                    if (v.ht_languages.size() == 0 && this.report_unknown_language) {
                        String language = "Unknown language";
                        RecognizedLanguage recognized_language = (RecognizedLanguage)statistic_bag.ht_languages.get(language);
                        if (recognized_language == null) {
                            recognized_language = new RecognizedLanguage(language);
                            statistic_bag.ht_languages.put(language, recognized_language);
                        }
                        ++recognized_language.nbr_visits;
                        recognized_language.getDailyActivityStorage().update(v.getFirstHitDate(), visit_incrementer);
                        recognized_language.setDate(v.getFirstHitDate());
                    }
                    Enumeration e4 = v.ht_languages.keys();
                    while (e4.hasMoreElements()) {
                        String language = (String)e4.nextElement();
                        Float pref = (Float)v.ht_languages.get(language);
                        if (pref == null) continue;
                        RecognizedLanguage recognized_language = (RecognizedLanguage)statistic_bag.ht_languages.get(language);
                        if (recognized_language == null) {
                            recognized_language = new RecognizedLanguage(language);
                            statistic_bag.ht_languages.put(language, recognized_language);
                        }
                        ++recognized_language.nbr_visits;
                        recognized_language.getDailyActivityStorage().update(v.getFirstHitDate(), visit_incrementer);
                        recognized_language.setDate(v.getFirstHitDate());
                    }
                }
                e = this.plugins.elements();
                while (e.hasMoreElements()) {
                    ReportPlugin p = (ReportPlugin)e.nextElement();
                    out_report.println(p.getReport(this, statistic_bag.visitor_type));
                }
                out_report.println("<h3>From where comes the visitors...</h3>");
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.histo_country, this.report_directory, false, HTTPStatisticElement.getter_visits));
                String hosts_report_directory = String.valueOf(this.report_directory) + "hosts/" + statistic_bag.visitor_type + "/";
                new File(hosts_report_directory).mkdirs();
                int min_visits_histo = 20;
                Iterator e2 = statistic_bag.histo_hosts.values().iterator();
                while (e2.hasNext()) {
                    RecognizedHost h = (RecognizedHost)e2.next();
                    Vector visites = h.getVisits();
                    if (visites.size() < min_visits_histo) continue;
                    double[] ivi = new double[visites.size() - 1];
                    Visit previous_visit = (Visit)visites.elementAt(0);
                    int i4 = 0;
                    while (i4 < ivi.length) {
                        Visit current_visit = (Visit)visites.elementAt(i4 + 1);
                        ivi[i4] = ((double)current_visit.last_hit_date / 1000.0 - (double)previous_visit.last_hit_date / 1000.0) / 3600.0;
                        previous_visit = current_visit;
                        ++i4;
                    }
                    this.writeHist(ivi, String.valueOf(hosts_report_directory) + IPGeographyUtil.getIP(h.ip_address) + ".png", 150, 100, 50);
                }
                String host_details_filename = String.valueOf(statistic_bag.visitor_type) + ".hosts_details.html";
                out_report.println("<p>");
                out_report.println(this.makeReportTable(statistic_bag.histo_hosts, true, "VPHB", host_details_filename, null, "hosts.html", ""));
                ArrayList hosts = new ArrayList(statistic_bag.histo_hosts.values());
                Collections.sort(hosts, HTTPStatisticElement.COMPARATOR_VISITS);
                RecognizedHost total_host = new RecognizedHost(0L);
                Iterator e3 = hosts.iterator();
                while (e3.hasNext()) {
                    total_host.merge((RecognizedHost)e3.next());
                }
                out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + host_details_filename));
                out_report2.println(this.getReportHeader());
                out_report2.println("<script type=\"text/javascript\" src=\"folding.js\"></script>");
                out_report2.println("<table class=\"reporttable\" width=100%>");
                out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Hosts</td><td align=right><a href=help/hosts.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report2.println("<tr><td colspan=3>");
                out_report2.println("<table id=\"t_" + statistic_bag.visitor_type + "hosts_details\" class=\"sortable\">");
                out_report2.println("  <tr>");
                out_report2.println("    <th>Host</th><th>Host type</th><th>Visits</th><th>Pages</th><th>Hits</th><th>Bandwidth</th><th>Visits details</th>");
                out_report2.println("  </tr>");
                int nbr_hosts = 0;
                Iterator e4 = hosts.iterator();
                while (e4.hasNext()) {
                    InetAddress[] ips;
                    RecognizedHost host = (RecognizedHost)e4.next();
                    String host_name = (String)ReverseDNSQuery.resolved_hosts.get(host);
                    if (host_name != null) {
                        host.setHostName(host_name);
                    }
                    StringBuffer visit_text = new StringBuffer(host.getVisits().size() * 100);
                    int num_visit = 1;
                    Enumeration e22 = host.getVisits().elements();
                    while (e22.hasMoreElements()) {
                        Visit v = (Visit)e22.nextElement();
                        String useragent = "";
                        if (v.getUserAgent() != null) {
                            useragent = String.valueOf(v.getUserAgent().getUserAgent().getId()) + " " + v.getUserAgent().version;
                        }
                        visit_text.append("Visit " + num_visit++ + " (" + LogFormat.df.format(new Date(v.getFirstHitDate())) + ", " + v.getVisitDuration() / 1000L + " s)<br>" + useragent + "<br>");
                        if (v.getVisitedPages().size() <= 0) continue;
                        Iterator e32 = v.getVisitedPages().iterator();
                        while (e32.hasNext()) {
                            VisitedURL vu = (VisitedURL)e32.next();
                            String url = "null";
                            if (vu.getURL() == null) continue;
                            url = vu.getURL().url;
                            visit_text.append(String.valueOf(LogFormat.df.format(new Date(vu.getDate()))) + " " + url + "<br>");
                        }
                        visit_text.append("<br>");
                    }
                    String country_code = IPGeographyUtil.getCountryCode(host.ip_address);
                    String proxy_string = "";
                    if (host.getNbrProxyVotes() > 0) {
                        proxy_string = "<br>Proxy identification: " + host.getNbrProxyVotes() + " votes";
                    }
                    String ip = IPGeographyUtil.getIP(host.ip_address);
                    String sorbs_text = "";
                    if (this.do_sorbs) {
                        boolean listed_in_sorbs;
                        ips = (InetAddress[])DNSQuerySORBS.resolved_hosts.get(host);
                        boolean bl = listed_in_sorbs = ips.length > 0;
                        if (listed_in_sorbs) {
                            sorbs_text = "<br><a title=\"This host is listed in SORBS, an spam email server detector (the number matchings is in parenthesis)\" href=\"http://www.sorbs.net/lookup.shtml?" + ip + "\"><img src=images/sorbs.png>(" + ips.length + ")</a>:";
                            int i5 = 0;
                            while (i5 < ips.length) {
                                sorbs_text = String.valueOf(sorbs_text) + DNSQuerySORBS.sorbs_codes[Integer.parseInt(ips[i5].getHostAddress().replaceFirst("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)", "$4"))] + ",";
                                ++i5;
                            }
                            sorbs_text = sorbs_text.substring(0, sorbs_text.length() - 1);
                        }
                    }
                    String ahbl_text = "";
                    if (this.do_ahbl) {
                        boolean listed_in_ahbl;
                        ips = (InetAddress[])DNSQueryAHBL.resolved_hosts.get(host);
                        boolean bl = listed_in_ahbl = ips.length > 0;
                        if (listed_in_ahbl) {
                            ahbl_text = "<br><a title=\"This host is listed in AHBL (The Abusive Hosts Blocking List)\" href=\"http://www.ahbl.org/tools/lookup.php?ip=" + ip + "\">AHBL(" + ips.length + ")</a>:";
                            int i6 = 0;
                            while (i6 < ips.length) {
                                ahbl_text = String.valueOf(ahbl_text) + DNSQueryAHBL.ahbl_codes[Integer.parseInt(ips[i6].getHostAddress().replaceFirst("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)", "$4"))] + ",";
                                ++i6;
                            }
                            ahbl_text = ahbl_text.substring(0, ahbl_text.length() - 1);
                        }
                    }
                    String visit_text2 = "<script language=\"javascript\">sID='" + host.ip_address + "';writePM(sID)</script><script language=\"javascript\">startA('s'+sID)</script>Visit details<script language=\"javascript\">endA()</script><div id=\"s" + host.ip_address + "\"><script language=\"javascript\">chkHide('s'+sID);</script><div>" + visit_text + "</div></div>";
                    out_report2.println("<tr><td valign=top><a href=\"http://www.whois.sc/" + host.getHostName() + "\" rel=nofollow>" + host.getName() + "</a>" + "<br><img src=\"images/country_flag/" + country_code.toLowerCase() + ".gif\"> " + new Locale("en", country_code).getDisplayCountry() + (host.nbr_visits >= (long)min_visits_histo ? "<br><img src=hosts/" + statistic_bag.visitor_type + "/" + IPGeographyUtil.getIP(host.ip_address) + ".png>" : "") + "</td><td align=right valign=top>" + sorbs_text + ahbl_text + proxy_string + "</td><td align=right valign=top>" + host.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + host.nbr_visits * 100L / Math.max(1L, total_host.nbr_visits) + "%)</td><td align=right valign=top>" + host.nbr_pages + "&nbsp;&nbsp;&nbsp;(" + host.nbr_pages * 100L / Math.max(1L, total_host.nbr_pages) + "%)</td><td align=right valign=top>" + host.nbr_hits + "&nbsp;&nbsp;&nbsp;(" + host.nbr_hits * 100L / Math.max(1L, total_host.nbr_hits) + "%)</td><td align=right valign=top>" + this.longToDownloadQuantity(host.size) + "&nbsp;&nbsp;&nbsp;(" + host.size * 100L / Math.max(1L, total_host.size) + "%)</td><td valign=top width=50%>" + visit_text2 + "</td></tr>");
                    if (++nbr_hosts <= 1000) continue;
                    out_report2.println("<table id=\"t_" + statistic_bag.visitor_type + "hosts_details\" class=\"sortable\">");
                    out_report2.println("  <tr>");
                    out_report2.println("    <th>Host</th><th>Host type</th><th>Visits</th><th>Pages</th><th>Hits</th><th>Bandwidth</th><th>Visits details</th>");
                    out_report2.println("  </tr>");
                    nbr_hosts = 0;
                }
                out_report2.println("</table>");
                out_report2.println("<p>Total: " + hosts.size() + " hosts (" + total_host.nbr_visits + " visits, " + total_host.nbr_pages + " pages, " + total_host.nbr_hits + " hits, " + this.longToDownloadQuantity(total_host.size) + ")");
                out_report2.println("</td></tr></table>");
                out_report2.close();
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.alias_histo, this.report_directory, false, HTTPStatisticElement.getter_visits));
                if (statistic_bag.visitor_type.equals("human")) {
                    this.makeRefererReport(stats, statistic_bag, out_report, this.report_directory);
                }
                System.out.println("Building page report...");
                out_report.println("<h3>What visitors have seen...</h3>");
                statistic_bag.url_group_manager.root.computeTotals();
                String pages_details_rep = "pages/" + statistic_bag.visitor_type;
                new File(file_report_directory, pages_details_rep).mkdirs();
                String pages_details_filename = String.valueOf(pages_details_rep) + "/" + statistic_bag.visitor_type + ".pages." + statistic_bag.url_group_manager.root.group_id + ".html";
                out_report.println("<p>");
                out_report.println("<table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Page popularity (Top " + this.nbr_displayed_pages + ") - <a href=\"" + pages_details_filename + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a></td><td align=right><a href=help/pages.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=3>");
                out_report.println("<table id=\"t_" + statistic_bag.visitor_type + "pages\" class=\"sortable\">");
                out_report.println("  <tr>");
                out_report.println("    <th>URL</th><th>Pages</th><td>Prints</th><th>Bandwidth</th>");
                out_report.println("  </tr>");
                int nbr_pages = 0;
                statistic_bag.url_group_manager.root.computeTotals();
                statistic_bag.url_group_manager.root.sort();
                HTTPStatisticElement total_displayed_pages = new HTTPStatisticElement();
                Enumeration<TreeNode> e5 = statistic_bag.url_group_manager.root.children();
                while (nbr_pages < this.nbr_displayed_pages && e5.hasMoreElements()) {
                    String name;
                    URLGroup group = (URLGroup)e5.nextElement();
                    RecognizedURL url = group.stat;
                    total_displayed_pages.merge(url);
                    if (group.getAllowsChildren()) {
                        name = group.getDirectoryNameHTML();
                    } else {
                        name = group.getFileName();
                        if (name.length() == 0) {
                            name = "/";
                        }
                    }
                    out_report.println("<tr><td>" + name + "</td><td>" + url.nbr_pages + "</td><td>" + url.nbr_prints + "</td><td>" + this.longToDownloadQuantity(url.size) + "</td></tr>");
                    ++nbr_pages;
                }
                out_report.println("</table>");
                out_report.println("<p>Others: " + (statistic_bag.url_group_manager.root.stat.nbr_pages - total_displayed_pages.nbr_pages) + " pages; " + this.longToDownloadQuantity(statistic_bag.url_group_manager.root.stat.size - total_displayed_pages.size) + "<br>");
                out_report.println("Total: " + statistic_bag.url_group_manager.root.stat.nbr_pages + " pages; " + this.longToDownloadQuantity(statistic_bag.url_group_manager.root.stat.size));
                out_report.println("</td></tr></table>");
                this.makePageReport(statistic_bag.url_group_manager.root, statistic_bag.visitor_type, String.valueOf(statistic_bag.visitor_type) + ".pages", String.valueOf(this.report_directory) + "/" + pages_details_rep + "/");
                if (this.generate_visit_map && statistic_bag.visitor_type.equals("human")) {
                    out_report.println("<p>Visit map (2-gram page popularity)");
                    out_report.println("<p><img src=\"" + statistic_bag.visitor_type + ".visit_map.png\">");
                }
                this.writeVisitHistogram(String.valueOf(this.report_directory) + statistic_bag.visitor_type + ".visit_duration.png", statistic_bag.histo_visit_duration, stats.max_visit_duration);
                System.out.println("Building mime-type report...");
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.histo_mime_type, this.report_directory, false, HTTPStatisticElement.getter_visits));
                out_report.println("<p>");
                out_report.println("<h3>Client configuration</h3>");
                out_report.println("<p>This part of the report shows the hardware configuration of the clients. You can use it to adapt your web site to the client needs.");
                System.out.println("Building UA report...");
                String ua_details_filename = String.valueOf(statistic_bag.visitor_type) + ".ua_details.html";
                String ua_family_pop_filename = String.valueOf(statistic_bag.visitor_type) + "ua_family_pop.png";
                String ua_family_pop_filename_norm = String.valueOf(statistic_bag.visitor_type) + "ua_family_pop_norm.png";
                out_report.println(this.makeReportTable(statistic_bag.histo_useragent_families, true, "VPHBD", ua_details_filename, ua_unknown_filename, null, "<p align=center><table border=0><tr><td><img name=ua_family_pop_img src=" + ua_family_pop_filename_norm + "></td><td><input type=radio name=cb_ua_family_pop_img checked onclick='ua_family_pop_img.src=\"" + ua_family_pop_filename_norm + "\"'>Normalized<br><input type=radio name=cb_ua_family_pop_img  onclick='ua_family_pop_img.src=\"" + ua_family_pop_filename + "\"'>Unnormalized</td></tr></table>"));
                statistic_bag.histo_useragent_families.sort();
                this.writeImageStatisticElementArrayYearVisits(this.timestamps_days, new ArrayList(statistic_bag.histo_useragent_families.getArrayList()), String.valueOf(this.report_directory) + ua_family_pop_filename, false, HTTPStatisticElement.getter_visits);
                this.writeImageStatisticElementArrayYearVisits(this.timestamps_days, new ArrayList(statistic_bag.histo_useragent_families.getArrayList()), String.valueOf(this.report_directory) + ua_family_pop_filename_norm, true, HTTPStatisticElement.getter_visits);
                out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + ua_details_filename));
                RecognizedUserAgent total_ua = new RecognizedUserAgent();
                Iterator e6 = statistic_bag.histo_useragents.values().iterator();
                while (e6.hasNext()) {
                    RecognizedUserAgent ua2 = (RecognizedUserAgent)e6.next();
                    total_ua.merge(ua2);
                }
                ArrayList useragents_families = new ArrayList(statistic_bag.histo_useragent_families.values());
                Collections.sort(useragents_families, HTTPStatisticElement.COMPARATOR_VISITS);
                out_report2.println(this.getReportHeader());
                out_report2.println("<p>");
                out_report2.println("<table class=\"reporttable\">");
                out_report2.println("<tr><td class=\"tabletitle\">&nbsp;User-Agents details&nbsp;&nbsp;&nbsp;<a href=" + ua_unknown_filename + ">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + " Unknown</a></td><td align=right><a href=help/ua.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report2.println("<tr><td colspan=3>");
                Iterator fam_iter = useragents_families.iterator();
                while (fam_iter.hasNext()) {
                    RecognizedUserAgentFamily rec_family = (RecognizedUserAgentFamily)fam_iter.next();
                    UserAgentFamily family = rec_family.family;
                    out_report2.println("<p>" + (family.getIcon() != null ? "<img src=\"images/useragent_icon/" + family.getIcon() + "\"> " : "") + "<strong>" + family.getName() + "</strong> (" + rec_family.nbr_visits + " visits, " + rec_family.nbr_pages + " pages, " + rec_family.nbr_hits + " hits, " + this.longToDownloadQuantity(rec_family.size) + ")");
                    out_report2.println("<table id=\"t_ua" + family.getId() + "\" class=\"sortable\" width=100%>");
                    out_report2.println("  <tr>");
                    out_report2.println("    <th width=50%>User-Agent</th><th>Visits</th><th>Pages</th><th>Hits</th><th>Bandwidth</th><th>Last hit date</th><th>Hit on \"/robots.txt\"</th><th>Trapped</th>");
                    out_report2.println("  </tr>");
                    ArrayList useragents = new ArrayList(statistic_bag.histo_useragents.values());
                    Collections.sort(useragents, HTTPStatisticElement.COMPARATOR_VISITS);
                    Iterator e7 = useragents.iterator();
                    while (e7.hasNext()) {
                        RecognizedUserAgent ua3 = (RecognizedUserAgent)e7.next();
                        UserAgent b = ua3.getUserAgent();
                        if (!b.getFamily().equals(family)) continue;
                        String url = b.getURL();
                        String useragent_name = b.getName();
                        url = url.length() == 0 ? "unknown" : "<a href=" + url + ">" + url + "</a>";
                        String filename_ua_report_image = (String.valueOf(statistic_bag.visitor_type) + "." + ua3.getUserAgent().getId() + "_" + ua3.version).replaceAll("[/\\\\ ]", "");
                        String filename_ua_report_dir = "ua/";
                        File f = new File(String.valueOf(this.report_directory) + filename_ua_report_dir);
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        String filename_ua_report_relative = "/" + filename_ua_report_dir + filename_ua_report_image;
                        String filename_ua_report = String.valueOf(this.report_directory) + filename_ua_report_relative;
                        if (this.generate_detailed_useragent_graphs) {
                            this.writeGraphic(this.timestamps_days, ua3.getDailyActivityStorage(), String.valueOf(filename_ua_report) + "_vhp.png", false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_visits, HTTPStatisticElement.getter_pages, HTTPStatisticElement.getter_hits}, "Visits, Hits and Pages", "days", "", 366, 150, 14);
                        }
                        PrintWriter out_report4 = new PrintWriter(new FileWriter(String.valueOf(filename_ua_report) + ".html"));
                        out_report4.println(this.getReportHeader(1));
                        out_report4.println("<h2>" + b.getName() + " " + ua3.version + "</h2>");
                        out_report4.println("<p>User-Agent type : " + statistic_bag.visitor_type);
                        out_report4.println("<p>User-Agent URL : " + url);
                        out_report4.println("<p>");
                        out_report4.println("<table class=\"reporttable\">");
                        out_report4.println("<tr><td class=\"tabletitle\">&nbsp;Activity in time</td><td align=right><a href=../help/ua_details.html><img border=0 src=../images/help.png></a> </td></tr>");
                        out_report4.println("<tr><td colspan=3><img src=\"" + filename_ua_report_image + "_vhp.png\"></td></tr></table>");
                        out_report4.println("<p>");
                        out_report4.println("<table class=\"reporttable\">");
                        out_report4.println("<tr><td class=\"tabletitle\">&nbsp;Last pages viewed</td><td align=right><!--<a href=../help/ua_details.html><img border=0 src=../images/help.png></a>--> </td></tr>");
                        out_report4.println("<tr><td colspan=3><table id=\"t_ua" + family.getId() + "\" class=\"sortable\" width=100%>");
                        out_report4.println("  <tr>");
                        out_report4.println("    <th width=50%>URL</th><th>Last view date</th>");
                        out_report4.println("  </tr>");
                        Enumeration pages = ua3.getPageLastDateTable().keys();
                        while (pages.hasMoreElements()) {
                            String page_url = (String)pages.nextElement();
                            Long date = (Long)ua3.getPageLastDateTable().get(page_url);
                            out_report4.println("<tr><td>" + page_url + "</td><td>" + LogFormat.df.format(new Date(date)) + "</td></tr>");
                        }
                        out_report4.println("</table>");
                        out_report4.println("</td></tr></table>");
                        out_report4.close();
                        useragent_name = "<a href=\"." + filename_ua_report_relative + ".html\">" + useragent_name + "</a>";
                        out_report2.println("<tr><td><img src=\"images/useragent_icon/" + b.getIcon() + ".png\"> " + useragent_name + " " + ua3.version + "</td><td align=right nowrap>" + ua3.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + ua3.nbr_visits * 100L / Math.max(1L, total_ua.nbr_visits) + "%)</td><td align=right nowrap>" + ua3.nbr_pages + "&nbsp;&nbsp;&nbsp;(" + ua3.nbr_pages * 100L / Math.max(1L, total_ua.nbr_pages) + "%)</td><td align=right nowrap>" + ua3.nbr_hits + "&nbsp;&nbsp;&nbsp;(" + ua3.nbr_hits * 100L / Math.max(1L, total_ua.nbr_hits) + "%)</td><td align=right nowrap>" + this.longToDownloadQuantity(ua3.size) + "&nbsp;&nbsp;&nbsp;(" + ua3.size * 100L / Math.max(1L, total_ua.size) + "%)</td><td align=right nowrap>" + LogFormat.df.format(new Date(ua3.getDate())) + "</td><td align=center valign=top>" + this.booleanToYesNoImageURL(ua3.isRobotsTxtHited()) + "</td><td align=center valign=top>" + this.booleanToYesNoImageURL(ua3.isRobotTrapHited()) + "</td></tr>");
                    }
                    out_report2.println("</table>");
                }
                out_report2.println("<p>Total: " + total_ua.nbr_visits + " visits, " + total_ua.nbr_pages + " pages, " + total_ua.nbr_hits + " hits, " + this.longToDownloadQuantity(total_ua.size));
                out_report2.println("</td></tr></table>");
                out_report2.close();
                System.out.println("Building OS report...");
                String os_unknown_filename = String.valueOf(statistic_bag.visitor_type) + "." + "os_unknown.html";
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.histo_os, this.report_directory, false, HTTPStatisticElement.getter_visits));
                out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + os_unknown_filename));
                out_report2.println(this.getReportHeader());
                out_report2.println(this.makeReportTable(statistic_bag.ht_unknown_os, false, "VPHBD", null, null, null));
                out_report2.close();
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.ht_screen_size, this.report_directory, false, HTTPStatisticElement.getter_visits));
                out_report.println(this.makeReport(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.ht_languages, this.report_directory, false, HTTPStatisticElement.getter_visits));
                System.out.println("Building download speed report...");
                out_report.println("<p>");
                out_report.println("<table class=\"reporttable\">");
                out_report.println("<tr><td class=\"tabletitle\">&nbsp;Download speed</td><td align=right><a href=help/download_speed.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report.println("<tr><td colspan=3>");
                out_report.println("<table class=\"graph_table\">");
                out_report.println("  <tr>");
                int max_height = 70;
                int max_download_speed_pop = -1;
                int total_pop_download_speed = 0;
                int i7 = 0;
                while (i7 < statistic_bag.download_speed_histo.length) {
                    total_pop_download_speed += statistic_bag.download_speed_histo[i7];
                    if (statistic_bag.download_speed_histo[i7] > max_download_speed_pop) {
                        max_download_speed_pop = statistic_bag.download_speed_histo[i7];
                    }
                    ++i7;
                }
                if (max_download_speed_pop == 0) {
                    max_download_speed_pop = 1;
                }
                i7 = 0;
                while (i7 < statistic_bag.download_speed_histo.length) {
                    out_report.print("<td>&nbsp;</td><td valign=bottom><p style=\"text-align:center\">" + statistic_bag.download_speed_histo[i7] + "<br>(" + Math.round((float)(statistic_bag.download_speed_histo[i7] * 100) / (float)total_pop_download_speed) + "%)<br><img src=images/bar_green.png width=16 height=" + statistic_bag.download_speed_histo[i7] * max_height / max_download_speed_pop + "></td>");
                    ++i7;
                }
                out_report.println("</tr><tr>");
                i7 = 0;
                while (i7 < statistic_bag.download_speed_histo.length) {
                    out_report.print("<td><p>" + this.longToDownloadQuantity((long)Math.floor(Math.pow(2.0, this.log2(statistic_bag.min_download_speed) + (double)i7 * (this.log2(statistic_bag.max_download_speed) - this.log2(statistic_bag.min_download_speed)) / (double)(statistic_bag.download_speed_histo.length - 1)))) + "</td><td>&nbsp;</td>");
                    ++i7;
                }
                out_report.println("</table>");
                if (total_pop_download_speed == 0) {
                    total_pop_download_speed = 1;
                }
                out_report.println("<p>All bandwidth are in bytes/second. Number of unknown download speed: " + statistic_bag.nbr_unknown_download_speed + " (" + statistic_bag.nbr_unknown_download_speed * 100 / (total_pop_download_speed + statistic_bag.nbr_unknown_download_speed) + "%)");
                String download_speed_per_day_filename = String.valueOf(statistic_bag.visitor_type) + ".daily_download_speed.png";
                out_report.println("<p><img src=" + download_speed_per_day_filename + " alt=\"Daily mean download speed\">");
                this.writeGraphic(this.timestamps_days, statistic_bag.daily_download_speed.getDailyActivityStorage(), String.valueOf(this.report_directory) + download_speed_per_day_filename, false, new StatisticElementArrayGetter[]{statistic_bag.daily_download_speed.getter_download_speed}, "Mean download speed [bytes/s]", "days", "", 366, 150, 14);
                out_report.println("</td></tr></table>");
                System.out.println("Building plugin report...");
                out_report.println(this.makeReportBar(this.timestamps_days, statistic_bag.visitor_type, statistic_bag.installed_plugins_histo, this.report_directory, false));
                out_report.close();
                if (!this.generate_visit_map || !statistic_bag.visitor_type.equals("human")) continue;
                statistic_bag.visit_map.setFilename(String.valueOf(this.report_directory) + statistic_bag.visitor_type + ".visit_map.png");
                try {
                    statistic_bag.visit_map.display();
                }
                catch (Exception e8) {
                    e8.printStackTrace();
                }
            }
            System.out.println("Building unknown UA report...");
            UnknownUserAgent total_ua = new UnknownUserAgent();
            Iterator e = HTTPStatistics.unknown_useragents.values().iterator();
            while (e.hasNext()) {
                UnknownUserAgent ua4 = (UnknownUserAgent)e.next();
                total_ua.merge(ua4);
            }
            out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + ua_unknown_filename));
            out_report2.println(this.getReportHeader());
            out_report2.println("<p>");
            out_report2.println("<table class=\"reporttable\">");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Unknown User-Agents (" + HTTPStatistics.unknown_useragents.size() + ")</td><td align=right><a href=help/unknown_ua.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println("<table id=\"t_unknown_ua\" class=\"sortable\">");
            out_report2.println("  <tr>");
            out_report2.println("    <th>HTTP User-Agent String</th><th>Hosts</th><th>Last Visit Date/Time</th><th>Visits</th><th>Pages</th><th>Hits</th><th>Bandwidth</th><th>Hit on \"/robots.txt\"</th><th>Trapped</th>");
            out_report2.println("  </tr>");
            ArrayList unknown_useragents2 = new ArrayList(HTTPStatistics.unknown_useragents.values());
            Collections.sort(unknown_useragents2, HTTPStatisticElement.COMPARATOR_VISITS);
            Iterator e9 = unknown_useragents2.iterator();
            while (e9.hasNext()) {
                UnknownUserAgent ua5 = (UnknownUserAgent)e9.next();
                StringBuffer host_list = new StringBuffer();
                Iterator e2 = ua5.getHosts().iterator();
                while (e2.hasNext()) {
                    host_list.append(String.valueOf((String)e2.next()) + "<br>");
                }
                int hashcode = ua5.getUAString().hashCode();
                String filename_ua_report_image = "unknown_ua." + hashcode;
                String filename_ua_report_dir = "unknown_ua/";
                File f = new File(String.valueOf(this.report_directory) + filename_ua_report_dir);
                if (!f.exists()) {
                    f.mkdirs();
                }
                String page_extension = ".html";
                String image_extension = "_vhp.png";
                String filename_ua_report_relative = String.valueOf(filename_ua_report_dir) + filename_ua_report_image;
                String filename_ua_report = String.valueOf(this.report_directory) + "/" + filename_ua_report_relative;
                String detailed_ua_report_filename_rel = String.valueOf(filename_ua_report_relative) + page_extension;
                String detailed_ua_report_filename = String.valueOf(filename_ua_report) + page_extension;
                String detailed_ua_report_image_url_rel = String.valueOf(filename_ua_report_image) + image_extension;
                String detailed_ua_report_image_url = String.valueOf(filename_ua_report) + image_extension;
                if (this.generate_detailed_unknow_ua_graphs) {
                    this.writeGraphic(this.timestamps_days, ua5.getDailyActivityStorage(), detailed_ua_report_image_url, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_visits, HTTPStatisticElement.getter_pages, HTTPStatisticElement.getter_hits}, "", "days", "", 366, 150, 14);
                }
                PrintWriter out_report4 = new PrintWriter(new FileWriter(detailed_ua_report_filename));
                out_report4.println(this.getReportHeader(1));
                out_report4.println("<h2>" + HTMLTools.cleanFromCSSA(ua5.getUAString()) + "</h2>");
                out_report4.println("<p>User-Agent type : unknown (counted as human)");
                out_report4.println("<p>User-Agent URL : unknown");
                out_report4.println("<p>What do do with this user-agent? <a href=\"http://www.google.com/search?q=" + ua5.getUAString() + "\">Search on google</a> - <a href=http://www.whois.sc/" + ua5.hosts.get(0) + ">Whois IP</a>");
                out_report4.println("<p>");
                out_report4.println("<table class=\"reporttable\">");
                out_report4.println("<tr><td class=\"tabletitle\">&nbsp;Activity in time</td><td align=right><a href=../help/ua_details.html><img border=0 src=../images/help.png></a> </td></tr>");
                out_report4.println("<tr><td colspan=3><img src=\"" + detailed_ua_report_image_url_rel + "\"></td></tr></table>");
                out_report4.println("<p>");
                out_report4.println("<table class=\"reporttable\">");
                out_report4.println("<tr><td class=\"tabletitle\">&nbsp;Last pages viewed</td><td align=right><!--<a href=../help/ua_details.html><img border=0 src=../images/help.png></a>--> </td></tr>");
                out_report4.println("<tr><td colspan=3><table id=\"t_uaxx\" class=\"sortable\" width=100%>");
                out_report4.println("  <tr>");
                out_report4.println("    <th width=50%>URL</th><th>Hits</th><th>Last view date</th>");
                out_report4.println("  </tr>");
                Enumeration pages = ua5.getPageLastDateTable().keys();
                while (pages.hasMoreElements()) {
                    String page_url = (String)pages.nextElement();
                    Long date = (Long)ua5.getPageLastDateTable().get(page_url);
                    int nbr_hits = ua5.getNbrHits(page_url);
                    out_report4.println("<tr><td>" + page_url + "</td><td>" + nbr_hits + "</td><td>" + LogFormat.df.format(new Date(date)) + "</td></tr>");
                }
                out_report4.println("</table>");
                out_report4.println("</td></tr></table>");
                out_report4.close();
                out_report2.println("<tr><td valign=top><a href=" + detailed_ua_report_filename_rel + ">" + HTMLTools.cleanFromCSSA(ua5.getUAString()) + "</a></td><td>" + host_list.toString() + "</td><td valign=top>" + LogFormat.df.format(new Date(ua5.getDate())) + "</td><td align=right valign=top>" + ua5.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + ua5.nbr_visits * 100L / Math.max(1L, total_ua.nbr_visits) + "%)</td><td align=right valign=top>" + ua5.nbr_pages + "&nbsp;&nbsp;&nbsp;(" + ua5.nbr_pages * 100L / Math.max(1L, total_ua.nbr_pages) + "%)</td><td align=right valign=top>" + ua5.nbr_hits + "&nbsp;&nbsp;&nbsp;(" + ua5.nbr_hits * 100L / Math.max(1L, total_ua.nbr_hits) + "%)</td><td align=right valign=top>" + this.longToDownloadQuantity(ua5.size) + "&nbsp;&nbsp;&nbsp;(" + ua5.size * 100L / Math.max(1L, total_ua.size) + "%)</td><td align=center valign=top>" + this.booleanToYesNoImageURL(ua5.isRobotsTxtHited()) + "</td><td align=center valign=top>" + this.booleanToYesNoImageURL(ua5.isRobotTrapHited()) + "</td></tr>");
            }
            out_report2.println("</table>");
            out_report2.println("<p>Total: " + total_ua.nbr_visits + " visits, " + total_ua.nbr_pages + " pages, " + total_ua.nbr_hits + " hits, " + this.longToDownloadQuantity(total_ua.size));
            out_report2.println("</td></tr></table>");
            out_report2.close();
            out_report = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + "index.server.html"));
            out_report.println(this.getReportHeader());
            out_report.println("<h1>Report for " + HTTPStatistics.host.getDomainName() + "</h1>");
            out_report.println("<p>");
            out_report.println("<h2>Web server statistics & integrity</h2>");
            out_report.println("<p>Are you interested to improve your web site ? <a href=advices.html>Check our advices!</a>");
            String server_activity_hours_filename = "server_activity_hours.png";
            String server_activity_hours_filename_download = "server_activity_hours_download.png";
            out_report.println("<p><table class=\"reporttable\">");
            out_report.println("<tr><td class=\"tabletitle\">&nbsp;Daily activity</td><td align=right><a href=help/activity_day.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report.println("<tr><td colspan=2>");
            out_report.println("<img src=" + server_activity_hours_filename + ">");
            out_report.println("<img src=" + server_activity_hours_filename_download + ">");
            out_report.println("</td></tr></table>");
            this.writeImageStatisticElementArray(this.timestamps_hours, stats.server_activity_hours, String.valueOf(this.report_directory) + server_activity_hours_filename, String.valueOf(this.report_directory) + server_activity_hours_filename_download, false, stats.nbr_activity_days);
            String server_activity_days_filename = "server_activity_days.png";
            String server_activity_days_filename_download = "server_activity_days_download.png";
            out_report.println("<p><table class=\"reporttable\">");
            out_report.println("<tr><td class=\"tabletitle\">&nbsp;Weekly activity</td><td align=right><a href=help/activity_week.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report.println("<tr><td colspan=2>");
            out_report.println("<img src=" + server_activity_days_filename + ">");
            out_report.println("<img src=" + server_activity_days_filename_download + ">");
            out_report.println("</td></tr></table>");
            this.writeGraphic(this.timestamps_days_of_week, stats.server_daily_activity, String.valueOf(this.report_directory) + server_activity_days_filename, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_visits_weekdays, HTTPStatisticElement.getter_pages_weekdays, HTTPStatisticElement.getter_hits_weekdays}, "", "days", "", 366, 150, 1, this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
            this.writeGraphic(this.timestamps_days_of_week, stats.server_daily_activity, String.valueOf(this.report_directory) + server_activity_days_filename_download, false, new StatisticElementArrayGetter[]{HTTPStatisticElement.getter_sizes_weekdays}, "", "days", "", 366, 150, 1, this.timestamps_days[0], this.timestamps_days[this.timestamps_days.length - 1]);
            String details_filename = "bad_links_details.html";
            out_report.println("<p>");
            out_report.println("<table class=\"reporttable\">");
            out_report.println("<tr><td class=\"tabletitle\">&nbsp;<img src=images/404_error.png> Bad links (Top " + this.nbr_displayed_bad_links + ")&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=" + details_filename + ">" + "<img src=\"images/details.png\" border=0>" + " Details</a></td><td align=right><a href=help/bad_links.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report.println("<tr><td colspan=3>");
            out_report.println("<table id=\"t_bad_links\" class=\"sortable\">");
            out_report.println("  <tr>");
            out_report.println("    <th>Requested URL</th><th>Last request date</th><th>Hits</th>");
            out_report.println("  </tr>");
            ArrayList ht_bad_links2 = new ArrayList(stats.ht_bad_links.values());
            Collections.sort(ht_bad_links2, HTTPStatisticElement.COMPARATOR_DATE);
            int nbr_bad_links = 0;
            Recognized404Error remaining_bad_links = new Recognized404Error(null);
            Iterator e10 = ht_bad_links2.iterator();
            while (e10.hasNext()) {
                Recognized404Error ua6 = (Recognized404Error)e10.next();
                if (nbr_bad_links < this.nbr_displayed_bad_links) {
                    bad_url = HTMLTools.cleanFromCSSA(ua6.url);
                    out_report.println("<tr><td valign=top>" + bad_url + "</td><td>" + LogFormat.df.format(new Date(ua6.getDate())) + "</td><td>" + ua6.nbr_hits + "</td></tr>");
                } else {
                    remaining_bad_links.merge(ua6);
                }
                ++nbr_bad_links;
            }
            out_report.println("</table>");
            out_report.println("<p>Others: " + Math.max(0, stats.ht_bad_links.size() - this.nbr_displayed_bad_links) + " bad links (" + remaining_bad_links.nbr_hits + " hits)");
            out_report.println("</td></tr></table>");
            out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + details_filename));
            out_report2.println(this.getReportHeader());
            out_report2.println("<p>");
            out_report2.println("<table class=\"reporttable\">");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;<img src=images/404_error.png> Bad links (" + stats.ht_bad_links.size() + ")</td><td align=right><a href=help/bad_links.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println("<table id=\"t_bad_links\" class=\"sortable\">");
            out_report2.println("  <tr>");
            out_report2.println("    <th>Requested URL</th><th>Referer</th><th>Last request date</th><th>Hits</th>");
            out_report2.println("  </tr>");
            e10 = ht_bad_links2.iterator();
            while (e10.hasNext()) {
                Recognized404Error ua7 = (Recognized404Error)e10.next();
                bad_url = HTMLTools.cleanFromCSSA(ua7.url);
                out_report2.println("<tr><td valign=top>" + bad_url + "</td><td>");
                Enumeration e2 = ua7.getReferers().elements();
                while (e2.hasMoreElements()) {
                    String referer = (String)e2.nextElement();
                    if (referer.startsWith("http://")) {
                        out_report2.println("<a href=\"" + referer + "\">" + referer + "</a><br>");
                        continue;
                    }
                    out_report2.println(String.valueOf(referer) + "<br>");
                }
                out_report2.println("</td><td valign=top>" + LogFormat.df.format(new Date(ua7.getDate())) + "</td><td valign=top>" + ua7.nbr_hits + "</td></tr>");
            }
            out_report2.println("</table>");
            out_report2.println("</td></tr></table>");
            out_report2.close();
            details_filename = "bad_referer_links_details.html";
            out_report.println("<p>");
            out_report.println("<table class=\"reporttable\">");
            out_report.println("<tr><td class=\"tabletitle\">&nbsp;<img src=images/404_error.png> Bad Referer links (Top " + this.nbr_displayed_bad_referer_links + ")&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=" + details_filename + ">" + "<img src=\"images/details.png\" border=0>" + " Details</a></td><td align=right><a href=help/bad_referer_links.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report.println("<tr><td colspan=3>");
            out_report.println("<table id=\"t_bad_referer_links\" class=\"sortable\">");
            out_report.println("  <tr>");
            out_report.println("    <th>Requested URL</th><th>Last request date</th><th>Hits</th>");
            out_report.println("  </tr>");
            ArrayList ht_bad_referer_links2 = new ArrayList(stats.ht_bad_referer_links.values());
            Collections.sort(ht_bad_referer_links2, HTTPStatisticElement.COMPARATOR_DATE);
            int nbr_bad_referer_links = 0;
            Recognized404Error remaining_bad_referer_links = new Recognized404Error(null);
            Iterator e11 = ht_bad_referer_links2.iterator();
            while (e11.hasNext()) {
                ua = (Recognized404Error)e11.next();
                if (nbr_bad_referer_links < this.nbr_displayed_bad_referer_links) {
                    String bad_url2 = HTMLTools.cleanFromCSSA(ua.url);
                    out_report.println("<tr><td><a href=http://www.google.com/search?q=" + URLEncoder.encode(bad_url2, "UTF-8") + ">" + bad_url2 + "</a></td><td>" + LogFormat.df.format(new Date(ua.getDate())) + "</td><td>" + ua.nbr_hits + "</td></tr>");
                } else {
                    remaining_bad_referer_links.merge(ua);
                }
                ++nbr_bad_referer_links;
            }
            out_report.println("</table>");
            out_report.println("<p>Others: " + Math.max(0, stats.ht_bad_referer_links.size() - this.nbr_displayed_bad_referer_links) + " bad referer links (" + remaining_bad_referer_links.nbr_hits + " hits)");
            out_report.println("</td></tr></table>");
            out_report2 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + details_filename));
            out_report2.println(this.getReportHeader());
            out_report2.println("<p>");
            out_report2.println("<table class=\"reporttable\">");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;<img src=images/404_error.png> Bad Referer links (" + stats.ht_bad_referer_links.size() + ")</td><td align=right><a href=help/bad_referer_links.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println("<table id=\"t_bad_referer_links\" class=\"sortable\">");
            out_report2.println("  <tr>");
            out_report2.println("    <th>Requested URL</th><th>Referer</th><th>Last request date</th><th>Hits</th>");
            out_report2.println("  </tr>");
            e11 = ht_bad_referer_links2.iterator();
            while (e11.hasNext()) {
                ua = (Recognized404Error)e11.next();
                String bad_url3 = HTMLTools.cleanFromCSSA(ua.url);
                out_report2.println("<tr><td valign=top><a href=http://www.google.com/search?q=" + URLEncoder.encode(bad_url3, "UTF-8") + ">" + bad_url3 + "</a></td><td>");
                Enumeration e2 = ua.getReferers().elements();
                while (e2.hasMoreElements()) {
                    String referer = (String)e2.nextElement();
                    if (referer.startsWith("http://")) {
                        out_report2.println("<a href=\"" + referer + "\">" + referer + "</a><br>");
                        continue;
                    }
                    out_report2.println(String.valueOf(referer) + "<br>");
                }
                out_report2.println("</td><td valign=top>" + LogFormat.df.format(new Date(ua.getDate())) + "</td><td valign=top>" + ua.nbr_hits + "</td></tr>");
            }
            out_report2.println("</table>");
            out_report2.println("</td></tr></table>");
            out_report2.close();
            out_report.println("<p>");
            out_report.println("<table class=\"reporttable\">");
            out_report.println("<tr><td class=\"tabletitle\">&nbsp;<img src=images/piracy.png> Worm attacks</td><td align=right><a href=help/worm_attacks.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report.println("<tr><td colspan=3>");
            out_report.println("<table id=\"t_worm_attacks\" class=\"sortable\">");
            out_report.println("  <tr>");
            out_report.println("    <th>Worm name</th><th>Target</th><th>Hits</th><th>Last visit</th>");
            out_report.println("  </tr>");
            RecognizedWorm total_worm = new RecognizedWorm(null);
            Iterator iter = stats.ht_worms.values().iterator();
            while (iter.hasNext()) {
                total_worm.merge((RecognizedWorm)iter.next());
            }
            ArrayList ht_worms2 = new ArrayList(stats.ht_worms.values());
            Collections.sort(ht_worms2, HTTPStatisticElement.COMPARATOR_HITS);
            Iterator e12 = ht_worms2.iterator();
            while (e12.hasNext()) {
                RecognizedWorm ua8 = (RecognizedWorm)e12.next();
                out_report.println("<tr><td>" + ua8.getWorm().getName() + "</td><td>" + ua8.getWorm().getTarget() + "</td><td align=right>" + ua8.nbr_hits + "&nbsp;&nbsp;&nbsp;(" + ua8.nbr_hits * 100L / total_worm.nbr_hits + "%)</td><td>" + LogFormat.df.format(new Date(ua8.getDate())) + "</td></tr>");
            }
            out_report.println("</table>");
            out_report.println("</td></tr></table>");
            out_report.close();
            out_report3.close();
            out_report3 = new PrintWriter(new FileWriter(String.valueOf(this.report_directory) + "advices.html"));
            out_report3.println(this.getReportHeader());
            Enumeration e3 = PluginManager.getAdvisorPlugins().elements();
            while (e3.hasMoreElements()) {
                AdvisorPlugin advisor_plugin = (AdvisorPlugin)e3.nextElement();
                advisor_plugin.setStatisticsBuilder(this.stat_builder);
                advisor_plugin.setReportBuilder(this);
                out_report3.println(advisor_plugin.getHTMLAdvice());
            }
            out_report3.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("\nReport duration: " + stats.nbr_log_entries * 1000L / (t1 - t0) + " records/second (" + stats.nbr_log_entries + " records, " + (t1 - t0) / 1000L + " seconds)");
        System.out.println("\nFull duration: " + stats.nbr_log_entries * 1000L / (t1 - stats.t0) + " records/second (" + stats.nbr_log_entries + " records, " + (t1 - stats.t0) / 1000L + " seconds)");
    }

    public void writeBarReport(Calendar last_date, int nbr_days, ArrayList stats, String filename, int width, int height) {
        Calendar first_date = (Calendar)last_date.clone();
        first_date.add(6, -nbr_days);
        SortableCategoryDataset dataset = new SortableCategoryDataset();
        String[] series_names = new String[]{"Installed", "Installed (predicted)", "Uninstalled (predicted)", "Uninstalled"};
        int i = 0;
        while (i < Math.min(10, stats.size())) {
            DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i)).getDailyActivityStorage();
            StatisticElement[] visits = fam.getRange(first_date, last_date);
            RecognizedPlugin total = new RecognizedPlugin();
            int k = 0;
            while (k < visits.length) {
                total.merge((HTTPStatisticElement)visits[k]);
                ++k;
            }
            int j = 1;
            while (j <= 4) {
                long count = total.getValue(j);
                dataset.addValue((double)(count * 100L) / (double)(total.nbr_visits + total.nbr_pages + total.nbr_hits), (Comparable)((Object)series_names[j - 1]), (Comparable)((Object)fam.getShortName()));
                ++j;
            }
            ++i;
        }
        dataset.sort((Comparable)((Object)series_names[0]));
        JFreeChart chart = ChartFactory.createBarChart(null, null, (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.getLegend().setItemFont(new Font("SansSerif", 0, 9));
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        StackedBarRenderer rend = new StackedBarRenderer();
        rend.setSeriesPaint(3, (Paint)Color.RED);
        rend.setSeriesPaint(2, (Paint)new Color(180, 60, 60));
        rend.setSeriesPaint(1, (Paint)new Color(60, 180, 60));
        rend.setSeriesPaint(0, (Paint)Color.GREEN);
        plot.setRenderer((CategoryItemRenderer)rend);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
        BufferedImage bimg = chart.createBufferedImage(width, height);
        ((Graphics2D)bimg.getGraphics()).setBackground(new Color(102, 102, 102));
        chart.draw((Graphics2D)bimg.getGraphics(), (Rectangle2D)new Rectangle2D.Double(1.0, 1.0, width, height));
        try {
            ImageIO.write((RenderedImage)bimg, "PNG", new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeHist(double[] data, String filename, int width, int height, int nbr_bins) {
        HistogramDataset dataset = new HistogramDataset();
        dataset.addSeries((Comparable)new Double(1.0), data, nbr_bins);
        JFreeChart chart = ChartFactory.createHistogram(null, (String)"Inter-Visit Interval [h]", null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        if (chart.getLegend() != null) {
            chart.getLegend().setItemFont(new Font("SansSerif", 0, 9));
        }
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 255));
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BufferedImage bimg = chart.createBufferedImage(width, height);
        ((Graphics2D)bimg.getGraphics()).setBackground(new Color(102, 102, 102));
        chart.draw((Graphics2D)bimg.getGraphics(), (Rectangle2D)new Rectangle2D.Double(1.0, 1.0, width, height));
        try {
            ImageIO.write((RenderedImage)bimg, "PNG", new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writePieReport(Calendar last_date, int nbr_days, ArrayList stats, String filename, int width, int height, StatisticElementArrayGetter getter) {
        Calendar first_date = (Calendar)last_date.clone();
        first_date.add(6, -nbr_days);
        SortablePieDataset dataset = new SortablePieDataset();
        int i = 0;
        while (i < Math.min(10, stats.size())) {
            DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i)).getDailyActivityStorage();
            double[] values = getter.getValues(fam, first_date.getTimeInMillis(), last_date.getTimeInMillis());
            int total_values = 0;
            int j = 0;
            while (j < values.length) {
                total_values = (int)((double)total_values + values[j]);
                ++j;
            }
            if (total_values > 0) {
                dataset.setValue((Comparable)((Object)fam.getShortName()), new Double(total_values));
            }
            ++i;
        }
        dataset.sortByValues();
        PiePlot3D2 plot = new PiePlot3D2(dataset);
        plot.setInsets(new RectangleInsets(-1.0, -1.0, 0.0, 0.0));
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}: {2}"));
        boolean legend = false;
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        plot.setLabelFont(new Font("SansSerif", 0, 10));
        plot.setNoDataMessage("No data available");
        plot.setCircular(false);
        plot.setLabelGap(0.02);
        plot.setForegroundAlpha(0.95f);
        plot.setDepthFactor(0.1);
        plot.setMaximumLabelWidth(0.3);
        plot.setStartAngle(70.0);
        plot.setBackgroundPaint(new Color(238, 238, 238));
        BufferedImage bimg = chart.createBufferedImage(width, height);
        ((Graphics2D)bimg.getGraphics()).setBackground(new Color(102, 102, 102));
        chart.draw((Graphics2D)bimg.getGraphics(), (Rectangle2D)new Rectangle2D.Double(1.0, 1.0, width, height));
        try {
            ImageIO.write((RenderedImage)bimg, "PNG", new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String makeReportTable(StatisticsTable table, boolean limit_table_size, String columns, String filename_details, String filename_unknown, String filename_help) {
        return this.makeReportTable(table, limit_table_size, columns, filename_details, filename_unknown, filename_help, "");
    }

    public String makeReportTable(StatisticsTable table, boolean limit_table_size, String columns, String filename_details, String filename_unknown, String filename_help, String footnotes) {
        StringBuffer result = new StringBuffer();
        table.sort();
        HTTPStatisticElement total = table.getTotal();
        HTTPStatisticElement total_top = table.getTotalTop();
        result.append("<p>");
        result.append("<table class=\"reporttable\">");
        result.append("<tr><td class=\"tabletitle\">&nbsp;" + table.getName() + " " + (table.nbr_displayed_rows_in_summary > 0 && limit_table_size ? "(Top " + table.nbr_displayed_rows_in_summary + ")" : ""));
        if (filename_details != null) {
            result.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=\"" + filename_details + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a>");
        }
        if (filename_unknown != null) {
            result.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=" + filename_unknown + ">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + " Unknown</a>");
        }
        result.append("</td><td align=right>");
        if (filename_help != null) {
            result.append("<a href=help/" + filename_help + "><img border=0 src=images/help.png></a>");
        }
        result.append("</td></tr>");
        result.append("<tr><td colspan=3>");
        result.append(this.makeTable(table, limit_table_size, columns, filename_details, filename_unknown, filename_help, footnotes));
        result.append("</td></tr></table>");
        return result.toString();
    }

    public String makeTable(StatisticsTable table, boolean limit_table_size, String columns, String filename_details, String filename_unknown, String filename_help, String footnotes) {
        StringBuffer result = new StringBuffer();
        int percent_graphic_bar_width = 70;
        int percent_graphic_bar_height = 5;
        boolean use_graphic_bar = true;
        table.sort();
        HTTPStatisticElement total = table.getTotal();
        HTTPStatisticElement total_top = table.getTotalTop();
        result.append("<table id=\"t_" + table.getName().replaceAll(" ", "_").toLowerCase() + "\" width=100% class=\"sortable\">");
        result.append("  <tr>");
        String str_others = "Other: " + Math.max(0, table.size() - table.nbr_displayed_rows_in_summary) + " " + table.getFirstColumnName().toLowerCase() + " (";
        String str_totals = "Total: " + table.size() + " " + table.getFirstColumnName().toLowerCase() + " (";
        result.append("    <th>" + table.getFirstColumnName() + "</th>");
        int i = 0;
        while (i < columns.length()) {
            char c = columns.charAt(i);
            switch (c) {
                case 'D': {
                    result.append("<th>Last Visit Date</th>");
                    break;
                }
                case 'V': {
                    result.append("<th>Visits</th>");
                    if (i > 0) {
                        str_others = String.valueOf(str_others) + ",";
                        str_totals = String.valueOf(str_totals) + ",";
                    }
                    str_others = String.valueOf(str_others) + " " + (total.nbr_visits - total_top.nbr_visits) + " visits";
                    str_totals = String.valueOf(str_totals) + " " + total.nbr_visits + " visits";
                    break;
                }
                case 'P': {
                    result.append("<th>Pages</th>");
                    if (i > 0) {
                        str_others = String.valueOf(str_others) + ",";
                        str_totals = String.valueOf(str_totals) + ",";
                    }
                    str_others = String.valueOf(str_others) + " " + (total.nbr_pages - total_top.nbr_pages) + " pages";
                    str_totals = String.valueOf(str_totals) + " " + total.nbr_pages + " pages";
                    break;
                }
                case 'H': {
                    result.append("<th>Hits</th>");
                    if (i > 0) {
                        str_others = String.valueOf(str_others) + ",";
                        str_totals = String.valueOf(str_totals) + ",";
                    }
                    str_others = String.valueOf(str_others) + " " + (total.nbr_hits - total_top.nbr_hits) + " hits";
                    str_totals = String.valueOf(str_totals) + " " + total.nbr_hits + " hits";
                    break;
                }
                case 'B': {
                    result.append("<th>Bandwidth</th>");
                    if (i > 0) {
                        str_others = String.valueOf(str_others) + ",";
                        str_totals = String.valueOf(str_totals) + ",";
                    }
                    str_others = String.valueOf(str_others) + " " + this.longToDownloadQuantity(total.size - total_top.size);
                    str_totals = String.valueOf(str_totals) + " " + this.longToDownloadQuantity(total.size);
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int index = Integer.parseInt("" + c);
                    result.append("<th>" + table.getColumnName(index) + "</th>");
                    if (i > 0) {
                        str_others = String.valueOf(str_others) + ",";
                        str_totals = String.valueOf(str_totals) + ",";
                    }
                    str_others = String.valueOf(str_others) + " " + (total.getValue(index) - total_top.getValue(index));
                    str_totals = String.valueOf(str_totals) + " " + total.getValue(index);
                }
            }
            ++i;
        }
        str_others = String.valueOf(str_others) + ").<br>";
        str_totals = String.valueOf(str_totals) + ").";
        result.append("  </tr>");
        int j = 0;
        Iterator e = table.getArrayList().iterator();
        while ((j < table.nbr_displayed_rows_in_summary || !limit_table_size) && e.hasNext()) {
            HTTPStatisticElement elem = (HTTPStatisticElement)e.next();
            result.append("<tr><td>" + elem.getName(filename_unknown) + "</td>");
            int i2 = 0;
            while (i2 < columns.length()) {
                char c = columns.charAt(i2);
                switch (c) {
                    case 'D': {
                        result.append("<td>" + (elem.getDate() != 0L ? LogFormat.df.format(new Date(elem.getDate())) : "?") + "</td>");
                        break;
                    }
                    case 'V': {
                        result.append("<td align=right>" + elem.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + (total.nbr_visits != 0L ? elem.nbr_visits * 100L / total.nbr_visits : 0L) + "%)" + (use_graphic_bar ? "<br><img width=" + (total.nbr_visits != 0L ? elem.nbr_visits * (long)percent_graphic_bar_width / total.nbr_visits : 0L) + " height=" + percent_graphic_bar_height + " src=images/bar_green_horiz.png>" : "") + "</td>");
                        break;
                    }
                    case 'P': {
                        result.append("<td align=right>" + elem.nbr_pages + "&nbsp;&nbsp;&nbsp;(" + (total.nbr_pages != 0L ? elem.nbr_pages * 100L / total.nbr_pages : 0L) + "%)" + (use_graphic_bar ? "<br><img width=" + (total.nbr_pages != 0L ? elem.nbr_pages * (long)percent_graphic_bar_width / total.nbr_pages : 0L) + " height=" + percent_graphic_bar_height + " src=images/bar_green_horiz.png>" : "") + "</td>");
                        break;
                    }
                    case 'H': {
                        result.append("<td align=right>" + elem.nbr_hits + "&nbsp;&nbsp;&nbsp;(" + (total.nbr_hits != 0L ? elem.nbr_hits * 100L / total.nbr_hits : 0L) + "%)" + (use_graphic_bar ? "<br><img width=" + (total.nbr_hits != 0L ? elem.nbr_hits * (long)percent_graphic_bar_width / total.nbr_hits : 0L) + " height=" + percent_graphic_bar_height + " src=images/bar_green_horiz.png>" : "") + "</td>");
                        break;
                    }
                    case 'B': {
                        result.append("<td align=right>" + this.longToDownloadQuantity(elem.size) + "&nbsp;&nbsp;&nbsp;(" + (total.size != 0L ? elem.size * 100L / total.size : 0L) + "%)" + (use_graphic_bar ? "<br><img width=" + (total.size != 0L ? elem.size * (long)percent_graphic_bar_width / total.size : 0L) + " height=" + percent_graphic_bar_height + " src=images/bar_green_horiz.png>" : "") + "</td>");
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int index = Integer.parseInt("" + c);
                        long value = elem.getValue(index);
                        result.append("<td align=right>" + value + "&nbsp;&nbsp;&nbsp;(" + (elem.getTotal(index) != 0L ? value * 100L / elem.getTotal(index) : 0L) + "%)" + (use_graphic_bar ? "<br><img width=" + (elem.getTotal(index) != 0L ? value * (long)percent_graphic_bar_width / elem.getTotal(index) : 0L) + " height=" + percent_graphic_bar_height + " src=images/bar_green_horiz.png>" : "") + "</td>");
                    }
                }
                ++i2;
            }
            result.append("</tr>");
            ++j;
        }
        result.append("</table><p>");
        if (limit_table_size) {
            result.append(str_others);
        }
        result.append(String.valueOf(str_totals) + footnotes);
        return result.toString();
    }

    public void makePageReport(URLGroup root, String visitor_type, String filename_base, String directory) {
        int max_filename_length = 256;
        int dir_depth = 2;
        try {
            String root_group_name = "/";
            TreeNode[] path = root.getPath();
            int i = 1;
            while (i < path.length) {
                URLGroup g = (URLGroup)path[i];
                if (g.getDirectoryName().length() > 0) {
                    root_group_name = String.valueOf(root_group_name) + g.getDirectoryName() + "/";
                }
                ++i;
            }
            String double_dot_str = "";
            int i2 = 0;
            while (i2 < dir_depth) {
                double_dot_str = String.valueOf(double_dot_str) + "../";
                ++i2;
            }
            String filename_base2 = String.valueOf(filename_base) + "." + root.group_id;
            PrintWriter out_report2 = new PrintWriter(new FileWriter(String.valueOf(directory) + filename_base2 + ".html"));
            out_report2.println(this.getReportHeader(dir_depth));
            out_report2.println("<table class=\"reporttable\">");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Pages from " + root_group_name + "</td><td align=right><a href=" + double_dot_str + "help/pages.html><img border=0 src=" + double_dot_str + "images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println("<table id=\"t_" + visitor_type + "pages\" class=\"sortable\">");
            out_report2.println("  <tr>");
            out_report2.println("    <th>URL</th><th>Pages</th><th>Prints</th><th>Bandwidth</th><th>Last view date</th><th>Mean view time [s]</th>");
            out_report2.println("  </tr>");
            String group_link = null;
            root.sort();
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                URLGroup group = (URLGroup)e.nextElement();
                RecognizedURL url = group.getRecognizedURL();
                if (group.getAllowsChildren() && (String.valueOf(filename_base2) + "." + group.group_id + ".html").length() < max_filename_length) {
                    this.makePageReport(group, visitor_type, filename_base2, directory);
                    group_link = "<a href=\"" + filename_base2 + "." + group.group_id + ".html\">" + group.getDirectoryNameHTML(dir_depth) + "</a>";
                } else {
                    group_link = group.getFileName();
                    if (group_link.length() == 0) {
                        group_link = "/";
                    }
                }
                if (url.nbr_pages <= 0L && url.nbr_prints <= 0L) continue;
                out_report2.println("<tr><td>" + group_link + "</td>" + "<td>" + url.nbr_pages + "</td>" + "<td>" + url.nbr_prints + "</td>" + "<td nowrap>" + this.longToDownloadQuantity(url.size) + "</td>" + "<td>" + (url.getDate() != 0L ? LogFormat.df.format(new Date(url.getDate())) : "?") + "</td>" + "<td>" + (url.nbr_pages > 0L ? "" + url.getTotalVisitTime() / (1000L * url.nbr_pages) : "-") + "</td></tr>");
            }
            out_report2.println("</table>");
            out_report2.println("<p>Total: " + root.stat.nbr_pages + " pages; " + this.longToDownloadQuantity(root.stat.size));
            out_report2.println("</td></tr></table>");
            out_report2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void makeRefererReport(HTTPStatistics stats, StatisticBag statistic_bag, PrintWriter out_report, String report_directory) {
        System.out.println("Building referer report...");
        RefererGroup product_referer_root = RefererDatabaseParser.getDefaultDatabase().getRootProductRefererGroup();
        HTTPStatistics.referer_group_root.computeTotals();
        HTTPStatistics.referer_group_root.sort();
        product_referer_root.computeTotals();
        product_referer_root.sort();
        out_report.println("<p>");
        out_report.println("<table class=\"reporttable\" width=50%>");
        out_report.println("<tr><td class=\"tabletitle\">&nbsp;Referers (Top " + this.nbr_displayed_referers + ")</td><td align=right><a href=help/referer.html><img border=0 src=images/help.png></a></td></tr>");
        out_report.println("<tr><td valign=top nowrap>");
        String referers_details_filename = (String.valueOf(statistic_bag.visitor_type) + "." + product_referer_root.getID() + ".html").replaceAll(" ", "_");
        long nbr_total_referers = product_referer_root.stat.nbr_visits + HTTPStatistics.referer_group_root.stat.nbr_visits;
        out_report.println("<p><strong>\"Product\"-referers</strong> (" + product_referer_root.stat.nbr_visits + " visits, " + Math.round((float)(product_referer_root.stat.nbr_visits * 100L) / (float)nbr_total_referers) + "%) - <a href=\"" + referers_details_filename + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a>");
        out_report.println("<table id=\"t_" + statistic_bag.visitor_type + "referer_solution\" class=\"sortable\">");
        out_report.println("  <tr>");
        out_report.println("    <th>Referer</th><th width=5%>Visits</th>");
        out_report.println("  </tr>");
        int nbr_referers = 0;
        Enumeration<TreeNode> e = product_referer_root.children();
        while (nbr_referers < this.nbr_displayed_referers && e.hasMoreElements()) {
            RefererOrRefererGroup node = (RefererOrRefererGroup)e.nextElement();
            if (node.stat.nbr_visits <= 0L) continue;
            out_report.println("<tr><td>" + node.getHTMLString() + "</td><td>" + node.stat.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + Math.round((float)(node.stat.nbr_visits * 100L) / (float)product_referer_root.stat.nbr_visits) + "%)</td></tr>");
            ++nbr_referers;
        }
        out_report.println("</table>");
        referers_details_filename = String.valueOf(statistic_bag.visitor_type) + "." + HTTPStatistics.referer_group_root.getID() + ".html";
        out_report.println("<p><strong>\"Solution\"-referers</strong> (" + HTTPStatistics.referer_group_root.stat.nbr_visits + " visits, " + Math.round((float)(HTTPStatistics.referer_group_root.stat.nbr_visits * 100L) / (float)nbr_total_referers) + "%) - <a href=\"" + referers_details_filename + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a>");
        out_report.println("<table id=\"t_" + statistic_bag.visitor_type + "referer_solution\" class=\"sortable\">");
        out_report.println("  <tr>");
        out_report.println("    <th>Referer</th><th width=5%>Visits</th>");
        out_report.println("  </tr>");
        nbr_referers = 0;
        ArrayList<SearchEngineStatisticElement> v = new ArrayList<SearchEngineStatisticElement>();
        String filename_solution_referer_image = (String.valueOf(statistic_bag.visitor_type) + ".daily_solution_referer.png").replaceAll(" ", "_");
        String filename_solution_referer_image_norm = (String.valueOf(statistic_bag.visitor_type) + ".daily_solution_referer_norm.png").replaceAll(" ", "_");
        Enumeration<TreeNode> e2 = HTTPStatistics.referer_group_root.children();
        while (nbr_referers < this.nbr_displayed_referers && e2.hasMoreElements()) {
            RefererOrRefererGroup node = (RefererOrRefererGroup)e2.nextElement();
            if (node.stat.nbr_visits <= 0L) continue;
            out_report.println("<tr><td>" + node.getHTMLString() + "</td><td>" + node.stat.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + node.stat.nbr_visits * 100L / HTTPStatistics.referer_group_root.stat.nbr_visits + "%)</td></tr>");
            ++nbr_referers;
            v.add(node.stat);
        }
        out_report.println("</table>");
        out_report.println("<p>Total: " + (HTTPStatistics.referer_group_root.stat.nbr_visits + product_referer_root.stat.nbr_visits) + " visits.");
        out_report.println("</td><td>" + this.getNormalizedImageTable(filename_solution_referer_image, filename_solution_referer_image_norm, "Solution-referer History") + "</td></tr></table>");
        this.writeImageStatisticElementArrayYearVisits(this.timestamps_days, v, String.valueOf(report_directory) + filename_solution_referer_image, false, 480, HTTPStatisticElement.getter_visits);
        this.writeImageStatisticElementArrayYearVisits(this.timestamps_days, v, String.valueOf(report_directory) + filename_solution_referer_image_norm, true, 480, HTTPStatisticElement.getter_visits);
        this.makeRefererReport(HTTPStatistics.referer_group_root, statistic_bag.visitor_type, statistic_bag.visitor_type, report_directory);
        this.makeRefererReport(RefererDatabaseParser.getDefaultDatabase().getRootProductRefererGroup(), statistic_bag.visitor_type, statistic_bag.visitor_type, report_directory);
    }

    public void makeRefererReport(RefererGroup root, String visitor_type, String filename_base, String directory) {
        try {
            Object key;
            IntegerCounter count;
            Iterator e;
            ArrayList col;
            String filename_base2 = String.valueOf(filename_base) + "." + root.getID();
            PrintWriter out_report2 = new PrintWriter(new FileWriter(String.valueOf(directory) + filename_base2 + ".html"));
            out_report2.println(this.getReportHeader());
            out_report2.println("<table class=\"reporttable\">");
            out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Referer (" + root.getName() + ")</td><td align=right><a href=help/referer.html><img border=0 src=images/help.png></a> </td></tr>");
            out_report2.println("<tr><td colspan=3>");
            out_report2.println("<table id=\"t_" + visitor_type + "referer\" class=\"sortable\">");
            out_report2.println("  <tr>");
            out_report2.println("    <th>Referer</th><th>Visits</th><th>Last view date</th>");
            out_report2.println("  </tr>");
            String group_link = null;
            root.sort();
            root.computeTotals();
            Enumeration<TreeNode> e2 = root.children();
            while (e2.hasMoreElements()) {
                RefererOrRefererGroup group = (RefererOrRefererGroup)e2.nextElement();
                group_link = group.getHTMLString();
                if (!group.isLeaf() && group.stat.nbr_visits > 0L) {
                    this.makeRefererReport((RefererGroup)group, visitor_type, filename_base2, directory);
                    group_link = "<a href=\"" + filename_base2 + "." + ((RefererGroup)group).getID() + ".html\">" + group_link + "</a>";
                }
                if (group.stat.nbr_visits <= 0L) continue;
                out_report2.println("<tr><td>" + group_link + "</td><td>" + group.stat.nbr_visits + "&nbsp;&nbsp;&nbsp;(" + group.stat.nbr_visits * 100L / root.stat.nbr_visits + "%)</td><td>" + (group.stat.getDate() != 0L ? LogFormat.df.format(new Date(group.stat.getDate())) : "?") + "</td></tr>");
            }
            out_report2.println("</table>");
            out_report2.println("<p>Total: " + root.stat.nbr_visits + " visits. ");
            out_report2.println("</td></tr></table>");
            if (root.stat.hasKeywords()) {
                out_report2.println("<p><table class=\"reporttable\">");
                out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Keyphrases</td><td align=right><a href=help/referer_keywords.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report2.println("<tr><td colspan=3>");
                out_report2.println("<table id=\"t_" + visitor_type + "referer_keyphrases\" class=\"sortable\">");
                out_report2.println("  <tr>");
                out_report2.println("    <th>Referer</th><th>Visits</th>");
                out_report2.println("  </tr>");
                col = new ArrayList(root.stat.ht_keywords.values());
                Collections.sort(col);
                e = col.iterator();
                while (e.hasNext()) {
                    count = (IntegerCounter)e.next();
                    key = (SearchEngineKeywords)count.object;
                    out_report2.println("<tr><td>" + ((SearchEngineKeywords)key).toString() + "</td><td>" + count.i + "</td></tr>");
                }
                out_report2.println("</table>");
                out_report2.println("</td></tr></table>");
            }
            if (root.stat.hasKeywords()) {
                out_report2.println("<p><table class=\"reporttable\">");
                out_report2.println("<tr><td class=\"tabletitle\">&nbsp;Keywords</td><td align=right><a href=help/referer_keywords.html><img border=0 src=images/help.png></a> </td></tr>");
                out_report2.println("<tr><td colspan=3>");
                out_report2.println("<table id=\"t_" + visitor_type + "referer_keywords\" class=\"sortable\">");
                out_report2.println("  <tr>");
                out_report2.println("    <th>Referer</th><th>Visits</th>");
                out_report2.println("  </tr>");
                col = new ArrayList(root.stat.getKeywordHistogram().values());
                Collections.sort(col);
                e = col.iterator();
                while (e.hasNext()) {
                    count = (IntegerCounter)e.next();
                    key = (String)count.object;
                    out_report2.println("<tr><td>" + (String)key + "</td><td>" + count.i + "</td></tr>");
                }
                out_report2.println("</table>");
                out_report2.println("</td></tr></table>");
            }
            out_report2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNormalizedImageTable(String image_name, String image_name_normalized, String title) {
        String id = (String.valueOf(image_name) + "_pop_img").replaceAll(" ", "_").replaceAll("-", "_").replaceAll("\\.", "_");
        StringBuffer result = new StringBuffer();
        result.append("<table class=\"sortable\" style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        result.append("  <tbody>");
        result.append("    <tr>");
        result.append("      <td style=\"vertical-align: top;\">" + title + "</td>");
        result.append("      <td style=\"vertical-align: top; text-align: right;\">Display in percents <input id=\"cb_" + id + "_pop_img\" checked=\"checked\" onclick='if (cb_" + id + "_pop_img.checked) { " + id + "_pop_img.src=\"" + image_name_normalized + "\" } else {" + id + "_pop_img.src=\"" + image_name + "\"}' type=\"checkbox\"><br>");
        result.append("      </td>");
        result.append("    </tr>");
        result.append("    <tr>");
        result.append("      <td colspan=\"2\" rowspan=\"1\" style=\"vertical-align: top;\"><img name=\"" + id + "_pop_img\" src=\"" + image_name_normalized + "\"></td>");
        result.append("    </tr>");
        result.append("  </tbody>");
        result.append("</table>");
        return new String(result);
    }

    public void writeVisitHistogram(String filename, int[] histo_visit_duration, int max_visit_duration) {
        GregorianCalendar[] timestamps = new GregorianCalendar[]{new GregorianCalendar(2004, 2, 1, 0, 0, 0), new GregorianCalendar(2004, 2, 1, 2, 0, 0), new GregorianCalendar(2004, 2, 1, 7, 0, 0), new GregorianCalendar(2004, 2, 1, 14, 0, 0), new GregorianCalendar(2004, 2, 1, 17, 0, 0), new GregorianCalendar(2004, 2, 1, 19, 0, 0), new GregorianCalendar(2004, 2, 1, 23, 0, 0), new GregorianCalendar(2004, 2, 1, 24, 0, 0)};
        double[] values = new double[]{100.0, 250.0, 230.0, 370.0, 350.0, 300.0, 340.0, 350.0};
        int len = histo_visit_duration.length;
        timestamps = new GregorianCalendar[len - 1];
        values = new double[len - 1];
        int bin_duration = max_visit_duration * 60 / len;
        int i = 0;
        while (i < len - 1) {
            timestamps[i] = new GregorianCalendar(2004, 2, 1, 0, 0, i * bin_duration);
            values[i] = histo_visit_duration[i];
            ++i;
        }
        try {
            LinearInterpolator linear = new LinearInterpolator(timestamps, values);
            RrdGraphDef gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            gDef.setTitle("Duration histogram");
            gDef.setTimeAxisLabel("duration [hours]");
            gDef.setVerticalLabel("number of visits");
            gDef.datasource("linear", (Plottable)linear);
            gDef.setShowSignature(false);
            gDef.setBaseValue(1000.0);
            gDef.line("linear", Color.RED, null, 2);
            RrdGraph graph = new RrdGraph(gDef);
            graph.saveAsPNG(filename, 366, 190);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeImageStatisticElementArray(GregorianCalendar[] timestamps, HTTPStatisticElement[] stats, String filename, String filename2, boolean normalized, int[] nbr_activity_days) {
        double[] nbr_visits = new double[stats.length + 1];
        double[] nbr_pages = new double[stats.length + 1];
        double[] nbr_hits = new double[stats.length + 1];
        double[] size = new double[stats.length + 1];
        if (normalized) {
            HTTPStatisticElement max_values = new HTTPStatisticElement();
            int i = 0;
            while (i < stats.length) {
                HTTPStatisticElement s = stats[i];
                if (s.nbr_visits > max_values.nbr_visits) {
                    max_values.nbr_visits = s.nbr_visits;
                }
                if (s.nbr_hits > max_values.nbr_hits) {
                    max_values.nbr_hits = s.nbr_hits;
                }
                if (s.nbr_pages > max_values.nbr_pages) {
                    max_values.nbr_pages = s.nbr_pages;
                }
                if (s.size > max_values.size) {
                    max_values.size = s.size;
                }
                ++i;
            }
            i = 0;
            while (i < timestamps.length - 1) {
                nbr_visits[i] = (double)stats[i].nbr_visits / (double)max_values.nbr_visits;
                nbr_pages[i] = (double)stats[i].nbr_pages / (double)max_values.nbr_pages;
                nbr_hits[i] = (double)stats[i].nbr_hits / (double)max_values.nbr_hits;
                size[i] = (double)stats[i].size / (double)max_values.size;
                ++i;
            }
        } else {
            int sum_nbr_activity_days = 0;
            int i = 0;
            while (i < nbr_activity_days.length) {
                sum_nbr_activity_days += nbr_activity_days[i];
                ++i;
            }
            double factor = sum_nbr_activity_days;
            int i2 = 0;
            while (i2 < timestamps.length - 1) {
                nbr_visits[i2] = (double)stats[i2].nbr_visits / factor;
                nbr_pages[i2] = (double)stats[i2].nbr_pages / factor;
                nbr_hits[i2] = (double)stats[i2].nbr_hits / factor;
                size[i2] = (double)stats[i2].size / factor;
                ++i2;
            }
        }
        nbr_visits[timestamps.length - 1] = nbr_visits[0];
        nbr_pages[timestamps.length - 1] = nbr_pages[0];
        nbr_hits[timestamps.length - 1] = nbr_hits[0];
        size[timestamps.length - 1] = size[0];
        try {
            LinearInterpolator linear_visits = new LinearInterpolator(timestamps, nbr_visits);
            LinearInterpolator linear_pages = new LinearInterpolator(timestamps, nbr_pages);
            LinearInterpolator linear_hits = new LinearInterpolator(timestamps, nbr_hits);
            LinearInterpolator linear_size = new LinearInterpolator(timestamps, size);
            RrdGraphDef gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            gDef.setTitle("Visits, pages & hits");
            gDef.setTimeAxisLabel("hours of the day");
            gDef.datasource("linear1", (Plottable)linear_visits);
            gDef.datasource("linear2", (Plottable)linear_pages);
            gDef.datasource("linear3", (Plottable)linear_hits);
            gDef.setShowSignature(false);
            gDef.setBaseValue(1000.0);
            gDef.line("linear1", Color.RED, "visits");
            gDef.line("linear2", Color.GREEN, "pages");
            gDef.line("linear3", Color.BLUE, "hits");
            RrdGraph graph = new RrdGraph(gDef);
            graph.saveAsPNG(filename, 366, 150);
            gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            gDef.setTitle("Downloaded data");
            gDef.setTimeAxisLabel("hours of the day");
            gDef.setVerticalLabel("size [bytes]");
            gDef.datasource("linear4", (Plottable)linear_size);
            gDef.setShowSignature(false);
            gDef.setBaseValue(1024.0);
            gDef.line("linear4", Color.BLACK, null);
            graph = new RrdGraph(gDef);
            graph.saveAsPNG(filename2, 366, 150);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("nbr_visits.length=" + nbr_visits.length);
            System.out.println("timestamps.length=" + timestamps.length);
        }
    }

    public void collect(double[] values, int nbr_values, boolean sliding_window) {
        block8: {
            if (nbr_values <= 1) break block8;
            if (sliding_window) {
                double[] values_bak = new double[values.length];
                System.arraycopy(values, 0, values_bak, 0, values.length);
                int i = nbr_values / 2;
                while (i < values_bak.length - nbr_values / 2) {
                    double sum = 0.0;
                    int nbr_null_values = 0;
                    int j = i - nbr_values / 2;
                    while (j < i + nbr_values / 2) {
                        sum += values_bak[j];
                        if ((int)values_bak[j] == 0) {
                            ++nbr_null_values;
                        }
                        ++j;
                    }
                    values[i] = sum / (double)nbr_values;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < values.length - nbr_values) {
                    double mean_value = 0.0;
                    int j = 0;
                    while (j < nbr_values) {
                        mean_value += values[i + j];
                        ++j;
                    }
                    j = 0;
                    while (j < nbr_values) {
                        values[i + j] = mean_value / (double)nbr_values;
                        ++j;
                    }
                    i += nbr_values;
                }
            }
        }
    }

    public void writeImageStatisticElementArrayYearVisits(GregorianCalendar[] timestamps, ArrayList stats, String filename, boolean normalized, StatisticElementArrayGetter getter) {
        this.writeImageStatisticElementArrayYearVisits(timestamps, stats, filename, normalized, 366, getter);
    }

    public void writeImageStatisticElementArrayYearVisits(GregorianCalendar[] timestamps, ArrayList stats, String filename, boolean normalized, int figure_width, StatisticElementArrayGetter getter) {
        int j;
        stats.size();
        int cfr_ignored_0 = this.colors.length;
        int nbr_values = timestamps.length;
        double[][] normalized_visits = new double[stats.size()][nbr_values];
        int i = 0;
        while (i < stats.size()) {
            DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i)).getDailyActivityStorage();
            normalized_visits[i] = getter.getValues(fam, timestamps[0].getTimeInMillis(), timestamps[timestamps.length - 1].getTimeInMillis());
            this.collect(normalized_visits[i], 14, true);
            ++i;
        }
        double[] max_visits = new double[nbr_values];
        int i2 = 0;
        while (i2 < stats.size()) {
            j = 0;
            while (j < max_visits.length) {
                int n = j;
                max_visits[n] = max_visits[n] + normalized_visits[i2][j];
                ++j;
            }
            ++i2;
        }
        if (normalized) {
            i2 = 0;
            while (i2 < stats.size()) {
                j = 0;
                while (j < max_visits.length) {
                    normalized_visits[i2][j] = Math.min(99.9, normalized_visits[i2][j] * 100.0 / Math.max(1.0, max_visits[j]));
                    ++j;
                }
                ++i2;
            }
        }
        try {
            RrdGraphDef gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            if (normalized) {
                gDef.setTitle("% of visits per day");
                gDef.setVerticalLabel("% of visits");
            } else {
                gDef.setTitle("number of visits per day");
                gDef.setVerticalLabel("number of visits");
            }
            gDef.setTimeAxisLabel("days of the year");
            int i3 = 0;
            while (i3 < stats.size()) {
                gDef.datasource("lin" + i3, (Plottable)new LinearInterpolator(timestamps, normalized_visits[i3]));
                ++i3;
            }
            gDef.setShowSignature(false);
            gDef.setBaseValue(1000.0);
            int max_event_name_len = 0;
            int i4 = 0;
            while (i4 < this.host.getHistoryGraphEvent().size()) {
                HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i4);
                max_event_name_len = Math.max(max_event_name_len, ev.getName().length());
                ++i4;
            }
            String spaces = "                                                        ";
            String spaces_required = max_event_name_len != 0 ? spaces.substring(0, max_event_name_len - "Events:".length() + 3) : spaces;
            gDef.comment("Legend:@LEvents:" + spaces_required + "@r");
            int nbr_displayed_events = 0;
            int max_legend_lines = this.colors.length - 1;
            int i5 = 0;
            while (i5 < Math.max(stats.size(), this.host.getHistoryGraphEvent().size())) {
                if (i5 < stats.size() && i5 < max_legend_lines) {
                    DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i5)).getDailyActivityStorage();
                    gDef.line("lin" + i5, this.colors[i5], String.valueOf(fam.getName()) + "@L");
                }
                if (i5 < this.host.getHistoryGraphEvent().size() && nbr_displayed_events < max_legend_lines) {
                    HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i5);
                    int index = (int)(ev.getCalendar().getTimeInMillis() / 86400000L) - (int)(timestamps[0].getTimeInMillis() / 86400000L);
                    if (index >= 0 && index < timestamps.length) {
                        gDef.vrule(timestamps[index], ev.getColorAsColor(), String.valueOf(ev.getName()) + spaces.substring(0, max_event_name_len - ev.getName().length()) + "@r", 2);
                        ++nbr_displayed_events;
                    } else {
                        gDef.comment("\n");
                    }
                } else if (i5 < max_legend_lines) {
                    gDef.comment("\n");
                }
                ++i5;
            }
            if (!normalized) {
                int index = Math.min(stats.size(), this.colors.length - 1);
                gDef.datasource("lin" + index, (Plottable)new LinearInterpolator(timestamps, max_visits));
                gDef.line("lin" + index, this.colors[index], "Total visits\n", 2);
            } else {
                gDef.comment("\n");
            }
            if (figure_width == 0) {
                figure_width = 366;
            }
            int figure_height = 200;
            String date_format = "MMMyy";
            int major_grid_step = (int)Math.round((double)timestamps.length / (double)figure_width);
            if (date_format.length() > 3) {
                ++major_grid_step;
            }
            gDef.setTimeAxis(5, 1, 5, major_grid_step, date_format, major_grid_step == 1);
            RrdGraph graph = new RrdGraph(gDef, true);
            graph.saveAsPNG(filename, figure_width, figure_height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeImageStatisticElementArrayYearVisits2(GregorianCalendar[] timestamps, ArrayList stats, String filename, boolean normalized) {
        stats.size();
        int cfr_ignored_0 = this.colors.length;
        int nbr_values = timestamps.length;
        double[][] normalized_visits = new double[stats.size()][nbr_values];
        double[][] max_visits = new double[stats.size()][nbr_values];
        int i = 0;
        while (i < stats.size()) {
            DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i)).getDailyActivityStorage();
            StatisticElement[] visits = fam.getRange(timestamps[0], timestamps[timestamps.length - 1]);
            int j = 0;
            while (j < nbr_values) {
                HTTPStatisticElement el = (HTTPStatisticElement)visits[j];
                normalized_visits[i][j] = el.getValue(1);
                max_visits[i][j] = el.getTotal(1);
                ++j;
            }
            ++i;
        }
        if (normalized) {
            i = 0;
            while (i < stats.size()) {
                int j = 0;
                while (j < nbr_values) {
                    normalized_visits[i][j] = Math.min(99.9, normalized_visits[i][j] * 100.0 / Math.max(1.0, max_visits[i][j]));
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < stats.size()) {
            this.collect(normalized_visits[i], 14, true);
            ++i;
        }
        try {
            RrdGraphDef gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            if (normalized) {
                gDef.setTitle("% of visits per day");
                gDef.setVerticalLabel("% of visits");
            } else {
                gDef.setTitle("number of visits per day");
                gDef.setVerticalLabel("number of visits");
            }
            gDef.setTimeAxisLabel("days of the year");
            int i2 = 0;
            while (i2 < stats.size()) {
                gDef.datasource("lin" + i2, (Plottable)new LinearInterpolator(timestamps, normalized_visits[i2]));
                ++i2;
            }
            gDef.setShowSignature(false);
            gDef.setBaseValue(1000.0);
            int max_event_name_len = 0;
            int i3 = 0;
            while (i3 < this.host.getHistoryGraphEvent().size()) {
                HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i3);
                max_event_name_len = Math.max(max_event_name_len, ev.getName().length());
                ++i3;
            }
            String spaces = "                                                        ";
            String spaces_required = max_event_name_len != 0 ? spaces.substring(0, max_event_name_len - "Events:".length() + 3) : spaces;
            gDef.comment("Legend:@LEvents:" + spaces_required + "@r");
            int i4 = 0;
            while (i4 < stats.size() && i4 < this.colors.length - 1) {
                DailyActivityStorage fam = ((DailyActivityStorageOwner)stats.get(i4)).getDailyActivityStorage();
                gDef.line("lin" + i4, this.colors[i4], String.valueOf(fam.getName()) + "@L");
                if (i4 < this.host.getHistoryGraphEvent().size()) {
                    HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i4);
                    int index = (int)(ev.getCalendar().getTimeInMillis() / 86400000L) - (int)(timestamps[0].getTimeInMillis() / 86400000L);
                    if (index >= 0 && index < timestamps.length) {
                        gDef.vrule(timestamps[index], ev.getColorAsColor(), String.valueOf(ev.getName()) + spaces.substring(0, max_event_name_len - ev.getName().length()) + "@r", 2);
                    } else {
                        gDef.comment("\n");
                    }
                } else {
                    gDef.comment("\n");
                }
                ++i4;
            }
            int figure_width = 366;
            int figure_height = 200;
            String date_format = "MMMyy";
            int major_grid_step = (int)Math.round((double)timestamps.length / (double)figure_width);
            if (date_format.length() > 3) {
                ++major_grid_step;
            }
            gDef.setTimeAxis(5, 1, 5, major_grid_step, date_format, major_grid_step == 1);
            RrdGraph graph = new RrdGraph(gDef, true);
            graph.saveAsPNG(filename, figure_width, figure_height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String makeReport(GregorianCalendar[] timestamps_days, String visitor_type, StatisticsTable table, String report_directory, boolean short_form, StatisticElementArrayGetter getter_graphs) {
        int[] nbr_days_pie = new int[]{7, 30};
        String id = (String.valueOf(visitor_type) + "_" + table.getName()).replaceAll(" ", "_").replaceAll("-", "_").toLowerCase();
        int pie_width = 340;
        int pie_height = 207;
        StringBuffer result = new StringBuffer();
        String help_link = table.getHelp();
        if (help_link != null) {
            help_link = "help/" + help_link;
        }
        String icon = "";
        if (table.getIcon() != null) {
            icon = "<img alt=\"" + table.getName() + " report\" src=\"images/" + table.getIcon() + "\" style=\"width: 16px; height: 16px;\" align=\"middle\"> ";
        }
        result.append("<p><table class=\"reporttable\">");
        result.append("  <tbody>");
        result.append("    <tr>");
        result.append("      <td class=\"tabletitle\">&nbsp;" + icon + table.getName() + "</td>");
        result.append("      <td align=\"right\">");
        if (help_link != null) {
            result.append("     <a href=\"" + help_link + "\"><img src=\"images/help.png\" alt=\"Contextual help\" border=\"0\"></a>");
        }
        result.append("    </td></tr>");
        result.append("    <tr>");
        result.append("      <td colspan=\"3\">");
        result.append("      <p align=\"center\">");
        result.append("      <table border=\"0\" cellspacing=\"0\">");
        result.append("        <tbody>");
        table.sort();
        int num_pie = 0;
        while (num_pie < nbr_days_pie.length) {
            String pie_filename = String.valueOf(id) + "pie_" + num_pie + ".png";
            result.append("          <tr>");
            result.append("            <td style=\"vertical-align: " + (num_pie == 0 ? "top" : "bottom") + ";\">");
            result.append("            <table class=\"sortable\" style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"2\" cellspacing=\"2\">");
            result.append("              <tbody>");
            result.append("                <tr>");
            result.append("                  <td style=\"vertical-align: top;\">Mean visits over the last " + nbr_days_pie[num_pie] + " days</td>");
            result.append("                </tr>");
            result.append("                <tr>");
            result.append("                  <td style=\"vertical-align: top;\">");
            result.append("                  <img alt=\"" + table.getName() + " report, pie over " + nbr_days_pie[num_pie] + " days\" src=\"" + pie_filename + "\" style=\"width: " + pie_width + "px; height: " + pie_height + "px;\"></td>");
            result.append("                </tr>");
            result.append("              </tbody>");
            result.append("            </table>");
            result.append("            </td>");
            this.writePieReport(timestamps_days[timestamps_days.length - 1], nbr_days_pie[num_pie], new ArrayList(table.getArrayList()), String.valueOf(report_directory) + pie_filename, pie_width, pie_height, getter_graphs);
            if (num_pie == 0) {
                String history_filename_norm = String.valueOf(id) + "_pop_norm.png";
                String history_filename = String.valueOf(id) + "_pop.png";
                result.append("            <td colspan=\"1\" rowspan=\"" + nbr_days_pie.length + "\" style=\"vertical-align: top;\">");
                result.append(this.getNormalizedImageTable(history_filename, history_filename_norm, "History"));
                result.append("            </td>");
                this.writeImageStatisticElementArrayYearVisits(timestamps_days, new ArrayList(table.getArrayList()), String.valueOf(report_directory) + history_filename, false, getter_graphs);
                this.writeImageStatisticElementArrayYearVisits(timestamps_days, new ArrayList(table.getArrayList()), String.valueOf(report_directory) + history_filename_norm, true, getter_graphs);
            }
            result.append("          </tr>");
            ++num_pie;
        }
        result.append("        </tbody>");
        result.append("      </table>");
        String topX_link = "topX link";
        String details_link = table.getDetails();
        String unknown_link = table.getUnknown();
        String footnotes = "";
        if (unknown_link != null) {
            unknown_link = String.valueOf(visitor_type) + "." + unknown_link;
        }
        if (details_link != null) {
            details_link = String.valueOf(visitor_type) + "." + details_link;
        }
        if (short_form) {
            result.append("<!-- short form -->");
            result.append("<p style=\"text-align:right; position: relative; left: -5px; top: -5px;\">Statistics over the whole report period:&nbsp; ");
            result.append("<a href=\"" + topX_link + "\"><img alt=\"Top " + table.nbr_displayed_rows_in_summary + "\" src=\"images/top10.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Top " + table.nbr_displayed_rows_in_summary + "</a>");
            if (details_link != null) {
                result.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + details_link + "\"><img alt=\"Display the full table and details\" src=\"images/details.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Details</a>");
            }
            if (unknown_link != null) {
                result.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + unknown_link + "\">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + "Unknow</a>");
            }
            result.append("</p>");
        } else {
            result.append("<!-- long form -->");
            result.append("      <table style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
            result.append("        <tbody>");
            result.append("          <tr>");
            result.append("            <td style=\"vertical-align: bottom;\">");
            result.append("            <p>Statistics over the whole report period (Top " + table.nbr_displayed_rows_in_summary + ")</p>");
            result.append("            </td>");
            result.append("            <td style=\"vertical-align: top; text-align: right;\">");
            if (details_link != null) {
                result.append("            <a href=\"" + details_link + "\"><img alt=\"Display the full table and details\" src=\"images/details.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Details</a>");
            }
            if (unknown_link != null) {
                result.append("            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + unknown_link + "\"><img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Unknow</a></td>");
            }
            result.append("          </tr>");
            result.append("        </tbody>");
            result.append("      </table>");
            boolean limit_table_size = true;
            result.append(this.makeTable(table, limit_table_size, table.getColumns(), details_link, unknown_link, table.getHelp(), footnotes));
            if (details_link != null) {
                StringBuffer result_details = new StringBuffer();
                result_details.append(this.getReportHeader());
                result_details.append("<p>");
                result_details.append("<table class=\"reporttable\">");
                result_details.append("<tr><td class=\"tabletitle\">&nbsp;" + table.getName() + " " + (table.nbr_displayed_rows_in_summary > 0 && limit_table_size ? "(Top " + table.nbr_displayed_rows_in_summary + ")" : ""));
                if (details_link != null) {
                    result_details.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=\"" + details_link + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a>");
                }
                if (unknown_link != null) {
                    result_details.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=" + unknown_link + ">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + " Unknown</a>");
                }
                result_details.append("</td><td align=right>");
                if (help_link != null) {
                    result_details.append("<a href=help/" + help_link + "><img border=0 src=images/help.png></a>");
                }
                result_details.append("</td></tr>");
                result_details.append("<tr><td colspan=3>");
                result_details.append(this.makeTable(table, false, table.getColumns(), null, unknown_link, help_link, footnotes));
                result_details.append("</td></tr></table>");
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(report_directory) + details_link));
                    out.println(new String(result_details));
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        result.append("      </td>");
        result.append("    </tr>");
        result.append("  </tbody>");
        result.append("</table>");
        return new String(result);
    }

    public String makeReportBar(GregorianCalendar[] timestamps_days, String visitor_type, StatisticsTable table, String report_directory, boolean short_form) {
        int[] nbr_days_pie = new int[]{7, 30};
        String id = (String.valueOf(visitor_type) + "_" + table.getName()).replaceAll(" ", "_").replaceAll("-", "_").toLowerCase();
        int pie_width = 340;
        int pie_height = 207;
        StringBuffer result = new StringBuffer();
        String help_link = table.getHelp();
        if (help_link != null) {
            help_link = "help/" + help_link;
        }
        result.append("<p><table class=\"reporttable\">");
        result.append("  <tbody>");
        result.append("    <tr>");
        result.append("      <td class=\"tabletitle\">&nbsp;" + (table.getIcon() != null ? "<img alt=\"" + table.getName() + " report\" src=\"images/" + table.getIcon() + "\" style=\"width: 16px; height: 16px;\" align=\"middle\"> " : "") + table.getName() + "</td>");
        result.append("      <td align=\"right\">");
        if (help_link != null) {
            result.append("     <a href=\"" + help_link + "\"><img src=\"images/help.png\" alt=\"Contextual help\" border=\"0\"></a>");
        }
        result.append("    </td></tr>");
        result.append("    <tr>");
        result.append("      <td colspan=\"3\">");
        result.append("      <p align=\"center\">");
        result.append("      <table border=\"0\" cellspacing=\"0\">");
        result.append("        <tbody>");
        table.sort();
        int num_pie = 0;
        while (num_pie < nbr_days_pie.length) {
            String bar_filename = String.valueOf(id) + "bar_" + num_pie + ".png";
            result.append("          <tr>");
            result.append("            <td style=\"vertical-align: " + (num_pie == 0 ? "top" : "bottom") + ";\">");
            result.append("            <table class=\"sortable\" style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"2\" cellspacing=\"2\">");
            result.append("              <tbody>");
            result.append("                <tr>");
            result.append("                  <td style=\"vertical-align: top;\">Mean visits over the last " + nbr_days_pie[num_pie] + " days</td>");
            result.append("                </tr>");
            result.append("                <tr>");
            result.append("                  <td style=\"vertical-align: top;\">");
            result.append("                  <img alt=\"" + table.getName() + " report, bar over " + nbr_days_pie[num_pie] + " days\" src=\"" + bar_filename + "\" style=\"width: " + pie_width + "px; height: " + pie_height + "px;\"></td>");
            result.append("                </tr>");
            result.append("              </tbody>");
            result.append("            </table>");
            result.append("            </td>");
            this.writeBarReport(timestamps_days[timestamps_days.length - 1], nbr_days_pie[num_pie], new ArrayList(table.getArrayList()), String.valueOf(report_directory) + bar_filename, pie_width, pie_height);
            if (num_pie == 0) {
                String history_filename_norm = String.valueOf(id) + "_pop_norm.png";
                String history_filename = String.valueOf(id) + "_pop.png";
                result.append("            <td colspan=\"1\" rowspan=\"" + nbr_days_pie.length + "\" style=\"vertical-align: top;\">");
                result.append("            <table class=\"sortable\" style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
                result.append("              <tbody>");
                result.append("                <tr>");
                result.append("                  <td style=\"vertical-align: top;\">History&nbsp;</td>");
                result.append("                  <td style=\"vertical-align: top; text-align: right;\">Display in percents <input id=\"cb_" + id + "_pop_img\" checked=\"checked\" onclick='if (cb_" + id + "_pop_img.checked) { " + id + "_pop_img.src=\"" + history_filename_norm + "\" } else {" + id + "_pop_img.src=\"" + history_filename + "\"}' type=\"checkbox\"><br>");
                result.append("                  </td>");
                result.append("                </tr>");
                result.append("                <tr>");
                result.append("                  <td colspan=\"2\" rowspan=\"1\" style=\"vertical-align: top;\"><img name=\"" + id + "_pop_img\" src=\"" + history_filename_norm + "\"></td>");
                result.append("                </tr>");
                result.append("              </tbody>");
                result.append("            </table>");
                result.append("            </td>");
                this.writeImageStatisticElementArrayYearVisits2(timestamps_days, new ArrayList(table.getArrayList()), String.valueOf(report_directory) + history_filename, false);
                this.writeImageStatisticElementArrayYearVisits2(timestamps_days, new ArrayList(table.getArrayList()), String.valueOf(report_directory) + history_filename_norm, true);
            }
            result.append("          </tr>");
            ++num_pie;
        }
        result.append("        </tbody>");
        result.append("      </table>");
        String topX_link = "topX link";
        String details_link = table.getDetails();
        String unknown_link = table.getUnknown();
        String footnotes = "";
        if (unknown_link != null) {
            unknown_link = String.valueOf(visitor_type) + "." + unknown_link;
        }
        if (details_link != null) {
            details_link = String.valueOf(visitor_type) + "." + details_link;
        }
        if (short_form) {
            result.append("<!-- short form -->");
            result.append("<p style=\"text-align:right; position: relative; left: -5px; top: -5px;\">Statistics over the whole report period:&nbsp; ");
            result.append("<a href=\"" + topX_link + "\"><img alt=\"Top " + table.nbr_displayed_rows_in_summary + "\" src=\"images/top10.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Top " + table.nbr_displayed_rows_in_summary + "</a>");
            if (details_link != null) {
                result.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + details_link + "\"><img alt=\"Display the full table and details\" src=\"images/details.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Details</a>");
            }
            if (unknown_link != null) {
                result.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + unknown_link + "\">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + "Unknow</a>");
            }
            result.append("</p>");
        } else {
            result.append("<!-- long form -->");
            result.append("      <table style=\"width: 100%; text-align: left;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
            result.append("        <tbody>");
            result.append("          <tr>");
            result.append("            <td style=\"vertical-align: bottom;\">");
            result.append("            <p>Statistics over the whole report period (Top " + table.nbr_displayed_rows_in_summary + ")</p>");
            result.append("            </td>");
            result.append("            <td style=\"vertical-align: top; text-align: right;\">");
            if (details_link != null) {
                result.append("            <a href=\"" + details_link + "\"><img alt=\"Display the full table and details\" src=\"images/details.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Details</a>");
            }
            if (unknown_link != null) {
                result.append("            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + unknown_link + "\"><img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">Unknow</a></td>");
            }
            result.append("          </tr>");
            result.append("        </tbody>");
            result.append("      </table>");
            boolean limit_table_size = true;
            result.append(this.makeTable(table, limit_table_size, table.getColumns(), details_link, unknown_link, table.getHelp(), footnotes));
            if (details_link != null) {
                StringBuffer result_details = new StringBuffer();
                result_details.append(this.getReportHeader());
                result_details.append("<p>");
                result_details.append("<table class=\"reporttable\">");
                result_details.append("<tr><td class=\"tabletitle\">&nbsp;" + table.getName() + " " + (table.nbr_displayed_rows_in_summary > 0 && limit_table_size ? "(Top " + table.nbr_displayed_rows_in_summary + ")" : ""));
                if (details_link != null) {
                    result_details.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=\"" + details_link + "\">" + "<img src=\"images/details.png\" border=0>" + " Details</a>");
                }
                if (unknown_link != null) {
                    result_details.append("&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<a href=" + unknown_link + ">" + "<img alt=\"Displays details about unknown informations\" src=\"images/unknown.png\" style=\"border: 0px solid ; width: 16px; height: 16px;\" align=\"middle\">" + " Unknown</a>");
                }
                result_details.append("</td><td align=right>");
                if (help_link != null) {
                    result_details.append("<a href=help/" + help_link + "><img border=0 src=images/help.png></a>");
                }
                result_details.append("</td></tr>");
                result_details.append("<tr><td colspan=3>");
                result_details.append(this.makeTable(table, false, table.getColumns(), null, unknown_link, help_link, footnotes));
                result_details.append("</td></tr></table>");
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(report_directory) + details_link));
                    out.println(new String(result_details));
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        result.append("      </td>");
        result.append("    </tr>");
        result.append("  </tbody>");
        result.append("</table>");
        return new String(result);
    }

    public void writeGraphic(GregorianCalendar[] timestamps, DailyActivityStorage das, String filename, boolean normalized, StatisticElementArrayGetter[] getters, String figure_title, String xlabel, String ylabel, int figure_width, int figure_height, int nbr_days_smooth) {
        this.writeGraphic(timestamps, das, filename, normalized, getters, figure_title, xlabel, ylabel, figure_width, figure_height, nbr_days_smooth, null, null);
    }

    public void writeGraphic(GregorianCalendar[] timestamps, DailyActivityStorage das, String filename, boolean normalized, StatisticElementArrayGetter[] getters, String figure_title, String xlabel, String ylabel, int figure_width, int figure_height, int nbr_days_smooth, GregorianCalendar date_start, GregorianCalendar date_stop) {
        int i;
        Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.BLACK, Color.CYAN, Color.MAGENTA};
        long first_date = date_start != null ? date_start.getTimeInMillis() : timestamps[0].getTimeInMillis();
        long last_date = date_stop != null ? date_stop.getTimeInMillis() : timestamps[timestamps.length - 1].getTimeInMillis();
        double[][] values = new double[getters.length][timestamps.length];
        double[] total_values = new double[timestamps.length];
        int num_getter = 0;
        while (num_getter < getters.length) {
            values[num_getter] = getters[num_getter].getValues(das, first_date, last_date);
            this.collect(values[num_getter], nbr_days_smooth, true);
            int i2 = 0;
            while (i2 < total_values.length) {
                int n = i2;
                total_values[n] = total_values[n] + values[num_getter][i2];
                ++i2;
            }
            ++num_getter;
        }
        if (normalized) {
            num_getter = 0;
            while (num_getter < getters.length) {
                double[] v = values[num_getter];
                i = 0;
                while (i < total_values.length) {
                    int n = i;
                    v[n] = v[n] / total_values[i];
                    ++i;
                }
                ++num_getter;
            }
        }
        try {
            RrdGraphDef gDef = new RrdGraphDef(timestamps[0], timestamps[timestamps.length - 1]);
            int num_getter2 = 0;
            while (num_getter2 < getters.length) {
                gDef.datasource("s" + num_getter2, (Plottable)new LinearInterpolator(timestamps, values[num_getter2]));
                ++num_getter2;
            }
            if (figure_title != null) {
                gDef.setTitle(figure_title);
            }
            if (xlabel != null) {
                gDef.setTimeAxisLabel(xlabel);
            }
            if (ylabel != null) {
                gDef.setVerticalLabel(ylabel);
            }
            gDef.setShowSignature(false);
            gDef.setBaseValue(1000.0);
            int max_event_name_len = 0;
            i = 0;
            while (i < this.host.getHistoryGraphEvent().size()) {
                HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i);
                max_event_name_len = Math.max(max_event_name_len, ev.getName().length());
                ++i;
            }
            String spaces = "                                                        ";
            String spaces_required = max_event_name_len != 0 ? spaces.substring(0, max_event_name_len - "Events:".length() + 3) : spaces;
            gDef.comment("Legend:@LEvents:" + spaces_required + "@r");
            int i3 = 0;
            while (i3 < Math.max(getters.length, this.host.getHistoryGraphEvent().size()) && i3 < colors.length - 1) {
                if (i3 < getters.length) {
                    gDef.line("s" + i3, colors[i3], String.valueOf(getters[i3].getValueName()) + "@L");
                }
                if (i3 < this.host.getHistoryGraphEvent().size()) {
                    HistoryGraphEvent ev = (HistoryGraphEvent)this.host.getHistoryGraphEvent().elementAt(i3);
                    int index = (int)(ev.getCalendar().getTimeInMillis() / 86400000L) - (int)(timestamps[0].getTimeInMillis() / 86400000L);
                    if (index >= 0 && index < timestamps.length) {
                        gDef.vrule(timestamps[index], ev.getColorAsColor(), String.valueOf(ev.getName()) + spaces.substring(0, max_event_name_len - ev.getName().length()) + "@r", 2);
                    } else {
                        gDef.comment("\n");
                    }
                } else {
                    gDef.comment("\n");
                }
                ++i3;
            }
            int report_duration_days = (int)(timestamps[timestamps.length - 1].getTimeInMillis() / 1000L / 60L / 60L / 24L) - (int)(timestamps[0].getTimeInMillis() / 1000L / 60L / 60L / 24L);
            if (report_duration_days > 8) {
                String date_format = "MMMyy";
                int major_grid_step = (int)Math.round((double)timestamps.length / (double)figure_width);
                if (date_format.length() > 3) {
                    ++major_grid_step;
                }
                gDef.setTimeAxis(5, 1, 5, major_grid_step, date_format, major_grid_step == 1);
            } else if (report_duration_days > 2) {
                gDef.setTimeAxis(2, 24, 3, 1, "EE", false);
                gDef.setFirstDayOfWeek(1);
            }
            RrdGraph graph = new RrdGraph(gDef, true);
            graph.saveAsPNG(filename, figure_width, figure_height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String longToDownloadQuantity(long bytes) {
        String[] suffix = new String[]{"B", "KB", "MB", "GB", "TB"};
        double number = bytes;
        int index = 0;
        while (number > 1024.0 && index < suffix.length) {
            ++index;
            number /= 1024.0;
        }
        return String.valueOf((float)Math.round(number * 10.0) / 10.0f) + " " + suffix[index];
    }

    public String getReportHeader() {
        return this.getReportHeader(0);
    }

    public String getReportHeader(int nbr_subdirs) {
        StringBuffer buffer = new StringBuffer();
        String str_2dot = "";
        int i = 0;
        while (i < nbr_subdirs) {
            str_2dot = String.valueOf(str_2dot) + "../";
            ++i;
        }
        buffer.append("<script type=\"text/javascript\" src=\"" + str_2dot + "sorttable.js\"></script>\n");
        buffer.append("<link rel=\"stylesheet\" href=\"" + str_2dot + "look_and_feel.css\" type=\"text/css\" />");
        return new String(buffer);
    }

    public String booleanToYesNoImageURL(boolean value) {
        if (value) {
            return "<img src=\"images/yes.png\" border=0>";
        }
        return "<img src=\"images/no.png\" border=0>";
    }

    public double round(double value, int nbr_digits) {
        double factor = 1.0;
        while (nbr_digits > 0) {
            factor *= 10.0;
            --nbr_digits;
        }
        return (double)Math.round(value * factor) / factor;
    }

    public void setAveragePagesPerVisit(double avg_pages_per_visit) {
        this.avg_pages_per_visit = avg_pages_per_visit;
    }

    public double getAveragePagesPerVisit() {
        return this.avg_pages_per_visit;
    }
}

