/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.taskscheduler;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ScheduledTask {
    public static final int PLANIFICATION_UNSPECIFIED = -1;
    public static final int PLANIFICATION_MINUTE = 1;
    public static final int PLANIFICATION_HOURLY = 2;
    public static final int PLANIFICATION_DAILY = 3;
    public static final int PLANIFICATION_WEEKLY = 4;
    public static final int PLANIFICATION_MONTHLY = 5;
    public static final int PLANIFICATION_ONCE = 6;
    public static final int PLANIFICATION_ONSTART = 7;
    public static final int PLANIFICATION_ONLOGON = 8;
    public static final int PLANIFICATION_ONIDLE = 9;
    private int planification = -1;
    private String command = null;
    private String name;
    private boolean interactive = false;
    private boolean[] launch_day_in_week = new boolean[8];
    private int hour = -1;
    private int minute = -1;
    private int id = -1;
    private String username = null;
    private String password = null;

    public ScheduledTask(String name) {
        this.setName(name);
    }

    public void setPlanification(int planification) {
        this.planification = planification;
    }

    public int getPlanification() {
        return this.planification;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setLaunchDayInWeek(int day_of_week, boolean must_be_launched) {
        this.launch_day_in_week[day_of_week] = must_be_launched;
    }

    public boolean[] getLaunchDaysInWeek() {
        return this.launch_day_in_week;
    }

    public void setStartTime(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    public int getStartHour() {
        return this.hour;
    }

    public int getStartMinute() {
        return this.minute;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void askLogin() {
        if (this.username == null) {
            this.username = System.getProperty("user.name");
        }
        if (this.password == null) {
            JFrame f = new JFrame();
            this.password = JOptionPane.showInputDialog(f, "Interactive tasks require a login. Please enter the password for the user \"" + this.username + "\", or cancel to use non-interactive mode.", "Scheduled task creation/deletion/edition", 3);
            if (this.password != null && this.password.length() == 0) {
                JOptionPane.showMessageDialog(f, "The password cannot be empty. Please change it in Windows user account management.");
                this.password = "\"\"";
            }
        }
    }
}

