/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.taskscheduler;

import ch.kronospace.taskscheduler.ScheduledTask;
import ch.kronospace.taskscheduler.TaskSchedulerWindowsAT;
import ch.kronospace.taskscheduler.TaskSchedulerWindowsSchTasks;
import ch.kronospace.tools.DOSCommands;
import java.io.File;

public abstract class TaskScheduler {
    static TaskScheduler default_scheduler = null;

    public static TaskScheduler getDefault() {
        if (default_scheduler != null) {
            return default_scheduler;
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows ")) {
            File schtasks_exe;
            String system_root = DOSCommands.getenv("SystemRoot");
            File at_exe = new File(String.valueOf(system_root) + "/system32/at.exe");
            if (at_exe.exists()) {
                default_scheduler = new TaskSchedulerWindowsAT();
            }
            if (!(schtasks_exe = new File(String.valueOf(system_root) + "/system32/schtasks.exe")).exists()) {
                schtasks_exe = new File("lib/schtasks.exe");
            }
            if (schtasks_exe.exists()) {
                default_scheduler = new TaskSchedulerWindowsSchTasks(schtasks_exe);
            }
            if (default_scheduler == null) {
                System.out.println("Error: no task scheduler program could be found on your machine (at.exe or schtasks.exe).");
            }
        } else {
            System.out.println("Error: cannot recognize the task scheduler for your operating system. Please submit a RFE.");
        }
        return default_scheduler;
    }

    public abstract boolean isPlanificationSupported(int var1);

    public abstract void create(ScheduledTask var1);

    public abstract void delete(ScheduledTask var1);

    public static final void main(String[] args) {
        ScheduledTask task = new ScheduledTask("test task");
        task.setPlanification(2);
        task.setCommand("winmine.exe");
        task.setInteractive(true);
        task.setLaunchDayInWeek(1, true);
        task.setLaunchDayInWeek(2, true);
        task.setLaunchDayInWeek(7, true);
        task.setStartTime(18, 30);
        TaskScheduler scheduler = TaskScheduler.getDefault();
        scheduler.create(task);
    }
}

