/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.taskscheduler;

import ch.kronospace.taskscheduler.ScheduledTask;
import ch.kronospace.taskscheduler.TaskScheduler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskSchedulerWindowsAT
extends TaskScheduler {
    private final String[] PLANIFICATIONS_AT;
    private String[] days_short_name;

    public TaskSchedulerWindowsAT() {
        String[] stringArray = new String[10];
        stringArray[3] = "DAILY";
        stringArray[4] = "WEEKLY";
        stringArray[5] = "MONTHLY";
        this.PLANIFICATIONS_AT = stringArray;
        this.days_short_name = null;
        this.init();
    }

    public boolean isPlanificationSupported(int planification_type) {
        return this.PLANIFICATIONS_AT[planification_type] != null;
    }

    public void create(ScheduledTask task) {
        String at_command = "at ";
        at_command = String.valueOf(at_command) + task.getStartHour() + ":" + task.getStartMinute() + " ";
        if (task.isInteractive()) {
            at_command = String.valueOf(at_command) + "/INTERACTIVE ";
        }
        boolean[] launch_days = task.getLaunchDaysInWeek();
        int nbr_days_to_launch = 0;
        int i = 1;
        while (i < launch_days.length) {
            if (launch_days[i]) {
                ++nbr_days_to_launch;
            }
            ++i;
        }
        if (nbr_days_to_launch > 0) {
            at_command = String.valueOf(at_command) + "/every:";
            i = 1;
            while (i < launch_days.length) {
                if (launch_days[i]) {
                    at_command = String.valueOf(at_command) + this.days_short_name[i] + ",";
                }
                ++i;
            }
            at_command = String.valueOf(at_command.substring(0, at_command.length() - 1)) + " ";
        }
        String create = at_command = String.valueOf(at_command) + "\"" + task.getCommand() + "\"";
        try {
            Process p = Runtime.getRuntime().exec(create);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String ligne = in.readLine();
            Pattern pat = Pattern.compile(".*ID = (\\d+)");
            while (ligne != null) {
                Matcher m = pat.matcher(ligne);
                if (m.find()) {
                    try {
                        int id = Integer.parseInt(m.group(1));
                        task.setID(id);
                        if (task.getName().length() == 0) {
                            task.setName("At" + id);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ligne = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScheduledTask task) {
        if (task.getID() < 0) {
            System.out.println("Error: cannot remove a task without its ID.");
            return;
        }
        try {
            Runtime.getRuntime().exec("at " + task.getID() + " /DELETE");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        SimpleDateFormat df = new SimpleDateFormat("EE", Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        String[] days = new String[8];
        days[0] = null;
        int i = 1;
        while (i < days.length) {
            cal.set(7, i);
            days[i] = df.format(cal.getTime());
            ++i;
        }
        i = 1;
        while (i < days.length) {
            int nbr_letters = 1;
            String short_name = null;
            boolean same_short_name_exist = false;
            block2: do {
                short_name = days[i].substring(0, nbr_letters);
                same_short_name_exist = false;
                int j = 1;
                while (j < days.length) {
                    if (i != j && days[j].startsWith(short_name)) {
                        same_short_name_exist = true;
                        ++nbr_letters;
                        continue block2;
                    }
                    ++j;
                }
            } while (same_short_name_exist);
            days[i] = short_name;
            ++i;
        }
        this.days_short_name = days;
    }
}

