/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.taskscheduler;

import ch.kronospace.taskscheduler.ScheduledTask;
import ch.kronospace.taskscheduler.TaskScheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class TaskSchedulerWindowsSchTasks
extends TaskScheduler {
    private final String[] PLANIFICATIONS_WINXP;
    private File schtasks_exe;

    public TaskSchedulerWindowsSchTasks(File schtasks_exe) {
        String[] stringArray = new String[10];
        stringArray[1] = "MINUTE";
        stringArray[2] = "HOURLY";
        stringArray[3] = "DAILY";
        stringArray[4] = "WEEKLY";
        stringArray[5] = "MONTHLY";
        stringArray[6] = "ONCE";
        stringArray[7] = "ONSTART";
        stringArray[8] = "ONLOGON";
        stringArray[9] = "ONIDLE";
        this.PLANIFICATIONS_WINXP = stringArray;
        this.schtasks_exe = null;
        this.schtasks_exe = schtasks_exe;
    }

    public boolean isPlanificationSupported(int planification_type) {
        return this.PLANIFICATIONS_WINXP[planification_type] != null;
    }

    public void create(ScheduledTask task) {
        String planif = this.PLANIFICATIONS_WINXP[task.getPlanification()];
        if (planif == null) {
            throw new UnsupportedOperationException("not supported planification");
        }
        String start_time = "";
        if (task.getStartHour() >= 0) {
            start_time = "/ST " + (task.getStartHour() > 9 ? "" : "0") + task.getStartHour() + ":" + (task.getStartMinute() > 9 ? "" : "0") + task.getStartMinute() + ":00";
        }
        String interactive = "/ru system";
        if (task.isInteractive()) {
            task.askLogin();
            if (task.getPassword() != null) {
                interactive = "/ru " + task.getUsername() + " /rp " + task.getPassword();
            }
        }
        String prg = "schtasks";
        if (this.schtasks_exe != null) {
            prg = this.schtasks_exe.getAbsolutePath();
        }
        String create = String.valueOf(prg) + " /create /tn \"" + task.getName() + "\" /tr \"" + task.getCommand() + "\" /sc " + planif + " " + start_time + " " + interactive;
        System.out.println(create);
        try {
            Process p = Runtime.getRuntime().exec(create);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String ligne = in.readLine();
            while (ligne != null) {
                System.out.println(ligne);
                ligne = in.readLine();
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void delete(ScheduledTask task) {
        try {
            String prg = "schtasks";
            if (this.schtasks_exe != null) {
                prg = this.schtasks_exe.getAbsolutePath();
            }
            Runtime.getRuntime().exec(String.valueOf(prg) + " /DELETE /F /tn \"" + task.getName() + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

