/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.tools;

import ch.kronospace.tools.CompressedEntry;
import ch.kronospace.tools.DOSCommands;
import ch.kronospace.tools.DiskTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompressedFile {
    private static File unrar_exe = new File(String.valueOf(DOSCommands.getenv("ProgramFiles")) + "/WinRAR/unrar.exe");
    private static File global_temp_directory;
    private File temp_directory = null;
    private Vector open_streams = new Vector();
    File compressed_file = null;
    Vector entries = new Vector();

    static {
        if (!unrar_exe.exists()) {
            unrar_exe = new File("lib/unrar.exe");
        }
        if (!unrar_exe.exists()) {
            throw new RuntimeException("unable to find " + unrar_exe.getAbsolutePath());
        }
        global_temp_directory = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + "ch.kronospace.tool" + File.separatorChar);
    }

    public CompressedFile(File compressed_file) {
        this.compressed_file = compressed_file;
        this.temp_directory = new File(global_temp_directory, compressed_file.getName());
        this.computeEntries();
    }

    public void uncompressTo(File out_directory) {
        try {
            Runtime r = Runtime.getRuntime();
            String command = "\"" + unrar_exe.getAbsolutePath() + "\" e -y " + this.compressed_file.getAbsolutePath() + " " + out_directory.getAbsolutePath() + "\\";
            Process pr = r.exec(command);
            InputStream stdinp = pr.getInputStream();
            BufferedReader brinp = new BufferedReader(new InputStreamReader(stdinp));
            while (brinp.readLine() != null) {
            }
            brinp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        Enumeration e = this.open_streams.elements();
        while (e.hasMoreElements()) {
            InputStream in = (InputStream)e.nextElement();
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DiskTools.deltree(this.temp_directory);
        if (global_temp_directory.exists() && global_temp_directory.listFiles().length == 0) {
            global_temp_directory.delete();
        }
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    private void computeEntries() {
        try {
            Runtime r = Runtime.getRuntime();
            Process pr = r.exec(String.valueOf(unrar_exe.getAbsolutePath()) + " v " + this.compressed_file.getAbsolutePath());
            InputStream stdinp = pr.getInputStream();
            BufferedReader brinp = new BufferedReader(new InputStreamReader(stdinp));
            String lineinp = null;
            Pattern pat_tiret = Pattern.compile("\\-+");
            while ((lineinp = brinp.readLine()) != null) {
                Matcher m = pat_tiret.matcher(lineinp);
                if (m.matches()) break;
            }
            Pattern pat_parse = Pattern.compile("\\s+(\\d+)\\s+(\\d+)");
            while ((lineinp = brinp.readLine()) != null) {
                Matcher m = pat_tiret.matcher(lineinp);
                if (m.matches()) break;
                String name = lineinp.substring(1);
                CompressedEntry entry = new CompressedEntry(name);
                lineinp = brinp.readLine();
                if (lineinp == null) {
                    throw new RuntimeException("bad entry format: no more lines");
                }
                m = pat_parse.matcher(lineinp);
                if (!m.find()) continue;
                entry.setCompressedSize(Long.parseLong(m.group(2)));
                entry.setSize(Long.parseLong(m.group(1)));
                System.out.println(lineinp);
                System.out.println(entry);
                this.entries.add(entry);
            }
            brinp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        this.close();
    }

    public CompressedEntry getEntry(String name) {
        return null;
    }

    public InputStream getInputStream(CompressedEntry entry) {
        try {
            Runtime r = Runtime.getRuntime();
            String command = "\"" + unrar_exe.getAbsolutePath() + "\" e -y " + this.compressed_file.getAbsolutePath() + " " + entry.getName() + " " + this.temp_directory.getAbsolutePath() + "\\";
            Process pr = r.exec(command);
            InputStream stdinp = pr.getInputStream();
            BufferedReader brinp = new BufferedReader(new InputStreamReader(stdinp));
            while (brinp.readLine() != null) {
            }
            brinp.close();
            FileInputStream in = new FileInputStream(new File(this.temp_directory, entry.getName()));
            this.open_streams.add(in);
            return in;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return this.compressed_file.getName();
    }

    public int size() {
        return this.entries.size();
    }
}

