/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JXMonthView;

public class DateChooser
extends JComponent {
    private static final long serialVersionUID = 1L;
    final JXMonthView monthView = new JXMonthView();
    final JSpinner spin_year = new JSpinner(new SpinnerDateModel());

    public DateChooser() {
        this.monthView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.monthView.setFont(this.monthView.getFont().deriveFont(0));
        this.monthView.setTodayBackground(Color.RED);
        this.spin_year.setEditor(new JSpinner.DateEditor(this.spin_year, "dd.MM.yyyy"));
        this.spin_year.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                long date = ((SpinnerDateModel)DateChooser.this.spin_year.getModel()).getDate().getTime();
                DateChooser.this.monthView.setFirstDisplayedDate(date);
                DateChooser.this.monthView.setSelectedDateSpan(new DateSpan(date, date));
            }
        });
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.spin_year);
        this.setLayout(new BorderLayout());
        this.add((Component)p, "North");
        this.add((Component)this.monthView, "Center");
    }

    public void setFlaggedDates(long[] flagged_dates) {
        this.monthView.setFlaggedDates(flagged_dates);
    }

    public void setSelectedDateSpan(DateSpan time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time.getStart());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        ((SpinnerDateModel)this.spin_year.getModel()).setValue(c.getTime());
    }

    public Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.monthView.getSelectedDateSpan().getEnd());
        return c;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return DateChooser.getWindowForComponent(parentComponent.getParent());
    }

    public static JDialog createDialog(Component c, String title, boolean modal, DateChooser date_chooser, ActionListener okListener, ActionListener cancelListener) {
        JDialog d = null;
        Window window = DateChooser.getWindowForComponent(c);
        d = window instanceof Frame ? new JDialog((Frame)window, title, modal) : new JDialog((Dialog)window, title, modal);
        final JDialog d2 = d;
        JButton bt_ok = new JButton("Ok");
        JButton bt_cancel = new JButton("Cancel");
        JButton bt_reset = new JButton("Reset");
        bt_reset.setEnabled(false);
        bt_ok.addActionListener(okListener);
        bt_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d2.setVisible(false);
            }
        });
        bt_cancel.addActionListener(cancelListener);
        bt_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d2.setVisible(false);
            }
        });
        JPanel p_buttons = new JPanel(new FlowLayout());
        p_buttons.add(bt_ok);
        p_buttons.add(bt_cancel);
        p_buttons.add(bt_reset);
        d.setLayout(new BorderLayout());
        d.add((Component)date_chooser, "Center");
        d.add((Component)p_buttons, "South");
        d.pack();
        return d;
    }
}

